@extends('layouts.factor-master')
<?php
$reportTitle = __('layout.CompletedProjectsReport');
?>
@section('content')
<?php
$report = customeReport('invoice', 'index');
$ex_amount = 0;
  foreach($data AS $records){
    $ex_amount += (float)$records->ex_amount;
  }

?>
<h4 style="text-align: center; ">@lang('layout.GRN1')</h4>

<table style="width: 100%; border: 1px solid black;">
  <tr>
    <td style="font-size: 14px" width='15%' >@lang('layout.Date') : </td>
    <td style="font-size: 14px" width='35%' >{{$contract->date}}</td>
    <td style="font-size: 14px" width='20%' >@lang('layout.StockManPhone') : </td>
    <td style="font-size: 14px" width='30%' >{{$stock_man_phone}}</td>
  </tr>  
  <tr>
    <td style="font-size: 14px" width='15%' >@lang('layout.Number') : </td>
    <td style="font-size: 14px" width='35%' >{{$contract->number}}</td>
    <td style="font-size: 14px" width='20%' >@lang('layout.Address') : </td>
    <td style="font-size: 14px" width='30%' >{{$stock_address}}</td>
  </tr>
  <tr>
    <td style="font-size: 14px" width='15%' >@lang('layout.Customer') : </td>
    <td style="font-size: 14px" width='35%' >{{$member->name}}</td>
    <td style="font-size: 14px" width='20%' >@lang('layout.StockManName') : </td>
    <td style="font-size: 14px" width='30%' >{{$stock_man_name}}</td>
  </tr>
  <tr>
    <td style="font-size: 14px" width='15%' >@lang('layout.Amount') : </td>
    <td style="font-size: 14px" width='35%' >{{$ex_amount}} {{$contract->currency}}</td>
  </tr>
</table>
<table class="main-table">
  <tr>
    <td>
      <div class="center"> #</div>
    </td>
    <th>@lang('layout.ItemName')</th>
    <th>@lang('layout.Quantity')</th>
    <th>@lang('layout.Janitor')</th>
    <th>@lang('layout.JanitorTotalAmount')</th>
  </tr>
  <?php
  $count = 0;
  $empty = 0;
  $qtyTotal = 0;
  $discount = 0;
  $ex_amount = 0;
  $total_amount = 0;

  ?>
  @foreach($data AS $record)
  <?php
  $qtyTotal += (float)$record->quantity_in;
  $discount += (float)$record->discount;
  $ex_amount += (float)$record->ex_amount;
  $total_amount += (float)$record->amount;
  ?>
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->item_description1}}</td>
    <td class="center">{{$record->quantity_in}} {{$record->measure}}</td>
    <td class="center">{{ myRound((float)$record->ex_amount / (float)$record->quantity_in)}}</td>
    <td class="center">{{myRound((float)$record->ex_amount)}} {{$contract->currency}}</td>
  </tr>
  @endforeach

</table>

<table style="width: 100%; border: 1px solid black;" class="main-table">
  <tr>
    <th>@lang('layout.TotalQuantity'): {{$qtyTotal}}</th>
    <td>
      @if(getFactorLang()=='fa')
      <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
              :&nbsp; {{notowo(abs(round($ex_amount)),'fa')}}</b></div>
      @elseif(getFactorLang()=='pa')
      <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
              :&nbsp; {{notowo(abs(round($ex_amount)),'pa')}}</b></div>
      @else
      <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
              :&nbsp; {{notowo(abs(round($ex_amount)),'en')}}</b></div>
      @endif
  </td>
    <th>@lang('layout.JanitorTotalAmount'): {{myRound($ex_amount)}} {{$contract->currency}}</th>
  </tr>
</table>

<table width="100%" >
  <tr>
      <td width="33%" >@lang('layout.BossSign')</td>
      <td width="33%" >@lang('layout.ResponsibleSign')</td>
      <td width="34%" >@lang('layout.RecipientSign')</td>
  </tr>
</table>

<table width="100%" style="margin-top: 40px;" >
  <tr>
      <td></td>
  </tr>
</table>

@if(company()['grn_message'])
    <table width="100%" style="border: 1px solid black;">
        <tr>
            <td style="font-size: 14px;"> {!!company()['grn_message']!!}</td>
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>
    </table>
@endif

<!--  signature -->
{{-- <table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','invoice') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table> --}}
<!-- End signature -->


@endsection