@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('contract');
    $_code = in_array('code', $report);
    $_date = in_array('date', $report);
    $_contract_name = in_array('contract_name', $report);
    $_vendor = in_array('vendor', $report);
    $_bank = in_array('bank', $report);
    $_price = in_array('price', $report);
    $_amount = in_array('amount', $report);
    $_currency = in_array('currency', $report);
    $_rate = in_array('rate', $report);
    $_total_in_home_currency = in_array('total_in_home_currency', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CargoContractReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
            @if($member_name)
                <td>
                    <span>@lang('layout.CustomerName')</span>:
                    {{$member_name}}
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">

            <td class="center"><div >  @lang('layout.Record') </div></td>
            
                <td class="center">
                    <div > @lang('layout.Number') </div>
                </td>
            
                <td class="center">
                    <div > @lang('layout.ReferenceNumber') </div>
                </td>
            
                <td class="center">
                    <div > @lang('layout.Date')</div>
                </td>
                <td class="center">
                    <div > @lang('layout.Description')</div>
                </td>
                <td class="center">
                    <div > @lang('layout.Customer')</div>
                </td>
                
            
            
                <td class="center">
                    <div > @lang('layout.DeliveryDate')</div>
                </td>
            
                <td class="center">
                    <div > @lang('layout.Amount')</div>
                </td>
            
                <td class="center">
                    <div > @lang('layout.Currency')</div>
                </td>
            
                <td class="center">
                    <div > @lang('layout.Rate')</div>
                </td>
            
                <td class="center">
                    <div > @lang('layout.Status')</div>
                </td>
                <td class="center">
                    <div > @lang('layout.LoadQuantity')</div>
                </td>
                <td class="center">
                    <div > @lang('layout.DeliveredQuantity')</div>
                </td>
                
                <td class="center">
                    <div > @lang('layout.QuantityInInventory')</div>
                </td>
                
                <td class="center">
                    <div > @lang('layout.User')</div>
                </td>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        $total_loading_quantity = 0;
        $total_in_inventory = 0;
        $total_delivered = 0;
        ?>
        @foreach($data AS $record)
            <tr>
            <?php

            $total_home_currency += $record->amount / $record->rate;
            if (array_key_exists($record->currency, $currencies)) {
                $currencies[$record->currency] = $currencies[$record->currency] + $record->amount;
            } else {

                $currencies[$record->currency] = $record->amount;
            }
            $total_loading_quantity = $total_loading_quantity + $record->quantity;
            $total_in_inventory = $total_in_inventory + $record->on_hand;
            $total_delivered = $total_delivered + $record->delivered_count;

            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                
                    <td class="center">{{$record->number}}</td>
                
                    <td class="center">{{$record->ref_no}}</td>
                    <td class="center">{{convertDate($record->date)}}</td>
                    <td class="center">{{$record->description}}</td>
                
                    <td class="center">{{$record->Customer}}</td>

                    <td class="center">{{convertDate($record->delivery_date)}}</td>
                
                    <td class="center">{{myRound($record->amount)}}</td>
                
                    <td class="center">{{$record->currency}}</td>
                
                    <td class="center">{{$record->rate}}</td>
                    <td class="center">
                        @if($record->status == "Active")
                        @lang('layout.Active')
                        @else
                        @lang('layout.Closed')
                        @endif
                    </td>
                    
                   
                    <td class="center">{{$record->quantity}}</td>
                    <td class="center">{{$record->delivered_count}}</td>
                    <td class="center">{{$record->on_hand}}</td>
                    <td class="center">{{$record->user}}</td>
            </tr>
        @endforeach

    </table>


    <table class="main-table" style="margin-top: 20px;">
        <tr class="bg">
            <td colspan="3" class="center"> @lang('layout.Total') </td>
        </tr>
        <tr>
            <td class="center"> @lang('layout.LoadQuantity') </td>
            <td class="center"> @lang('layout.DeliveredQuantity') </td>
            <td class="center"> @lang('layout.QuantityInInventory') </td>
        </tr>
        <tr>
            <td class="center"> {{$total_loading_quantity}} </td>
            <td class="center"> {{$total_delivered}} </td>
            <td class="center"> {{$total_in_inventory}} </td>
        </tr>
    </table>


    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency )
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
        <?php
        }
        ?>
        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}}  </div>
            </td>

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection