@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ItemExpense')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th class="">
                            <i class="fa fa-user"></i> @lang('layout.Type')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.TypeNumber')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('menu.Vehicle')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.ExpenseType')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Account')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Amount')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Rate')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Currency')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.User')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=""> {{ __('layout.'.ucfirst($itemExpense->type ))}}  </td>
                        <td class=""> {{ $itemExpense->number}}  </td>
                        <td class=""> {{ convertDate($itemExpense->date)}}  </td>
                        <td class=""> {{ $itemExpense->vehicle}}  </td>
                        <td class=""> {{ __('layout.'.ucfirst($itemExpense->expense_type ))}}  </td>
                        <td class=""> {{ $itemExpense->account_name }}  </td>
                        <td class=""> {{ $itemExpense->amount }}  </td>
                        <td class=""> {{ $itemExpense->rate }}  </td>
                        <td class=""> {{ $itemExpense->currency }}  </td>
                        <td class=""> {{ $itemExpense->user }}  </td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <table>
                                <tr>
                                    <td><span><i class="fa fa-text-width"></i> @lang('layout.Description')</span>:</td>
                                    <td><span>{{$itemExpense->description}}</span></td>
                                </tr>
                            </table>
                        </td>

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.ItemExpenseDetail')</a>
                </li>
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.ItemExpenseDetail') </span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        {{Form::open(['route' => 'cargoItemExpense.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="item_expense_detail"/>
                                        <input type="hidden" name="report_format" value="excel"/>
                                        <input type="hidden" name="item_expense_id" value="{{$itemExpense->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}

                                        {{Form::open(['route' => 'cargoItemExpense.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="item_expense_detail"/>
                                        <input type="hidden" name="report_format" value="pdf"/>
                                        <input type="hidden" name="item_expense_id" value="{{$itemExpense->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="item_expense">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Customer') </th>
                                            <th>@lang('layout.ItemName') </th>
                                            <th>@lang('layout.SiteName') </th>
                                            <th>@lang('layout.Quantity') </th>
                                            <th>@lang('layout.Weight') </th>
                                            <!-- <th>@lang('layout.Percentage') </th> -->
                                            <th>@lang('layout.Total')</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="cargoItemExpense.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$itemExpense->id}}">
                                        <input type="hidden" name="path" value="uploads/ItemExpense">
                                        <input type="hidden" name="table_name" value="cargo_item_expense">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                            <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('cargoItemExpense.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


@endsection
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#item_expense').DataTable({
                ajax: {
                    url: '{{route("cargoItemExpense.show",$itemExpense->id)}}',
                    data: {type: 'itemExpense'}
                },
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'member', name: 'member'},
                    {data: 'name', name: 'name'},
                    {data: 'destination', name: 'destination'},
                    {data: 'quantity', name: 'quantity'},
                    {data: 'weight', name: 'weight'},
                    //{data: 'percent', name: 'percent'},
                    {data: 'total', name: 'total', orderable: false, searchable: false},
                ]
            });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("cargoItemExpense.show",$itemExpense->id)}}',
                    data: {type: 'attachment'}
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });


        });
    </script>


@endpush
