@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'item_expense'" @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs"> 
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['EmployeeRewards-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="control-label ">@lang('layout.Type')</label>
                                                <select name="expense_type" class="form-control">
                                                    <option value="">@lang('layout.SelectType')</option>
                                                    <option value="loading">@lang('layout.Loading')</option>
                                                    <option value="InventoryTransfer">@lang('layout.InventoryTransfer')</option>
                                                    <option value="discharge">@lang('layout.Discharge')</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="control-label ">@lang('layout.Number')</label>
                                                <input type="number" name="type_number" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="control-label ">@lang('layout.Category') </label>
                                                <select name="category_id" id="" class="form-control">
                                                    <option value="">@lang('layout.SelectCategory')</option>
                                                    @foreach($category as  $rec)
                                                        <option value="{{$rec->id}}">{{$rec->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <!-- <div class="col-md-6">
                                                <label class="control-label ">@lang('layout.Type') </label>
                                                <div class="input-group">
                                                    <input type="radio" checked name="report_type" value="simple">@lang('layout.Simple')
                                                    <input type="radio" name="report_type" value="detail">@lang('layout.Details')
                                                </div>
                                                
                                            </div> -->
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Date')</label>
                                            <div slot="date">
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2">
                                <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                    @csrf
                                    <input type="hidden" name="part_name" value="cargoItemExpense_index">
                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                            <div class="form-group" style="margin: 1px;">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                    <tr>
                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td style="text-align: center;">
                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                            <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                                <span class="slider round"></span>
                                                            </label>
                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                <option value="">@lang('layout.Select')</option>
                                                                <option value="2">2 %</option>
                                                                <option value="6">6 %</option>
                                                                <option value="10">10 %</option>
                                                                <option value="15">15 %</option>
                                                                <option value="20">20 %</option>
                                                                <option value="25">25 %</option>
                                                                <option value="30">30 %</option>
                                                                <option value="40">40 %</option>
                                                                <option value="50">50 %</option>
                                                                <option value="60">60 %</option>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="margiv-top-10">
                                        <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                        <button style="margin-top: 10px !important;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        {{-- <button style="margin-top: 10px !important;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemExpense')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('CargoItemExpense-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('CargoItemExpense-create')
                    <a href="{{route('cargoItemExpense.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="itemExpense">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.ExpenseType')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('cargoItemExpense_index')!!};
        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#itemExpense').DataTable({
                ajax: '{{route("cargoItemExpense.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'cargo_item_expense.id'},
                    {data: 'type', name: 'cargo_item_expense.type', orderable: false, searchable: false},
                    {data: 'number', name: 'cargo_item_expense.number'},
                    {data: 'expense_type', name: 'expense_type', orderable: false, searchable: false},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'currency', name: 'cargo_item_expense.currency'},
                    {data: 'rate', name: 'cargo_item_expense.rate', orderable: false, searchable: false},
                    {data: 'date', name: 'cargo_item_expense.date', searchable: false},
                    {data: 'description', name: 'cargo_item_expense.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });
        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("cargoItemExpense.report") !!}',
                excelRoute: '{!! route("cargoItemExpense.report") !!}',
                customReportData:
                [ 
                    {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                    {Name: '@lang("layout.TypeNumber")', column_name: 'typeNumber',checkedColumn:(cust_rep.typeNumber)?'checked':'',column_percentage:(cust_rep.typeNumber___percent)?cust_rep.typeNumber___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                    {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                    {Name: '@lang("layout.ExpenseType")', column_name: 'expenseType',checkedColumn:(cust_rep.expenseType)?'checked':'',column_percentage:(cust_rep.expenseType___percent)?cust_rep.expenseType___percent:''},
                    {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'',column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
                    {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                    {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                    {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                    {Name: '@lang("layout.Vehicle")', column_name: 'vehicle',checkedColumn:(cust_rep.vehicle)?'checked':'',column_percentage:(cust_rep.vehicle___percent)?cust_rep.vehicle___percent:''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                    {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                ],
                cust_rep:cust_rep,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   if (typeof data_table == 'object'){
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });
    </script>
@endpush