@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Update') @lang('layout.ItemExpense') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="itemexpense" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->


                {{Form::model($itemExpense,['route' => ['itemExpense.update',$itemExpense->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'item-expense-form'])}}

                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                        <div class=" col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Type')</label>
                                    <select name="type" class="form-control" v-model="selected_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="purchase">@lang('layout.Purchases')</option>
                                        <option value="build">@lang('layout.Build')</option>
                                        <option value="inventoryTransfer">@lang('layout.InventoryTransfer')</option>
                                        <option value="branchTransfer">@lang('layout.BranchTransfer')</option>
                                    </select>
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    <input type="number" :disabled="selected_type==null || selected_type==''"
                                           v-model="itemExpenseNumber" readonly name="type_number" id="number"
                                           class="form-control">
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.CostType')</label>
                                    <select name="cost_type" class="form-control" v-model="selected_cost_type">
                                    <!-- <option value="none_posting">@lang('layout.NonePosting')</option> -->
                                        <option value="posting">@lang('layout.Posting')</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="currency"
                                              v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Rate')</label>

                                    <input type="number" name="currency_rate" name="rate"
                                           v-model="!selected_currency?0:selected_currency.rate" class="form-control"
                                           :class="{'has-error':rate<=0}">
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseType')</label>

                                            <select name="expense_type" v-model="selected_expense_type"
                                                    class="form-control">
                                                <option value="writeCheck">@lang('layout.Writecheck')</option>
                                                <option value="bill">@lang('layout.Bill')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>

                                            <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                            <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="selected_expense_type!='bill'">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>

                                            <v-select label="name" :options="approperiateBank"
                                                      v-model="selected_banks"></v-select>
                                            <input type="hidden" name="bank_account"
                                                   :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseCategory')</label>

                                            <v-select label="name" :options="expenseCategory"
                                                      v-model="selected_category"></v-select>
                                            <input type="hidden" name="expense_category_id"
                                                   :value="(this.selected_category==null)?null:selected_category.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" value="{{$itemExpense->date}}"
                                                   class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control"
                                                      rows="1">{{$itemExpense->description}}</textarea>
                                        </div>
                                    </div>
                                </div>

                            </div>

                        </div>

                        <!-- bgin pay -->
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ (Total-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                                        <span class="text-right" data-counter="counterup"
                                              data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ (Total).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    
                                </table>

                            </div>

                            <!-- end total -->
                        </div>
                        <!-- end pay -->


                    </div>
                    <br>
                    <!-- begin items -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>@lang('layout.ItemName') </th>
                                <th>@lang('layout.SiteName') </th>
                                <th>@lang('layout.Quantity') </th>
                                <th>@lang('layout.Unit') </th>
                                <th>@lang('layout.NewCost') </th>
                                <th style="min-width: 100px">@lang('layout.Category') </th>
                                <th style="min-width: 100px"  v-for="cat in itemExpenseCategory">
                                    @{{ cat.name }}
                                </th>
                                <th style="min-width: 100px">@lang('layout.PerUnitExpense') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <input type="hidden" name="stock_id[]" :value="(!item.item)?null:item.item.stock_id">
                                <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.inventory_id">
                                <input type="hidden" name="quantity[]" :value="(!item.item)?null:item.item.qut_in">
                                <td>@{{index+1}}</td>
                                 <td>@{{(!item.item)?null:item.item.name}}</td>
                                <td>@{{(!item.item)?null:item.item.site_name}}</td>
                                <td>@{{(!item.item)?null:item.item.qut_in}}</td>
                                <td>@{{(!item.item)?null:item.item.measure}}</td>
                                <td>@{{myRound((!item.item)?null:item.item.cost)}}</td>
                                <td>
                                    <select name="category[]" v-model="(!item.item)?null:item.item.category" class="form-control">
                                        <option value="total">@lang('layout.Total')</option>
                                        <option value="perUnit">@lang('layout.PerUnit')</option>
                                    </select>
									
                                </td>
                                <template v-if="item.itemExpenseCategory">

                                    <td v-for="cat in item.itemExpenseCategory">
                                        <input type="number" class="form-control" v-model="(!cat)?null:cat.amount"
                                                :name="'item_expense_category_id['+item.item.stock_id+']['+cat.item_expense_category_id+']'" >

                                    </td>
                                </template>
                                  <td>@{{myRound(itemExpenseCogs((!item.item)?null:item.item,item.itemExpenseCategory))}}</td> 
                                  <td>@{{myRound(itemExpenseTotalItem((!item.item)?null:item.item,item.itemExpenseCategory))}}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- end items -->

                    <div v-show="selected_expense_type=='bill'">
                        <hr>
                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                 
                                      <span v-if="payment.item !=null">
                                         @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                      </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate).result"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px" required/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->

                    </div>

                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        <a href="{{route('itemExpense.index')}}" class="btn default"><i
                                    class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>


                </div>


                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        var currency = {!! $currency !!};
        var itemExpense = {!! $itemExpense !!};
        var selectedCurrency = {!! $selectedCurrency!!};
        var selectedVendor = {!! $selectedVendor !!};
        var itemExpenseItems = {!! $itemExpenseItems !!};

        var banks = {!! $banks !!};
        var selected_banks1 = {!! $selected_banks !!};
        var expenseCategory = {!! $expenseCategory !!};
        var vm = new Vue({
            el: '#itemexpense',
            data: {
                itemExpense: itemExpense,
                itemExpenseNumber: null,
                selected_cost_type: itemExpense.cost_type,
                selected_type: itemExpense.type,
                inventories: [],
                typeInfo: null,
                currency: currency,
                selected_currency: selectedCurrency,
                itemExpenseItems: itemExpenseItems,

                selected_expense_type: 'writecheck',
                selected_vendor: selectedVendor,
                banks: banks,
                vendor: [],
                selected_banks: null,
                selected_banks1: selected_banks1,
                rate: 0,
                payments: [],
                expenseCategory: expenseCategory,
                selected_category: null,
                itemExpenseCategory:[]
            },
            computed: {
                isError: function () {
                    var isError = false;
                    //var flag=false;
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {

                    //    if (this.inventories[i].item)
                    //    {
                    //      flag=true;
                    //      if(((this.inventories[i]['item']['rate'] <=0) ))
                    //      {
                    //        rate=this.inventories[i]['item']['rate'];
                    //        new_rate=this.inventories[i]['item']['new_rate'];
                    //        if(rate <=0 && new_rate <=0)
                    //        {
                    //             isError = true;
                    //        }

                    //      }
                    //    }
                    // }
                    if (this.selected_vendor == null) {
                        isError = true;
                    }
                    return isError;


                },
				 Total: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i] && this.inventories[i] != null) {

                            
                        if (this.inventories[i].item != null) {
                            
                            var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                            var cost = this.inventories[i].item.cost * rate;

                            sum+=Number(itemExpenseTotalItem(this.inventories[i].item,this.inventories[i].itemExpenseCategory));

                        }
                           
                        }
                        
                    }

                    return sum;

                },


                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                },

                subtotal: function () {
					// console.log(this.inventories);
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i] && this.inventories[i] != null) {
                        var expenses = 0;
						if (this.inventories[i].itemExpenseCategory != null) {
							for(var z=0;z<this.inventories[i].itemExpenseCategory.length;z++)
							{
								if (this.inventories[i].itemExpenseCategory[z].amount != null) {
									expenses += Number.parseFloat(this.inventories[i].itemExpenseCategory[z].amount);
								}
							}
						}
							
						if (this.inventories[i].item != null) {
							
							var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
							var cost = this.inventories[i].item.cost * rate;
							if (this.inventories[i].item.category == 'total') {
								expenses = expenses / this.inventories[i].item.qut_in;
							}
							// total = cost + expenses;
								sum += expenses * rate;
						}

                   // var sum = 0;
                   //  for (var i = 0; i < this.inventories.length; i++) {
                        
                   //      if (this.inventories[i].item !=null && this.inventories[i].itemExpenseCategory) {

                   //          let itemExpenseCategoryArray=this.inventories[i].itemExpenseCategory;
                            
                   //              sum+=Number(itemExpenseTotalItem(this.inventories[i].item,itemExpenseCategoryArray));
                           
                           
                        }

                    }
                    return sum;
                },
                payeds: function () {

                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    this.selected_banks=null;
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },

            },
            mounted: function () {
                if (this.itemExpense) {
                    this.itemExpenseNumber = this.itemExpense.type_number;
                    this.selected_expense_type = this.itemExpense.expense_type

                    if (this.selected_expense_type == 'writeCheck') {
                        for (var j = 0; j < this.banks.length; j++) {
                            if (this.banks[j].id == this.itemExpense.account_id) {
                                this.selected_banks = this.banks[j];
                            }
                        }

                    }
                    else {

                        for (var t = 0; t < this.selected_banks1.length; t++) {
                            var foundFlag = false;
                            var tempBank = null;
                            for (var y = 0; y < this.banks.length; y++) {
                                if (this.selected_banks1[t].Account_id == this.banks[y].id) {
                                    foundFlag = true;
                                    tempBank = this.banks[y];
                                    tempBank.amount = this.selected_banks1[t].Amount;
                                    tempBank.rate = this.selected_banks1[t].Rate;
                                }
                            }
                            if (foundFlag) {

                                this.payments.push({item: tempBank, items: this.banks});
                            }
                        }
                        for (var w = 1; w > this.selected_banks.length; w--) {
                            this.payments.push({item: null, items: banks});
                        }
                    }

                    this.selected_type = this.itemExpense.type;
                    this.selected_cost_type = this.itemExpense.cost_type;
                    this.selected_category = _.find(this.expenseCategory, (e) => e.id == this.itemExpense.expense_category_id);

                    if (this.itemExpenseItems) {
                        var items = this.itemExpenseItems[0].myData;
                        for (var i = 0; i < items.length; i++) {
                            this.inventories.push({item:items[i].items,itemExpenseCategory:items[i].itemExpenseCategory});
                            this.itemExpenseCategory=items[i].itemExpenseCategory;
                        }

                    }
                }
            },
            methods: {
                numberChange() {
                    this.inventories = [];
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.vendor = [];
                            vm.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                
                getTotal(item = null) {
                    var total = 0;
                    if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += Number.parseFloat(item.itemExpenseCategory[i].amount);
							}
						}
					}
					// console.log('fff',expenses);
						
					if (item.item != null) {
						
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        var cost = item.item.cost * rate;
                        if (item.item.category == 'total') {
                            expenses = expenses / item.item.qut_in;
                    //  var sum = 0;
                    // for (var i = 0; i < this.inventories.length; i++) {
                        
                    //     if (this.inventories[i].item !=null && this.inventories[i].itemExpenseCategory) {

                    //         let itemExpenseCategoryArray=this.inventories[i].itemExpenseCategory;
                            
                    //             sum+=Number(itemExpenseTotalItem(this.inventories[i].item,itemExpenseCategoryArray));
                           
                           
                        }

                    }
                    }
                    return total;
                    // return sum;
                },

                //getTotalExpense
                getTotalExpense(item = null) {

                    var total = 0;
					if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += item.itemExpenseCategory[i].amount;
							}
						}
					}
					if (item.item != null) {
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        var cost = item.item.cost * rate;
                        if (item.item.category == 'total') {
                            expenses = expenses;
                        }
                        else {

                    // var sum = 0;
                    // for (var i = 0; i < this.inventories.length; i++) {
                        
                    //     if (this.inventories[i].item !=null && this.inventories[i].itemExpenseCategory) {

                    //         let itemExpenseCategoryArray=this.inventories[i].itemExpenseCategory;
                            
                    //             sum+=Number(itemExpenseTotalItem(this.inventories[i].item,itemExpenseCategoryArray));
                           
       
                        }

                    }

                    }
                    return total;

                    // return sum;
                },
                searchType() {
                    var id = document.getElementById('number').value;
                    this.inventories = [];
                    this.typeInfo = null;
                    if (id && this.selected_type) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemExpenseSearch',
                                type: this.selected_type,
                                number: id,
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {

                                    if (response.data[0]) {
                                        vm.inventories = response.data[0].items;

                                    }
                                    if (response.data[0]) {
                                        this.typeInfo = response.data[0].typeInfo;

                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }

                },
                // in here you can check and decide to allow duplicate bank for payment or not
                checkExistingPayment(index = null, name = '') {
                    var bank_temp = this.banks.slice();
                    var bank_temp1 = [];
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                            if (fined != -1) {
                                var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                            }
                        }
                    }
                    this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
                    //this.payments[index].items =bank_temp;


                },


                // generic function for adding item to list
                addNew(type = null, index) {
                    this.temp_items = [];
                    if (type != null) {
                        if (type == 'inventory') {
                            if (this.inventories[index + 1] == undefined) {
                                this.temp_items = [];
                                this.inventories.push({item: null});
                            }
                        }
                        if (type == 'payment') {
                            if (this.payments[index + 1] == undefined) {
                                this.checkExistingPayment(index, '');
                                this.payments.push({
                                    items: this.banks,
                                    item: null,
                                });
                            }
                        }
                    }

                },

                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        console.log(type);
                        if (type == 'inventory') {
                            this.inventories.splice(index, 1);
                        }
                        if (type == 'payment') {
                            this.payments.splice(index, 1);
                        }
                    }

                },
            }
        });

    </script>
@endpush
 