@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense');
$_number=in_array('number', $report);
$_type_number=in_array('type_number', $report);
$_date=in_array('date', $report);
$_vendor=in_array('vendor', $report);
$_amount=in_array('amount', $report);
$_currency=in_array('currency', $report);
$_rate=in_array('rate', $report);
$_description=in_array('description', $report);
$_type=in_array('type', $report);
$_expense_type=in_array('expense_type', $report);
$currencies = [];
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.ItemExpenseReport')</h3>

@if($itemExpenseInfo)
<table class="main-table">

<thead>
  <tr class="bg">
    <td class="center" ><div>  @lang('layout.Record') </div></td>
    <th>@lang('layout.Type')</th>
    <th>@lang('layout.TypeNumber')</th>
    <th>@lang('layout.ExpenseType')</th>
    <th>@lang('layout.Category')</th>
    <th>@lang('layout.Amount')</th>
    <th>@lang('layout.Currency')</th>
    <th>@lang('layout.Rate')</th>
    <th>@lang('layout.Date')</th>
    <th>@lang('layout.Description')</th>
    <th>@lang('layout.User')</th>
  </tr>
</thead>
<?php
$count = 0;
 $total_home_currency=0;
  $currencies=[];

?>
<?php

  
   $total_home_currency+=$itemExpenseInfo->amount/$itemExpenseInfo->rate;


   if(array_key_exists($itemExpenseInfo->currency, $currencies))
   {
    $currencies[$itemExpenseInfo->currency]=$currencies[$itemExpenseInfo->currency]+$itemExpenseInfo->amount;
  }
  else
  {
    $currencies[$itemExpenseInfo->currency]=$itemExpenseInfo->amount;
  }
  ?>
<tr>
<td  class="center">{{__('layout.'.ucfirst($itemExpenseInfo->type))}}</td>
<td class="center">{{$itemExpenseInfo->number}}</td>
<td  class="center">{{__('layout.'.ucfirst($itemExpenseInfo->expense_type))}}</td>
<td  class="center">{{$itemExpenseInfo->expense_category}}</td>
<td  class="center">{{myRound($itemExpenseInfo->amount)}}</td>
<td  class="center">{{$itemExpenseInfo->currency}}</td>
<td  class="center">{{$itemExpenseInfo->rate}}</td>
<td  class="center"> {{convertDate($itemExpenseInfo->date)}}</td>
<td  class="center">{{$itemExpenseInfo->description}}</td>
<td  class="center">{{$itemExpenseInfo->user}}</td>
</tr> 
</table>
@endif

@if($itemExpCategoryList && count($itemExpCategoryList) > 0)
<br/>
<!-- begin category List -->
<table class="main-table">
    <thead>
        <tr class="bg">
            <th class="text-center" >@lang('layout.ItemExpenseCategory')</th>
            <th class="text-center" >@lang('layout.Category')</th>
            <th class="text-center" >@lang('layout.Amount')</th>
        </tr>
    </thead>
    <tbody>
    @foreach($itemExpCategoryList AS $record1)
      <tr>
        <td  class="center">{{$record1->name}}</td>
        <td  class="center">{{__('layout.'.ucfirst($record1->category))}}</td>
        <td  class="center">{{$record1->amount}}</td>
      </tr>
    @endforeach 

    </tbody>
</table>
<!-- end category List -->
<br/>
@endif

<!-- begin List -->
<table class="main-table">
<thead>
  <tr class="bg">
    <td class="center"><div > @lang('layout.Record')  </div></td>
    <th>@lang('layout.Customer') </th>
    <th>@lang('layout.ItemName') </th>
    <th>@lang('layout.SiteName') </th>
    <th>@lang('layout.Quantity') </th>
    <th>@lang('layout.Weight') </th>
    <th>@lang('layout.Currency')</th>
    <th>@lang('layout.Rate')</th>
    <th>@lang('layout.TotalExpenses')</th>
  </tr>
</thead>
<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
<td class="center">{{$record->member}}</td>
<td  class="center">{{$record->name}}</td>
<td  class="center">{{$record->destination}}</td>
<td  class="center">{{$record->quantity}}</td>
<td  class="center">{{$record->weight}}</td>
<td class="center">{{$record->currency}}</td>
<td class="center">{{$record->rate}}</td>
<td class="center">{{myRound($record->totalAmount)}}</td>
</tr>
@endforeach  
</table>

@if($currencies)
<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency )
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{myRound($total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>
@endif
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection