@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@stop
@section('content')
@include('inventories.cmodal')  

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('layout.AddNewItemExpense') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div id="itemexpense" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'cargoItemExpense.store','method'=>'POST','class'=>'form-horizontal','id'=>'itemexpense-form')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class=" col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Type')</label>
                                    <select name="type" class="form-control" v-model="selected_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="loading">@lang('layout.Loading')</option>
                                        <option value="InventoryTransfer">@lang('layout.InventoryTransfer')</option>
                                        <option value="discharge">@lang('layout.Discharge')</option>
                                    </select>
                                </div>
 
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    <input type="number" :disabled="selected_type==null || selected_type==''"  v-model="type_number"
                                           name="type_number" id="number" @input="numberChange" class="form-control">
                                </div>
                                <div class="col-md-2" v-if="selected_type!=null && selected_type!=''">
                                    <br>
                                    <button type="button" @click="searchType" class="btn btn-info" style="background-color: rgb(80, 129, 141) !important;
                                    border: 1px solid rgb(80, 129, 141) !important;"><i
                                                class="fa fa-search"></i>@lang('layout.Search')</button>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12" v-if="selected_expense_type!='BillExpense'">
                                    <div class="col-md-12 form-group">
                                        <label class=" control-label">@lang('layout.Rent')</label>
                                        <div>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="rent_check" v-model="rent_check">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseType')</label>
                                            <select name="expense_type" v-model="selected_expense_type" class="form-control">
                                                <option value="WriteCheckExpense">@lang('layout.WriteCheckExpense')</option>
                                                <option value="BillExpense">@lang('layout.BillExpense')</option>
                                                <option value="CustomerExpense">@lang('layout.CustomerExpense')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Rate')</label>

                                    <input type="number" name="currency_rate" name="rate"
                                           v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="selected_expense_type!='WriteCheckExpense'">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer')</label>

                                            <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                            <input type="hidden" name="member_id" :value="!selected_vendor?null:selected_vendor.id" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="selected_expense_type!='BillExpense' && !rent_check">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>

                                            <v-select label="name" :options="approperiateBank"
                                                      v-model="selected_banks"></v-select>
                                            <input type="hidden" name="bank_account"
                                                   :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseCategory')</label>
                                            <div class="input-group">
                                                <v-select label="name" :options="expenseCategory"
                                                        v-model="selected_category"></v-select>
                                                <input type="hidden" name="expense_category_id"
                                                    :value="(this.selected_category==null)?null:selected_category.id">
                                                <span class="btn btn-success input-group-addon " title="@lang('layout.ExpenseCategory')" id="show-cmodal" @click="showcModal = true" style="background-color:  rgb(84, 199, 211)">
                                                <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4" v-if="rent_check && selected_expense_type!='BillExpense'" >
                                    <div class="form-group">
                                        <div class="col-md-12">
											<label class="control-label">@lang('menu.Vehicle')</label>
											  <v-select label="name" :options="vehicles" v-model="selected_vehicle" >
											</v-select>
											<input type="hidden" name="vehicle_id" :value="!selected_vehicle?null:selected_vehicle.id" >
										</div>
									</div>
								</div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseTypeMoney')</label>

                                            <select name="money_type" v-model="selected_money_type"  @input="change_precision()" @click="change_precision()" class="form-control">
                                                <option value="AutoPercentage">@lang('layout.AutoPercentage')</option>
                                                <option value="Total">@lang('layout.Total')</option>
                                                <option value="Percentage">@lang('layout.Percentage')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <!-- bgin pay -->
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%"> 

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total'):</small>
                                        </td>
                                        <td class="text-right">
                                        <span class="text-right" data-counter="counterup"
                                            data-value="7800">@{{ (Total-payeds).toFixed(precision())}}  </span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>

                                    <tr> 
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                                        <span class="text-right" data-counter="counterup"
                                              data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ (Total).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    
                                </table>

                            </div>

                            <!-- end total -->
                        </div>
                        <!-- end pay -->
                    </div>
                    <br>
                    <!-- begin category List -->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemExpenseCategory')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Category')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Amount')</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(item,index) in categoryList">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="item.select_category" :options="(item.category)" @click.native="addNew('categoryList',index), checkExistingcategory(index)"  @input="checkExistingcategory(index)" >
                                    </v-select>
                                    <input type="hidden" name="category_id[]" :value="(item.select_category==null)?null:item.select_category.id">
                                </td>
                                <td>
                                    <select v-model="item.type" :disabled="selected_money_type == 'AutoPercentage'" class="form-control">
                                        <option value="total">@lang('layout.Total')</option>
                                        <option value="perUnit">@lang('layout.PerUnit')</option>
                                    </select>
                                    <input type="hidden" name="category_type[]" :value="item.type">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="category_amount[]" placeholder="@lang('layout.Amount')" v-model="(!item)?null:item.amount"  class="form-control">
                                        <span class="input-group-addon">
                                            @{{selected_currency.symbol}}
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span v-if="categoryList.length>1" v-on:click="deleteItem('categoryList',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                    <!-- end category List -->
                    <!-- begin items -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>@lang('layout.Customer') </th>
                                <th>@lang('layout.ItemName') </th>
                                <th>@lang('layout.SiteName') </th>
                                <th>@lang('layout.Quantity') </th>
                                <th>@lang('layout.Weight') </th>
                                <th>@lang('layout.Price') </th>
                                <th v-show="selected_money_type == 'Percentage' || selected_money_type == 'AutoPercentage'">@lang('layout.Percentage') </th>
                                <th style="min-width: 100px">@lang('layout.PerUnitExpense') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th> </th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <input type="hidden" name="cargo_loading_detail_id[]" :value="(!item.item)?null:item.item.id">
                                <input type="hidden" name="cargo_contract_id[]" :value="(!item.item)?null:item.item.cargo_contract_id">
                                <input type="hidden" name="cargo_item_id[]" :value="(!item.item)?null:item.item.cargo_item_id">
                                <input type="hidden" name="cargo_loading_id[]" :value="(!item.item)?null:item.item.cargo_loading_id">
                                <input type="hidden" name="allmember_id[]" :value="(!item.item)?null:item.item.member_id">
                                <input type="hidden" name="site_id[]" :value="(!item.item)?null:item.item.site_id">
                                <input type="hidden" name="quantity[]" :value="(!item.item)?null:item.item.quantity">
                                <td>@{{index+1}}</td>
                                <td>@{{(!item.item)?null:item.item.member}}</td>
                                <td>@{{(!item.item)?null:item.item.name}}</td>
                                <td>@{{(!item.item)?null:item.item.destination}}</td>
                                <td>@{{(!item.item)?null:item.item.quantity}}</td>
                                <td>@{{(!item.item)?null:item.item.weight}}</td>
                                <td>@{{myRound((!item.item)?null:item.item.price)}}</td>
                                <td v-show="selected_money_type == 'Percentage' || selected_money_type == 'AutoPercentage'">
                                    <input type="number" class="form-control" :readonly="selected_money_type == 'AutoPercentage'" v-model="(!item.item)?null:item.item.percent" name="percent[]" >
                                </td>
                                <td>
                                    <input type="hidden" :value="(!item.item)?0:item.item.perAmount" name="perAmount[]" >
                                    <input type="hidden" :value="(!item.item)?0:item.item.totalAmount" name="totalAmount[]" >
                                    @{{myRound((!item.item)?0:item.item.perAmount)}}
                                </td> 
                                <td>@{{myRound((!item.item)?0:item.item.totalAmount)}}</td> 
                                <td>
                                    <span v-if="inventories.length>1" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>

                    </div>
                    <!-- end items -->

                    <div v-show="selected_expense_type=='BillExpense'">
                        <hr>
                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                 
                                      <span v-if="payment.item !=null">
                                         @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                      </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>


                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                            :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate, null, selected_currency.static_rate).result"
                                            placeholder="@lang('layout.Total')" style="min-width: 100px" required/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td> 


                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->

                    </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" v-if="!isError"
                            :disabled="disabled" @click="submitForm()" >@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" v-if="!isError"
                        :disabled="disabled"  @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>        
                        <a href="{{route('cargoItemExpense.index')}}" class="btn default"><i
                                    class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>
                </div>


                {!! Form::close() !!}

                <!--Begin Modal -->
                {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                    {{ csrf_field() }}                                        
                    <cmodal :show="showcModal" @close="showcModal = false">
                        <h3 slot='cheader'>@lang('layout.CreateNewExpenseCategory')</h3>
                        <div slot="cbody">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>
                                </div>

                                 <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description")</label>
                                            <textarea class="form-control" name="description" v-model="description">
                                            </textarea>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <div slot="cfooter">
                            <button type="button" class="modal-default-button btn btn-success" @click="addExpenseCategory">
                                @lang('layout.Submit')
                            </button>
                        </div>
                    </cmodal>
                    {!! Form::close() !!}
                    <!--End Modal-->

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

            var Modal = Vue.component('cmodal',
                {
                    template:'#cmodal-template',
                    props: ['show'],
                });

        var currency = {!! $currency !!};
        var banks = {!! $banks !!};
        var expenseCategory = {!! $expenseCategory !!};
        var category = {!! $category !!};
        var type = {!! $type !!};
        var type_id = {!! $type_id !!};
        var vehicles = {!! $vehicles !!};

        var vm = new Vue({
            el: '#itemexpense',
            data: {
                selected_type: 'loading',
                type_number: '',
                selected_cost_type: 'posting',
                inventories: [],
                typeInfo: null,
                selected_expense_type: 'WriteCheckExpense',
                selected_money_type: 'AutoPercentage',
                currency: currency,
                selected_currency: {!!json_encode(getHomeCurrency()) !!},
                banks: banks,
                vendor: [],
                selected_vendor: null,
                selected_banks: null,
                defuilt_banks: null,
                rent_check: null,
                vehicles:vehicles,
                selected_vehicle:null,
                disabled: false,
                rate: 0,
                payments: [],
                expenseCategory: expenseCategory,
                selected_category: null,
                category: category,
                categoryList: [{
                        category: category,
                        select_category: null,
                        type: 'total',
                        amount: null,
                    },
                    {
                        category: category,
                        select_category: null,
                        type: 'total',
                        amount: null,
                    },
                ],
                showcModal: false,
                errorMessage: '',
                fieldErrors: [],
                className: null,
                description: null,
                itemExpenseCategory:[],
                total_amount:0,
                per_amount:0,
                quantity:0
            },
            computed: {
                isError: function () {
                    var isError = false;
                    //var flag=false;
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {

                    //    if (this.inventories[i].item)
                    //    {
                    //      flag=true;
                    //      if(((this.inventories[i]['item']['rate'] <=0) ))
                    //      {
                    //        rate=this.inventories[i]['item']['rate'];
                    //        new_rate=this.inventories[i]['item']['new_rate'];
                    //        if(rate <=0 && new_rate <=0)
                    //        {
                    //             isError = true;
                    //        }

                    //      }
                    //    }
                    // }
                    if (this.inventories.length == 0 || !this.type_number) {
                        isError = true;
                    }
                    return isError;


                },
                Total: function () {
                    var qut_in = 0;
                    var percent = 0;
                    var amount = 0;
                    var per_amount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
						if (this.inventories[i] && this.inventories[i] != null) {
                            if (this.inventories[i].item != null) {
                                qut_in = (Number.parseFloat(this.inventories[i].item.quantity) + qut_in);
                                percent = (Number.parseFloat(this.inventories[i].item.percent) + percent);
                            }
                        }
                    }
                    if (qut_in > 0) {
                        for (var i = 0; i < this.categoryList.length; i++) {
                            if (this.categoryList[i].amount != null && this.categoryList[i].type != null && this.categoryList[i].select_category != null) {
                                if (this.categoryList[i].type == 'perUnit') {
                                    amount = ((Number.parseFloat(this.categoryList[i].amount) * qut_in) + amount);
                                } else{
                                    amount = (Number.parseFloat(this.categoryList[i].amount) + amount);
                                }
                            }
                        }
                        // var amount =  (Number.parseFloat(vm.inventories[i].item.price) * Number.parseFloat(vm.inventories[i].item.quantity));
                    this.total_amount = amount;
                    this.per_amount = (amount / qut_in);
                    this.quantity = qut_in;
                    per_amount = (amount / qut_in);
                    }
                    if (this.selected_money_type == 'Total') {
                        if (qut_in > 0 && amount > 0) {
                            for (var i = 0; i < this.inventories.length; i++) {
                                if (this.inventories[i] && this.inventories[i] != null) {
                                    if (this.inventories[i].item != null) {
                                        this.inventories[i].item.perAmount = per_amount;
                                        this.inventories[i].item.totalAmount = (per_amount * Number.parseFloat(this.inventories[i].item.quantity));
                                    }
                                }
                            }
                        }
                    } else if (this.selected_money_type == 'Percentage') {
                        if (percent > 0 && amount > 0) {
                            for (var i = 0; i < this.inventories.length; i++) {
                                if (this.inventories[i] && this.inventories[i] != null) {
                                    if (this.inventories[i].item != null) {
                                        this.inventories[i].item.perAmount =  (((amount * Number.parseFloat(this.inventories[i].item.percent)) / percent) / Number.parseFloat(this.inventories[i].item.quantity)).toFixed(8);
                                        this.inventories[i].item.totalAmount = ((amount * Number.parseFloat(this.inventories[i].item.percent)) / percent).toFixed(8);
                                    }
                                }
                            }
                        }
                    } else if (this.selected_money_type == 'AutoPercentage') {
                        if (percent > 0 && amount > 0) {
                            for (var i = 0; i < this.inventories.length; i++) {
                                if (this.inventories[i] && this.inventories[i] != null) {
                                    if (this.inventories[i].item != null) {
                                        this.inventories[i].item.perAmount =  (((amount * Number.parseFloat(this.inventories[i].item.percent)) / percent) / Number.parseFloat(this.inventories[i].item.quantity)).toFixed(8);
                                        this.inventories[i].item.totalAmount = ((amount * Number.parseFloat(this.inventories[i].item.percent)) / percent).toFixed(8);
                                    }
                                }
                            }
                        }
                    }
                    return amount;
                }, 
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                }, 
 

                 payeds: function () { 
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) { 
                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif  
                            }
                        }
                    }
                    return sum;
                },
                

                // filter the banks according to selected currency
                approperiateBank: function () {
                    this.selected_banks=null;
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        if (this.defuilt_banks) {
                            this.selected_banks = this.defuilt_banks;
                            this.defuilt_banks = null;
                        }else{
                            this.selected_banks = tempBank[0];
                        }
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                var selected_banks=_.find(this.banks,(v)=>v.id=={!! getDropdown('itemExpense', 'bank') !!});
                if(selected_banks){
                    // this.defaultAccount = selected_banks.id;
                    var selected_currency=_.find(this.currency,(v)=>v.code==selected_banks.code);
                    // currency
                    this.selected_currency = selected_currency;
                    this.defuilt_banks = selected_banks;
                }

                var selected_A = null;
                var bank=_.find(banks,(v)=>v.id=={!! getDropdown('itemExpense', 'account') !!});
                if (bank) {
                    selected_A = bank;
                }

                this.payments.push({
                    items: banks,
                    item: selected_A
                });

                if(type_id != null){
                    this.selected_type = type;
                    this.type_number = type_id;
                    setTimeout(function(){ vm.searchType(); },600);
                    
                    // console.log(123, purchase_number);
                }

                // console.log(123, selected_banks, selected_currency);
            },
            methods: {
                    //Function to add MemberCLass
                addExpenseCategory:function(){
                    axios.post("{{route('expenseCategory.store')}}",{
                        name:vm.className,
                        description:vm.description
                    })
                    .then(function(response){
                        
                        // location.reload();

                          var data = {id: response.data.id,name: response.data.name};
                        // vu.categories = response.data;
                        axios.get("{{route('expenseCategory.create')}}").then(function (response) {
                            
                            vm.className = null;
                             vm.description = null;
                            vm.expenseCategory     = response.data;
                        });


                    });
                    vm.showcModal = false;
                },

                change_precision() {
                    if (vm.selected_money_type == 'AutoPercentage' && vm.inventories) {
                        // console.log(123, vm.selected_money_type);
                        var total_amount = 0;
                        for (var i = 0; i < vm.inventories.length; i++) {
                            if (vm.inventories[i] && vm.inventories[i] != null) {
                                if (vm.inventories[i].item != null) {
                                    total_amount +=  (Number.parseFloat(vm.inventories[i].item.price) * Number.parseFloat(vm.inventories[i].item.quantity));
                                }
                            }
                        }
                        for (var i = 0; i < vm.categoryList.length; i++) {
                            vm.categoryList[i].type = 'total';
                        }
                        // console.log(123, vm.categoryList);
                        if (total_amount > 0) {
                            for (var i = 0; i < vm.inventories.length; i++) {
                                if (vm.inventories[i] && vm.inventories[i] != null) {
                                    if (vm.inventories[i].item != null) {
                                        var amount =  (Number.parseFloat(vm.inventories[i].item.price) * Number.parseFloat(vm.inventories[i].item.quantity));
                                        vm.inventories[i].item.percent = Number.parseFloat((100 * amount) / total_amount).toFixed(4);
                                    }
                                }
                            }
                        }
                    }
                },

                numberChange() {
                    vm.inventories = [];
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            multitype: ['Customer','Driver']
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.vendor = [];
                            vm.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                getTotal(item = null) {
                    var total = 0;
                    if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += Number.parseFloat(item.itemExpenseCategory[i].amount);
							}
						}
					}
                        // var materialCost = Number(item.materialCost);
                        // var transportCost = Number(item.transportCost);
                        // var customeCost = Number(item.customeCost);
                        // var laborCost = Number(item.laborCost);
                        // var subContractorCost = Number(item.subContractorCost);
                        // var manufacturingCost = Number(item.manufacturingCost);
                        // var otherCost = Number(item.otherCost);
						
					if (item.item != null) {
						
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        @if(systemConfig()[30] == 1)
                        var cost = item.item.cost * this.selected_currency.static_rate / rate;
                        @else 
                        var cost = item.item.cost * rate;
                        @endif

                        if (item.item.category == 'total') {
                            expenses = expenses / item.item.qut_in;
                        }
                        else { 

                        }
                        total = cost + expenses;
                    }
                    }
                    return total;
                },

                //getTotalExpense
                getTotalExpense(item = null) {
                    var total = 0;
					if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += item.itemExpenseCategory[i].amount;
							}
						}
					}
					if (item.item != null) {
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        @if(systemConfig()[30] == 1)
                        var cost = item.item.cost * this.selected_currency.static_rate  /  rate;
                        @else 
                        var cost = item.item.cost * rate;
                        @endif

                        if (item.item.category == 'total') {
                            expenses = expenses;
                        }
                        else {

                        }
                        total = expenses;
                    }
                    }
                    return total;
                },

                // in here you can check and decide to allow duplicate service or not
                checkExistingcategory(index = null, id = '') {
                    
                    var service_temp = this.category.slice();
                    for (var i = 0; i < this.categoryList.length; i++) {
                        if (this.categoryList[i].select_category != null) {
                            var fined = service_temp.findIndex((item) => item.id == this.categoryList[i].select_category.id);
                            if (fined != -1) {
                                var o = service_temp.splice(service_temp.findIndex((item) => item.id == this.categoryList[i].select_category.id), 1);
                            }
                        }
                    }
                    this.categoryList[index].category = service_temp;
                    // this.categoryList[index].category = service_temp.filter((item) => {
                    //     return (new RegExp(id)).test(item.id)
                    // });

                },

                // search stock based on type purchase/build/opening
                searchType() {
                    var id = document.getElementById('number').value;
                    this.inventories = [];
                    this.typeInfo = null;
                    if (id && this.selected_type) {
                        axios.get("{{route('callcargoItemExpense.search')}}", {
                            params: {
                                method_name: 'itemExpenseSearch',
                                type: this.selected_type,
                                number: id,
                            }
                        })
                            .then(function (response) {
                                // console.log('123', response.data);

                                if (response.data.length > 0) {

                                        var myDataArray=response.data;
                                        for(var i=0;i<myDataArray.length;i++)
                                        {
                                            vm.inventories.push({item:myDataArray[i]});
                                        }

                                        setTimeout(function(){ vm.change_precision(); },500);
                                    
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }

                },
                // end search type


                // in here you can check and decide to allow duplicate bank for payment or not
                checkExistingPayment(index = null, name = '') {
                    var bank_temp = this.banks.slice();
                    var bank_temp1 = [];
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                            if (fined != -1) {
                                var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                            }
                        }
                    }
                    this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
                    //this.payments[index].items =bank_temp;


                },

                // submit the form
                submitForm() {
                    vm.disabled = true;
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("itemexpense-form").submit()
                        } else {
                            vm.disabled = false;
                        }
                    });
                },

                saveAndNew() {
                    // console.log('eee');
                    vm.disabled = true;
                    var url = "{{route('cargoItemExpense.store')}}";
                    form_id = 'itemexpense-form';
                    var data = $('#' + form_id).serialize();
                    toggleBlock(true);
                    axios.post(url, data)
                    .then(function (response) {
                        toggleBlock(0);

                        if (response.data.result == 1) {
                            $('#' + form_id).trigger('reset');
                            //$('#success-sound')[0].play();
                            toastr.success('', response.data.message);
                            location.reload();
                            // sales.defaultValueM();
                        }
                        else {
                            vm.disabled = false;
                            var message = "{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                        }
                    })
                    .catch(function (error) {
                        vm.disabled = false;
                        toggleBlock(0);
                        console.log(error);
                        var message = "{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('', message);
                    });

                },

                // generic function for adding item to list
                addNew(type = null, index) {
                    this.temp_items = [];
                    if (type != null) {
                        if (type == 'categoryList') {
                            if (this.categoryList[index + 1] == undefined){
                                this.categoryList.push({
                                    category: category,
                                    select_category: null,
                                    type: 'total',
                                    amount: null
                                });
                            }
                        }
                        if (type == 'inventory') {
                            if (this.inventories[index + 1] == undefined) {
                                this.temp_items = [];
                                this.inventories.push({item: null});
                            }
                        }
                        if (type == 'payment') {
                            if (this.payments[index + 1] == undefined) {
                                this.checkExistingPayment(index, '');
                                this.payments.push({
                                    items: this.banks,
                                    item: null,
                                });
                            }
                        }
                    }

                },

                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        console.log(type);
                        if (type == 'categoryList') {
                            this.categoryList.splice(index, 1);
                        }
                        if (type == 'inventory') {
                            this.inventories.splice(index, 1);
                        }
                        if (type == 'payment') {
                            this.payments.splice(index, 1);
                        }
                    }

                },


            }
        });

    </script>
@endpush
 