@extends('layouts.factor-master')
@section('content')
<?php
  $report = customeReport('item_expense');
    $_number=in_array('number', $report);
    $_type_number=in_array('type_number', $report);
    $_date=in_array('date', $report);
    $_vendor=in_array('vendor', $report);
    $_amount=in_array('amount', $report);
    $_currency=in_array('currency', $report);
    $_rate=in_array('rate', $report);
    $_description=in_array('description', $report);
    $_type=in_array('type', $report);
    $_expense_type=in_array('expense_type', $report);

  $report_cargoItemExpense = customeReportNew('cargoItemExpense_index');
    $_record = !in_array('record', $report_cargoItemExpense);
    $_typeNumber = !in_array('typeNumber', $report_cargoItemExpense);
    $_date = !in_array('date', $report_cargoItemExpense);
    $_description = !in_array('description', $report_cargoItemExpense);
    $_type = !in_array('type', $report_cargoItemExpense);
    $_expenseType = !in_array('expenseType', $report_cargoItemExpense);
    $_category = !in_array('category', $report_cargoItemExpense);
    $_amount = !in_array('amount', $report_cargoItemExpense);
    $_currency = !in_array('currency', $report_cargoItemExpense);
    $_rate = !in_array('rate', $report_cargoItemExpense);
    $_vehicle = !in_array('vehicle', $report_cargoItemExpense);
    $_user = !in_array('user', $report_cargoItemExpense);
    $_total = !in_array('total', $report_cargoItemExpense);
  // percent start 
  $report_cargoItemExpense_percent = customeReportNewPercent('cargoItemExpense_index');
    $_record_percent = (array_key_exists('record___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['record___percent']:null;
    $_typeNumber_percent = (array_key_exists('typeNumber___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['typeNumber___percent']:null;
    $_date_percent = (array_key_exists('date___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['date___percent']:null;
    $_description_percent = (array_key_exists('description___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['description___percent']:null;
    $_type_percent = (array_key_exists('type___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['type___percent']:null;
    $_expenseType_percent = (array_key_exists('expenseType___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['expenseType___percent']:null;
    $_category_percent = (array_key_exists('category___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['category___percent']:null;
    $_amount_percent = (array_key_exists('amount___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['amount___percent']:null;
    $_currency_percent = (array_key_exists('currency___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['currency___percent']:null;
    $_rate_percent = (array_key_exists('rate___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['rate___percent']:null;
    $_vehicle_percent = (array_key_exists('vehicle___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['vehicle___percent']:null;
    $_user_percent = (array_key_exists('user___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['user___percent']:null;
    $_total_percent = (array_key_exists('total___percent', $report_cargoItemExpense_percent))?$report_cargoItemExpense_percent['total___percent']:null;
  // percent end 
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ItemExpenseReport')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
<br>
<table class="main-table">
  <thead>
    <tr class="bg">
      @if($_record)
        <th class="center">
          <div>@lang('layout.Record') </div>
        </th>
      @endif
      @if($_typeNumber)
        <th>@lang('layout.TypeNumber')</th>
      @endif
      @if($_date)
        <th>@lang('layout.Date')</th>
      @endif
      @if($_description)
        <th>@lang('layout.Description')</th>
      @endif
      @if($_type)
        <th>@lang('layout.Type')</th>
      @endif
      @if($_expenseType)
        <th>@lang('layout.ExpenseType')</th>
      @endif
      @if($_category)
        <th>@lang('layout.Category')</th>
      @endif
      @if($_amount)
        <th>@lang('layout.Amount')</th>
      @endif
      @if($_currency)
        <th>@lang('layout.Currency')</th>
      @endif
      @if($_rate)
        <th>@lang('layout.Rate')</th>
      @endif
      @if($_vehicle)
        <th>@lang('menu.Vehicle')</th>
      @endif
      @if($_user)
        <th>@lang('layout.User')</th>
      @endif
    </tr>
  </thead>
  <?php
    $count = 0;
    $total_home_currency=0;
    $currencies=[];
    $colspan = 7;
  ?>
  @foreach($data AS $record)
    <?php

      if(systemConfig()[30] == 1){
        $total_home_currency+=$record->amount/ $record->static_rate * $record->rate;
      }else{
        $total_home_currency+=$record->amount/$record->rate;
      }


      if(array_key_exists($record->currency, $currencies))
      {
        $currencies[$record->currency]=$currencies[$record->currency]+$record->amount;
      }
      else
      {
        $currencies[$record->currency]=$record->amount;
      }
    ?>
    <tr>
      @if($_record)
        <td class="center">{{++$count}}</td>
      @endif
      @if($_typeNumber)
        <td class="center">{{$record->number}}</td>
      @endif
      @if($_date)
        <td  class="center"> {{convertDate($record->date)}}</td>
      @endif
      @if($_description)
        <td  class="center">{{$record->description}}</td>
      @endif
      @if($_type)
        <td  class="center">{{__('layout.'.ucfirst($record->type))}}</td>
      @endif
      @if($_expenseType)
        <td  class="center">{{__('layout.'.ucfirst($record->expense_type))}}</td>
      @endif
      @if($_category)
        <td  class="center">{{$record->expense_category}}</td>
      @endif
      @if($_amount)
        <td  class="center">{{myRound($record->amount)}}</td>
      @endif
      @if($_currency)
        <td  class="center">{{$record->currency}}</td>
      @endif
      @if($_rate)
        <td  class="center">{{$record->rate}}</td>
      @endif
      @if($_vehicle)
        <td  class="center">{{$record->vehicle}}</td>
      @endif
      @if($_user)
        <td  class="center">{{$record->user}}</td>
      @endif
    </tr>
  @endforeach  
  @if(!$_record)        <?php  $colspan = $colspan-1;  ?> @endif
  @if(!$_typeNumber)    <?php  $colspan = $colspan-1;  ?> @endif
  @if(!$_date)          <?php  $colspan = $colspan-1;  ?> @endif
  @if(!$_description)   <?php  $colspan = $colspan-1;  ?> @endif
  @if(!$_type)          <?php  $colspan = $colspan-1;  ?> @endif
  @if(!$_expenseType)   <?php  $colspan = $colspan-1;  ?> @endif
  @if(!$_category)      <?php  $colspan = $colspan-1;  ?> @endif
  @if($_amount)
  <tr class="bg">
    <td colspan="{{$colspan}}" class="center" style="font-weight: bold;">@lang('layout.Total')</td>
    @if($_amount)
      <td style="font-weight: bold;" class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
    @endif
    @if($_currency)
      <td class="center"></td>
    @endif
    @if($_rate)
      <td class="center"></td>
    @endif
    @if($_vehicle)
      <td class="center"></td>
    @endif
    @if($_user)
      <td class="center"></td>
    @endif
  </tr>
  @endif
</table>
@if($_total)
<table class="main-table">
  <tr class="bg">
    <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
  </tr>
  <tr>
    <td><div class="center">  @lang('layout.Record') </div></td>
    <td><div class="center"> @lang('layout.Currency') </div></td>
    <td><div class="center"> @lang('layout.Amount') </div></td>
  </tr>
  <?php
    $count=0;
    foreach($currencies As $key=>$currency )
    {
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency)}}</div></td>
  </tr>
  <?php
    }
  ?>
  <tr>
  <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
  <td><div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}  </div></td>
  </tr>
</table>
@endif
<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
      @foreach(getCompanyInfo('sign','reports') AS $info)
      <td style="text-align: left; width:40%">
        <table >       
          <tr>
            <td align="right" class="signsize">{{$info['name']}}</td>
          </tr>
        </table>
      </td>
      @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection