@extends('layouts.app')
@section('content')
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PossibleBuildQuentity')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead >
                    <tr style="background-color:#9998ee"> 
                        <th class="text-center">
                            <i class=""></i> @lang('layout.AssemblyCode')
                        </th>
                        <th class="text-center">
                            <i class=""></i> @lang('layout.ItemName')
                        </th>
                        <th class="text-center">
                            <i class=" "></i> @lang('layout.Measure')
                        </th> 
                         <th class="text-center">
                            <i class=""></i> @lang('layout.Quantities')
                        </th>
                         <th class="text-center">
                            <i class=""></i> @lang('layout.Inventory')
                        </th>
                         <th class="text-center">
                            <i class=""></i> @lang('layout.Date')
                        </th> 
                        <th class="text-center">
                            <i class=""></i> @lang('layout.Hour')
                        </th> 
                        <th class="text-center">
                            <i class=""></i> @lang('layout.PaletNumber')
                        </th> 
                        <th class="text-center">
                            <i class=""></i> @lang('layout.TransferdBy')
                        </th> 
                        <th class="text-center">
                            <i class=""></i> @lang('layout.Description')
                        </th> 
                    </tr>
                    </thead>
                    <tbody>
                        <tr> 
                            <td class="text-center"> {{$formulaInfo->build_code }}  </td>
                            <td class="text-center"> {{$formulaInfo->item_name}}  </td>
                            <td class="text-center"> {{$formulaInfo->measure}}  </td>
                            <td class="text-center"> {{$formulaInfo->quentity}}  </td>
                            <td class="text-center"> {{$formulaInfo->SiteName}}  </td>
                            <td class="text-center"> {{convertDate($formulaInfo->date) }}  </td>
                            <td class="text-center"> {{$formulaInfo->hour }}  </td>
                            <td class="text-center"> {{$formulaInfo->palet_number }}  </td>
                            <td class="text-center"> {{$formulaInfo->person_by }}  </td>
                            <td class="text-center"> {{$formulaInfo->description }}  </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
@push('scripts')

<script>
   $(document).ready(function () {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#assembly').DataTable({
           ajax:{
            url:'{{route("assembly.show",$formulaInfo->id)}}',
                data:{type:'assembly'}
              },
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging: true,
            destroy: true,
            columns: [    
                { data: 'item', name: 'items.name'},
                { data: 'qut', name: 'qut', orderable:false,searchable:false},
                { data: 'measure', name: 'measure', orderable:false,searchable:false},
            ]

        });

        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#expense').DataTable({
           ajax:{
            url:'{{route("assembly.show",$formulaInfo->id)}}',
                data:{type:'expense'}
              },
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging: true,
            destroy: true,
            columns: [    
                { data: 'account', name: 'account'},
                { data: 'amount', name: 'amount'},
                { data: 'description', name: 'description'}
            ]

        });
    });
 

</script>


@endpush
