@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'buildsStatistic'"
                      @closed="closeModal">
            <div slot=body>
             
                <div class="row" v-cloak>

                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['EmployeeRewards-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
    
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12">
                                                <label class="control-label">@lang('layout.AssemblyCode')</label>
                                                <input type="text" class="form-control" name="build_code">
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemName')</label>
                                                    <v-select label="name" v-model="selected_assembly_item" :options="temp_items" @search="onItemsSearch" ></v-select>
                                                    <input type="hidden" name="item_id" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!selected_assembly_item)?null:selected_assembly_item.id">
                                                  </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12">
                                                <label class="control-label">@lang('layout.PaletNumber')</label>
                                                <input type="text" class="form-control" name="palet_number">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group">
                                               
                                                <div class="col-md-12" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example"
                                                                v-model="from_date" name="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example"
                                                                v-model="to_date" name="to_date" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
    
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
    
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="buils_statistic_index">
    
    
                                            <div class="col-md-12 col-sm-12 col-xs-12">
    
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
    
                                                    <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
    
    
                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
    
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                        class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
    
                        </div>
                    </div>
                </div>
    






            </div>
        </report-modal>
    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase"> @lang('layout.PossibleBuildQuentity') </span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    @permission('BuildStatistic-export')
                    <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                         </span>
                    @endpermission
                    @permission('BuildStatistic-create')
                    <a href="{{route('buildsStatisticCreate.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="buildStatistic">
                    <thead>
                    <tr>
                        <th>@lang('layout.AssemblyCode')</th>
                        <th>@lang('layout.ItemName')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.Quantities')</th>
                        <th>@lang('layout.Inventory')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        <th>@lang('layout.PaletNumber')</th>
                        <th>@lang('layout.TransferdBy')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@endsection
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>

        @if (Session('buils_statistic'))
        printTransferBill("{{Session('buils_statistic')}}")
        @endif 
 

        var cust_rep = {!!customeReportNewData('buils_statistic_index')!!};
 
        function printTransferBill(id) {
        var a = document.createElement('a');
        a.href = "{{url('printBuildStatisticBill')}}/" + id;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        }
 
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#buildStatistic').DataTable({
                ajax: '{{route("buildsStatistic.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'build_code', name: 'builds_statistic.build_code'},
                    {data: 'item_name', name: 'items.name'},
                    {data: 'measure', name: 'measure_units.name'},
                    {data: 'quentity', name: 'quentity'},
                    {data: 'SiteName', name: 'inventory_sites.name'},
                    {data: 'date', name: 'date'},
                    {data: 'hour', name: 'hour'},
                    {data: 'palet_number', name: 'palet_number'},
                    {data: 'person_by', name: 'person_by'},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false },
                    
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },
  
                ]

            });
        });


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                selected_assembly_item: null,
                temp_items: [],
                is_show: false,
                from_date: null,
                to_date: null,
                pdfRoute: '{!!route('buildsStatistic.report') !!}',
                excelRoute: '{!! route('buildsStatistic.report') !!}' , 
                period: 'CustomDates',


                customReportData:
                [
                 {Name: '@lang("layout.AssemblyCode")', column_name: 'build_code',checkedColumn:(cust_rep.build_code)?'checked':'',column_percentage:(cust_rep.build_code_percent)?cust_rep.build_code___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.Quantities")', column_name: 'quentity',checkedColumn:(cust_rep.quentity)?'checked':'',column_percentage:(cust_rep.quentity___percent)?cust_rep.quentity___percent:''},
                 {Name: '@lang("layout.Inventory")', column_name: 'SiteName',checkedColumn:(cust_rep.SiteName)?'checked':'',column_percentage:(cust_rep.SiteName___percent)?cust_rep.SiteName___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.PaletNumber")', column_name: 'palet_number',checkedColumn:(cust_rep.palet_number)?'checked':'',column_percentage:(cust_rep.palet_number___percent)?cust_rep.palet_number___percent:''},
                 {Name: '@lang("layout.TransferdBy")', column_name: 'person_by',checkedColumn:(cust_rep.person_by)?'checked':'',column_percentage:(cust_rep.person_by___percent)?cust_rep.person_by___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                  ],
                  cust_rep:cust_rep

            },
            mounted: function() {
                @if(saveTempData() == 'true')
                axios.get("{{route('temp.assembly.getData')}}", {
                        params: {
                            type: 'assembly'
                        }
                    })
                    .then(function(response) {
                        // console.log('myrespo1', response);
                        if (response.data) {
                            //begin formula item initialize
                            if (response.data.asseItem) {
                            vm.formula_items.push(response.data.asseItem);
                            vm.selected_assembly_item = vm.formula_items[0];
                            }

                        }
                    })
                    .catch(function(error) {
                    console.log(error);
                    })
                @endif
                },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                // items serarch method

                onItemsSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                        method_name: 'items_search_assebley',
                        'type': 'builds_statistic',
                        keyword: search,
                        }
                    })
                    .then(function(response) {
                        vm.temp_items = [];
                        if (response.data.length > 0) {
                        
                        vm.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }, getDebounceTime()),

                onSubmit() {
                var ivn = this;
                vm.showInvModal = false;
                var datas = $("#modalFormInv").serializeArray();
                // console.log(123,datas);
                $.ajax({
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    url: '{{route("inventory.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        'type': datas[1]['value'],
                        'number': datas[2]['value'],
                        'gauge': datas[3]['value'],
                        'rate': datas[4]['value'],
                        'description': datas[5]['value'],
                        'asset_account': this.assetAccount.id,
                        'um_id': this.selectMeasure.id,
                        'income_account': this.incomeAccount.id,
                        'cost_account': this.costAccount.id,
                        'cost': 1,
                        'category': (this.category) ? this.category.id : null
                    },
                    dataType: 'json',

                }).done(function (response) {
                    // console.log(123, response);
                    if (response) {
                      response.item.id = response.item.item_id;
                      sales.selected_assembly_item = null;
                      sales.selected_assembly_item = response.item;
                    }
                    axios.get('{{route("inventory.create")}}', {
                        params: {
                            saveAndNew: 'on'
                        }
                    }).then(response => {
                        // console.log(1239, response);
                        ivn.number = response.data;
                        document.getElementById("modalFormInv").reset();
                    }).catch(error => console.log(error));

                }).fail(function (error) {
                    console.log('error', error);
                });

            }
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
    </script>
@endpush