@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title">
            <div class="caption">
                <i class=""></i>@lang('layout.BuildInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.BuildNumber')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.ItemName')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa-user"></i> @lang('layout.CreatedBy')
                        </th> 
                        <th>
                            <i class="fa fa-shopping-cart"></i> @lang('layout.Quantity')
                        </th>
                        <th>
                            <i class="fa fa-dollar"></i> @lang('layout.Cost')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Type')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr> 
                        <td class="hidden-xs"> {{ $build[0]->b_number}}  </td>
                        <td class="hidden-xs"> {{ $build[0]->name}}  </td>
                        <td class="hidden-xs"> {{ $build[0]->username }}  </td>
                        <td class="hidden-xs"> {{ $build[0]->qty }}  </td>
                        <td class="hidden-xs"> {{ $build[0]->cost*$build[0]->qty}}  </td>
                        <td class="hidden-xs"> @lang('layout.OutItems')  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.BuildDetails')</span>
                    </div>
                        <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="build_Details_ch_roll"/>
                           <input type="hidden" name="id" value="{{$build[0]->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="build_Details_ch_roll"/>
                           <input type="hidden" name="id" value="{{$build[0]->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="builds">
                        <thead>
                        <tr> 
                            <th>#</th>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Code')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.MeasureName')</th>
                            <th>@lang('layout.Total')</th>
                            <!-- <th>Action</th> -->
                        </tr>
                        </thead>
                    </table>
                </div>
				
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="builds_roll">
                        <thead>
                        <tr>  

                            <th>#</th>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Code')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.MeasureName')</th>
                            <th>@lang('layout.Total')</th>
                            <th>@lang('layout.Width')</th>
                            @if(getOtherMeasure()=="true")
                            <th> @lang('layout.OMeasureValue1')</th>
                            @endif
                            @if(getOtherMeasure2()=="true")
                            <th> @lang('layout.OMeasureValue2')</th>
                            @endif
                            <th>@lang('layout.Action')</th>
                        </tr>
                        </thead>
                    </table>
                </div>

                <h4>@lang('layout.UseWastage')</h4>
                
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="build_wastage">
                        <thead>
                        <tr>  
                            <th>#</th>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.MeasureName')</th>
                            <th>@lang('layout.Total')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')
 <script>
    $(document).ready(function () {
        $('#builds').DataTable({
            ajax:{
                    url:'{{route("build_m_ch.show",$build[0]->id)}}',
                    data:{type:'build'}
                },
            serverSide: true,
            scrollCollapse: true,
            paging: true,
            columns: [ 
               {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},   
                { data: 'Name', name: 'Name',orderable:false,searchable:false  },
                { data: 'Code', name: 'Code' },
                { data: 'Type', name: 'Type',orderable:false,searchable:false },
                { data: 'Date', name: 'Date',orderable:false,searchable:false },
                { data: 'Quantity', name: 'Quantity',orderable:false,searchable:false },
                { data: 'Measure', name: 'Measure',orderable:false,searchable:false },
                { data: 'Cost', name: 'Cost',orderable:false,searchable:false },
        
        ]

        });
    });


    $(document).ready(function () {
		var dd = null;
        $('#builds_roll').DataTable({
			ajax:{
                    url:'{{route("build_m_ch.show",$build[0]->id)}}',
                    data:{type:'roll'}
                },
			serverSide: true,
            scrollCollapse: true,
            paging: true,
            columns: [    
            {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false}, 
                { data: 'Name', name: 'Name',orderable:false,searchable:false  },
                { data: 'Code', name: 'Code' },
                { data: 'Type', name: 'Type',orderable:false,searchable:false },
                { data: 'Date', name: 'Date',orderable:false,searchable:false },
                { data: 'Quantity', name: 'Quantity',orderable:false,searchable:false },
                { data: 'Measure', name: 'Measure',orderable:false,searchable:false },
                { data: 'Cost', name: 'Cost',orderable:false,searchable:false },
                { data: 'widths', name: 'widths',orderable:false,searchable:false },
                @if(getOtherMeasure()=="true")
                { data: 'other_measure', name: 'other_measure',orderable:false,searchable:false },
                @endif
                @if(getOtherMeasure2()=="true")
                { data: 'other_measure2', name: 'other_measure2',orderable:false,searchable:false },
                @endif
                { data: 'actions', name: 'actions',orderable:false,searchable:false },
        ],

        });
    });

    $(document).ready(function () {
		var dd = null;
        $('#build_wastage').DataTable({
			ajax:{
                    url:'{{route("build_m_ch.show",$build[0]->id)}}',
                    data:{type:'wastage'}
                },
			serverSide: true,
            scrollCollapse: true,
            paging: true,
            columns: [    
            {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false}, 
                { data: 'name', name: 'name',orderable:false,searchable:false  },
                { data: 'Type', name: 'Type',orderable:false,searchable:false },
                { data: 'Date', name: 'Date',orderable:false,searchable:false },
                { data: 'qty', name: 'qty',orderable:false,searchable:false },
                { data: 'Measure', name: 'Measure',orderable:false,searchable:false },
                { data: 'Cost', name: 'Cost',orderable:false,searchable:false }
        
        ],

        });
    });

</script>
 
@endpush 