@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    
@stop

@section('content')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title hidden-print">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.BuildAssembly')</span>
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
                <div class=" pull-right">
                  <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()"/><i class="fa fa-print"></i>  @lang('layout.PrintBuildOrder')</a>
                </div>
            </div>
            <div class="portlet-body form" id="assembaly" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($build,['method' => 'PATCH','route' => ['build_change.update',$build->id],'files'=> true, 'id'=>'build-form'])!!}
				<div class="form-body">
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12 hidden-print">
                           
                                <!-- div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.ItemName')</label>
                                            <v-select label="name" v-model="selected_item" :options="items" @input="getItemFormula(this)" @search="onItemSearch"></v-select>

                                            <input type="hidden" name="item" :value="(!selected_item)?null:selected_item.item_id">

                                        </div> 
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.FormulaName')</label>
                                            <select class="form-control" v-model="selected_formula" @click="change_formula()">
                                                <option>@lang('layout.Select')</option>
                                                <option v-for="formula in formula_list" :value="formula">@{{formula.code+'-'+formula.name}}</option>
                                            </select>
                                            <input type="hidden" name="formula" :value="(!selected_formula)?null:selected_formula.id">
                                        </div>
                                    </div>
                                </div -->
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.SiteName')</label>

                                                <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site"  >
                                                    
                                                </v-select>
                                                <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null">
                                                    <input type="hidden" placeholder="@lang('layout.EnterQuantityToBuild')" readonly name="build_qty" v-model="buildQty" class="form-control">

                                        </div>
                                    </div>

                                    <!-- div class="col-md-6">
                                          <div class="form-group">
                                              <label class="control-label ">@lang('layout.QuantityToBuild')</label>
                                                    <input type="hidden" placeholder="@lang('layout.EnterQuantityToBuild')" readonly name="build_qty" v-model="buildQty" class="form-control">
                                  
                                          </div>
                                    </div -->
                                     <div class="col-md-4">
                                          <div class="form-group">
                                              <label class="control-label ">@lang('layout.Date')</label>
                                                  <input class="form-control date" name="date" readonly="readonly" autocomplete="off" value="{{$build->date}}">
                                          </div>
                                    </div>
                                    <div class="col-md-3">
                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.AssemblyCode') </label>
                                              <input type="number" name="number" value="{{$build->number}}" class="form-control">
                                          </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-7">

                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.Description') </label>
                                              <textarea  name="description" class="form-control" rows="2">{{$build->description}}</textarea>
                                          </div>
                                    </div>
									<div class="col-md-1">
									<div class="form-group">
									<label class="control-label">@lang('layout.Simple')   
									<input type="checkbox" name="simple"  v-model="simple" class="form-control">
									</label>
									</div>
                                    </div>
                                    <div class="col-md-1">
                                        <div class="form-group">
                                        <label class="control-label">@lang('layout.NoWidth')   
                                        <input type="checkbox" name="noWidth"  v-model="noWidth" class="form-control">
                                        </label>
                                        </div>
									</div>
									<div class="col-md-1">
									    <div class="form-group">
                                            <label class="control-label">@lang('layout.Check')   
                                            <input type="checkbox" name="check"  value="ok" class="form-control">
                                            </label>
                                        </div>
									</div>
                                </div>

                            
                        </div>
                        <!--  calculation part -->
                        <div class="col-lg-4 col-md-4 col-sm-12">
                            <div class="row">
                              <label class="control-label"> @lang('layout.Formula')</label>
                                <div class="dashboard-stat2 ">

                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small>@lang('layout.ItemName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{ (selected_item)?selected_item.name:null }}</span>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.MeasureName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{(selected_item)?selected_item.measure:null }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.FormulaName') :</small>
                                            </td>
                                            <td class="text-right">

                                                <span data-counter="counterup"
                                                data-value="">@{{ (selected_formula)?selected_formula.name:null }}</span>
											</td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <small>@lang('layout.QuantityToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{Number.parseFloat(subtotal).toFixed(1)}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>
										
										<tr>
                                            <td>
                                                <small>@lang('layout.AfterBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{Number.parseFloat(remain).toFixed(1)}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>
                                        @if(getBuildExpense() == "true")
                                        <tr>
                                            <td>
                                            <small>@lang('layout.TotalExpense'):</small>
                                            </td>
                                            <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800"> @{{ expenseAmount }} {{getHomeCurrency()["code"]}}</span>
                                            <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>
                                        @endif

                                        <!-- tr>
                                            <td>
                                                <small>@lang('layout.Price'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                      data-value="7800">@{{ Number.parseFloat(subtotal).toFixed(precision())}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr -->


                                    </table>

                                </div>
                            </div>
                        </div>
                       <!-- end of calculation -->
                       <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                    </div>

                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
						<table id="table_content" class="table table-bordered table-responsive table-full-width .met">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Item')</th>
                                <th class="text-center" style="min-width: 60px;"> @lang('layout.Code')</th>
                                <th class="text-center" style="min-width: 60px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 60px;"> @lang('layout.ToBuild')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Width')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Length')</th>
                                <!-- th class="text-center" style="min-width: 80px;"> @lang('layout.Price')</th -->
                                <th class="text-center" style="width: 10px;"></th>
                            </tr>
                            </thead>
                            <tbody>
							<!--/row-->
							<tr v-for="(service,index) in services">
								
								<td>
									<v-select label="name" v-model="service.selected_sub_item_name" :options="FormilaItemsName" @search="onItemSearchName" @input="change_name(index)" placeholder="@lang('layout.Name')" style=""></v-select>
								</td>
								<td>
									<v-select label="name" v-model="service.selected_sub_item" :options="FormilaItems" @search="onItemSearchFormila"  @input="check_qty(0)"  placeholder="@lang('layout.Code')" ></v-select>
									<input type="hidden" name="sub_item" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id">
									<input type="hidden" id="item_id" name="m_stocks_in_id" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id" >
									<input type="hidden" name="main_stock_id" :value="(!service.selected_sub_item)?null:service.selected_sub_item.main_stock_id" >
									<input type="hidden" name="items_id" :value="(!service.selected_sub_item)?null:service.selected_sub_item.items_id" >
									<input type="hidden" name="inventory_id_out" :value="(!service.selected_sub_item)?null:service.selected_sub_item.inventory_id" >
									<input type="hidden" name="measure_id" :value="(!service.selected_sub_item)?null:service.selected_sub_item.measure_id" >
								</td>
								<td>
										<input :value="(!service.selected_sub_item)?null:service.selected_sub_item.Measure" class="form-control" placeholder="@lang('layout.Measure')"   >
								</td>
								<td>
										<input name="qut_out" id="item_quantity" ref="OnHand" type="number"  @input="change_qut(index)"  @click="change_qut(index)" :value="(!service.selected_sub_item)?null:service.selected_sub_item.OnHand" class="form-control" placeholder="@lang('layout.ToBuild')"   >
								</td>
								<td>
										<input type="number" ref="width" @input="change_lengths(index)" @click="change_lengths(index)"  :value="(!service.selected_sub_item)?null:service.selected_sub_item.widths" class="form-control" placeholder="@lang('layout.Width')" >
							   </td>
								<td>
										<input type="number"  name="" :value="(!service.selected_sub_item)?null:service.selected_sub_item.qut_temp" disabled  placeholder="@lang('layout.OnHand')" class = 'form-control' >
								</td>
								<td>
										<input name="lengths_out" readonly type="number"  :value="(!service.selected_sub_item)?null:Number.parseFloat(service.selected_sub_item.lengths).toFixed(1)" class="form-control" placeholder="@lang('layout.Length')" >
								 </td>
								
								<!-- td>
										<input name="cost_out" type="number" :value="(!service.selected_sub_item)?null:service.selected_sub_item.per_price" ref="per_price" @input="setNewRate(index)" class="form-control" placeholder="@lang('layout.Price')" >
								</td -->
								<td>
									 <span  v-if="index != 0" v-on:click="deleteItem_roll(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
								
							</tr>

                            </tbody>
                        </table>
                        <button v-if="services.length <= 0" type="button" class="btn default" @click="addNew('base_item',0)">@lang('layout.AddItem')</button>
                    <hr>
                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.ChangeToRoll') </li>
                    <div  v-if=""  class="" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-responsive table-full-width">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Code')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Width')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Length')</th>
                                @if(itemBrand()=="true")
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Brand')</th>
                                @endif
                                @if(showLocation()=="true")
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Location')</th>
                                @endif
                                @if(getOtherMeasure()=="true")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.OMeasureValue1')</th>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.OMeasureValue2')</th>
                                @endif
                                <th class="text-center" ></th>
                            </tr>
                            </thead>
                            <tbody>
							 <!--/row-->
							<tr v-for="(item,index) in formula_items">
							
								<td> @{{ index+1 }} </td>
								<td>
									<v-select label="name" v-model="item.s_formula" :options="subItems" @search="onItemSearchCode" @click.native="addNew_roll(index)" placeholder="@lang('layout.ItemName')" style=""></v-select>
									<input type="hidden" name="inventory_id[]" :value="(!item.s_formula)?null:item.s_formula.id" >
                                    <input type="hidden" name="item_id[]" :value="(!item.s_formula)?null:item.s_formula.item_id" >
                                    
									<input type="hidden" name="main_stocks_id_old[]" :value="(!item)?null:item.main_stocks_id" >
									<input type="hidden" name="m_stocks_in_id_old[]" :value="(!item)?null:item.m_stocks_in_id" >
								</td>
								<td>
                                    <select v-if="(item.s_formula !=null)" v-model="(item.s_formula == null)?null:item.s_formula.measure_select"  class="form-control input_style"
                                             placeholder="Measure"
                                            
                                             required="required">

                                       <span v-if="item.s_formula.measure_list !=null">
                                            <option v-if="(item.s_formula !=null)"
                                                v-for="measures in item.s_formula.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select> 
                                    <input type="hidden" name="inventory_measure[]" :value="(item.s_formula==null)?null:(item.s_formula.measure_select)?item.s_formula.measure_select.measure_id:null">
                                    <input type="hidden" name="measure_unit_selected[]" :value="(item.s_formula==null)?null:(item.s_formula.measure_select)?item.s_formula.measure_select.measure_unit:null">
                                    <input type="hidden" name="um_id[]" :value="(!item.s_formula)?null:item.s_formula.um_id" >
								    <input type="hidden" name="measure_unit[]" :value="(!item.s_formula)?null:item.s_formula.measure_unit" >
                                </td>
								
								<td>
									<input name="code[]" type="text" :value="(item.s_formula)?item.s_formula.code:null" ref="code" @input="change_qut_in(index)" class="form-control" placeholder="@lang('layout.Code')" >
								</td>
								<td>
									<input name="qut_in[]"  v-model="formula_items[index].qut_in" @input="addQut(index)" ref="OnHand_in" type="number" placeholder="@lang('layout.Quantity')" class = 'form-control' >
								</td>
								<td>
									<input name="widths[]"  v-model="formula_items[index].widths" @input="addWidth(index)" ref="widths" type="number"  class="form-control" placeholder="@lang('layout.Width')" >
							   </td>
								
								<td>
									<input name="lengths[]" :value="(item.s_formula)?item.s_formula.lengths:null" ref="lengths_in" @input="change_qut_in(index)" type="number" class="form-control" placeholder="@lang('layout.Length')" >
                                </td>
                                @if(itemBrand()=="true")
                                <td>
                                    <v-select placeholder="@lang('layout.Brand')" label="name" :options="brand" v-model="item.selectedBrand"></v-select>
                                    <input type="hidden" name="brand_id[]" :value="(item.selectedBrand)?item.selectedBrand.id:null">
                                </td>
                                @endif  
                                @if(showLocation()=="true")
                                <td>
                                    <input name="location[]" type="text" v-model="(!item)?null:item.location" class="form-control" placeholder="@lang('layout.Location')">
                                </td>
                                @endif  
                                @if(getOtherMeasure()=="true")
                                <td>
                                    <input name="o_measure_value1[]" type="number" v-model="(!item.s_formula)?null:item.s_formula.other_measure" class="form-control" placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <td>
                                    <input name="o_measure_value2[]" type="number" v-model="(!item.s_formula)?null:item.s_formula.other_measure2" class="form-control" placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                @endif
								<td>
									 <span  v-if="index != 0" v-on:click="deleteItem_roll(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
							</tr>

                            </tbody>
                        </table>

                    </div>
                    <hr>
                     <li class="list-group-item bg-green bg-font-green"> @lang('layout.AdjastmentItems') </li>
                    <div class="" id="printarea" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
							    <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th>
							    <th class="text-center" style="min-width: 5px;"></th>
                            </tr>
                            </thead>
                            <tbody>
							<!--/row-->
							<tr v-for="(item,index) in other_build">
						
								<td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
								
							  <td>
									<v-select label="name" v-model="item.other_build_row" :options="other_build_item" @search="onItemSearchOther" @click.native="addOtherBuildItems(index)" placeholder="@lang('layout.ItemName')" ></v-select>
									<input type="hidden" name="other_build_inventory_id[]" :value="(!item.other_build_row)?null:item.other_build_row.item_id" >
								</td>
								<td>
										<input :value="(!item.other_build_row)?null:item.other_build_row.Measure" type="text"   class="form-control" placeholder="@lang('layout.Measure')"   >
										<input type="hidden" name="other_build_measure[]" :value="(!item.other_build_row)?null:item.other_build_row.um_id" >
								</td>
								<td>
                                <input type="number" name="other_build_qty[]" v-model="(!item.other_build_row)?null:item.other_build_row.new_quantity"  style="width: 100%;" >
                              </td>
                              <td>
                                  <div class="input-group">
                                      <input type="number" class="form-control" v-model="(!item.other_build_row)?null:item.other_build_row.cost" 
                                      placeholder="%" style="min-width: 100px" required name="other_build_cost[]" />
                                      <span class="input-group-addon">%</span>
                                  </div>
                              </td>
							  
								<td>
									 <span  v-if="index != 0" v-on:click="deleteOtherBuildItems(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
							</tr>
							

						</tbody>
						</table>
						</div>
                    <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addNew('inventory')">@lang('layout.AddItem')
                    </button>

                    @if(getBuildExpense() == "true")
                    <!-- build expense -->

                        <div class="form-section"></div>
                        <li class="list-group-item bg-green bg-font-green"> @lang('layout.Expense') </li>

                        <div v-if="expenses.length >0 " class="">

                            <table id="table_content" class="table table-bordered">
                                <thead>
                                <tr>
                                    <th class="text-center" style="width: 25px;"> #</th>
                                    <th class="text-center"
                                        style="min-width: 160px;">@lang('layout.ExpenseAccount')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Description')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                    <th style="width: 20px;"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(expense,index) in expenses" class="even">
                                    <td class="td_one"><span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                    </td>
                                    <td class="td_one">
                                        <v-select label="name" v-model="expense.expense_account" :options="expense_account"
                                                  @click.native="addNew('expense',index)"></v-select>
                                        <input type="hidden" name="expense_id[]" :value="(expense.expense_account==null)?null:expense.expense_account.id">
                                    </td>
                                    <td>
                                        <input type="text" name="expense_description[]" class="form-control"
                                               placeholder="@lang('layout.Description')" v-model="expense.description">
                                    </td>
                                    <td>
                                        <input type="number" name="expense_amount[]" class="form-control"
                                               placeholder="@lang('layout.Amount')" v-model="expense.amount">
                                    </td>
                                    <td>
                                        <span v-on:click="deleteItem('expense',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                    </td>
                                </tr>

                                </tbody>
                            </table>

                        </div>
                    @endif
                    <!-- end build expense -->

                    <div class="row hidden-print">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('assembly.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>

                </div>
                {{Form::close()}}
            </div>

            <!-- END FORM-->
        </div>
    </div>
     
@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>
<script>

 

     Vue.component('v-select', VueSelect.VueSelect);
    var site={!! $site !!};
    var buildDetail          = {!! $buildDetail !!};
    var buildDetailName          = {!! $buildDetailName !!};
    var otherBuildDetail     = {!! $otherBuildDetail !!};
    var opening     = {!! $opening !!};
    var selectedSite     = {!! $selectedSite !!};
    var build     = {!! $build !!};
    var expense_account = {!! $expense_account !!};
    var selectExpense = {!! $selectExpense !!};
    var brand = {!!json_encode($brand) !!};
	//console.log(site);
    var sales = new Vue({
        el:'#assembaly',
        data:{
            site:site,
            buildDetail:buildDetail,
            buildDetailName:buildDetailName,
            selected_site:selectedSite,
            otherBuildDetail:otherBuildDetail,
            opening:opening,
            brand:brand,
            selected_item:null,
            
            noWidth:false,
            buildQty:build.qty,
            onhandQty:0,
            remain:0,
            simple:false,
            assembly_item:[],
            temp_items:[],
            items:[],
            subItems:[],
            FormilaItems:[],
            FormilaItemsName:[],
            other_build_item:[],
            formula_list:[],
            selected_formula:null,
            assemlby_items: [
              {item:null},
              {item:null},
              {item:null},
              {item:null},
            ],
			services:[
			],
			
			subMeasureSelected:[],
			formula_items:[
			],
			other_build:[
			],
            selectExpense: selectExpense,
            expense_account: expense_account,
            expenses: [],
			Indexbase:0,
        },
	computed:{
          // calculate subtotal
          subtotal: function ()
          {
			  this.Indexbase = (this.formula_items)?(this.formula_items.length - 1):0;
			 //console.log('test 22',this.Indexbase);
			  var item_quantity = $("#item_quantity").val();
                var sum = 0;
                var buildQu = 0;
						   // console.log('ssas',this.formula_items);
                for (var i = 0; i < this.formula_items.length; i++) {
                    if (this.formula_items[i].qut_in > 0)
                    {  

                        var qut_in=this.formula_items[i].qut_in;
                        
                           // sum =Number(sum)+Number(OnHand*cost);
                           buildQu +=Number(qut_in);
						   // console.log('sss',buildQu);
                    }

                }
				//console.log('aaa',buildQu,'bbb',item_quantity);
				this.onhandQty = (item_quantity - buildQu)? (item_quantity - buildQu):0;
				this.buildQty = (buildQu)? (buildQu):0;
				buildQs = (buildQu)? (buildQu):0;
				// sum = (sum/buildQu)? sum/buildQu:0;
                return buildQs;
				
          },

          
                buildQ: function () 
                {
                  var min = null;
                  if(this.selected_formula)
                  {
                     var rows = this.selected_formula.formula;
                    
                      if(rows.length >0) 
                      {
                          var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));

                          //var temp_other_build=this.selected_formula.other_build;
                          min = rows[0].on_hand/temp;
                          for (var i = 1; i < rows.length; i++) 
                          {

                            var temp=((rows[i].new_quantity*rows[i].measure.measure_unit/rows[i].measure_unit));
                            var result= (rows[i].on_hand * rows[i].item_item_measure.measure_unit)/(rows[i].measure.measure_unit);

                            if (result / temp < min) 
                            {
                                min = result / temp;
                            }

                          }
                          min = Number.parseFloat(min).toFixed(precision());

                      }

                  }
                  return min;
              },
             isError:function()
             {
                var isError=false;
                if(this.selected_site==null || this.remain < 0)
                {
                  isError=true;
                }
                return isError;
             },

             expenseAmount: function() {
                var temp = 0;
                if (this.expenses) {
                var rows = this.expenses;
                    var buildQty = this.buildQty;
                    var count = 1000;
                    for (var i = 0; i < count; i++) {
                    if (rows[i] && buildQty) {
                        if (rows[i] && rows[i].amount != null) {
                        var temp = (temp + (Number.parseFloat(rows[i].amount) * Number.parseFloat(buildQty)));
                        }
                    }else{
                        count = 0;
                    }
                    }
                }
                return temp.toFixed(precision());
            },

        },


	
        mounted:function()
        {
			
            // initialize the selected item
            
            for(var i=0;i<this.buildDetail.length;i++)
            {
                this.services.push({selected_sub_item:this.buildDetail[i],selected_sub_item_name:this.buildDetailName[0]});
                
            }
            // console.log('test3333', this.services);
            for(var i=0;i<this.opening.length;i++)
            {
                var selectedBrand = null;
                if (this.opening[i].brand_id) {
                    selectedBrand = _.find(this.brand,(o) => o.id == this.opening[i].brand_id);
                }

                this.formula_items.push({s_formula:this.opening[i],qut_in:this.opening[i].qut_in,widths:this.opening[i].widths,selectedBrand:selectedBrand,location:this.opening[i].location,main_stocks_id:this.opening[i].main_stocks_id,m_stocks_in_id:this.opening[i].m_stocks_in_id});
                this.buildQty  +=Number(this.opening[i].qut_in);
            }
                
            for(var i=0;i<10;i++)
            {
            if(this.otherBuildDetail[i] && this.otherBuildDetail[i].name != null){
                this.other_build.push({other_build_row:this.otherBuildDetail[i]});
            }
            }

            for (var x = 0; x < this.selectExpense.length; x++) {
                this.expenses.push({
                    expense_account: this.selectExpense[x].expense_account, info: this.selectExpense[x], description: this.selectExpense[x].description, amount: this.selectExpense[x].amount
                });
            }

            for (var m = 4; m > this.selectExpense.length; m--) {

                this.expenses.push({expense_account: null, info: null, description: null, amount: null});
            }


		    // console.log(this.other_build);
		
		},

      methods:{
			 change_formula()
      {            
         // this.services = [];
         this.services = [{selected_sub_item:null}];
      },

	  change_data()
      {       
         // this.subtotal;
		 setTimeout(function(){ sales.deleteItem_rolls(1000); }, 30);
		 
		 // var alls = this.subtotal;
		 // console.log('aa');
      },
	  change_lengths(index)
      {       
	  // console.log('newe',this.services[index].selected_sub_item.unit);
			if(this.services[index].selected_sub_item)
				  {
					var per_qut_in=this.services[index].selected_sub_item.per_qut_in;
					var width = this.$refs.width[index].value;
					 this.services[index].selected_sub_item.widths = this.$refs.width[index].value;
                     if (!this.noWidth) {
					 this.services[index].selected_sub_item.OnHand = Number.parseFloat(per_qut_in * width).toFixed(1);
                    }
				}
            this.check_qty(index);     
		//  setTimeout(function(){ sales.deleteItem_rolls(1000); }, 30);
      },
	  change_qut(index)
      {       
			if(this.services[index].selected_sub_item)
				  {
					var per_qut_in=this.services[index].selected_sub_item.per_qut_in;
					var OnHand = this.$refs.OnHand[index].value;
					 this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
					 
                     if (!this.noWidth) {
					 this.services[index].selected_sub_item.widths = Number.parseFloat(OnHand / per_qut_in).toFixed(1);
                     } else {
                        this.services[index].selected_sub_item.widths = 0;
                     }

				}
            this.check_qty(index);  
        //  setTimeout(function(){ sales.deleteItem_rolls(1000); }, 30);
      },
	  
	  change_qut_in(index)
      {       
	  
				if(this.formula_items[index].s_formula)
				  {
					 this.formula_items[index].s_formula.qut_in = this.$refs.OnHand_in[index].value;
					 this.formula_items[index].s_formula.lengths = this.$refs.lengths_in[index].value;
					 this.formula_items[index].s_formula.code = this.$refs.code[index].value;
					 this.formula_items[index].s_formula.widths = this.$refs.widths[index].value;
				}
	  
         setTimeout(function(){ sales.deleteItem_rolls(1000); }, 30);
      },
	  
	   addWidth(index)
      {       
	  // console.log('wwe', this.formula_items[index].s_formula.measure_select.measure_unit);
	  // console.log('wwe', this.services[0].selected_sub_item);
			if(this.formula_items[index].widths && !this.simple)
				  {
					var per_qut_in=this.services[0].selected_sub_item.per_qut_in;
					var width = this.formula_items[index].widths;
					 // this.services[index].selected_sub_item.widths = this.$refs.width[index].value;
					 this.formula_items[index].qut_in = Number.parseFloat(per_qut_in * width).toFixed(1);
				}
				
				if(this.formula_items[index].s_formula && this.services[0].selected_sub_item){
				var all = 0;
				var On_hand = 0;
				var unit = 0;
				var On_hand = this.services[0].selected_sub_item.OnHand;
				var unit = this.services[0].selected_sub_item.unit;
				
				for (var i = 0; i < this.formula_items.length; i++) {
					if(this.formula_items[i].s_formula){
					var qut_in = this.formula_items[i].qut_in;
					var measure_unit = this.formula_items[i].s_formula.measure_select.measure_unit;
					all += (qut_in * measure_unit);
					}	
				}	
				this.remain = (((On_hand * unit) - all) / unit );
				}	
				
		 setTimeout(function(){ sales.deleteItem_rolls(1000); }, 30);
      },
	  addQut(index)
      {       
	  
			if(this.formula_items[index].qut_in && !this.simple)
				  {
					var per_qut_in=this.services[0].selected_sub_item.per_qut_in;
					var OnHand = this.formula_items[index].qut_in;
					 // this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
					 this.formula_items[index].widths = Number.parseFloat(OnHand / per_qut_in).toFixed(1);
				}
				
				
			if(this.formula_items[index].s_formula && this.services[0].selected_sub_item){
				var all = 0;
				var On_hand = 0;
				var unit = 0;
				var On_hand = this.services[0].selected_sub_item.OnHand;
				var unit = this.services[0].selected_sub_item.unit;
				
				for (var i = 0; i < this.formula_items.length; i++) {
					if(this.formula_items[i].s_formula){
					var qut_in = this.formula_items[i].qut_in;
					var measure_unit = this.formula_items[i].s_formula.measure_select.measure_unit;
					all += (qut_in * measure_unit);
					}	
				}	
				this.remain = (((On_hand * unit) - all) / unit );
			}	
	  
         setTimeout(function(){ sales.deleteItem_rolls(1000); }, 30);
      },
	  check_qty(index)
      {       
			if(this.formula_items[index].s_formula && this.services[0].selected_sub_item){
				var all = 0;
				var On_hand = 0;
				var unit = 0;
				var On_hand = this.services[0].selected_sub_item.OnHand;
				var unit = this.services[0].selected_sub_item.unit;
				
				for (var i = 0; i < this.formula_items.length; i++) {
					if(this.formula_items[i].s_formula){
					var qut_in = this.formula_items[i].qut_in;
					var measure_unit = this.formula_items[i].s_formula.measure_select.measure_unit;
					all += (qut_in * measure_unit);
					}	
				}	
				this.remain = (((On_hand * unit) - all) / unit );
			}	
	  
         setTimeout(function(){ sales.deleteItem_rolls(1000); }, 30);
      },
	  
           // calculate item price based on measure change
           measureChange(index)
           {
              
               if(this.selected_formula)
               {
                  
                  var item=this.selected_formula.formula[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.formula[index].new_quantity =result;
              
                    
              }
           },
           measureChangeOtherBuild(index)
           {
              if(this.selected_formula)
              {
                  var item=this.selected_formula.other_build[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.other_build[index].new_quantity =result;   
              }
           },
            getItemFormula(e)
            {
                if(this.selected_item && this.selected_item !=null)
                {
                     this.formulaSearch(this.selected_item.item_id,this);
                }
            },
         
           //ajax call to get items
           onItemSearch:_.debounce((search,loading)=>{
               sales.formula_list=[];
               sales.selected_formula=null;
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblyList',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 sales.items=[];
                 if(response.data.length>0)
                 {
                    sales.items=response.data;
                    console.log('sssss',sales.items);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
		   
		   
		            
           //ajax call to get items code
           onItemSearchName:_.debounce((search,loading)=>{
               item_id = '';
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblySubListName',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 sales.FormilaItemsName=[];
                 if(response.data.length>0)
                 {
                    sales.FormilaItemsName=response.data;
                    console.log('FormilaItemsName',sales.FormilaItemsName);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
		   
         
           //ajax call to get items code
           change_name(index){
			   // console.log('in num',index,'aa',sales.services[index].selected_sub_item_name.items_id);
               
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblySubList',
                  item_id:sales.services[index].selected_sub_item_name.items_id,
                }
               })
               .then(function (response)
               {
                 sales.FormilaItems=[];
                 if(response.data.length>0)
                 {
                    sales.FormilaItems=response.data;
                    //console.log('FormilaItems',sales.FormilaItems);
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },
		   
         
           //ajax call to get items code
           onItemSearchFormila:_.debounce((search,loading)=>{
               if (sales.services[index].selected_sub_item_name != null) {
                item_id = sales.services[index].selected_sub_item_name.items_id,
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblySubList',
                  keyword:search,
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 sales.FormilaItems=[];
                 if(response.data.length>0)
                 {
                    sales.FormilaItems=response.data;
                    console.log('FormilaItems',sales.FormilaItems);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
               }
           },getDebounceTime()),
		   
           //ajax call to get items code
           onItemSearchCode:_.debounce((search,loading)=>{
			   loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'getFormulaSubItem',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 sales.subItems=[];
                 if(response.data.length>0)
                 {
                    sales.subItems=response.data;
                    console.log('subItems',sales.subItems);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
           //ajax call to get items code
           onItemSearchOther:_.debounce((search,loading)=>{
			   loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'getFormulaOtherItem',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 sales.other_build_item=[];
                 if(response.data.length>0)
                 {
                    sales.other_build_item=response.data;
                    console.log('other_build_item',sales.other_build_item);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
           // end item search
            //ajax call to get formula
           formulaSearch(item_id,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'item_formula',
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 this.formula_list=[];
                 if(response.data.length>0)
                 {
                    vm.formula_list=response.data;
                    console.log('test 3333333',vm.formula_list);
                  
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end formula search
           // items serarch method
            onItemsSearch(search,loading)
           {  
               this.temp_items=[];
               loading(true);
               this.itemsSearch(search,loading,this);
           },
           itemsSearch(search,loading,vm)
           {
               this.temp_items=[];
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'items_search_assebley',
                  'type':'assembaly',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.temp_items=response.data;
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },

            addNew(type=null,index)
            { 
              if(type !=null)
              {
                 if(type=='inventory')
                 { 
                    if(this.assemlby_items[index+1]==undefined)
                    {
                      this.assemlby_items.push({item:null});
                    }
                 } 
                 if(type=='otherBuilds')
                 { 
                    if(this.otherBuild[index+1]==undefined)
                    {
                      this.otherBuild.push({item:null});
                    }
                 }
                 if(type=='base_item')
                 { 
                    if(this.services[0]==undefined)
                    {
                        this.services.push({selected_sub_item:null,selected_sub_item_name:null});
                    //   this.otherBuild.push({item:null});
                    }
                 }

                 if (type == 'expense') {
                    if (this.expenses[index + 1] == undefined) {
                        this.expenses.push({expense_account: null, info: null, description: null, amount: null});
                    }
                }
                  
              }
              
           },

            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'expense') {
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                this.expenses.splice(index, 1);
                            }
                            else {
                            
                            }
                        });
                        
                    }

                }

            },
		   
            deleteOtherBuildItems(index)
           {
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        this.other_build.splice(index, 1);
                    }
                    else {
                    
                    }
                });
				
           },

           addOtherBuildItems(index)
           { 
                   sales.other_build_item=[];
				   if(this.other_build[index+1]==undefined)
						{
						sales.other_build.push({other_build_row:null});
						}				   
                     
              },
			  
			  // generic function for adding item to list
				addNew_roll(index)
				{
					for(var i=0;i<this.formula_items.length;i++)
						{
					if(this.formula_items[i].code != null){
							this.formula_items[i].s_formula.code = this.$refs.code[i].value;
							this.formula_items[i].s_formula.lengths = this.$refs.lengths[i].value;
							this.formula_items[i].s_formula.widths = this.$refs.widths[i].value;
							this.formula_items[i].s_formula.qut_in = this.$refs.qut_in[i].value;
					  
						}
						}
						sales.subItems=[];
						if(this.formula_items[index+1]==undefined)
						{
						  this.formula_items.push({
							s_formula:null,
                            selectedBrand:null,
                            location:null,
                            qut_in:null,
                            widths:null,
                            main_stocks_id:null,
                            m_stocks_in_id:null
						});
						}
				  
				},
				// delete item from list
				deleteItem_roll(index)
				{
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            this.formula_items.splice(index, 1);
                        }
                        else {
                        
                        }
                    });
				  
				},
				// delete item from list
				deleteItem_rolls(index)
				{
                    this.formula_items.splice(index, 1);
				},
				   // set new price
			   setNewRate(index)
			   {
				   
				  if(this.services[index].selected_sub_item)
				  {
					 this.services[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
					 this.services[index].selected_sub_item.widths = this.$refs.width[index].value;
					 this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
					 
					 // this.services[index].selected_sub_item.qut_temp = this.services[index].selected_sub_item.qut_in;
				  }
				  this.deleteItem_rolls(1000);
			   },
			  
        }
    });



</script>


@endpush