@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    
@stop

@section('content')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditBuild')</span>
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <div class="portlet-body form" id="assembaly" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($build,['method' => 'PATCH','route' => ['build_m_code.update',$build->id],'files'=> true, 'id'=>'build-form'])!!}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12">
                            <div class="row">
                               
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.ItemName')</label>
                                            <v-select label="name" v-model="selected_item" :options="items"  @search="onItemSearch" disabled></v-select>

                                            <input type="hidden" name="item" :value="(!selected_item)?null:selected_item.item_id">

                                        </div>
                                    </div>
									<div class="col-md-6">
                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.AssemblyCode') </label>
                                              <input type="number" readonly name="number" value="{{$build->number}}" class="form-control">
                                          </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.SiteName')</label>

                                                <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site" disabled  >
                                                    
                                                </v-select>
                                                <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null">

                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                          <div class="form-group">
                                              <label class="control-label ">@lang('layout.QuantityToBuild')</label>
                                                    <input type="number" placeholder="@lang('layout.EnterQuantityToBuild')" readonly name="build_qty" v-model="(buildQty == 0)?myRound(subtotals):myRound(buildQty)" class="form-control">
                                  
                                          </div>
                                    </div>
									
                                </div>

                                <div class="row">
                                    <div class="col-md-12">

                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.Description') </label>
                                              <textarea  name="description" readonly class="form-control" rows="2">
                                              {{$build->description}}    
                                              </textarea>
                                          </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <!--  calculation part -->
                        <!-- div class="col-lg-4 col-md-4 col-sm-12">
                            <div class="row">
                              <label class="control-label"> @lang('layout.Formula')</label>
                                <div class="dashboard-stat2 ">

                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small>@lang('layout.ItemName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{ (selected_item)?selected_item.name:null }}</span>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.MeasureName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{ (selected_item)?selected_item.measure:null }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.FormulaName') :</small>
                                            </td>
                                            <td class="text-right">

                                                <span data-counter="counterup"
                                                data-value="">@{{ (selected_formula)?selected_formula.name:null }}</span>

                                            </td>
                                        </tr>

										<tr>
                                            <td>
                                                <small>@lang('layout.QuantityUsedToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{(subtotal == 0)?myRound(subtotals):myRound(subtotal)}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>


                                        <tr>
                                            <td>
                                                <small>@lang('layout.QuantityToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{myRound(buildQtyB)}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <small>@lang('layout.AfterBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{myRound(subtotal - buildQtyB)}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>


                                    </table>

                                </div>
                            </div>
                        </div -->
                       <!-- end of calculation -->
                    
                    </div>
					
					<li class="list-group-item bg-green bg-font-green"> @lang('layout.Item') </li>
                    <div v-if="formulaDataIn" class="" id="printarea" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Code')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Wing')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Width')</th>
                                <th> </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in formulaDataIn">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
								<td>
									<v-select label="name" v-model="item.item" :options="newItems" placeholder="@lang('layout.ItemName')" ></v-select>
									<input type="hidden" name="item_id_in" :value="(!item.item)?null:item.item.item_id" >
									<input type="hidden" name="inventory_id_in" :value="(!item.item)?null:item.item.inventory_id" >
									<input type="hidden" name="m_stocks_in_id" :value="(!item.item)?null:item.item.id" >
								</td>
                                <td> 
									<input name="code_in" type="text" v-model="(!item)?null:item.code" class="form-control" placeholder="@lang('layout.Code')" >
								</td> 
                              
                                <td> 
									<input name="quty_in" type="number" class="form-control" placeholder="@lang('layout.OnHand')"  v-model.number="item.qty"  >
								</td> 
                              
                                <td> 
									<input name="khada" type="number" v-model="(!item)?null:item.khada" class="form-control" placeholder="@lang('layout.Wing')" >
								</td> 
                                <td> 
									<input name="widths" type="number" v-model="(!item)?null:item.item.widths" class="form-control" placeholder="@lang('layout.Width')" >
								</td> 
								<td>
									 <span  v-if="formulaDataIn.length != 1" v-on:click="deleteBundl(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
                              
							</tr>
                            </tbody>
                        </table>

                    </div>
                    
					<br/>
					

                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button"  @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('assembly.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>

                </div>
                {{Form::close()}}
            </div>

            <!-- END FORM-->
        </div>
    </div>
     
@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>
<script>
    Vue.component('v-select', VueSelect.VueSelect);
    var site                 = {!! $site !!};
    var selectedSite         = {!! $selectedSite !!};
    var build                = {!! $build !!};
    var m_stocks_ins         = {!! $m_stocks_ins !!};
    var buildQty;
    var sales = new Vue({
        el:'#assembaly',
        data:{
            site:site,
            selected_site:selectedSite,
            build:build,
            buildQtyB:0,
            buildQty:build.qty,
            subtotals:build.qty,
            m_stocks_ins:m_stocks_ins,
            assembly_item:[],
            temp_items:[],
            newItems:[],
            items:[],
            subItems:[],
            formula_list:[],
            selected_formula:null,
			
			
            selected_item:m_stocks_ins,
            
			
			
			assemlby_items: [
              {item:null},
              {item:null},
              {item:null},
              {item:null},
            ],
            formulaDataIn: [],
			services:[],
			
			Indexbase:0,
        },
        created:function()
        {
            if(this.selected_formula)
            {
                var rows = this.selected_formula.formula;
                if(rows.length>0)
                {
                    for(var x=0; x<rows.length;x++)
                    {
                            rows[x].new_quantity = buildDetail[x].quantity;
                    }  
                }
            }
        },
        computed:{
			
			
			// calculate subtotal
          subtotal: function ()
          {
			  this.Indexbase = (this.selected_formula)?(this.selected_formula.formula.length - 1):0;
			  
			   var qtyBundl = 0;
                for (var i = 0; i < this.formulaDataIn.length; i++) {
                    if (this.formulaDataIn[i].qty && this.formulaDataIn[i].qty !=null)
                    {  
                        var OnHand1=this.formulaDataIn[i].qty;
                           qtyBundl += parseFloat(OnHand1);
                    }

                }
			 this.buildQtyB = qtyBundl;
			 
			  var item_quantity = $("#item_quantity").val();
                var sum = 0;
                var buildQu = 0;
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].selected_sub_item && this.services[i].selected_sub_item.OnHand !=null)
                    {  

                        var OnHand=this.services[i].selected_sub_item.OnHand;
                        var cost=this.services[i].selected_sub_item.per_price;
                        
                           // sum =Number(sum)+Number(OnHand*cost);
                           sum += parseFloat(OnHand)*parseFloat(cost);
                           buildQu =Number(buildQu)+Number(OnHand);
						   
                        
                        
                    }

                }
				
				this.buildQty = (buildQu/item_quantity)? buildQu/item_quantity:0;
				buildQs = (buildQu/item_quantity)? buildQu/item_quantity:0;
				// this.subtotals = '';
				// sum = (sum/buildQu)? sum/buildQu:0;
			 // console.log('test 99',buildQs,buildQu);
                return buildQs;
				
          },

            
			
                buildQ: function () 
                {
                  var min = null;
                  if(this.selected_formula)
                  {
                     var rows = this.selected_formula.formula;
                    // console.log(this.selected_formula);
                      if(rows.length >0) 
                      {
                          var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));

                          var temp_other_build=this.selected_formula.other_build;
                          min = rows[0].on_hand/temp;
                          for (var i = 1; i < rows.length; i++) 
                          {
                              var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));
                              if (rows[i].on_hand / temp < min) 
                              {
                                  min = rows[i].on_hand / temp;
                              }

                          }
                          min = myRound(min);

                      }

                  }
                  return min;
              },
             isError:function()
             {
                var isError=false;
                if((this.formulaDataIn==null && !this.formulaDataIn))
                {
                  isError=true;
                }
                return isError;
             },
        },
        
        mounted:function()
        {
			
			if(this.m_stocks_ins)
            {
				
				this.formulaDataIn.push({item:this.m_stocks_ins, qty:this.m_stocks_ins.qut_in, code:this.m_stocks_ins.code, khada:this.m_stocks_ins.khada});

				console.log('code',this.m_stocks_ins);
            }
            // end item initialization
           
		
		},
        methods:{
			
			
			change_lengths(index)
      {       
			if(this.services[index].selected_sub_item)
				  {
					var per_qut_in=this.services[index].selected_sub_item.per_qut_in;
					var lengths = this.$refs.lengths[index].value;
					 this.services[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
					 this.services[index].selected_sub_item.OnHand = (per_qut_in * lengths);
				}
		 setTimeout(function(){ sales.deleteItem_roll(100); }, 30);
      },
	  change_qut(index)
      {       
         if(this.services[index].selected_sub_item)
			  {
				var per_qut_in=this.services[index].selected_sub_item.per_qut_in;
				var OnHand = this.$refs.OnHand[index].value;
				 this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
				 this.services[index].selected_sub_item.lengths = (OnHand / per_qut_in);
			}
		 setTimeout(function(){ sales.deleteItem_roll(100); }, 30);
      },
			
           // calculate item price based on measure change
           measureChange(index)
           {
              
               if(this.selected_formula)
               { 
                  var item=this.selected_formula.formula[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=myRound(temp);

                  this.selected_formula.formula[index].new_quantity =result;  
              }
           },
           measureChangeOtherBuild(index)
           {
              if(this.selected_formula)
              {
                  var item=this.selected_formula.other_build[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=myRound(temp);

                  this.selected_formula.other_build[index].new_quantity =result;   
              }
           },
            getItemFormula(e)
            {
                if(this.selected_item && this.selected_item !=null)
                {
                     this.formulaSearch(this.selected_item.item_id,this);
                    
                }
            },
          
            // begin item search
           onItemSearch(search,loading)
           {  
               this.formula_list=[];
               this.selected_formula=null;
               loading(true);
               this.itemSearch(search,loading,this);
           },

           //ajax call to get items
           itemSearch(search,loading,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                   method_name:'assemblyList',
                   keyword:search,
                }
               })
               .then(function (response)
               {
                 this.items=[];
                 if(response.data.length>0)
                 {
                    vm.items=response.data;
                    console.log('data',vm.items);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end item search
            //ajax call to get formula
           formulaSearch(item_id,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'item_formula',
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.formula_list=response.data;
                  
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end formula search
           // items serarch method
            onItemsSearch(search,loading)
           {  
               loading(true);
               this.itemsSearch(search,loading,this);
           },
           itemsSearch(search,loading,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'items_search_assebley',
                  'type':'assembaly',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.temp_items=response.data;
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
		   
		            
           //ajax call to get items code
           onItemSearchCode:_.debounce((search,loading)=>{
               item_id = $("#item_id").val();
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblySubList',
                  keyword:search,
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 sales.subItems=[];
                 if(response.data.length>0)
                 {
                    sales.subItems=response.data;
                    console.log('subItems',sales.subItems);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
		   
		   //ajax call to get items code
           onItemSearchBuild:_.debounce((search,loading)=>{
			   loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'getFormulaSubItem',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 sales.newItems=[];
                 if(response.data.length>0)
                 {
                    sales.newItems=response.data;
                    console.log('subItems',sales.newItems);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
		   			
			handleSubmit(e) {
				this.Indexbase = (this.selected_formula)?(this.selected_formula.formula.length - 1):0;
				regForm(e.target);
            },
		   
			  // generic function for adding item to list
				addNew_roll(index)
				{
						sales.subItems=[];
						if(this.services[index+1]==undefined)
						{
						  this.services.push({
							selected_sub_item:null,
						});
						}
					 
				  
				},
				// delete item from list
				deleteItem_roll(index)
				{
						this.services.splice(index, 1);
				  
				},
		   
		   

            addNew(type=null,index)
            { 
              if(type !=null)
              {
                 if(type=='inventory')
                 { 
                    if(this.assemlby_items[index+1]==undefined)
                    {
                      this.assemlby_items.push({item:null});
                    }
                 } 
                 if(type=='otherBuilds')
                 { 
                    if(this.otherBuild[index+1]==undefined)
                    {
                      this.otherBuild.push({item:null});
                    }
                 }
                  
              }
              
           },
            deleteItem(type=null,index)
           {
             if(type !=null)
             {
                 console.log(type);
                 if(type=='inventory')
                 {
                    this.assemlby_items.splice(index, 1);
                 }
                 if(type=='otherBuild')
                 {
                    this.otherBuild.splice(index, 1);
                 }
                   
             }
              
           },
		      // set new price
			   setNewRate(index)
			   {
				   
				  if(this.services[index].selected_sub_item)
				  {
					 this.services[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
					 this.services[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
					 this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
					 // this.services[index].selected_sub_item.qut_temp = this.services[index].selected_sub_item.qut_in;
				  }
				  this.deleteItem_roll(100);
			   },

           addItems(type)
           { 
                if(type !=null)
                {
                    if(type=="otherBuilds")
                    { 
                        this.temp_items=[];
                      this.otherBuild.push({item:null}); 
                    }
                    if(type=="inventory")
                    { 
                       this.temp_items=[];
                      this.assemlby_items.push({item:null});
                    }
                }
                     
              },
			  
			  // generic function for adding item to list
				addBundl(index)
				{
						if(this.formulaDataIn[index+1]==undefined)
						{
						  this.formulaDataIn.push({
							item:this.selected_item,
							qty:null,
							code:null,
							khada:null
						});
						}
					 
				  
				},
				// delete item from list
				deleteBundl(index)
				{
						this.formulaDataIn.splice(index, 1);
				  
				},
        }
    });



</script>


@endpush