@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    
@stop

@section('content')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditBuild')</span>
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <div class="portlet-body form" id="assembaly" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($build,['method' => 'PATCH','route' => ['build_m.update',$build->id],'files'=> true, 'id'=>'build-form'])!!}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.ItemName')</label>
                                        <v-select label="name" v-model="selected_item" :options="items" @search="onItemSearch" disabled></v-select>

                                        <input type="hidden" name="item" :value="(!selected_item)?null:selected_item.item_id">

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.FormulaName')</label>
                                        <select class="form-control" v-model="selected_formula" disabled>
                                            <option>@lang('layout.Select')</option>
                                            <option v-for="formula in formula_list" :value="formula">@{{formula.code+'-'+formula.name}}</option>
                                        </select>
                                        <input type="hidden" name="formula" :value="(!selected_formula)?null:selected_formula.id">
                                        <input type="hidden" name="name" :value="(!selected_formula)?null:selected_formula.name">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.SiteName')</label>

                                        <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site">

                                        </v-select>
                                        <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null">

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.QuantityToBuild')</label>
                                        <input v-if="(has_code)" type="number" placeholder="@lang('layout.EnterQuantityToBuild')" readonly name="build_qty" v-model="(buildQty == 0)?Number.parseFloat(subtotals).toFixed(precision()):Number.parseFloat(buildQty).toFixed(precision())" class="form-control">
                                        <input v-if="(!has_code)" type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="build_qty" v-model="buildQty" @input="select_percentage()" class="form-control">

                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.Date')</label>
                                        <input class="form-control date" name="date" readonly="readonly" autocomplete="off" value="{{$assemblyInfo->date}}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.AssemblyCode') </label>
                                        <input type="number" name="number" value="{{$build->number}}" class="form-control">
                                    </div>
                                </div>
                                @if(getFlour()=="true")
                                <div class="col-md-2">
                                    <label class=" control-label">@lang('layout.Percentage')</label>
                                    <div>
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="percentage" @click="select_percentage()" value="on" v-model="percentage" <?php if($build->percentage == 'on'){ echo "checked"; } ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                @endif
                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" name="ref_no" value="{{$build->ref_no}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3" v-if="length_width">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.EvaporatedWater')</label>
                                        <input type="number" name="evaporated_water" value="{{$build->evaporated_water}}" v-validate="'required'" data-vv-as="@lang('layout.EvaporatedWater')" class="form-control" >
                                        <span class="required">@{{ errors.first('evaporated_water') }}</span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Description') </label>
                                        <textarea name="description" class="form-control" v-validate="(length_width)?'required':''" data-vv-as="@lang('layout.Description')" rows="2">{{$build->description}}</textarea>
                                        <span class="required">@{{ errors.first('description') }}</span>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label class=" control-label">@lang('layout.Length') & @lang('layout.Width')</label>
                                    <div>
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="process_length_width" value="on" v-model="length_width" <?php if($build->process_length_width == 'on'){ echo "checked"; } ?> >
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!--  calculation part -->
                        <div class="col-lg-4 col-md-4 col-sm-12">
                            <div class="row">
                                <label class="control-label"> @lang('layout.Formula')</label>
                                <div class="dashboard-stat2 ">

                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small>@lang('layout.ItemName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="">@{{ (selected_item)?selected_item.name:null }}</span>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.MeasureName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="">@{{ (selected_item)?selected_item.measure:null }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.FormulaName') :</small>
                                            </td>
                                            <td class="text-right">

                                                <span data-counter="counterup" data-value="">@{{ (selected_formula)?selected_formula.name:null }}</span>

                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <small>@lang('layout.QuantityUsedToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{(subtotal == 0)?Number.parseFloat(subtotals).toFixed(precision()):Number.parseFloat(subtotal).toFixed(1)}}</span>

                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>


                                        <tr>
                                            <td>
                                                <small>@lang('layout.QuantityToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{Number.parseFloat(buildQtyB).toFixed(1)}}</span>

                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <small>@lang('layout.AfterBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{Number.parseFloat(subtotal - buildQtyB).toFixed(1)}}</span>
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>
                                        @if(getBuildExpense() == "true")
                                        <tr>
                                            <td>
                                                <small>@lang('layout.TotalExpense'):</small>
                                            </td>
                                            <td class="text-right">
                                                <span class="text-right" data-counter="counterup" data-value="7800"> @{{ expenseAmount }} {{getHomeCurrency()["code"]}}</span>
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>
                                        @endif

                                    </table>

                                </div>
                            </div>
                        </div>
                        <!-- end of calculation -->
                        <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                    </div>

                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.Bundl') </li>
                    <div v-if="selected_formula" class="" id="printarea" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 25px;"> # </th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.ItemName')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Code')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                    @if(getShowWing()!="false")
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Wing')</th>
                                    @endif
                                    @if(itemBrand()=="true")
                                    <th class="text-center" style="min-width: 80px;">@lang('layout.Brand')</th>
                                    @endif
                                    @if(showLocation()=="true")
                                    <th class="text-center" style="min-width: 80px;">@lang('layout.Location')</th>
                                    @endif
                                    @if(getShowSuperceedNo()=="true")
                                    <th class="text-center" style="min-width: 80px;">@lang('layout.SuperceedNo')</th>
                                    @endif
                                    @if(getOtherMeasure()=="true")
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.OMeasureValue1')</th>
                                    @endif
                                    @if(getOtherMeasure2()=="true")
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.OMeasureValue2')</th>
                                    @endif
                                    <th @if(getCubicMetereItems()!="true") v-if="length_width" @endif class="text-center" style="min-width: 80px;"> @lang('layout.Width')</th>
                                    <th @if(getCubicMetereItems()!="true") v-if="length_width" @endif class="text-center" style="min-width: 80px;"> @lang('layout.Length')</th>
                                    @if(getCubicMetereItems()=="true")
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Gauge')</th>
                                    @endif
                                    <th> </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(item,index) in formulaDataIn">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                    </td>
                                    <td>
                                        <v-select label="name" v-model="item.item" :options="newItems" @search="onItemSearchBuild" @click.native="addBundl(index)" placeholder="@lang('layout.ItemName')"></v-select>
                                        <input type="hidden" name="item_id_in[]" :value="(!item.item)?null:item.item.item_id">
                                        <input type="hidden" name="C_stocks_in_id[]" :value="(!item)?null:item.m_stocks_in_id">
                                        <input type="hidden" name="C_main_stock_id[]" :value="(!item)?null:item.main_stock_id">
                                    </td>
                                    <td>
                                        <input name="code_in[]" type="text" v-model="(!item)?null:item.code" v-on:click="addBundl(index)" class="form-control" placeholder="@lang('layout.Code')">
                                    </td>

                                    <td>
                                        <input name="quty_in[]" type="number" class="form-control" placeholder="@lang('layout.OnHand')" v-model.number="item.qty" @input="changeWing(index), changeBuildQty()">
                                    </td>
                                    @if(getShowWing()!="false")
                                    <td>
                                        <input name="khada[]" type="number" v-model="(!item)?null:item.khada" class="form-control" placeholder="@lang('layout.Wing')">
                                    </td>
                                    @endif
                                    @if(itemBrand()=="true")
                                    <td>
                                        <v-select placeholder="@lang('layout.Brand')" label="name" :options="brand" v-model="item.selectedBrand"></v-select>
                                        <input type="hidden" name="brand_id[]" :value="(item.selectedBrand)?item.selectedBrand.id:null">
                                    </td>
                                    @endif
                                    @if(showLocation()=="true")
                                    <td>
                                        <input name="location[]" type="text" v-model="(!item)?null:item.location" class="form-control" placeholder="@lang('layout.Location')">
                                    </td>
                                    @endif
                                    @if(getShowSuperceedNo()=="true") 
                                    <td>
                                        <input name="superceed[]" type="text" v-model="(!item)?null:item.superceed" class="form-control" placeholder="@lang('layout.SuperceedNo')">
                                    </td>
                                    @endif 
                                    @if(getOtherMeasure()=="true")
                                    <td>
                                        <input name="o_measure_value1[]" type="number" v-model="(!item)?null:item.other_measure" class="form-control" placeholder="@lang('layout.OMeasureValue1')">
                                    </td>
                                    @endif
                                    @if(getOtherMeasure2()=="true")
                                    <td>
                                        <input name="o_measure_value2[]" type="number" v-model="(!item)?null:item.other_measure2" class="form-control" placeholder="@lang('layout.OMeasureValue2')">
                                    </td>
                                    @endif
                                    <td @if(getCubicMetereItems()!="true") v-if="length_width" @endif>
                                        <input name="width_in[]"  type="number" v-model.number="item.widths" @input="changeWing(index)"  class="form-control" placeholder="@lang('layout.Width')" >
                                   </td>
                                    <td @if(getCubicMetereItems()!="true") v-if="length_width" @endif>
                                        <input name="length_in[]" type="number" v-model.number="item.lengths" @input="changeWing(index)" class="form-control" placeholder="@lang('layout.Length')" >
                                    </td>
                                    @if(getCubicMetereItems()=="true")
                                    <td>
                                        <input name="gauge[]" type="number" v-model.number="item.gauge" @input="changeWing(index)" class="form-control" placeholder="@lang('layout.Gauge')" >
                                    </td>
                                    @endif
                                    <td>
                                        @if($edit_sale != 'yes')
                                        <span v-if="formulaDataIn.length != 1" v-on:click="deleteBundl(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        @endif
                                    </td>

                                </tr>
                            </tbody>
                        </table>

                    </div>

                    <br />

                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
                    <div v-if="selected_formula && has_code" class="" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-responsive table-full-width .met">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Item')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Measure')</th>
                                    <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Formula')</th>
                                    <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.ToBuild')</th>
                                    <th v-if="length_width" class="text-center"></th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.AfterBuild')</th>
                                    <th class="text-center" style="width: 10px;"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.formula" v-if="(item.type == 'base')">

                                    <td class="td_one">
                                        <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                        <input type="hidden" id="item_id" :name="'item_ids['+Indexbase+']'" :value="(!item.item_id)?null:item.item_id">
                                        <input type="hidden" :name="'item_type['+Indexbase+']'" :value="(!item.item_id)?null:item.type">

                                    </td>
                                    <td>
                                        <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChange(index)" class="form-control input_style" placeholder="Measure" required="required" disabled>

                                            <span v-if="item.measure_list !=null">
                                                <option v-if="(item !=null)" v-for="measures in item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                                            </span>
                                        </select>

                                        <input type="hidden" :name="'inventory_measure['+Indexbase+']'" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                                    </td>
                                    <td class="hidden-print">
                                        <input type="number" :name="'item_quantity['+Indexbase+']'" @input="change_data()" v-model="(!item)?null:item.new_quantity">
                                        <input type="hidden" id="item_quantity" v-model="(!item)?null:item.new_quantity">
                                    </td>
                                    <td class="hidden-print">
                                        <!-- <input readonly type="number"  :value="(!item)?null:item.on_hand"> -->
                                        <!-- <input readonly type="number"  :value="(!item)?null:item.on_hand"> item_item_measure  -->
                                        <input readonly type="number" :value="(!item)?null:buildItemQuantity(item.item_item_measure.measure_unit,item.measure.measure_unit,1,item.on_hand,0)">
                                    </td>
                                    <td>
                                        <input readonly type="number" :value="(!item)?null:Number.parseFloat(item.new_quantity*buildQty).toFixed(precision())">
                                    </td>
                                    <td v-if="length_width" >
                                    </td>
                                    <td>
                                        <input readonly type="number" :value="(!item)?null:buildItemQuantity(item.item_item_measure.measure_unit,item.measure.measure_unit,1,item.on_hand,item.new_quantity*buildQty)">
                                    </td>
                                    <td>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="padding: 0px;">
                                        <li class="list-group-item bg-green bg-font-green"> @lang('layout.Roll') </li>
                                    </td>
                                </tr>

                                <!--/row-->
                                <tr v-for="(service,index) in services">

                                    <td>
                                        <v-select label="name" v-model="service.selected_sub_item" :options="subItems" @search="onItemSearchCode" @click.native="addNew_roll(index)" placeholder="@lang('layout.Code')" style=""></v-select>
                                        <input type="hidden" name="sub_item[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id">
                                        <input type="hidden" name="m_stocks_in_id[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id">
                                        <input type="hidden" name="main_stock_id[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.main_stock_id">
                                        <input type="hidden" name="measure_unit_cu[]" :value="selected_formula.formula[(selected_formula.formula.length - 1)].item_item_measure.measure_unit">
                                        <input type="hidden" name="measure_unit_sel[]" :value="selected_formula.formula[(selected_formula.formula.length - 1)].measure.measure_unit">
                                    </td>
                                    <td>
                                        <input name="qut_in[]" ref="OnHand" type="number" @input="change_qut(index)" :value="(!service.selected_sub_item)?null: service.selected_sub_item.OnHand" class="form-control" placeholder="@lang('layout.ToBuild')">
                                    </td>
                                    <td>
                                        <input name="lengths[]" ref="lengths" type="number" @input="change_lengths(index)" :value="(!service.selected_sub_item)?null:service.selected_sub_item.lengths" class="form-control" placeholder="@lang('layout.Length')">
                                    </td>

                                    <td>
                                        <input type="number" name="" :value="(!service.selected_sub_item)?null:buildItemQuantity(selected_formula.formula[(selected_formula.formula.length - 1)].item_item_measure.measure_unit,selected_formula.formula[(selected_formula.formula.length - 1)].measure.measure_unit,1,service.selected_sub_item.qut_temp,0)" disabled placeholder="@lang('layout.OnHand')" class='form-control'>
                                    </td>
                                    <td>
                                        <input name="widths[]" type="number" readonly :value="(!service.selected_sub_item)?null:service.selected_sub_item.widths" class="form-control" placeholder="@lang('layout.Width')">
                                    </td>
                                    <td v-if="length_width">
                                        @{{(!service.selected_sub_item)?"@lang('layout.Wing')":service.selected_sub_item.khada}}
                                            {{-- <input readonly :value="(!service.selected_sub_item)?null:service.selected_sub_item.khada" class="form-control" placeholder="@lang('layout.Wing')" > --}}
                                    </td>
                                    <td>
                                        <input name="cost[]" type="number" :value="(!service.selected_sub_item)?null:service.selected_sub_item.per_price" ref="per_price" @input="setNewRate(index)" class="form-control" placeholder="@lang('layout.Price')">
                                    </td>
                                    <td>
                                        <span v-if="index != 0" v-on:click="deleteItem_roll(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                    </td>

                                </tr>

                            </tbody>
                        </table>

                    </div>
                    <hr>


                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
                    <div v-if="selected_formula" class="">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 25px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;"> @lang('layout.Item')</th>
                                    <th class="text-center" style="min-width: 160px;"> @lang('layout.Site')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                    <th v-if="percentage" class="text-center" style="min-width: 80px;"> @lang('layout.Percentage')</th>
                                    <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Formula')</th>
                                    <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.ToBuild')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.AfterBuild')</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.formula" v-if="(item.type != 'base')">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                    </td>
                                    <td class="td_one">
                                        <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                        <input type="hidden" :name="'item_ids['+index+']'" :value="(!item.item_id)?null:item.item_id">


                                    </td>
                                    <td class="highlight">
                                        <select v-model="(item==null)?null:item.site" class="form-control">
                                            <option value="null">@lang('layout.Select')</option>
                                            <span v-if="(item != null)">
                                                <option v-for="site in (item==null)?null:item.site_list" :value="site">
                                                    @{{site.site_name}}
                                                </option>
                                            </span>
                                        </select>

                                        <input type="hidden" :name="'inventory_site['+index+']'" :value="(item==null)?null:((item.site==null)?null:item.site.site_id)">
                                    </td>
                                    <td>
                                        <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChange(index)" class="form-control input_style" placeholder="Measure" disabled required="required">

                                            <span v-if="item.measure_list !=null">
                                                <option v-if="(item !=null)" v-for="measures in item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                                            </span>
                                        </select>

                                        <input type="hidden" :name="'inventory_measure['+index+']'" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                                    </td>
                                    <td v-if="percentage">
                                        <input type="number" :name="'item_percentage['+index+']'" v-model.number="(item==null)?null:item.percentage" @input="select_percentages()" class="form-control input-style input-number" placeholder="@lang('layout.Percentage')">
                                    </td>
                                    <td>
                                        <input type="number" :name="'item_quantity['+index+']'" v-model="(!item)?null:item.new_quantity">
                                    </td>
                                    <td>
                                        <input readonly type="number" name="item_quantity[]" v-model="(!item)?null:item.on_hand">
                                    </td>
                                    <td>
                                        <input readonly type="number" :value="(!item)?null:(item.new_quantity*buildQty)">
                                    </td>
                                    <td>
                                        <input readonly type="number" :value="(!item)?null:(item.on_hand-(item.new_quantity*buildQty))">
                                    </td>
                                    <td>
                                        <span v-if="selected_formula" v-on:click="deleteItem('inventory',index)">
                                            <i v-if="selected_formula.formula.length > 2" class="paddint-both glyphicon glyphicon-trash"></i>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                    <hr>
                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.AdjastmentItems') </li>
                    <div v-if="selected_formula" class="">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 25px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.other_build">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                    </td>
                                    <td class="td_one">
                                        <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                        <input type="hidden" name="other_build_id[]" :value="(!item.item_id)?null:item.item_id" class="form-control">

                                    </td>
                                    <td>
                                        <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChangeOtherBuild(index)" class="form-control input_style" placeholder="Measure" required="required" disabled>

                                            <span v-if="item.measure_list !=null">
                                                <option v-if="(item !=null)" v-for="measures in item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                                            </span>
                                        </select>

                                        <input type="hidden" name="other_build_measure[]" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                                    </td>
                                    <td>
                                        <input type="number" name="other_build_qty[]" v-model="(!item)?null:item.new_quantity" @input="changeBuildQty()" >
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control" placeholder="%" style="min-width: 100px" v-model="(!item)?null:item.cost" required name="other_build_cost[]" />
                                            <span class="input-group-addon">%</span>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                    <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
                    </button>

                    @if(getBuildExpense() == "true")
                    <!-- begin build expense -->
                    <hr>
                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.Expense') </li>
                    <div v-if="selected_formula" class="" id="printarea" style="overflow-x: scroll;">
                        <table v-if="selected_formula.expense" id="table_content" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 25px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;"> @lang('layout.Expense')</th>
                                    <th class="text-center" style="min-width: 160px;"> @lang('layout.Description')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Amount')</th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(item,index) in (!selected_formula.expense)?null:selected_formula.expense">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>

                                        <input type="hidden" name="assembly_expense_id[]" :value="(!item.id)?null:item.id" class="form-control">
                                    </td>
                                    <td class="td_one">
                                        <v-select label="name" v-model="(!item.expense_account)?null:item.expense_account"></v-select>
                                        <input type="hidden" name="expense_id[]" :value="(!item.expense_account)?null:item.expense_account.id" class="form-control">



                                    </td>
                                    <td class="td_one">
                                        <input type="text" name="expense_description[]" :value="(!item.description)?null:item.description" class="form-control">

                                    </td>

                                    <td class="td_one">
                                        <input type="number" name="expense_amount[]" v-model="item.amount" class="form-control">

                                    </td>

                                </tr>
                            </tbody>
                        </table>

                    </div>
                    <!-- end build expense -->
                    @endif

                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('assembly.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>

                </div>
                {{Form::close()}}
            </div>

            <!-- END FORM-->
        </div>
    </div>

     
@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>
<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('v-select', VueSelect.VueSelect);
    var site                 = {!! $site !!};
    var selectedSite         = {!! $selectedSite !!};
    var build                = {!! $build !!};
    var buildSelectedFormula = {!! $buildSelectedFormula !!};
    var buildSelectedItem    = {!! $buildSelectedItem !!};
    var buildDetail          = {!! $buildDetail !!};
    var otherBuildDetail     = {!! $otherBuildDetail !!};
    var ItemStockRoll        = {!! $ItemStockRoll !!};
    var m_stocks_ins         = {!! $m_stocks_ins !!};
    var brand                = {!!json_encode($brand) !!};
    var buildQty;
    var sales = new Vue({
        el:'#assembaly',
        data:{
            site:site,
            selected_site:selectedSite,
            buildSelectedFormula:buildSelectedFormula,
            build:build,
            selected_item:buildSelectedItem,
            buildQtyB:0,
            buildQty:build.qty,
            subtotals:build.qty,
            ref_no:null,
            percentage:null,
            buildSelectedItem:buildSelectedItem,
            buildDetail:buildDetail,
            otherBuildDetail:otherBuildDetail,
            ItemStockRoll:ItemStockRoll,
            m_stocks_ins:m_stocks_ins,
            assembly_item:[],
            temp_items:[],
            newItems:[],
            items:[],
            subItems:[],
            formula_list:[],
            selected_formula:null,
            length_width:null,
            brand:brand,
            has_code:false,
            assemlby_items: [
              {item:null},
              {item:null},
              {item:null},
              {item:null},
            ],
            formulaDataIn: [],
			services:[],
			
			Indexbase:0,
        },
        created:function()
        {
            if(this.selected_formula)
            {
                var rows = this.selected_formula.formula;
                if(rows.length>0)
                {
                    for(var x=0; x<rows.length;x++)
                    {
                            rows[x].new_quantity = buildDetail[x].quantity;
                    }  
                }
            }
        },
        computed:{
			
			
			// calculate subtotal
          subtotal: function ()
          {
			  this.Indexbase = (this.selected_formula)?(this.selected_formula.formula.length):0;
			  
			   var qtyBundl = 0;
                for (var i = 0; i < this.formulaDataIn.length; i++) {
                    if (this.formulaDataIn[i].qty && this.formulaDataIn[i].qty !=null)
                    {  
                        var OnHand1=this.formulaDataIn[i].qty;
                           qtyBundl += parseFloat(OnHand1);
                    }

                }
			 this.buildQtyB = qtyBundl;

            // console.log(44, this.length_width, this.selected_formula);
			 
			var item_quantity = $("#item_quantity").val();
            var sum = 0;
            var buildQu = 0;
            if(this.has_code){
            for (var i = 0; i < this.services.length; i++) {
                if (this.services[i].selected_sub_item && this.services[i].selected_sub_item.OnHand !=null)
                {  
                    var OnHand=this.services[i].selected_sub_item.OnHand;
                    var cost=this.services[i].selected_sub_item.per_price;
                    
                    // sum =Number(sum)+Number(OnHand*cost);
                    sum += parseFloat(OnHand)*parseFloat(cost);
                    buildQu =Number(buildQu)+Number(OnHand);   
                }
            }
            
            this.buildQty = (buildQu/item_quantity)? buildQu/item_quantity:0;
            buildQs = (buildQu/item_quantity)? buildQu/item_quantity:0;
            
            }else{
                buildQs = this.buildQty;
            }

            if(this.length_width && this.selected_formula){
                if(this.selected_formula.formula){
                    var othBuild = 0;
                    var rows = this.selected_formula.formula;
                    if(rows.length >0) 
                    {
                        for (var i = 0; i < rows.length; i++) 
                        {
                            if(rows[i].type != 'base'){
                                othBuild += (parseFloat(rows[i].new_quantity)*parseFloat(this.buildQty));
                            } 
                        }
                    }
                    buildQs = parseFloat(this.buildQty)+parseFloat(othBuild);
                }
            }
			  
            // sum = (sum/buildQu)? sum/buildQu:0;
            return parseFloat(buildQs);
				
          },

                buildQ: function () 
                {
                  var min = null;
                  if(this.selected_formula)
                  {
                     var rows = this.selected_formula.formula;
                    // console.log(this.selected_formula);
                      if(rows.length >0) 
                      {
                          var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));

                          var temp_other_build=this.selected_formula.other_build;
                          min = rows[0].on_hand/temp;
                          for (var i = 1; i < rows.length; i++) 
                          {
                              var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));
                              if (rows[i].on_hand / temp < min) 
                              {
                                  min = rows[i].on_hand / temp;
                              }

                          }
                          min = Number.parseFloat(min).toFixed(precision());

                      }

                  }
                  return min;
              },
             isError:function()
             {
                var isError=false;
                if((this.selected_item==null && !this.selected_item)  || this.selected_formula ==null || this.selected_site==null || this.buildQty<=0)
                {
                  isError=true;
                }
                return isError;
             },

            expenseAmount: function() {
                var temp = 0;
                if (this.selected_formula) {
                if (this.selected_formula.expense) {
                var rows = this.selected_formula.expense;
                    var buildQty = this.buildQtyB;
                    var count = 1000;
                    for (var i = 0; i < count; i++) {
                    if (rows[i] && buildQty) {
                        if (rows[i] && rows[i].amount != null) {
                        var temp = (temp + (Number.parseFloat(rows[i].amount) * Number.parseFloat(buildQty)));
                        }
                    }else{
                        count = 0;
                    }
                    }
                }
                }
                return temp.toFixed(precision());
            },
        },
        
        mounted:function()
        {
            if(this.build && build.expense_id)
            {
              this.searchExpense();
            }

            // to initialize raw items
            if(this.buildSelectedFormula)
            {
                this.formula_list=this.buildSelectedFormula;
				
            }
			
            @if($build->percentage == 'on')
            this.percentage = "{{$build->percentage}}";
            @endif

            @if($build->process_length_width == 'on')
            this.length_width = "{{$build->process_length_width}}";
            @endif

			// this.buildQty = this.subtotal;
            for(var i=0;i<this.buildSelectedFormula.length;i++)
            {
                if(this.build.assembly_id==this.buildSelectedFormula[i].id)
                {
                    this.selected_formula=this.buildSelectedFormula[i];
                }
				
				// console.log(44, this.selected_formula);
            }
			
			if(this.ItemStockRoll)
            {
				for(var i=0;i<this.ItemStockRoll.length;i++)
				{
				this.services.push({selected_sub_item:this.ItemStockRoll[i]});
			
				}
				// console.log('code',this.services);
            }
			
			if(this.m_stocks_ins)
            {
				for(var i=0;i<this.m_stocks_ins.length;i++)
				{
                    var selectedBrand = null;
                    if (this.m_stocks_ins[i].brand_id) {
                        selectedBrand = _.find(this.brand,(o) => o.id == this.m_stocks_ins[i].brand_id);
                    }
                    this.formulaDataIn.push({item:this.m_stocks_ins[i], qty:this.m_stocks_ins[i].qut_in, 
                    code:this.m_stocks_ins[i].code, 
                    m_stocks_in_id:this.m_stocks_ins[i].m_stocks_in_id, 
                    main_stock_id:this.m_stocks_ins[i].main_stock_id,
                    selectedBrand:selectedBrand, 
                    location:this.m_stocks_ins[i].location, 
                    superceed:this.m_stocks_ins[i].superceed, 
                    other_measure:this.m_stocks_ins[i].other_measure, 
                    other_measure2:this.m_stocks_ins[i].other_measure2, 
                    lengths:this.m_stocks_ins[i].lengths, 
                    widths:this.m_stocks_ins[i].widths,
                    gauge:this.m_stocks_ins[i].gauge,
                    khada:this.m_stocks_ins[i].khada
                    }
                    );

				}
				// console.log('code',this.formulaDataIn);
            }
            // end item initialization
            if(this.selected_formula)
            {
                if(this.selected_formula.formula.length>0)
                {
                    // console.log(123,this.selected_formula.formula);
					this.has_code = false;
                    for(var x=0; x<this.selected_formula.formula.length;x++)
                    {
						// console.log(123,this.selected_formula.formula[x]);
						if(this.selected_formula.formula[x].type == 'base'){
							this.has_code = true;
						}
                       
                       for(var w=0;w<this.buildDetail.length;w++)
                       {
                           if(this.selected_formula.formula[x].item_id == this.buildDetail[w].item_id)
                            {
                               this.selected_formula.formula[x].new_quantity=this.buildDetail[w].quantity;
                            
                            }
                           
                       }
                    }  
            
                }
                if(this.selected_formula.other_build.length>0)
                {
                    for(var x=0; x<this.selected_formula.other_build.length;x++)
                    {
                       
                       for(var w=0;w<this.otherBuildDetail.length;w++)
                       {
                           if(this.selected_formula.other_build[x].item_id == this.otherBuildDetail[w].item_id)
                            {
                               this.selected_formula.other_build[x].new_quantity=this.otherBuildDetail[w].quantity;
                            
                            }
                           
                       }
                    }  
            
                }
            setTimeout(function(){ sales.deleteItem_roll(1000); }, 30);
			}
		
		
		},
        methods:{

            // begin expense
           searchExpense()
           {
               var id = document.getElementById('daily_expense_number').value;
             
               if(id)
               {    
                    this.daily_expense_info=null;
                    axios.get("{{route('callMethod.search')}}",{
                    params:{
                        method_name:'dailyExpenseForBuild',
                        type:this.selected_type,
                        expense_id:id,
                    }
                   })
                   .then(function(response){
                    if(response.data)
                    {
                      sales.daily_expense_info=response.data;
                    }
                  
                   })
                   .catch(function (error){
                     console.log(error);
                   });
               }
           },
           // end expense

        changeBuildQty() {
            // console.log(333);
            var total = 0;
			if (this.percentage) {
                if (this.formulaDataIn) {
                    for (var i = 0; i < this.formulaDataIn.length; i++) {
                        if (this.formulaDataIn[i].qty && this.formulaDataIn[i].qty !=null)
                        {  
                            // console.log(32, this.formulaDataIn[i].qty);
                            var OnHand1=this.formulaDataIn[i].qty;
                            total += parseFloat(OnHand1);
                        }
                    }
                }
                if (this.selected_formula) {
                    if (this.selected_formula.other_build) {
                        for (var i = 0; i < this.selected_formula.other_build.length; i++) {
                            if (this.selected_formula.other_build[i].new_quantity && this.selected_formula.other_build[i].new_quantity !=null)
                            {  
                                // console.log(323, this.selected_formula.other_build[i].new_quantity);
                                var OnHand1=this.selected_formula.other_build[i].new_quantity;
                                total += parseFloat(OnHand1);
                            }
                        }
                    }
                }
                this.buildQty = total;
			}
		},
			
           select_percentage()
            {
                setTimeout((function () {
                    sales.changeBuildQty();
                }), 200)
                setTimeout((function () {
                    sales.select_percentages();
                }), 400)
            },
            select_percentages()
            {
                // if(this.selected_formula.formula[x].type == 'base'){
                    // percentage: 61
                    // quantity: 0.6
                    // site: null
                    // site_list: Array(5)
                    // type: ""

                if(sales.selected_formula && sales.buildQty && sales.percentage){
                    if(sales.selected_formula.formula && sales.buildQty && sales.percentage){
                        var buildQty = Number.parseFloat(sales.buildQty);
                        var perc = 0;

                        for (var i = 0; i < sales.selected_formula.formula.length; i++) 
                        {
                            // console.log(234, sales.selected_formula.formula[i], sales.percentage, sales.buildQty)
                            if(sales.selected_formula.formula[i].type != 'base'){
                                if(sales.selected_formula.formula[i].percentage){
                                    perc = (perc + Number.parseFloat(sales.selected_formula.formula[i].percentage));
                                }
                            }
                        }

                        for (var i = 0; i < sales.selected_formula.formula.length; i++) 
                        {
                            if(sales.selected_formula.formula[i].type != 'base'){
                                if(sales.selected_formula.formula[i].percentage && perc > 0){
                                    var percentage = Number.parseFloat(sales.selected_formula.formula[i].percentage);

                                    sales.selected_formula.formula[i].new_quantity = Number.parseFloat(((percentage * buildQty) / perc) / buildQty).toFixed(precision());
                                    sales.selected_formula.formula[i].quantity = Number.parseFloat(((percentage * buildQty) / perc) / buildQty).toFixed(precision());

                                    // console.log(234, sales.selected_formula.formula[i], sales.percentage, sales.buildQty)
                                }
                            }
                        }
                    }
                }
            },
			
			change_lengths(index)
            {       
                    if(this.services[index].selected_sub_item)
                        {
                            var per_qut_in=this.services[index].selected_sub_item.per_qut_in;
                            var lengths = this.$refs.lengths[index].value;
                            this.services[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
                            this.services[index].selected_sub_item.OnHand = (per_qut_in * lengths);
                        }
                setTimeout(function(){ sales.deleteItem_roll(1000); }, 30);
            },
            change_qut(index)
            {       
                if(this.services[index].selected_sub_item)
                    {
                        var per_qut_in=this.services[index].selected_sub_item.per_qut_in;
                        var OnHand = this.$refs.OnHand[index].value;
                        this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
                        this.services[index].selected_sub_item.lengths = (OnHand / per_qut_in);
                    }
                setTimeout(function(){ sales.deleteItem_roll(1000); }, 30);
            },
			
           // calculate item price based on measure change
           measureChange(index)
           {
              
               if(this.selected_formula)
               { 
                  var item=this.selected_formula.formula[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.formula[index].new_quantity =result;  
              }
           },

            changeWing(index) {
                if (this.formulaDataIn[index]) {
                    if (this.formulaDataIn[index].qty != null && this.formulaDataIn[index].widths != null && this.formulaDataIn[index].lengths != null) {
                        var qty =  Number.parseFloat(this.formulaDataIn[index].qty);
                        var width =  Number.parseFloat(this.formulaDataIn[index].widths);
                        var length =  Number.parseFloat(this.formulaDataIn[index].lengths);
                        var gauge =  Number.parseFloat(this.formulaDataIn[index].gauge);

                        @if(getCubicMetereItems()=="true")
                        this.formulaDataIn[index].khada = Number.parseFloat(qty * (width * length)).toFixed(precision());
                        if (this.formulaDataIn[index].gauge != null) {
                            this.formulaDataIn[index].other_measure = Number.parseFloat(qty * gauge * width * length).toFixed(precision());
                        }
                        @else
                        if (this.length_width) {
                            this.formulaDataIn[index].khada = Number.parseFloat(qty / (width * length)).toFixed(precision());
                        }
                        @endif
                    }
                }
            },

           measureChangeOtherBuild(index)
           {
              if(this.selected_formula)
              {
                  var item=this.selected_formula.other_build[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.other_build[index].new_quantity =result;   
              }
           },
            getItemFormula(e)
            {
                if(this.selected_item && this.selected_item !=null)
                {
                     this.formulaSearch(this.selected_item.item_id,this);
                    
                }
            },
          
            // begin item search
           onItemSearch(search,loading)
           {  
               this.formula_list=[];
               this.selected_formula=null;
               loading(true);
               this.itemSearch(search,loading,this);
           },

           //ajax call to get items
           itemSearch(search,loading,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                   method_name:'assemblyList',
                   keyword:search,
                   code:true,
                }
               })
               .then(function (response)
               {
                 this.items=[];
                 if(response.data.length>0)
                 {
                    vm.items=response.data;
                    console.log('data',vm.items);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end item search
            //ajax call to get formula
           formulaSearch(item_id,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'item_formula',
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.formula_list=response.data;
                  
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end formula search
           // items serarch method
            onItemsSearch(search,loading)
           {  
               loading(true);
               this.itemsSearch(search,loading,this);
           },
           itemsSearch(search,loading,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'items_search_assebley',
                  'type':'assembaly',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.temp_items=response.data;
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
		   
		            
           //ajax call to get items code
           onItemSearchCode:_.debounce((search,loading)=>{
               item_id = $("#item_id").val();
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblySubList',
                  keyword:search,
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 sales.subItems=[];
                 if(response.data.length>0)
                 {
                    sales.subItems=response.data;
                    console.log('subItems',sales.subItems);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
		   
		   //ajax call to get items code
           onItemSearchBuild:_.debounce((search,loading)=>{
			   loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'getFormulaSubItem',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 sales.newItems=[];
                 if(response.data.length>0)
                 {
                    sales.newItems=response.data;
                    console.log('subItems',sales.newItems);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
            handleSubmit(e) {
                this.Indexbase = (this.selected_formula)?(this.selected_formula.formula.length):0;
                this.$validator.validate().then(valid => {
                    if (valid) {
                        regForm(e.target);
                    }
                });
            },
		   
			  // generic function for adding item to list
				addNew_roll(index)
				{
						sales.subItems=[];
						if(this.services[index+1]==undefined)
						{
						  this.services.push({
							selected_sub_item:null,
						});
						}
					 
				  
				},
				// delete item from list
				deleteItem_roll(index)
				{
				    this.services.splice(index, 1);
				  
				},
		   
		   

            addNew(type=null,index)
            { 
              if(type !=null)
              {
                 if(type=='inventory')
                 { 
                    if(this.assemlby_items[index+1]==undefined)
                    {
                      this.assemlby_items.push({item:null});
                    }
                 } 
                 if(type=='otherBuilds')
                 { 
                    if(this.otherBuild[index+1]==undefined)
                    {
                      this.otherBuild.push({item:null});
                    }
                 }
                  
              }
              
           },
            deleteItem(type=null,index)
           {
             if(type !=null)
             {
                 console.log(type);
                 if(type=='inventory' && this.selected_formula)
                 {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            this.selected_formula.formula.splice(index, 1);
                        }
                        else {
                        
                        }
                    });
                 }
                 if(type=='otherBuild')
                 {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            this.otherBuild.splice(index, 1);
                        }
                        else {
                        
                        }
                    });
                 }
                   
             }
              
           },
		      // set new price
			   setNewRate(index)
			   {
				   
				  if(this.services[index].selected_sub_item)
				  {
					 this.services[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
					 this.services[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
					 this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
					 // this.services[index].selected_sub_item.qut_temp = this.services[index].selected_sub_item.qut_in;
				  }
				  this.deleteItem_roll(1000);
			   },

           addItems(type)
           { 
                if(type !=null)
                {
                    if(type=="otherBuilds")
                    { 
                        this.temp_items=[];
                      this.otherBuild.push({item:null}); 
                    }
                    if(type=="inventory")
                    { 
                       this.temp_items=[];
                      this.assemlby_items.push({item:null});
                    }
                }
                     
              },
			  
			  // generic function for adding item to list
				addBundl(index)
				{
						if(this.formulaDataIn[index+1]==undefined)
						{
						  this.formulaDataIn.push({
							item:this.selected_item,
							qty:null,
							code:null,
                            selectedBrand:null, 
                            location:null,
                            superceed:null,
                            m_stocks_in_id:null, 
                            main_stock_id:null, 
                            lengths:null, 
                            widths:null,
                            gauge:null,
							khada:null
						});
						}
					 
				  
				},
				// delete item from list
				deleteBundl(index)
				{
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            this.formulaDataIn.splice(index, 1);
                        }
                        else {
                        
                        }
                    });
				},
        }
    });



</script>


@endpush