@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    
@stop

@section('content')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title hidden-print">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.BuildAssembly')</span>
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
                <div class=" pull-right">
                  <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()"/><i class="fa fa-print"></i>  @lang('layout.PrintBuildOrder')</a>
                </div>
            </div>
            <div class="portlet-body form" id="assembaly" v-cloak>
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'build_m.store','method' => 'POST','class' => '','id'=>'build-form'])}}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12 hidden-print">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.ItemName')</label>
                                            <v-select label="name" v-model="selected_item" :options="items" @input="getItemFormula(this)" @search="onItemSearch"></v-select>

                                            <input type="hidden" name="item" :value="(!selected_item)?null:selected_item.item_id">

                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.FormulaName')</label>
                                            <select class="form-control" v-model="selected_formula" @click="change_formula(), checkRefNo()">
                                                <option>@lang('layout.Select')</option>
                                                <option v-for="formula in formula_list" :value="formula">@{{formula.code+'-'+formula.name}}</option>
                                            </select>
                                            <input type="hidden" name="formula" :value="(!selected_formula)?null:selected_formula.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.SiteName')</label>

                                                <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site"  >                                                    
                                                </v-select>
                                                <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null">

                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.QuantityToBuild')</label>
											<input v-if ="(has_code)" type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="build_qty" v-model="Number.parseFloat(buildQty).toFixed(precision())" readonly class="form-control">
											<input v-if="(!has_code)" type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="build_qty" @input="select_percentage()" v-model="buildQty" class="form-control">
										</div>
                                    </div>
                                </div>
                                <div class="row">
                                     <div class="col-md-6">
                                          <div class="form-group">
                                              <label class="control-label ">@lang('layout.Date')</label>
                                                  <input class="form-control date" name="date" readonly="readonly" autocomplete="off" value="">
                                          </div>
                                    </div>
                                    <div class="col-md-4">
                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.AssemblyCode') </label>
                                              <input type="number" name="number" value="{{$number}}" class="form-control">
                                          </div>
                                    </div>
                                    @if(getFlour()=="true")
                                    <div class="col-md-2">
                                        <label class=" control-label">@lang('layout.Percentage')</label>
                                        <div>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="percentage" @click="select_percentage()" value="on" v-model="percentage">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                </div>

                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                            <input type="text" name="ref_no" v-model="ref_no" class="form-control" >
                                        </div>
                                    </div>
                                    <div class="col-md-3" v-if="length_width">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.EvaporatedWater')</label>
                                            <input type="number" name="evaporated_water" v-validate="'required'" data-vv-as="@lang('layout.EvaporatedWater')" class="form-control" >
                                            <span class="required">@{{ errors.first('evaporated_water') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.Description') </label>
                                              <textarea  name="description" v-validate="(length_width)?'required':''" data-vv-as="@lang('layout.Description')" class="form-control" rows="2"></textarea>
                                              <span class="required">@{{ errors.first('description') }}</span>
                                          </div>
                                    </div>

                                    <div class="col-md-2">
                                        <label class=" control-label">@lang('layout.Length') & @lang('layout.Width')</label>
                                        <div>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="process_length_width" value="on" v-model="length_width">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <!--  calculation part -->
                        <div class="col-lg-4 col-md-4 col-sm-12">
                            <div class="row">
                              <label class="control-label"> @lang('layout.Formula')</label>
                                <div class="dashboard-stat2 ">

                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small>@lang('layout.ItemName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{ (selected_item)?selected_item.name:null }}</span>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.MeasureName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{(selected_item)?selected_item.measure:null }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.FormulaName') :</small>
                                            </td>
                                            <td class="text-right">

                                                <span data-counter="counterup"
                                                data-value="">@{{ (selected_formula)?selected_formula.name:null }}</span>
											</td>
                                        </tr>


                                        <tr>
                                            <td>
                                                <small>@lang('layout.QuantityUsedToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{Number.parseFloat(subtotal).toFixed(1)}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>


                                        <tr>
                                            <td>
                                                <small>@lang('layout.QuantityToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{Number.parseFloat(buildQtyB).toFixed(1)}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <small>@lang('layout.AfterBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{Number.parseFloat(subtotal - buildQtyB).toFixed(1)}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>
                                        @if(getBuildExpense() == "true")
                                        <tr>
                                            <td>
                                            <small>@lang('layout.TotalExpense'):</small>
                                            </td>
                                            <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800"> @{{ expenseAmount }} {{getHomeCurrency()["code"]}}</span>
                                            <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>
                                        @endif

                                        <!-- tr>
                                            <td>
                                                <small>@lang('layout.Price'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                      data-value="7800">@{{ Number.parseFloat(subtotal).toFixed(precision())}}</span>
															  
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr -->


                                    </table>

                                </div>
                            </div>
                        </div>
                       <!-- end of calculation -->
                    
                    </div>
					
					
					<li class="list-group-item bg-green bg-font-green"> @lang('layout.Bundl') </li>
                    <div v-if="selected_formula" class="" id="printarea" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.ItemName')</th>
                                @if(getBuildColor() == "true")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Code')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.NewCode')</th>
                                @else
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Code')</th>
                                @endif
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                @if(getShowWing()!="false")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Wing')</th>
                                @endif
                                @if(itemBrand()=="true")
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Brand')</th>
                                @endif
                                @if(showLocation()=="true")
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Location')</th>
                                @endif
                                @if(getShowSuperceedNo()=="true")
                                <th class="text-center" style="min-width: 80px;">@lang('layout.SuperceedNo')</th>
                                @endif
                                @if(getOtherMeasure()=="true")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.OMeasureValue1')</th>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.OMeasureValue2')</th>
                                @endif
                                <th @if(getCubicMetereItems()!="true") v-if="length_width" @endif class="text-center" style="min-width: 80px;"> @lang('layout.Width')</th>
                                <th @if(getCubicMetereItems()!="true") v-if="length_width" @endif class="text-center" style="min-width: 80px;"> @lang('layout.Length')</th>
                                @if(getCubicMetereItems()=="true")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Gauge')</th>
                                @endif
                                <th> </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in formulaDataIn">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
								
								<td>
									<v-select label="name" v-model="item.item" :options="newItems" @search="onItemSearchBuild" @click.native="addBundl(index)" placeholder="@lang('layout.ItemName')" ></v-select>
									<input type="hidden" name="item_id[]" :value="(!item.item)?null:item.item.item_id" >
								</td>
								@if(getBuildColor() == "true")
                                <td> 
                                    <v-select label="name" v-model="item.codeList" :options="(!item.item)?codeList:item.item.codeList" @click.native="addBundl(index)" placeholder="@lang('layout.Code')" ></v-select>
									<input type="hidden" name="code_in[]" :value="(!item.codeList)?null:item.codeList.name" >
										
                                </td> 
                                <td> 
									<input name="new_code_in[]" type="text" v-on:click="addBundl(index)" class="form-control" placeholder="@lang('layout.NewCode')" >
                                </td> 
                                @else
                                <td> 
									<input name="code_in[]" type="text" @input="checkCode(index)" v-model="item.maxCode"  v-on:click="addBundl(index)" class="form-control" placeholder="@lang('layout.Code')" >
									<span v-if="codeError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </td> 
                                @endif
                              
                                <td> 
									<input name="quty_in[]" type="number" class="form-control" placeholder="@lang('layout.OnHand')" @input="changeWing(index), changeBuildQty(index)" v-model.number="item.qty"  v-on:click="addBundl(index)" >
								</td> 
                                @if(getShowWing()!="false")
                                <td> 
									<input name="khada[]" type="number" class="form-control" v-model.number="item.khada" placeholder="@lang('layout.Wing')" >
                                </td>
                                @endif 
                                @if(itemBrand()=="true")
                                <td>
                                    <v-select placeholder="@lang('layout.Brand')" label="name" :options="brand" v-model="item.selectedBrand"></v-select>
                                    <input type="hidden" name="brand_id[]" :value="(item.selectedBrand)?item.selectedBrand.id:null">
                                </td>
                                @endif
                                @if(showLocation()=="true") 
                                <td>
                                    <input name="location[]" type="text" class="form-control" placeholder="@lang('layout.Location')">
                                </td>
                                @endif 
                                @if(getShowSuperceedNo()=="true") 
                                <td>
                                    <input name="superceed[]" type="text" class="form-control" placeholder="@lang('layout.SuperceedNo')">
                                </td>
                                @endif 
                                @if(getOtherMeasure()=="true")
                                <td>
                                    <input name="o_measure_value1[]" type="number" v-model.number="item.o_measure_value1" class="form-control" placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <td>
                                    <input name="o_measure_value2[]" type="number" class="form-control" placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                @endif
                                <td @if(getCubicMetereItems()!="true") v-if="length_width" @endif>
									<input name="width_in[]"  type="number" v-model.number="item.width" @input="changeWing(index)"  class="form-control" placeholder="@lang('layout.Width')" >
							   </td>
								<td @if(getCubicMetereItems()!="true") v-if="length_width" @endif>
									<input name="length_in[]" type="number" v-model.number="item.length" @input="changeWing(index)" class="form-control" placeholder="@lang('layout.Length')" >
                                </td>
                                @if(getCubicMetereItems()=="true")
                                <td>
									<input name="gauge[]" type="number" v-model.number="item.gauge" @input="changeWing(index)" class="form-control" placeholder="@lang('layout.Gauge')" >
                                </td>
                                @endif
								<td>
									 <span  v-if="formulaDataIn.length != 1" v-on:click="deleteBundl(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
                              
							</tr>
                            </tbody>
                        </table>

                    </div>
                    
					<br/>

                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
                    <div v-if="selected_formula && has_code" class="" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-responsive table-full-width .met">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Item')</th>
                                <th class="text-center" style="min-width: 60px;"> @lang('layout.Measure')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Formula')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.ToBuild')</th>
                                <th v-if="length_width" class="text-center"></th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.AfterBuild')</th>
                                <th class="text-center" style="width: 10px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.formula"   v-if="(item.type == 'base')">
                               
                                <td> @{{Indexbase}} </td> 
                                <td class="td_one"> 
                                      <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                      <input type="hidden" id="item_id" :name="'item_ids['+Indexbase+']'" :value="(!item.item_id)?null:item.item_id">
                                      <input type="hidden" :name="'item_type['+Indexbase+']'" :value="(!item.item_id)?null:item.type">
                                      
                                </td> 
                                <td>
                                    <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChange(index)"  class="form-control input_style"
                                             placeholder="Measure" disabled>
                                       <span v-if="item.measure_list !=null">
                                            <option v-if="(item !=null)"
                                                v-for="measures in item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" :name="'inventory_measure['+Indexbase+']'" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                              </td>
                              <td class="hidden-print">
                                <input type="number" :name="'item_quantity['+Indexbase+']'" @input="change_data()" v-model="(!item)?null:item.new_quantity">
                                <input type="hidden"  id="item_quantity" v-model="(!item)?null:item.new_quantity">
								</td>
                               <td class="hidden-print">
                                <!-- <input readonly type="number"  :value="(!item)?null:item.on_hand"> -->
                                <!-- <input readonly type="number"  :value="(!item)?null:item.on_hand">  -->
                                <input readonly type="number"  :value="(!item)?null:buildItemQuantity(item.item_item_measure.measure_unit,item.measure.measure_unit,1,item.on_hand,0)"> 
                              </td>
                              <td>
                                <input readonly  type="number"  :value="(!item)?null:Number.parseFloat(item.new_quantity*buildQty).toFixed(precision())">
                              </td>
                              <td v-if="length_width" >
                              </td>
                                <td>
                                <input readonly  type="number"  :value="(!item)?null:buildItemQuantity(item.item_item_measure.measure_unit,item.measure.measure_unit,1,item.on_hand,item.new_quantity*buildQty)">
                              </td>
                              <td>
                              </td>
                            </tr>
							
                            <tr><td> </td> <td style="padding: 0px;"><li class="list-group-item bg-green bg-font-green"> @lang('layout.Roll') </li></td></tr>
							
							<!--/row-->
							<tr v-for="(service,index) in services">
								<td> @{{index+1}}</td> 
								<td>
									<v-select label="name" v-model="service.selected_sub_item" :options="subItems" @search="onItemSearchCode" @click.native="addNew_roll(index)"  @input="checkExistingService()" placeholder="@lang('layout.Code')" style=""></v-select>
									{{-- <!-- v-select label="name" v-model="service.selected_sub_item" :options="subItems" @click.native="addNew_roll(index)" placeholder="@lang('layout.Code')" style=""></v-select --> --}}
									<input type="hidden" name="sub_item[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id">
									<input type="hidden" name="m_stocks_in_id[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id" >
									<input type="hidden" name="main_stock_id[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.main_stock_id" >
									<input type="hidden" name="measure_unit_cu[]"  :value="selected_formula.formula[(selected_formula.formula.length - 1)].item_item_measure.measure_unit" >
									<input type="hidden" name="measure_unit_sel[]"  :value="selected_formula.formula[(selected_formula.formula.length - 1)].measure.measure_unit" >
								</td>
								<td>
										<input name="qut_in[]" v-model="(!service.selected_sub_item)?null:service.selected_sub_item.OnHand" ref="OnHand" type="number"  @input="change_qut(index)"  class="form-control" placeholder="@lang('layout.ToBuild')"   >
								</td>
								<td>
										<input name="lengths[]" ref="lengths" type="number" @input="change_lengths(index)" :value="(!service.selected_sub_item)?null:service.selected_sub_item.lengths" class="form-control" placeholder="@lang('layout.Length')" >
								 </td>
								
								<td>
										<input type="number"  name="" :value="(!service.selected_sub_item)?null:buildItemQuantity(selected_formula.formula[(selected_formula.formula.length - 1)].item_item_measure.measure_unit,selected_formula.formula[(selected_formula.formula.length - 1)].measure.measure_unit,1,service.selected_sub_item.qut_temp,0)" disabled  placeholder="@lang('layout.OnHand')" class = 'form-control' >
								</td>
								<td>
										<input name="widths[]" type="number" readonly :value="(!service.selected_sub_item)?null:service.selected_sub_item.widths" class="form-control" placeholder="@lang('layout.Width')" >
							   </td>
								<td v-if="length_width">
                                    @{{(!service.selected_sub_item)?"@lang('layout.Wing')":service.selected_sub_item.khada}}
										{{-- <input readonly :value="(!service.selected_sub_item)?null:service.selected_sub_item.khada" class="form-control" placeholder="@lang('layout.Wing')" > --}}
							   </td>
								
								<td>
										<input name="cost[]" type="number" step="any" :value="(!service.selected_sub_item)?null:service.selected_sub_item.per_price" ref="per_price" @input="setNewRate(index)" class="form-control" placeholder="@lang('layout.Price')" >
								</td>
								<td>
									 <span  v-if="index != 0" v-on:click="deleteItem_roll(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
								
							</tr>

                            </tbody>
                        </table>

                    </div>
                    <hr>
                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
                    <div v-if="selected_formula" class="">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Item')</th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Site')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th v-if="percentage" class="text-center" style="min-width: 80px;"> @lang('layout.Percentage')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Formula')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.ToBuild')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.AfterBuild')</th>
                                <th style="width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(inventory,InventoryIndex) in new_temp_items" class="even">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                </td>
                                <td class="td_one">
                                <v-select label="name" v-model="inventory.item" :options="newtemp_items" @search="onItemsSearchitems"></v-select>
                                <input type="hidden" :name="'item_ids['+InventoryIndex+']'" :value="(inventory.item==null)?null:inventory.item.item_id">
                                </td>
                                <td class="highlight">
                                <select v-model="(inventory.item==null)?null:inventory.item.item.site" class="form-control">
                                    <option value="null">@lang('layout.Select')</option>
                                    <span v-if="(inventory.item != null)">
                                    <option v-for="site in (inventory.item==null)?null:inventory.item.item.site_list" :value="site">
                                        @{{site.site_name}}
                                    </option>
                                    </span>
                                </select>

                                <input type="hidden" :name="'inventory_site['+InventoryIndex+']'" :value="(inventory.item==null)?null:((inventory.item.item.site==null)?null:inventory.item.item.site.site_id)">
                                </td>
                                <td>
                                <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure" class="form-control input_style" placeholder="Measure" >
                                    <span v-if="inventory.item.measure_list !=null">
                                    <option v-if="(inventory.item !=null)" v-for="measures in inventory.item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                                    </span>
                                </select>

                                <input type="hidden" :name="'inventory_measure['+InventoryIndex+']'" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                                </td>
                                <td v-if="percentage" >
                                <input type="number" :name="'item_percentage['+InventoryIndex+']'" v-model.number="(inventory.item==null)?null:inventory.item.percentage" @input="select_percentages()" class="form-control input-style input-number" placeholder="@lang('layout.Percentage')">
                                </td>
                                <td>
                                <input type="number" :name="'item_quantity['+InventoryIndex+']'" v-model.number="(inventory.item==null)?null:inventory.item.new_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                </td>
                                <td>
                                <!--  <input readonly type="number"  :value="(inventory.item == null)?null:getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,null,inventory.item.on_hand)"> -->
                                <input readonly type="number" :value="(!inventory.item)?null:(inventory.item.item==null)?getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,null,inventory.item.on_hand):((inventory.item.item.site==null)?getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,null,inventory.item.on_hand):getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,null,inventory.item.item.site.OnHand))">
                                </td>
                                <td>
                                <input readonly type="number" :value="(inventory.item == null)?null:(inventory.item.new_quantity*buildQty)">
                                </td>
                                <td>
                                <!-- <input readonly  type="number"  :value="(inventory.item == null)?null:buildItemQuantity(inventory.item.item_item_measure.measure_unit,inventory.item.measure.measure_unit,inventory.item.new_quantity,inventory.item.on_hand,buildQty,inventory.item.um_exchange)"> -->
                                <input readonly type="number" :value="(!inventory.item)?null:(inventory.item.item==null)?(buildItemQuantity(inventory.item.item_item_measure.measure_unit,inventory.item.measure.measure_unit,inventory.item.new_quantity,inventory.item.on_hand,buildQty,inventory.item.um_exchange)):((inventory.item.item.site==null)?(buildItemQuantity(inventory.item.item_item_measure.measure_unit,inventory.item.measure.measure_unit,inventory.item.new_quantity,inventory.item.on_hand,buildQty,inventory.item.um_exchange)):(buildItemQuantity(inventory.item.item_item_measure.measure_unit,inventory.item.measure.measure_unit,inventory.item.new_quantity,inventory.item.item.site.OnHand,buildQty,inventory.item.um_exchange)))">
                                </td>

                                <td>
                                <span v-if="new_temp_items.length > 1" v-on:click="deleteItem('inventory',InventoryIndex)">
                                    <i class="paddint-both glyphicon glyphicon-trash"></i>
                                </span>

                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td colspan="2">
                                <center>
                                    <span @click="addNew('inventory',1000)" class="btn btn-success"><i class="fa fa-plus"></i></span>
                                </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>

                            </tbody>
                        </table>

                        </div>

                        {{-- <div v-if="selected_formula" class="" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-responsive table-full-width">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Item')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Formula')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.ToBuild')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.AfterBuild')</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.formula"   v-if="(item.type != 'base')">
							
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
                                <td class="td_one"> 
                                      <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                      <input type="hidden1" :name="'item_ids['+index+']'" :value="(!item.item_id)?null:item.item_id">
                                      <input type="hidden" :value="(!item.item_id)?null:item.item_id">

                                      
                                </td> 
                                <td>
                                    <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChange(index)"  class="form-control input_style"
                                             placeholder="Measure" disabled>

                                       <span v-if="item.measure_list !=null">
                                            <option v-if="(item)"
                                                v-for="measures in item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden1" :name="'inventory_measure['+index+']'" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                              </td>
                              <td class="hidden-print">
                                <input type="number" :name="'item_quantity['+index+']'" v-model="(!item)?null:item.new_quantity">
                              </td>
                               <td class="hidden-print">
                                <input readonly type="number"  :value="(!item)?null:buildItemQuantity(item.item_item_measure.measure_unit,item.measure.measure_unit,1,item.on_hand,0)"> 
                              </td>
                              <td>
                                <input readonly  type="number"  :value="(!item)?null:(item.new_quantity*buildQty)">
                              </td>
                                <td>
                                <input readonly  type="number"  :value="(!item)?null:buildItemQuantity(item.item_item_measure.measure_unit,item.measure.measure_unit,1,item.on_hand,item.new_quantity*buildQty)">
                              </td>
                            </tr>
                            </tbody>
                        </table>
                    </div> --}}

                    <hr>
                     <li class="list-group-item bg-green bg-font-green"> @lang('layout.AdjastmentItems') </li>
                    <div v-if="selected_formula" class="" id="printarea" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                 <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.other_build">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
                                <td class="td_one"> 
                                      <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                      <input type="hidden" name="other_build_id[]" :value="(!item.item_id)?null:item.item_id" class="form-control">
                                      
                                </td> 
                                <td>
                                    <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChangeOtherBuild(index)"  class="form-control input_style" placeholder="Measure" disabled >
                                       <span v-if="item.measure_list !=null">
                                            <option v-if="(item !=null)"
                                                v-for="measures in item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" name="other_build_measure[]" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                              </td>


                              <td>
                                <input type="number" name="other_build_qty[]" v-model="(!item)?null:item.new_quantity" @input="changeBuildQty()" >
                              </td>
                              <td>
                                  <div class="input-group">
                                      <input type="number" class="form-control" 
                                      placeholder="%" style="min-width: 100px" name="other_build_cost[]" />
                                      <span class="input-group-addon">%</span>
                                  </div>
                              </td>
                            </tr>
                            </tbody>
                        </table>

                    </div>
                    <!-- <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
                    </button> -->

                    @if(getBuildExpense() == "true")
                    <!-- begin build expense -->
                    <hr>
                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.Expense') </li>
                    <div v-if="selected_formula" class="" id="printarea" style="overflow-x: scroll;">
                    <table v-if="selected_formula.expense" id="table_content" class="table table-bordered">
                        <thead>
                        <tr>
                            <th class="text-center" style="width: 25px;"> # </th>
                            <th class="text-center" style="min-width: 160px;"> @lang('layout.Expense')</th>
                            <th class="text-center" style="min-width: 160px;"> @lang('layout.Description')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Amount')</th>

                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(item,index) in (!selected_formula.expense)?null:selected_formula.expense">

                            <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                            <input type="hidden" name="assembly_expense_id[]" :value="(!item.id)?null:item.id" class="form-control">

                            </td>
                            <td class="td_one">
                            <v-select label="name" v-model="(!item.expense_account)?null:item.expense_account"></v-select>
                            <input type="hidden" name="expense_id[]" :value="(!item.expense_account)?null:item.expense_account.id" class="form-control">


                            </td>
                            <td class="td_one">
                            <input type="text" name="expense_description[]" :value="(!item.description)?null:item.description" class="form-control">

                            </td>

                            <td class="td_one">
                            <input type="number" name="expense_amount[]" v-model="item.amount" class="form-control">

                            </td>

                        </tr>
                        </tbody>
                    </table>

                    </div>
                    <!-- end build expense -->
                    @endif

                    <div class="row hidden-print">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
							<button v-if="!isError" type="button" class="btn blue" :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                            <a href="{{route('build.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>

                </div>
                {{Form::close()}}
            </div>

            <!-- END FORM-->
        </div>
    </div>
     
@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>
<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

     Vue.component('v-select', VueSelect.VueSelect);
    var site={!! $site !!};
    var maxCode = {!! $maxCode !!};
    var brand = {!!json_encode($brand) !!};
	//console.log(site);
    var sales = new Vue({
        el:'#assembaly',
        data:{
            site:site,
            selected_site:null,
            selected_item:null,
            has_code:false,
            codeError:false,
            disabled:false,
            msg:'',
            buildQty:0,
            buildQtyB:0,
            ref_no:null,
            percentage:null,
            length_width:null,
            brand:brand,
            maxCode:maxCode,
            assembly_item:[],
            temp_items:[],
            items:[],
            subItems:[],
            subItemss:[],
            newItems:[],
            codeList:[],
            newtemp_items: [],
            new_temp_items: [],
            formula_list:[],
            selected_formula:null,
            assemlby_items: [
              {item:null},
              {item:null},
              {item:null},
              {item:null},
            ],
            formulaDataIn: [
              {
				item:null,
				codeList:null,
				selectedBrand:null,
                maxCode:maxCode,
				qty:null,
				width:null,
				length:null,
				gauge:null,
				o_measure_value1:null,
				khada:null
			  },
            ],
			services:[
              {
                  selected_sub_item:null,
              },
			],
			subMeasureSelected:[],
			Indexbase:0,
        },
	computed:{
          // calculate subtotal
          subtotal: function ()
          {
                this.Indexbase = (this.selected_formula)?(this.new_temp_items.length):0;
                // console.log('test 22',this.Indexbase);
                var qtyBundl = 0;
                for (var i = 0; i < this.formulaDataIn.length; i++) {
                    if (this.formulaDataIn[i].qty && this.formulaDataIn[i].qty !=null)
                    {  
                        var OnHand1=this.formulaDataIn[i].qty;
                           qtyBundl += parseFloat(OnHand1);
                    }

                }
                this.buildQtyB = qtyBundl;
                var item_quantity = $("#item_quantity").val();
                var sum = 0;
                var buildQu = 0;
                
                if(this.has_code){
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].selected_sub_item && this.services[i].selected_sub_item.OnHand !=null)
                        {  
                            var OnHand=this.services[i].selected_sub_item.OnHand;
                            var cost=this.services[i].selected_sub_item.per_price;
                            
                            sum += parseFloat(OnHand)*parseFloat(cost);
                            buildQu =Number(buildQu)+Number(OnHand); 
                        }
                    }
                    
                    this.buildQty = (buildQu/item_quantity)? buildQu/item_quantity:0;
                    buildQs = (buildQu/item_quantity)? buildQu/item_quantity:0;
                }else{
                    buildQs = this.buildQty;
                }
			  
                if(this.length_width && this.selected_formula && this.new_temp_items){
                    var othBuild = 0;
                    var rows = this.new_temp_items;
                    if(rows.length >0) 
                    {
                        for (var i = 0; i < rows.length; i++) 
                        {
                            othBuild += (parseFloat(rows[i].item.new_quantity)*parseFloat(this.buildQty));
                        }
                    }
                    buildQs = parseFloat(this.buildQty)+parseFloat(othBuild);
                }

                return parseFloat(buildQs);
				
          },

            
                buildQ: function () 
                {
                  var min = null;
                  if (this.selected_formula && this.new_temp_items) {
                    var rows = this.new_temp_items;
                      if(rows.length >0) 
                      {
                          var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));

                          //var temp_other_build=this.selected_formula.other_build;
                          min = rows[0].on_hand/temp;
                          for (var i = 1; i < rows.length; i++) 
                          {

                            var temp=((rows[i].new_quantity*rows[i].measure.measure_unit/rows[i].measure_unit));
                            var result= (rows[i].on_hand * rows[i].item_item_measure.measure_unit)/(rows[i].measure.measure_unit);

                            if (result / temp < min) 
                            {
                                min = result / temp;
                            }

                          }
                          min = Number.parseFloat(min).toFixed(precision());

                      }

                  }
                  return min;
              },
             isError:function()
             {
                var isError=false;
                if((this.selected_item==null && !this.selected_item)  || this.selected_formula ==null || this.selected_site==null || this.buildQty<=0 || this.buildQtyB<=0)
                {
                  isError=true;
                }
                return isError;
             },

            expenseAmount: function() {
                var temp = 0;
                if (this.selected_formula) {
                if (this.selected_formula.expense) {
                var rows = this.selected_formula.expense;
                    var buildQty = this.buildQtyB;
                    var count = 1000;
                    for (var i = 0; i < count; i++) {
                    if (rows[i] && buildQty) {
                        if (rows[i] && rows[i].amount != null) {
                        var temp = (temp + (Number.parseFloat(rows[i].amount) * Number.parseFloat(buildQty)));
                        }
                    }else{
                        count = 0;
                    }
                    }
                }
                }
                return temp.toFixed(precision());
            },
        },

      methods:{

        handleSubmit(e) {
            this.$validator.validate().then(valid => {
                if (valid) {
                    sales.disabled = true;
                    sales.submitForm(e.target);
                }
            });
        },

        // submit the form
        submitForm() {
            sales.disabled = true;
            swal({
                title: "@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    document.getElementById("build-form").submit()
                } else {
                    sales.disabled = false;
                }
            });
        },

        // in here you can check and decide to allow duplicate service or not
        checkExistingService() {
            var service_temp = sales.subItemss.slice();
            for (var i = 0; i < sales.services.length; i++) {
                if (sales.services[i].selected_sub_item != null) {
                    var fined = service_temp.findIndex((item) => item.id == sales.services[i].selected_sub_item.id);
                    if (fined != -1) {
                        var o = service_temp.splice(service_temp.findIndex((item) => item.id == sales.services[i].selected_sub_item.id), 1);
                    }
                }
            }
            sales.subItems = service_temp.filter((item) => {
                return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
            });
        },
		  
		checkCode(index) {
			sales.codeError = false;
			if (this.formulaDataIn[index]) {
			if (this.formulaDataIn[index].maxCode != null) {

			var maxCode = this.formulaDataIn[index].maxCode;
				axios.get("{{route('callMethod.search')}}",
					{
						params: {
							maxCode: maxCode,
							method_name: 'CheckCode'
						},
					})
					.then(function (response) {
						// console.log(response.data.result);
						if (response.data.result != null) {
							// console.log('rewr',response.data.result);
							// sales.temp_items=response.data;
							sales.msg = "@lang('layout.DuplicateData')";
							sales.codeError = true;
						}
						else {
							sales.msg = 'no';
							sales.codeError = false;

						}
					})
					.catch(function (error) {
						console.log(error);
					});

			}
			}
		},
		  
        changeWing(index) {
			if (this.formulaDataIn[index]) {
                if (this.formulaDataIn[index].qty != null && this.formulaDataIn[index].width != null && this.formulaDataIn[index].length != null) {
                    var qty =  Number.parseFloat(this.formulaDataIn[index].qty);
                    var width =  Number.parseFloat(this.formulaDataIn[index].width);
                    var length =  Number.parseFloat(this.formulaDataIn[index].length);
                    var gauge =  Number.parseFloat(this.formulaDataIn[index].gauge);

                    @if(getCubicMetereItems()=="true")
                    this.formulaDataIn[index].khada = Number.parseFloat(qty * (width * length)).toFixed(precision());
                    if (this.formulaDataIn[index].gauge != null) {
                        this.formulaDataIn[index].o_measure_value1 = Number.parseFloat(qty * gauge * width * length).toFixed(precision());
                    }
                    @else
                    if (this.length_width) {
                    this.formulaDataIn[index].khada = Number.parseFloat(qty / (width * length)).toFixed(precision());
                    }
                    @endif
                }
			}
		},
        changeBuildQty() {
            var total = 0;
			if (this.percentage) {
                if (this.formulaDataIn) {
                    for (var i = 0; i < this.formulaDataIn.length; i++) {
                        if (this.formulaDataIn[i].qty && this.formulaDataIn[i].qty !=null)
                        {  
                            // console.log(32, this.formulaDataIn[i].qty);
                            var OnHand1=this.formulaDataIn[i].qty;
                            total += parseFloat(OnHand1);
                        }
                    }
                }
                if (this.selected_formula) {
                    if (this.selected_formula.other_build) {
                        for (var i = 0; i < this.selected_formula.other_build.length; i++) {
                            if (this.selected_formula.other_build[i].new_quantity && this.selected_formula.other_build[i].new_quantity !=null)
                            {  
                                // console.log(323, this.selected_formula.other_build[i].new_quantity);
                                var OnHand1=this.selected_formula.other_build[i].new_quantity;
                                total += parseFloat(OnHand1);
                            }
                        }
                    }
                }
                this.buildQty = total;
			}
		},
		select_percentage()
        {
            setTimeout((function () {
                sales.changeBuildQty();
            }), 200)
            setTimeout((function () {
                sales.select_percentages();
            }), 400)
        },
		select_percentages()
        {
            if(sales.new_temp_items && sales.buildQty && sales.percentage){
                var buildQty = Number.parseFloat(sales.buildQty);
                var perc = 0;

                for (var i = 0; i < sales.new_temp_items.length; i++) 
                {
                    if(sales.new_temp_items[i].item){
                        if(sales.new_temp_items[i].item.percentage){
                            perc = (perc + Number.parseFloat(sales.new_temp_items[i].item.percentage));
                        }
                    }
                }

                for (var i = 0; i < sales.new_temp_items.length; i++) 
                {
                    if(sales.new_temp_items[i].item){
                        if(sales.new_temp_items[i].item.percentage && perc > 0){
                            var percentage = Number.parseFloat(sales.new_temp_items[i].item.percentage);

                            sales.new_temp_items[i].item.new_quantity = Number.parseFloat(((percentage * buildQty) / perc) / buildQty).toFixed(precision());
                            sales.new_temp_items[i].item.quantity = Number.parseFloat(((percentage * buildQty) / perc) / buildQty).toFixed(precision());

                            // console.log(234, sales.new_temp_items[i], sales.percentage, sales.buildQty)
                        }
                    }
                }
            }
        },

        change_formula()
        {
        if(sales.selected_formula){
            sales.has_code = false;
            for (var i = 0; i < sales.selected_formula.formula.length; i++) 
                {
                if(sales.selected_formula.formula[i].type == 'base'){
                    sales.has_code = true;
                }else{
                    this.onItemload(i, this);
                }
                
                }
        }
        sales.new_temp_items = [];
            // this.services = [];
            this.services = [{selected_sub_item:null}];
            this.getes_data();
        },

        checkRefNo() {
            @if(refNoByFormula() == "true")
            if (sales.selected_formula) {
                axios.get("{{route('callbuild.search')}}", {
                    params: {
                        assembly_id: sales.selected_formula.id,
                        method_name: 'selectRefNo'
                    },
                })
                .then(function(response) {
                        // console.log(222, response.data);
                    if (response.data) {
                        sales.ref_no = response.data;
                    } else {
                        sales.ref_no = null;
                    }
                })
                .catch(function(error) {
                    console.log(error);
                });
            }
            @endif
        },

	  change_data()
      {       
         // this.subtotal;
		 setTimeout(function(){ sales.deleteItem_roll(1000); }, 30);
		 
		 // var alls = this.subtotal;
		 // console.log('aa');
      },
	  getes_data()
      {       
		 setTimeout(function(){ sales.deleteItem_roll(1000); }, 100);
		 setTimeout(function(){ sales.getItemCodes(); }, 300);
		 
		 // console.log('aa');
      },
	  change_lengths(index)
      {       
			if(this.services[index].selected_sub_item)
				  {
					var per_qut_in=this.services[index].selected_sub_item.per_qut_in;
					var lengths = this.$refs.lengths[index].value;
					 this.services[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
					 this.services[index].selected_sub_item.OnHand = (per_qut_in * lengths);
				}
		 setTimeout(function(){ sales.deleteItem_roll(1000); }, 30);
      },
	  change_qut(index)
      {       
         if(this.services[index].selected_sub_item)
			  {
				var per_qut_in=this.services[index].selected_sub_item.per_qut_in;
				var OnHand = this.$refs.OnHand[index].value;
				 this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
				 this.services[index].selected_sub_item.lengths = (OnHand / per_qut_in);
			}
		 setTimeout(function(){ sales.deleteItem_roll(1000); }, 30);
      },
           // calculate item price based on measure change
           measureChange(index)
           {
              
               if(this.selected_formula)
               {
                  
                  var item=this.selected_formula.formula[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.formula[index].new_quantity =result;
              
                    
              }
           },
           measureChangeOtherBuild(index)
           {
              if(this.selected_formula)
              {
                  var item=this.selected_formula.other_build[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.other_build[index].new_quantity =result;   
              }
           },
            getItemFormula(e)
            {
                if(this.selected_item && this.selected_item !=null)
                {
                     this.formulaSearch(this.selected_item.item_id,this);
					 
					 this.formulaDataIn=[];
					 this.formulaDataIn.push({
							item:this.selected_item,
                            selectedBrand:null, 
							codeList:null,
				            maxCode: (this.maxCode),
							qty:null,
                            width:null,
                            length:null,
                            gauge:null,
                            o_measure_value1:null,
                            khada:null
						});
                }
            },
          
         
           //ajax call to get items
           onItemSearch:_.debounce((search,loading)=>{
               sales.formula_list=[];
               sales.selected_formula=null;
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblyList',
                  keyword:search,
                  code:true,
                }
               })
               .then(function (response)
               {
                 sales.items=[];
                 if(response.data.length>0)
                 {
                    sales.items=response.data;
                    console.log('sssss',sales.items);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
         
           //ajax call to get items code
           onItemSearchCode:_.debounce((search,loading)=>{
               item_id = $("#item_id").val();
                  // console.log('hhh',item_id);
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblySubList',
                  keyword:search,
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 sales.subItems=[];
                 sales.subItemss=[];
                 if(response.data.length>0)
                 {
                    sales.subItems=response.data;
                    sales.subItemss=response.data;
                    // console.log('subItems',sales.subItems);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
		   
		   //ajax call to get items code
           onItemSearchBuild:_.debounce((search,loading)=>{
			   loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'getFormulaSubItem',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 sales.newItems=[];
                 if(response.data.length>0)
                 {
                    sales.newItems=response.data;
                    console.log('2131231',response.data);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
           // end item search
            //ajax call to get formula
           getItemCodes()
           {
               item_id = $("#item_id").val();
			   if(item_id){
                  // console.log('hhh',item_id);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblySubList',
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 sales.subItems=[];
                 sales.subItemss=[];
                 if(response.data.length>0)
                 {
                    sales.subItems=response.data;
                    sales.subItemss=response.data;
                    // console.log('subItems',sales.subItems);
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               });
				}
           },

           Indexb()
            {
                sales.Indexbase = (this.selected_formula)?(this.new_temp_items.length):0;
            },
		   
		   //ajax call to get formula
           formulaSearch(item_id,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'item_formula',
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 this.formula_list=[];
                 if(response.data.length>0)
                 {
                    vm.formula_list=response.data;
                    // console.log('test 3333333',vm.formula_list);
                  
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end formula search
           // items serarch method
            onItemsSearch(search,loading)
           {  
               this.temp_items=[];
               loading(true);
               this.itemsSearch(search,loading,this);
           },
           itemsSearch(search,loading,vm)
           {
               this.temp_items=[];
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'items_search_assebley',
                  'type':'assembaly',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.temp_items=response.data;
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },

           onItemload(index, vm) {
                // console.log('site',vm.selected_formula.formula[index].item);
                // vm.selected_index = index;
                if (vm.selected_formula.formula[index] != null) {

                var inventory_id = vm.selected_formula.formula[index].inventory_id;

                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'itemSearchSale',
                        inventory_id: inventory_id,
                    }
                    })
                    .then(function(response) {
                    vm.selected_formula.formula[index].item = null;
                    vm.selected_formula.formula1[index].item = null;
                    if (response.data.length > 0) {
                        vm.selected_formula.formula[index].item = response.data[0];
                        vm.selected_formula.formula[index].item.site = null;
                        vm.selected_formula.formula1[index].item = response.data[0];
                        vm.selected_formula.formula1[index].item.site = null;

                        // console.log(234, vm.selected_formula.formula1[index]);
                        sales.new_temp_items.push({
                        item: vm.selected_formula.formula1[index]
                        });
                    }


                    })
                    .catch(function(error) {
                    console.log(error);
                    })
                }
            },

           getBuildOnHand(item_measure_unit = null, selected_measure_unit = null, qty = null, on_hand = null) {
                // console.log('qty',qty);
                // console.log('item_measure_unit',item_measure_unit);
                // console.log('selected_measure_unit',selected_measure_unit);
                // console.log('on_hand',on_hand);
                // console.log('lala',sales.new_temp_items);
                var result = 0;
                if (on_hand != null) {
                if (qty) {
                    result = (on_hand * item_measure_unit) / (selected_measure_unit) - (qty);
                } else {
                    result = (on_hand * item_measure_unit) / (selected_measure_unit);
                }
                }
                return Number.parseFloat(result).toFixed(precision());
            },

           onItemsSearchitems: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                    method_name: 'items_search_assebley',
                    'type': 'assembaly',
                    keyword: search,
                    }
                })
                .then(function(response) {
                    sales.newtemp_items = [];
                    if (response.data.length > 0) {
                    sales.newtemp_items = response.data;
                    // console.log('onItemsSearchitems', sales.newtemp_items);
                    // console.log('onItemsSearchitems pp', sales.new_temp_items);
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                })
        }, getDebounceTime()),

            addNew(type=null,index)
            { 
              if(type !=null)
              {
                 if (type == 'inventory') {
                    sales.new_temp_items.push({
                    item: null
                    });
                    sales.Indexbase = (sales.selected_formula)?(sales.new_temp_items.length):0;
                } 
                 if(type=='otherBuilds')
                 { 
                    if(this.otherBuild[index+1]==undefined)
                    {
                      this.otherBuild.push({item:null});
                    }
                 }
                  
              }
              
           },
            deleteItem(type=null,index)
           {
            if(type !=null)
            {
                
                 if (type == 'inventory') {
                    this.new_temp_items.splice(index, 1);
                }

                 if(type=='otherBuild')
                 {
                    this.otherBuild.splice(index, 1);
                 }
                   
            }
              
           },

           addItems(type)
           { 
                if(type !=null)
                {
                    if(type=="otherBuilds")
                    { 
                        this.temp_items=[];
                      this.otherBuild.push({item:null}); 
                    }
                    if(type=="inventory")
                    { 
                       this.temp_items=[];
                      this.assemlby_items.push({item:null});
                    }
                }
                     
              },
			  
			  // generic function for adding item to list
				addNew_roll(index)
				{
						// sales.subItems=[];
						if(this.services[index+1]==undefined)
						{
						  this.services.push({
							selected_sub_item:null,
				            maxCode: (this.maxCode+index+1),
						});
						}
					 
				  
				},
			  // generic function for adding item to list
				addBundl(index)
				{
						if(this.formulaDataIn[index+1]==undefined)
						{
						  this.formulaDataIn.push({
							item:this.selected_item,
                            selectedBrand:null, 
							codeList:null,
				            maxCode: (this.maxCode+index+1),
							qty:null,
                            width:null,
                            length:null,
                            gauge:null,
                            o_measure_value1:null,
                            khada:null
						});
						}
					 
				  
				},
				// delete item from list
				deleteBundl(index)
				{
						this.formulaDataIn.splice(index, 1);
				  
				},
				
				
				// delete item from list
				deleteItem_roll(index)
				{
						this.services.splice(index, 1);
				  
				},
				   // set new price
			   setNewRate(index)
			   {
				   
				  if(this.services[index].selected_sub_item)
				  {
					 this.services[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
					 this.services[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
					 this.services[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
					 // this.services[index].selected_sub_item.qut_temp = this.services[index].selected_sub_item.qut_in;
				  }
				  this.deleteItem_roll(100);
			   },
		saveAndNew() {
			this.$validator.validate().then(valid => {
				if (valid) {

                sales.disabled = true;	
				var url = "{{route('build_m.store')}}";
				form_id = 'build-form';
				var data = $('#' + form_id).serialize();
				toggleBlock(true);
				axios.post(url, data)
					.then(function (response) {
						toggleBlock(0);
						if (response.data.result == 1) {
							$('#' + form_id).trigger('reset');
							//$('#success-sound')[0].play();
							toastr.success('', response.data.message);
							location.reload();
							
						}
						else {
							var message = "{{__('message.Warning')}}";
                            sales.disabled = false;
							//$('#error-sound')[0].play();
							toastr.warning('', response.data.message);
						}
					})
					.catch(function (error) {
					  toggleBlock(0);
                      sales.disabled = false;
						console.log(error);
						var message = "{{__('message.Warning')}}";
						//$('#error-sound')[0].play();
						toastr.warning('', message);
					});

			}
		})
		},
			  
        }
    });



</script>


@endpush