@extends('layouts.app')
@section('style')

    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@stop

@section('content')

<div id="laboratory-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'laboratory_Tests'"
        @closed="closeModal">

        <div slot="body">
             <input type="hidden" name="id" value="{{$build[0]->id}}"/>

             <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label">@lang('layout.SelectType')</label>

                        <select class="form-control" name="report_type">
                            <option value="">@lang('layout.SelectType')</option>
                            <option value="general">@lang('layout.Details')</option>

                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                       autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                       autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>

<div id="weighbridge-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'weighbridge'"
        @closed="closeModal">

        <div slot="body">
             <input type="hidden" name="id" value="{{$build[0]->id}}"/>

             <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label">@lang('layout.SelectType')</label>

                        <select class="form-control" name="report_type">
                            <option value="">@lang('layout.SelectType')</option>
                            <option value="details">@lang('layout.Details')</option>

                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                       autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                       autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>


    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.BuildInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">

            @if(getBuildExpense()=='true')
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <span style="background-color: green">@lang('layout.BuildExpenseFromBuild')</span>
                    <tr>
                        <th>
                            <i class="fa "></i> @lang('layout.BuildNumber')
                        </th>
                        <th class="">
                            <i class="fa "></i> @lang('layout.ItemName')
                        </th>
                        <th class="">
                            <i class="fa "></i> @lang('layout.CreatedBy')
                        </th> 
                        <th>
                            <i class="fa "></i> @lang('layout.MoiatemPercentage')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Quantity')
                        </th>
                        <th v-show="showWhat('expire_date')=='yes'">
                            @lang('layout.ExpireDate')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Measure')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Cost')
                        </th> 
                        <th>
                            <i class="fa "></i> @lang('layout.TotalExpense')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.BuildExpense')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.CostWithExpenses')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.UnitCost')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr> 
                        <td class=""> {{ $build[0]->b_number}}  </td>
                        <td class=""> {{ $build[0]->name}}  </td>
                        <td class=""> {{ $build[0]->username }}  </td>
                        <td class=""> {{ $build[0]->moiatem_percentage }} % </td>
                        <td class=""> {{ $build[0]->qty }}  </td>
                        <td class=""  v-show="showWhat('expire_date')=='yes'"> {{ $build[0]->expire_date }}  </td>
                        <td class=""> {{ $build[0]->symbol }}  </td>
                        <td class=""> {{ $build[0]->cost*$build[0]->qty}}  </td>
                        <td class=""> {{ $build[0]->expense_amount}}  </td>
                        <td class=""> {{ $build[0]->build_expenses_amount}}</td>
                        <td class=""> {{ ($build[0]->cost*$build[0]->qty)+$build[0]->expense_amount}}  </td>
                        <td class=""> {{ ($build[0]->cost)+$build[0]->build_expenses_amount}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            @endif
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                            <span style="background-color: rgb(80, 129, 141) !important; padding: 0px 5px;color: white; margin-bottom: 10px;">@lang('layout.BuildExpenseFromItemExpense')</span>
                      
                    <tr>
                        <th>
                            <i class="fa "></i> @lang('layout.BuildNumber')
                        </th>
                        <th class="">
                            <i class="fa "></i> @lang('layout.ItemName')
                        </th>
                        <th class="">
                            <i class="fa "></i> @lang('layout.CreatedBy')
                        </th> 
                        <th>
                            <i class="fa "></i> @lang('layout.MoiatemPercentage')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Quantity')
                        </th>
                        <th  v-show="showWhat('expire_date')=='yes'">
                            @lang('layout.ExpireDate')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Measure')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Cost')
                        </th> 
                        <th>
                            <i class="fa "></i> @lang('layout.TotalExpense')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Expense')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.CostWithExpenses')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.UnitCost')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr> 
                        <td class=""> {{ $build[0]->b_number}}  </td>
                        <td class=""> {{ $build[0]->name}}  </td>
                        <td class=""> {{ $build[0]->username }}  </td>
                        <td class=""> {{ $build[0]->moiatem_percentage }} % </td>
                        <td class=""> {{ $build[0]->qty }}  </td>
                        <td class=""  v-show="showWhat('expire_date')=='yes'"> {{ $build[0]->expire_date }}  </td>
                        <td class=""> {{ $build[0]->symbol }}  </td>
                        <td class=""> {{ $build[0]->cost*$build[0]->qty}}  </td>
                        <td class=""> {{ $build[0]->expense_amount_stock}}  </td>
                        <td class=""> {{ $build[0]->expense_cost}}  </td>
                        <td class=""> {{ ($build[0]->cost*$build[0]->qty)+$build[0]->expense_amount_stock}}  </td>
                        <td class=""> {{ ($build[0]->cost)+$build[0]->expense_cost}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>      

        </div>
    </div>
        <div class="tabbable tabbable-tabdrop">

    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.BuildDetails')</a>
        </li>
        <li class="">
            <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Expense')</a>
        </li>
        <li class="">
            <a href="#tab3" data-toggle="tab" id="tab_item_expense">@lang('layout.ItemExpense')</a>
        </li>
        <li>
            <a href="#tab4" data-toggle="tab" id="tab_attachment">@lang('layout.Attachments')</a>
        </li>
        @if(getFlour()=="true")
            <li class="">
                <a href="#tab5" data-toggle="tab" id="laboratory_id">@lang('menu.LaboratoryTest')</a>
            </li>
            <li class="">
                <a href="#tab6" data-toggle="tab" id="weighbridge_id">@lang('layout.Weighbridge')</a>
            </li>
        @endif
    </ul>
<div class="tab-content">
<div class="tab-pane active" id="tab1">
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.BuildInItems')</span>
                </div>
                <div class="tools"> </div>
                <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="build_Details"/>
                           <input type="hidden" name="id" value="{{$build[0]->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="build_Details"/>
                           <input type="hidden" name="id" value="{{$build[0]->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="builds_in">
                        <thead>
                        <tr>  
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.BuildNumber')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.MeasureName')</th>
                            <th>@lang('layout.Total')</th>
                            <!-- <th>Action</th> -->
                        </tr>
                        </thead>
                    </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
		
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.BuildOutItems')</span>
                </div>
                <div class="tools"> </div>
                <div class="actions">
                         
                    </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="builds">
                        <thead>
                        <tr>  
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.BuildNumber')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.MeasureName')</th>
                            <th>@lang('layout.Total')</th>
                            <!-- <th>Action</th> -->
                        </tr>
                        </thead>
                    </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
    <div class="tab-pane" id="tab2"> 
                <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Expense')</span>
                </div>
                <div class="tools"> </div>
              
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="expens">
                        <thead>
                        <tr>  
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Amount')</th>
                            <!-- <th>Action</th> -->
                        </tr>
                        </thead>
                    </table>
            </div>
        </div>
    </div>

    <div class="tab-pane" id="tab3"> 
                <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemExpense')</span>
                </div>
                <div class="tools"> </div>
              
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="itemExpense">
                        <thead>
                        <tr>  
                            <th>@lang('layout.Category')</th>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Unit/M')</th>
                            <th>@lang('layout.Quantity')</th>
                            <!--th>@lang('layout.MaterialCost')</th>
                            <th>@lang('layout.TransportCost')</th>
                            <th>@lang('layout.CustomeCost')</th>
                            <th>@lang('layout.LaborCost')</th>
                            <th>@lang('layout.SubContractorCost')</th>
                            <th>@lang('layout.ManufacturingCost')</th>
                            <th>@lang('layout.OtherCost')</th -->
                            <th>@lang('layout.Total')</th>
                        </tr>
                        </thead>
                    </table>
            </div>
        </div>
    </div>
    <div class="tab-pane" id="tab4">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="portlet light bordered">
                    <div class="portlet-body">

                        <form role="form" action="{{route('attachment.store')}}" method="post"
                              enctype="multipart/form-data">

                            @csrf
                            <input type="hidden" name="redirect_route" value="build.show">
                            <input type="hidden" name="foreign_data_id" value="{{$build[0]->id}}">
                            <input type="hidden" name="path" value="uploads/buils">
                            <input type="hidden" name="table_name" value="builds">

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                        <input type="text" name="title" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control" rows="1"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="fileinput fileinput-new" data-provides="fileinput">
                                            <div class="fileinput-new thumbnail"
                                                 style="width: 140px; height: 70px;">
                                                <img src="" alt=""></div>
                                            <div class="fileinput-preview fileinput-exists thumbnail"
                                                 style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                            <div>
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input
                                                                    type="file" name="photo"> </span>

                                                <a href="javascript:;" class="btn default fileinput-exists"
                                                   data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="margiv-top-10" style="text-align: center">
                                <button type="button" onclick="regForm(this)"
                                        class="btn green"> @lang('layout.Submit') </button>
                                <a href="{{route('build.index')}}"
                                   class="btn default">@lang('layout.Cancel')</a>
                            </div>
                        </form>
                    </div>
                </div>
                <table class="table table-striped table-bordered table-hover" id="attachment">
                    <thead>
                    <tr>
                        <th>@lang('layout.AttachmentTitle')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Action')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
    <div class="tab-pane" id="tab5">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.LaboratoryTestCreate')</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="portlet green-meadow box">
                    <div class="portlet-title">
                        
                    </div> 
                    <div class="portlet-body" id="laboratory">

                        <form role="form" action="{{route('laboratory.store')}}" method="post">
                            @csrf
                            <input type="hidden" name="foreign_data_id" value="{{$build[0]->id}}">
                            <input type="hidden" name="type_number" value="{{$build[0]->b_number}}">
                            <input type="hidden" name="type" value="builds">
                            <input type="hidden" name="redirect_route" value="build.show">

                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="text" name="number" class="form-control">
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" name="date" class="form-control date" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.CarNumber')</label>
                                        <input type="text" name="vehicle_number" class="form-control" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.SelectItem') </label>
                                        <v-select class="vue-select2" v-model="selected_item" label="name"  :options="laboratory_item" @input="labSelectedMeasure()">
                                        </v-select>
                                        <input type="hidden" name="item_id" :value="!selected_item?null:selected_item.item_id" >
                                    </div>
                        
                                  </div>
                                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.Unit') </label>
                                        <v-select class="vue-select2" v-model="selected_measure_laboratory" label="measure_name"  :options="laboratory_measure" >
                                        </v-select>
                                        <input type="hidden" name="um_id" :value="!selected_measure_laboratory?null:selected_measure_laboratory.measure_id" >
                                    </div>
                        
                                  </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control"></textarea>
                                    </div>
                                </div>
                            </div>
                            @if(count($laboratoryTest)>0)
                            <table id="table_content" class="table table-bordered">
                                <thead style="background-color: #36c6d3; color:white"> 
                                <tr>
                                    @foreach ($laboratoryTest as $key=>$value)
                                    <th >{{$value->name}}</th>
                                    @endforeach
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    @foreach ($laboratoryTest as $key=>$value)
                                    <td class="highlight">
                                        <input type="text" name="laboratory_test[{{$value->id}}]" class="form-control" autocomplete="off">
                                    </td> 
                                    @endforeach
        
                                </tr> 
                                </tbody>
                            </table>
                            @else
                            <a href="{{route('laboratoryTest.create')}}"
                                class="btn red">@lang('menu.LaboratoryTest')</a>

                            @endif

                            <div class="margiv-top-10" style="text-align: center">
                                <button type="button" onclick="regForm(this)"
                                        class="btn green"> @lang('layout.Submit') </button>
                                <a href="{{route('build.index')}}"
                                   class="btn default">@lang('layout.Cancel')</a>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row">

                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.LaboratoryTestList') </span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                    <span id="lab-modal">
                                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                     </a>
                                    </span>

                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="laboratory_table">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.Number')</th>
                                        <th>@lang('layout.CarNumber')</th>
                                        <th>@lang('layout.Item')</th>
                                        <th>@lang('layout.Unit')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.Action')</th>
    
    
    
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
                
            </div>
        </div>
    </div>  
    <div class="tab-pane" id="tab6">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.WeighbridgeCreate')</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="portlet green-meadow box">
                    <div class="portlet-title">
                        
                    </div> 
                    <div class="portlet-body" id="weighbridge">

                        <form role="form" action="{{route('weighbridge.store')}}" method="post">
                            @csrf
                            <input type="hidden" name="foreign_data_id" value="{{$build[0]->id}}">
                            <input type="hidden" name="type_number" value="{{$build[0]->b_number}}">
                            <input type="hidden" name="type" value="builds">
                            <input type="hidden" name="redirect_route" value="build.show">

                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="text" name="number" class="form-control">
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.CarNumber')</label>
                                        <input type="text" name="vehicle_number" class="form-control" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.DriverName')</label>
                                        <input type="text" name="driver_name" class="form-control" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                  <div class="form-group">
                                      <label class="control-label">@lang('layout.FullWeight')</label>
                                      <input type="number" name="full_weight" class="form-control" autocomplete="off">
                                  </div>
                      
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.EmptyWeight')</label>
                                        <input type="number" name="empty_weight" class="form-control" autocomplete="off">
                                    </div>
                        
                                  </div>
                                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.NetWeight')</label>
                                        <input type="number" name="net_weight" class="form-control" autocomplete="off">
                                    </div>
                        
                                  </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.SelectItem') </label>
                                        <v-select class="vue-select2" v-model="selected_item_weighbridge" label="name"  :options="weighbridge_item" @input="selectedMeasure()">
                                        </v-select>
                                        <input type="hidden" name="item_id" :value="!selected_item_weighbridge?null:selected_item_weighbridge.item_id" >
                                    </div>
                        
                                  </div>
                                  <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.Unit') </label>
                                        <v-select class="vue-select2" v-model="selected_measure_weighbridge" label="measure_name"  :options="weighbridge_measure" >
                                        </v-select>
                                        <input type="hidden" name="um_id" :value="!selected_measure_weighbridge?null:selected_measure_weighbridge.measure_id" >
                                    </div>
                        
                                  </div>


                                  <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" name="date" class="form-control date" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Hour')</label>
                                        <div class="input-group"> 
                                            @if(getHourType() == 24)
                                            <input type="text" class="form-control timepicker timepicker-24" name="hour">
                                            @else
                                            <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour">
                                            @endif
                                            <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control"></textarea>
                                    </div>
                                </div>
                                @if(count($weighbridgeCategori)>0)
                                <table id="table_content" class="table table-bordered" style="overflow-x: scroll;">
                                    <thead style="background-color: #36c6d3; color:white"> 
                                    <tr>
                                        @foreach ($weighbridgeCategori as $key=>$value)
                                        <th>{{$value->name}}</th>
                                        @endforeach
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        @foreach ($weighbridgeCategori as $key=>$value)
                                        <td class="highlight">
                                            <input type="text" name="weight_category[{{$value->id}}]" class="form-control" autocomplete="off">
                                        </td> 
                                        @endforeach
            
                                    </tr> 
                                    </tbody>
                                </table>
                                @endif
                            </div>
                            <div class="margiv-top-10" style="text-align: center">
                                <button type="button" onclick="regForm(this)"
                                        class="btn green"> @lang('layout.Submit') </button>
                                <a href="{{route('build.index')}}"
                                   class="btn default">@lang('layout.Cancel')</a>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row">

                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.WeighbridgeList') </span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                    <span id="weigh-modal">
                                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                     </a>
                                    </span>

                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="weighbridge_table">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.Number')</th>
                                        <th>@lang('layout.CarNumber')</th>
                                        <th>@lang('layout.DriverName')</th>
                                        <th>@lang('layout.Item')</th>
                                        <th>@lang('layout.Unit')</th>
                                        <th>@lang('layout.FullWeight')</th>
                                        <th>@lang('layout.EmptyWeight')</th>
                                        <th>@lang('layout.NetWeight')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.Hour')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.Action')</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
                
            </div>
        </div>
    </div>     
</div>
    </div>
@endsection
@include('print.modal')
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
 <script>
     Vue.component('v-select', VueSelect.VueSelect);
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#builds').DataTable({
           // ajax:'{{route("build.show",$build[0]->id)}}',
           ajax:{
            url:'{{route("build.show",$build[0]->id)}}',
                data:{type:'buildDetail'}
              },
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging: true,
            columns: [    
                { data: 'Name', name: 'items.name' },
                { data: 'Build_Number', name: 'builds.number' },
                { data: 'Date', name: 'Date',orderable:false,searchable:false },
                { data: 'Quantity', name: 'Quantity',orderable:false,searchable:false },
                { data: 'Measure', name: 'Measure',orderable:false,searchable:false },
                { data: 'Cost', name: 'Cost',orderable:false,searchable:false },
        
        ]

        });
        $('#builds_in').DataTable({
           // ajax:'{{route("build.show",$build[0]->id)}}',
           ajax:{
            url:'{{route("build.show",$build[0]->id)}}',
                data:{type:'allBuildDetailIn'}
              },
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging: true,
			
            columns: [    
                { data: 'item_name', name: 'item_name' },
                { data: 'number', name: 'builds.number' },
                { data: 'Date', name: 'Date',orderable:false,searchable:false },
                { data: 'quantity', name: 'quantity',orderable:false,searchable:false },
                { data: 'measure', name: 'measure',orderable:false,searchable:false },
                { data: 'cost', name: 'cost',orderable:false,searchable:false },
        
        ]

        });
    });

     $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#expens').DataTable({
           // ajax:'{{route("build.show",$build[0]->id)}}',
           ajax:{
            url:'{{route("build.show",$build[0]->id)}}',
                data:{type:'expenseDetail'}
              },
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging: true,
            columns: [    
                { data: 'account', name: 'account' },
                { data: 'description', name: 'description' },
                { data: 'amount', name:'amount', orderable:true,searchable:false},
        
        ]

        });
    });

     $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#itemExpense').DataTable({
           // ajax:'{{route("build.show",$build[0]->id)}}',
           ajax:{
            url:'{{route("build.show",$build[0]->id)}}',
                data:{type:'itemExpense'}
              },
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging: true,
            columns: [    
                { data: 'category', name: 'category', orderable:false,searchable:false },
                { data: 'item_name', name: 'items.name' },
                { data: 'measure_name', name: 'symbol', orderable:false,searchable:false },
                { data: 'quantity', name: 'quantity', orderable:false,searchable:false },
                // { data: 'materialCost', name: 'materialCost', orderable:false,searchable:false },
                // { data: 'transportCost', name: 'transportCost', orderable:false,searchable:false },
                // { data: 'customeCost', name: 'customeCost', orderable:false,searchable:false },
                // { data: 'laborCost', name: 'laborCost', orderable:false,searchable:false },
                // { data: 'subContractorCost', name: 'subContractorCost', orderable:false,searchable:false },
                // { data: 'manufacturingCost', name: 'manufacturingCost', orderable:false,searchable:false },
                // { data: 'otherCost', name: 'otherCost', orderable:false,searchable:false },

                { data: 'total', name: 'total', orderable:false,searchable:false },
        
        ]

        });
    });

    $(document).ready(function () {
    $('#attachment').DataTable({
                ajax: {
                    url:'{{route("build.show",$build[0]->id)}}',
                    data: {type: 'attachment'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });  
        });
    $(document).ready(function () {
        $('#laboratory_id').on('shown.bs.tab', function(event){
            $('#laboratory_table').DataTable({
                ajax: {
                    url:'{{route("build.show",$build[0]->id)}}',
                    data: {type: 'laboratory'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [

                    {data: 'number', name: 'laboratories.number'},
                    {data: 'vehicle_number', name: 'laboratories.vehicle_number'},
                    {data: 'item_name', name: 'item_name', orderable: false, searchable: false},
                    {data: 'measure_name', name: 'measure_name', orderable: false, searchable: false},
                    {data: 'description', name: 'laboratories.description'},
                    {data: 'date', name: 'date', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            }); 
            });             
            
            $('#weighbridge_id').on('shown.bs.tab', function(event){
            $('#weighbridge_table').DataTable({
                ajax: {
                    url:'{{route("build.show",$build[0]->id)}}',
                    data: {type: 'weighbridge'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [

                    {data: 'number', name: 'weighbridges.number'},
                    {data: 'vehicle_number', name: 'weighbridges.vehicle_number'},
                    {data: 'driver_name', name: 'weighbridges.driver_name'},
                    {data: 'item_name', name: 'item_name', orderable: false, searchable: false},
                    {data: 'measure_name', name: 'measure_name', orderable: false, searchable: false},
                    {data: 'full_weight', name: 'weighbridges.full_weight'},
                    {data: 'empty_weight', name: 'weighbridges.empty_weight'},
                    {data: 'net_weight', name: 'weighbridges.net_weight'},
                    {data: 'date', name: 'date', orderable: false, searchable: false},
                    {data: 'hour', name: 'hour', orderable: false, searchable: false},
                    {data: 'description', name: 'weighbridges.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            }); 
            });   
    });

var vm_lab =new Vue({
    el: '#laboratory-modal',
    data:{
        is_show: false,
        pdfRoute: '{!!route('export.PDFAny') !!}',
        excelRoute: '{!! route('export.exportCsv') !!}'
    },

    methods:{
        closeModal: function(){
            this.is_show = !this.is_show;
        }
    }
});

var modal_lab= new Vue({
    el: '#lab-modal',
    methods: {
        showModal: function () {
            vm_lab.$data.is_show = true;

        }
        
    }
});

var vm_weigh =new Vue({
    el: '#weighbridge-modal',
    data:{
        is_show: false,
        pdfRoute: '{!!route('export.PDFAny') !!}',
        excelRoute: '{!! route('export.exportCsv') !!}'
    },

    methods:{
        closeModal: function(){
            this.is_show = !this.is_show;
        }
    }
});

var modal_weigh= new Vue({
    el: '#weigh-modal',
    methods: {
        showModal: function () {
            vm_weigh.$data.is_show = true;

        }
        
    }
});   

var laboratory_item = {!! $laboratory_item!!}
var laboratory_measure = {!! $measureUnitList!!}

   var laboratory =  new Vue({
        el:'#laboratory',
        data:{
            laboratory_item:laboratory_item,
            selected_item:null,
            laboratory_measure:laboratory_measure,
            selected_measure_laboratory:null
        },
        methods:{
            labSelectedMeasure(){
                if(this.selected_item!=null){
                    var measure_id = this.selected_item.measure_id;
                    if(measure_id){
                        this.selected_measure_laboratory = _.find(this.laboratory_measure, (m) => m.measure_id == measure_id);
                    }
                }

            }
        }
    });
    
    var weighbridge_item = {!! $laboratory_item!!}
    var weighbridge_measure = {!! $measureUnitList!!}
    

   var weighbridge =  new Vue({
        el:'#weighbridge',
        data:{
            weighbridge_item:weighbridge_item,
            selected_item_weighbridge:null,
            weighbridge_measure:weighbridge_measure,
            selected_measure_weighbridge:null
        },
        methods:{
            selectedMeasure(){
                if(this.selected_item_weighbridge!=null){
                    var measure_id = this.selected_item_weighbridge.measure_id;
                    if(measure_id){
                        this.selected_measure_weighbridge = _.find(this.weighbridge_measure, (m) => m.measure_id == measure_id);
                    }
                }

            }
        }
    });


</script>
 
@endpush 