@extends('layouts.factor-master')

@section('content')

<?php
  
$report =customeReportNew('bulids_index');
$_record = !in_array('record', $report);
$_date = !in_array('date', $report);
$_build_number = !in_array('build_number', $report);
$_reference_number = !in_array('reference_number', $report);
$_type = !in_array('type', $report);
$_item_name = !in_array('item_name', $report);
$_measure = !in_array('measure', $report);
$_quantity = !in_array('quantity', $report);
$_khada = !in_array('khada', $report);
$_cost = !in_array('cost', $report);
$_total_expense = !in_array('total_expense', $report);
$_cost_with_expenses = !in_array('cost_with_expenses', $report);
$_user = !in_array('user', $report);
 
$report_percent = customeReportNewPercent('bulids_index');
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_build_number_percent= (array_key_exists('build_number___percent', $report_percent))?$report_percent['build_number___percent']:null;
    $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null;
    $_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_khada_percent= (array_key_exists('khada___percent', $report_percent))?$report_percent['khada___percent']:null;
    $_cost_percent= (array_key_exists('cost___percent', $report_percent))?$report_percent['cost___percent']:null;
    $_total_expense_percent= (array_key_exists('total_expense___percent', $report_percent))?$report_percent['total_expense___percent']:null;
    $_cost_with_expenses_percent= (array_key_exists('cost_with_expenses___percent', $report_percent))?$report_percent['cost_with_expenses___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
 

?>

   <h3 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h3>
     <table   class="main-table">
    <tr>
      @if($from_date)
     <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif    {{convertDate($from_date)}} </BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif   {{convertDate($to_date)}}</BDO>
    </td>
    @endif

    @if($item_name)
    <td>
      <span>@lang('layout.ItemName')</span>:
      <BDO>{{$item_name}}</BDO>
    </td>
    @endif

  </tr>
  </table>
  <br>
  <table class="main-table">
    <thead>
      <tr class="bg">
      @if($_record)<td class="center" @if($_record_percent) width="{{$_record_percent}}%" @endif ><div > @lang('layout.Record')</div></td>@endif
      @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif  ><div > @lang('layout.Date')</div></td>@endif
      @if($_build_number)<td class="center" @if($_build_number_percent) width="{{$_build_number_percent}}%" @endif  ><div > @lang('layout.BuildNumber') </div></td>@endif
      @if($_reference_number)<td class="center" @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif  ><div > @lang('layout.ReferenceNumber') </div></td>@endif
      @if($_type)<td class="center" @if($_type_percent) width="{{$_type_percent}}%" @endif  ><div > @lang('layout.Type')</div></td>@endif
      @if(!$item_name)
      @if($_item_name)<td class="center" @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif  ><div > @lang('layout.ItemName')</div></td>@endif
      @endif
      @if($_measure)<td class="center" @if($_measure_percent) width="{{$_measure_percent}}%" @endif  ><div > @lang('layout.Measure')</div></td>@endif
      @if($_quantity)<td class="center" @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif  ><div > @lang('layout.Quantity')</div></td>@endif
      @if(systemConfig()[8] != 0 )
      @if($_khada)<td class="center" @if($_khada_percent) width="{{$_khada_percent}}%" @endif  ><div > @lang('layout.Khada')</div></td>@endif
      @endif
      @if($_cost)<td class="center" @if($_cost_percent) width="{{$_cost_percent}}%" @endif  ><div > @lang('layout.Cost')</div></td>@endif
      @if($_total_expense)<td class="center" @if($_total_expense_percent) width="{{$_total_expense_percent}}%" @endif  ><div > @lang('layout.TotalExpense')</div></td>@endif
      @if($_cost_with_expenses)<td class="center" @if($_cost_with_expenses_percent) width="{{$_cost_with_expenses_percent}}%" @endif  ><div > @lang('layout.CostWithExpenses')</div></td>@endif
      @if($_user)<td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif  ><div > @lang('layout.User')</div></td>@endif
    </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    <tbody>
    @foreach($data AS $record)
    <tr>
      @if($_record)<td class="center">{{++$count}}</td>@endif
      @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
      @if($_build_number)<td  class="center">{{$record->build_number}}</td>@endif
      @if($_reference_number)<td  class="center">{{$record->build_ref_number}}</td>@endif
      @if($record->type == 'pro_change_roll')
      @if($_type)<td class="center">@lang('layout.ChangeItem')</td>@endif
      @endif
      @if($record->type != 'pro_change_roll')
      @if($_type)<td class="center">@lang('layout.Build')</td>@endif
      @endif
      @if(!$item_name)
      @if($_item_name)<td class="center">{{$record->Name}}</td>@endif
      @endif
      @if($_measure)<td class="center">{{$record->measure_name}}</td>@endif
      @if($_quantity)<td class="center">{{$record->Quantity}}</td>@endif
      @if(systemConfig()[8] != 0 )
      @if($_khada)<td class="center">{{$record->khada}}</td>@endif
      @endif
      @if($_cost)<td class="center">{{round($record->Cost,2)}}{{getHomeCurrency()[getCurrencyType()]}}</td>@endif
      @if($_total_expense)<td class="center">{{$record->expense_amount}}</td>@endif
      @if($_cost_with_expenses)<td class="center">{{MyRound($record->Cost+$record->expense_amount)}}</td>@endif
      @if($_user)<td class="center">{{$record->user}}</td>@endif

    </tr>
    @endforeach
  </tbody>
</table>

<br>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h3>
<table class="main-table">
    <thead>
    <tr>
      @if($_record)<td  class="center"  @if($_record_percent) width="{{$_record_percent}}%" @endif ><div> @lang('layout.Record')</div></td>@endif
      @if($_date)<td  class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif ><div> @lang('layout.Date')</div></td>@endif
      @if($_build_number)<td  class="center" @if($_build_number_percent) width="{{$_build_number_percent}}%" @endif ><div> @lang('layout.BuildNumber') </div></td>@endif
      @if($_item_name)<td  class="center" @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif  ><div> @lang('layout.ItemName')</div></td>@endif

      @if($_measure)<td  class="center" @if($_measure_percent) width="{{$_measure_percent}}%" @endif ><div> @lang('layout.Measure')</div></td>@endif
      @if($_quantity)<td  class="center"  @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif><div> @lang('layout.Quantity')</div></td>@endif
      @if(systemConfig()[8] != 0 )
      @if($_khada)<td  class="center" @if($_khada_percent) width="{{$_khada_percent}}%" @endif ><div> @lang('layout.Khada')</div></td>@endif
      @endif
      @if($_total_expense)<td  class="center" @if($_total_expense_percent) width="{{$_total_expense_percent}}%" @endif  ><div> @lang('layout.TotalExpense')</div></td>@endif
      @if($_cost)<td  class="center" @if($_cost_percent) width="{{$_cost_percent}}%" @endif ><div> @lang('layout.Cost')</div></td>@endif
    </tr>
    </thead>
    <?php
    $count = 0;
    $totalCost=0;
    $totalQty=0;
    $totalKhada=0;
    ?>
    <tbody>
    @foreach($dataByTotal AS $record)
    <?php
    $totalCost+=$record->Cost;
    $totalQty+=$record->Quantity;
    if($record->khada > 0){
      $totalKhada+=$record->khada;
    }
    ?>
    <tr>
      @if($_record)<td class="center">{{++$count}}</td>@endif
      @if($_date)<td class="center">{{convertDate($record->Date)}}</td>@endif
      @if($_build_number)<td class="center">{{$record->build_number}}</td>@endif
      @if($_item_name)<td  class="center">{{$record->Name}}</td>@endif
      @if($_measure)<td class="center">{{$record->measure_name}}</td>@endif
      @if($_quantity)<td  class="center">{{$record->Quantity}}</td>@endif
      @if(systemConfig()[8] != 0 )
      @if($_khada)<td  class="center">{{$record->khada}}</td>@endif
      @endif
      @if($_total_expense)<td  class="center">{{round($record->expense_amount,2)}}</td>@endif
       @if($_cost)<td  class="center">{{round($record->Cost+$record->expense_amount,2)}}</td>@endif 
    </tr>
    @endforeach
    <tr class="bg">
      <td colspan="4"><div class="center">@lang('layout.Total') : {{myRound($totalCost)}}{{getHomeCurrency()[getCurrencyType()]}}</div></td>
    </tr>
      @if(systemConfig()[8] != 0 )
      <tr class="bg">
        <td colspan="2"><div class="center">@lang('layout.TotalQty') : {{myRound($totalQty)}}</div></td>
        <td colspan="2"><div class="center">@lang('layout.Total') @lang('layout.Khada') : {{myRound($totalKhada)}}</div></td>
      </tr>
      @endif
    </tbody>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table> 
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr> 
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection