@extends('layouts.app')
@section('content')
    @include('sales.modal')
    <!-- BEGIN TAB PORTLET-->
    <div id="app5" v-cloak>
        {{Form::open(['route' => 'build.addUnit','method' => 'Post','class' => 'inline'])}}
        <input type="hidden" name="type" value="invoicelistRoll"/>
        <button id="show-modal5" style="display: none" type="button" @click="editExample5">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <input type="hidden" name="build_id" v-model="selectedBuild">
                                <div class="input-group">
                                    <span class="input-group-addon"> @lang('layout.OMeasureValue') 1</span>
                                    <input type="number" name="other_measure" class="form-control"
                                           placeholder="@lang('layout.Quantities') 1">
                                    <span class="input-group-addon"> @lang('layout.OMeasureValue') 2</span>
                                    <input type="number" name="other_measure2" class="form-control"
                                           placeholder="@lang('layout.Quantities') 2">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->

    {{-- <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'build_report'"
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">

                            <label class="control-label">@lang('layout.SelectItem'):</label>
                            <v-select placeholder="@lang('layout.SelectItem')" label="name" :options="    itemList"
                                      v-model="items"></v-select>
                            <input type="hidden" name="item_id" :value="(items)?items.id:null">
                        </div>

                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" class="form-control">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="summary">@lang('layout.Summary')</option>
                                <option value="details">@lang('layout.Details')</option>
                            </select>
                        </div>
                        @if(systemConfig()[8] != 0 )
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.BuildType') </label>
                            <select name="build_type" class="form-control">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="build">@lang('layout.Build')</option>
                                <option value="pro_f_roll">@lang('type.buildByCode')</option>
                                <option value="pro_change_roll">@lang('layout.ChangeItem')</option>
                            </select>
                        </div>
                        @endif

                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </report-modal>
    </div> --}}

    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
        :value-type="'build_report'"
        @closed="closeModal">

            <div slot=body>
                

                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">

                       <ul class="nav nav-tabs">
                           
                           <li class="active">
                               <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                           </li>
                           @if(systemConfig()[2] != 0 )
                                   @permission(['customreport-list'])
                           <li class="">
                               <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                           </li>
                           @endpermission
                           @endif
                       </ul>
                       <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                   <div class="portlet light bordered">
                                    <input type="hidden" name="type_name" value="Expens_type"/>
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-4">
                    
                                                <label class="control-label">@lang('layout.SelectItem'):</label>
                                                <v-select placeholder="@lang('layout.SelectItem')" label="name" :options="    itemList"
                                                          v-model="items"></v-select>
                                                <input type="hidden" name="item_id" :value="(items)?items.id:null">
                                            </div>
                    
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.SelectType') </label>
                                                <select name="category" class="form-control">
                                                    <option value="">@lang('layout.SelectType')</option>
                                                    <option value="summary">@lang('layout.Summary')</option>
                                                    <option value="details">@lang('layout.Details')</option>
                                                </select>
                                            </div>
                                            @if(systemConfig()[8] != 0 )
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.BuildType') </label>
                                                <select name="build_type" class="form-control">
                                                    <option value="">@lang('layout.SelectType')</option>
                                                    <option value="build">@lang('layout.Build')</option>
                                                    <option value="pro_f_roll">@lang('type.buildByCode')</option>
                                                    <option value="pro_change_roll">@lang('layout.ChangeItem')</option>
                                                </select>
                                            </div>
                                            @endif
                    
                                        </div>
                                    </div>
                    
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                                    <option value="Today">@lang('type.Today')</option>
                                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                                </select>
                                            </div>
                                            <div class="col-md-8" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                    
                                   </div>
                           </div> 

                           <div class="tab-pane" id="tab2"> 
                              <div class="portlet light bordered">
                                   <div class="portlet-body">

                                       <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                           @csrf
                                           <input type="hidden" name="part_name" value="bulids_index">


                                           <div class="col-md-12 col-sm-12 col-xs-12">

                                               <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                   <div class="form-group">
                                                   <table class="table table-striped table-bordered table-advance table-hover">
                                                               <tr>
                                                                   <td style="text-align: center;">@{{ row.Name }}</td>
                                                               </tr>
                                                               <tr>
                                                                   <td style="text-align: center;">
                                                                       <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                       <label class="switch">
                                                                           <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                           :checked="row.checkedColumn">
                                                                           <span class="slider round"></span>
                                                                       </label>
                                                                       <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                   </td>
                                                               </tr>
                                                           </table>
                                                   </div>
                                               </div>
                                           </div>
                                           <div class="margiv-top-10">
                                               <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                           </div>
                                   </form>
                                   </div>
                           </div>
                   </div>
                   </div>
               </div>
           </div>
           <!----------------------------------------------
           ----Begin Report Body And Custome Report-------
           ----------------------------------------------->

            </div>
        </report-modal>
    </div>



    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.BuildList')</span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                    @permission('build-export')

                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>

                    @endpermission
                    @permission('build-create')
                    <a href="{{route('build.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i>@lang('layout.AddNew')
                        </button>
                    </a>
                    @if(systemConfig()[8] != 0 )
                        <a href="{{route('build_m.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i>@lang('layout.AddNew_m')
                            </button>
                        </a>
                        <a href="{{route('build_change.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i>@lang('layout.AddNew_m_change')
                            </button>
                        </a>
                    @endif
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="build">
                    <thead>
                    <tr>

                        <th>@lang('layout.BuildNumber') </th>
                        <th>@lang('layout.ReferenceNumber') </th>
                        <th>@lang('layout.Type') </th>
                        <th>@lang('layout.ProductName')  </th>
                        <th>@lang('layout.Qty')</th>
                        <th>@lang('layout.Measure') </th>
                        <th>@lang('layout.Date')</th>
                        @if (\Entrust::can('cost-create'))
                        <th>@lang('layout.Cost')</th>
                        @endif
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                    <tfoot>
                    {{--<tr>--}}
                    {{--<th>Code</th>--}}
                    {{--<th>Name</th>--}}
                    {{--<th>Description</th>--}}
                    {{--<th>Precent</th>--}}
                    {{--<th>Measure</th>--}}
                    {{--<th>Rate</th>--}}
                    {{--<th>Quantities</th>--}}
                    {{--<th>Actions</th>--}}
                    {{--</tr>--}}
                    </tfoot>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
    var cust_rep = {!!customeReportNewData('bulids_index')!!};

        $(document).ready(function () {

            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#build').DataTable({
                ajax: '{{route("build.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:6}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                scrollCollapse: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [

                    // {data: 'id', name: 'id'},
                    {data: 'number', name: 'number', searchable: false},
                    {data: 'ref_no', name: 'builds.ref_no', orderable: false, searchable: false},
                    {data: 'type', name: 'builds.type', orderable: false, searchable: false},
                    {data: 'name', name: 'name', searchable: false},
                    {data: 'qty', name: 'qty', orderable: false, searchable: false},
                    {data: 'symbol', name: 'symbol', searchable: false},
                    {data: 'date', name: 'date', searchable: false},
                    @if (\Entrust::can('cost-create'))
                    {data: 'cost', name: 'cost', orderable: false, searchable: false},
                    @endif
                    {data: 'username', name: 'username', searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},


                ]


            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                itemList:{!! json_encode($itemList) !!},
                items: null,
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.BuildNumber")', column_name: 'build_number',checkedColumn:(cust_rep.build_number)?'checked':'',column_percentage:(cust_rep.build_number___percent)?cust_rep.build_number___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.Khada")', column_name: 'khada',checkedColumn:(cust_rep.khada)?'checked':'',column_percentage:(cust_rep.khada___percent)?cust_rep.khada___percent:''},
                 {Name: '@lang("layout.Cost")', column_name: 'cost',checkedColumn:(cust_rep.cost)?'checked':'',column_percentage:(cust_rep.cost___percent)?cust_rep.cost___percent:''},
                 {Name: '@lang("layout.TotalExpense")', column_name: 'total_expense',checkedColumn:(cust_rep.total_expense)?'checked':'',column_percentage:(cust_rep.total_expense___percent)?cust_rep.total_expense___percent:''},
                 {Name: '@lang("layout.CostWithExpenses")', column_name: 'cost_with_expenses',checkedColumn:(cust_rep.cost_with_expenses)?'checked':'',column_percentage:(cust_rep.cost_with_expenses___percent)?cust_rep.cost_with_expenses___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 
                ],
                  cust_rep:cust_rep

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });


        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#app',
            data: {
                showModal: false,
                itemList:{!! json_encode($itemList) !!},
                items: null,
            },
            methods: {
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example").persianDatepicker(modelDate());
                            from = $("#range-from-example").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })
        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                itemList:{!! json_encode($itemList) !!},
                items: null,

            },
            methods: {
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

        // add unit
        // start app
        let app55 = new Vue({
            el: '#app5',
            data: {
                showModal: false,
                selectedBuild: null,
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample5: function (data) {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.selectedBuild = data;

                }
            },
        });

        function unitItemAjax(datatableId = null) {

            app55.editExample5(datatableId);

        }


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>


@endpush
