@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReportNew('general_build_report_index');
$_record = !in_array('record', $report);
$_date = !in_array('date', $report);
$_build_number = !in_array('build_number', $report);
$_build_item = !in_array('build_item', $report);
$_quantity = !in_array('quantity', $report);
$_total_expense = !in_array('total_expense', $report);
$_cost = !in_array('cost', $report);
 
$_evaporate_water = !in_array('evaporate_water', $report);
$_moiatem_percentage = !in_array('moiatem_percentage', $report);
$_balance = !in_array('balance', $report);
$_inventory = !in_array('inventory', $report);
 

$report_percent = customeReportNewPercent('general_build_report_index');
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_build_number_percent= (array_key_exists('build_number___percent', $report_percent))?$report_percent['build_number___percent']:null;
    $_build_item_percent= (array_key_exists('build_item___percent', $report_percent))?$report_percent['build_item___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_total_expense_percent= (array_key_exists('total_expense___percent', $report_percent))?$report_percent['total_expense___percent']:null;
    $_cost_percent= (array_key_exists('cost___percent', $report_percent))?$report_percent['cost___percent']:null;
     $_evaporate_water_percent= (array_key_exists('evaporate_water___percent', $report_percent))?$report_percent['evaporate_water___percent']:null;
     $_moiatem_percentage_percent= (array_key_exists('moiatem_percentage___percent', $report_percent))?$report_percent['moiatem_percentage___percent']:null;
    $_balance_percent= (array_key_exists('balance___percent', $report_percent))?$report_percent['balance___percent']:null;
    $_inventory_percent= (array_key_exists('inventory___percent', $report_percent))?$report_percent['inventory___percent']:null;
  

    // dd($_cost_percent);

?>

    <h4></h4>
	<h4 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h4>

  <table class="main-table">
    <tr>
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
  </table>
  
<table class="main-table">
    <thead>
    <tr>
      @if($_record)<td @if($_record_percent) width="{{$_record_percent}}%" @endif class="center"> @lang('layout.Record')</td>@endif
      @if($_date)<td @if($_date_percent) width="{{$_date_percent}}%" @endif class="center"> @lang('layout.Date')</td>@endif
      @if($_build_number)<td @if($_build_number_percent) width="{{$_build_number_percent}}%" @endif class="center"> @lang('layout.BuildNumber') </td>@endif
      @if($_build_item)<td @if($_build_item_percent) width="{{$_build_item_percent}}%" @endif class="center" > @lang('layout.BuildItem')</td>@endif
      @if($_quantity)<td @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif class="center"> @lang('layout.Quantity')</td>@endif
      @if($_total_expense)<td @if($_total_expense_percent) width="{{$_total_expense_percent}}%" @endif class="center" > @lang('layout.TotalExpense')</td>@endif
      @if($_cost)<td @if($_cost_percent) width="{{$_cost_percent}}%" @endif class="center"> @lang('layout.TotalAmount')</td>@endif
      @if($_cost)<td @if($_cost_percent) width="{{$_cost_percent}}%" @endif class="center"> @lang('layout.UnitCost')</td>@endif
      @if($_moiatem_percentage)<td @if($_moiatem_percentage_percent) width="{{$_moiatem_percentage_percent}}%" @endif class="center"> @lang('layout.MoiatemPercentage')</td>@endif
       <td class="center" width="20%">@lang('layout.OutItems')</td>
      <td class="center" width="25%" >@lang('layout.InItems')</td>
       @if($_evaporate_water)<td @if($_evaporate_water_percent) width="{{$_evaporate_water_percent}}%" @endif class="center" >@lang('layout.EvaporatedWater')</td>@endif
       @if ($com_poss_build_qty)
       @if($_balance)<td @if($_balance_percent) width="{{$_balance_percent}}%" @endif class="center" >@lang('layout.PossibleBuildQuentity')</td>@endif
       @endif
       @if($_balance)<td @if($_balance_percent) width="{{$_balance_percent}}%" @endif class="center" >@lang('layout.Balance')</td>@endif
    </tr>
    </thead>
    <?php
    $count = 0;
    $totalCost=0;
    $allBuildDetailIn=0;
    $allBuildDetailOut=0;
	
    $BuildIn=0;
    $BuildOut=0;
    $evaporated_water=0;
    $possibleBuildQty=0;
    $TQuantity=0;
    $colspan = 9;
    ?>
    <tbody>
    @foreach($data AS $record)
    <?php
    $totalCost+=$record['Cost'];
    $TQuantity+=$record['Quantity'];
    $evaporated_water+=$record['evaporated_water'];
    $possibleBuildQty+=$record['possibleBuildQty'];
    $allBuildDetailIn = $record['allBuildDetailIn'];
    $allBuildDetailOut = $record['allBuildDetailOut'];
    ?>
    <tr>
      @if($_record)<td class="center">{{++$count}}</td>@endif
      @if($_date)<td class="center">{{convertDate($record['Date'])}}</td>@endif
       @if($_build_number)<td  class="center">{{$record['build_number']}}</td>@endif
       @if($_build_item)<td  class="center">{{$record['Name']}}</td>@endif
       @if($_quantity)<td class="center">{{$record['Symbol']}} {{$record['Quantity']}}</td>@endif
       @if($_total_expense)<td  class="center">{{myRound($record['expense_amount'])}}</td>@endif
       @if($_cost) <td  class="center">{{myRound($record['Cost']+$record['expense_amount'])}}</td>@endif
       @if($_cost) <td  class="center">{{myRound(($record['Cost']+$record['expense_amount']) / $record['Quantity'])}}</td>@endif
       @if($_moiatem_percentage)<td class="center">{{$record['moiatem_percentage']}} % </td>@endif
      
	  <td >
      <table class="main-table" style="width:100%">
        <tr class="bg">
          <td width="40%" class="center"><div class="center"> @lang('layout.ItemName') </div></td>
          @if($_inventory)
          <td width="30%" class="center"><div class="center"> @lang('layout.Inventory') </div></td>
          @endif
          <td width="30%" class="center"><div class="center"> @lang('layout.Quantity') </div></td>
        </tr>
		<?php
		$totalOut = 0;
		?>
	  @foreach($allBuildDetailOut AS $row)
	  <?php
		$totalOut+=$row['quantity'];
		$BuildOut+=$row['quantity'];
		?>
		<tr>
			<td class="center">{{$row['item_name']}}</td>
      @if($_inventory)
			<td class="center">{{$row['inv_out_site_name']}}</td>
      @endif
			<td class="center">{{myRound($row['quantity'])}} {{$row['Symbol']}}</td>
		</tr>
	  @endforeach
	  <tr>
      @if($_inventory)
			<td class="center" colspan="2">@lang('layout.Total')</td>
      @else 
			<td class="center" colspan="1">@lang('layout.Total')</td>
      @endif
			<td class="center">{{$totalOut}}</td>
		</tr>
	  </table> 
	  </td>  
	  <td >
      <table class="main-table" style="width:100%">
        <tr class="bg">
          <td width="30%" class="center"><div class="center"> @lang('layout.ItemName') </div></td>
          @if($_inventory)
          <td width="30%" class="center"><div class="center"> @lang('layout.Inventory') </div></td>
          @endif
          <td width="20%" class="center"><div class="center"> @lang('layout.Quantity') </div></td>
          <td width="20%" class="center"><div class="center"> @lang('layout.Percent') </div></td>
        </tr>
		<?php
    $totalIn = 0;
    $totalInss = 0;
    foreach ($allBuildDetailIn as $valuuu) {
      $totalInss+=$valuuu['quantity'];
    }
		?>
	  @foreach($allBuildDetailIn AS $row)
	  <?php
		$totalIn+=$row['quantity'];
		$BuildIn+=$row['quantity'];
		?>
		<tr>
			<td class="center">{{$row['item_name']}}</td>
      @if($_inventory)
			<td class="center">{{$row['inv_site_name']}}</td>
      @endif
			<td class="center">{{myRound($row['quantity'])}} {{$row['Symbol']}}</td>
			<td class="center">{{myRound(($row['quantity'] * 100) / $totalInss)}} %</td>
		</tr>
	  @endforeach
	  <tr>
      @if($_inventory)
			<td class="center" colspan="2">@lang('layout.Total')</td>
      @else 
			<td class="center" colspan="1">@lang('layout.Total')</td>
      @endif
			<td class="center">{{$totalIn}}</td>
		</tr>
	  </table>
	  </td>
   
   @if($_evaporate_water)<td class="center">{{myRound($record['evaporated_water'])}} {{$record['Symbol']}}</td>@endif
   @if ($com_poss_build_qty)
   @if($_balance)<td class="center">{{myRound($record['possibleBuildQty'])}}</td>@endif
   @if($_balance)<td class="center">{{myRound(abs($record['Quantity'] - $record['possibleBuildQty']))}} <?php if($record['Quantity'] - $record['possibleBuildQty'] > 0){ echo __('layout.Increase'); }else{ echo __('layout.Decrease'); } ?></td>@endif
   @else
	 @if($_balance)<td class="center">{{myRound(abs($totalOut - $totalIn))}} <?php if($totalOut - $totalIn > 0){ echo __('layout.Decrease'); }else{ echo __('layout.Increase'); } ?></td>@endif
   @endif
    </tr>
    @endforeach

    @if(!$_record) <?php  $colspan = $colspan-1; ?> @endif
    @if(!$_date) <?php  $colspan = $colspan-1; ?> @endif
    @if(!$_build_number) <?php  $colspan = $colspan-1; ?> @endif
    @if(!$_build_item) <?php  $colspan = $colspan-1; ?> @endif
    @if(!$_quantity) <?php  $colspan = $colspan-1; ?> @endif
    @if(!$_total_expense) <?php  $colspan = $colspan-1; ?> @endif
    @if(!$_cost) <?php  $colspan = $colspan-1; ?> @endif
    @if(!$_cost) <?php  $colspan = $colspan-1; ?> @endif
    @if(!$_moiatem_percentage) <?php  $colspan = $colspan-1; ?> @endif

    <tr class="bg">
    <td colspan="{{$colspan}}"><div class="center">@lang('layout.Total'): {{round($totalCost,2)}}{{getHomeCurrency()[getCurrencyType()]}}</div></td>
	  <td >@lang('layout.OutItems'):  {{myRound($BuildOut)}} </td>
	  <td >@lang('layout.InItems'):  {{myRound($BuildIn)}} </td>
	   @if($_evaporate_water)<td @if($_evaporate_water_percent) width="{{$_evaporate_water_percent}}%" @endif>@lang('layout.Total'): {{myRound($evaporated_water)}} </td>@endif
     @if ($com_poss_build_qty) 
     @if($_balance)
     <td>  </td>
     @endif 
     @if($_balance)<td @if($_balance_percent) width="{{$_balance_percent}}%" @endif>@lang('layout.Balance'): {{myRound(abs($TQuantity - $possibleBuildQty))}} <?php if($TQuantity - $possibleBuildQty > 0){ echo __('layout.Increase'); }else{ echo __('layout.Decrease'); } ?> </td>@endif
      @else 
      @if($_balance)<td @if($_balance_percent) width="{{$_balance_percent}}%" @endif>@lang('layout.Balance'): {{myRound(abs($BuildOut - $BuildIn))}} <?php if($BuildOut - $BuildIn > 0){ echo __('layout.Decrease'); }else{ echo __('layout.Increase'); } ?> </td>@endif
     @endif
    </tr>
  </tbody>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection