@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReport('build');
$_date = in_array('date', $report);
$_build_number = in_array('build_number=', $report);
$_item_name = in_array('item_name', $report);
$_measure = in_array('measure', $report);
$_quantity = in_array('quantity', $report);
$_purchase_rate = in_array('purchase_rate', $report);
$_TotalExpense = in_array('_TotalExpense', $report);

?>
<h4></h4>
<h4 class="table-caption" style="text-align: center;">@lang('layout.GeneralPackageBuild')</h4>
<table class="main-table">
  <thead>
    <tr class="bg">
      <td>
        <div class="center"> #</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Number') </div>
      </td>
      @if($_date)<td>
        <div class="center"> @lang('layout.Date')</div>
      </td>@endif
      @if($_item_name)<td>
        <div class="center"> @lang('layout.Description')</div>
      </td>@endif
      <td class="center">@lang('layout.OutItems')</td>
      <td class="center">@lang('layout.InItems')</td>
      <td class="center">@lang('layout.Percent')</td>
    </tr>
  </thead>
  <?php
  $count = 0;
  $totalCost = 0;
  $allBuildDetailIn = 0;
  $allBuildDetailOut = 0;

  $BuildIn = 0;
  $BuildOut = 0;

  $measureBuildOut=[];
  $measureBuildIn=[];
  ?>
  <tbody>
    @foreach($data AS $record)
    <?php
    // $totalCost+=$record['Cost'];
    $allBuildDetailIn = $record['allBuildDetailIn'];
    $allBuildDetailOut = $record['allBuildDetailOut'];
    $category = [];
    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <td class="center">{{$record['number']}}</td>
      @if($_date)<td class="center">{{convertDate($record['date'])}}</td>@endif
      @if($_item_name)<td class="center">{{$record['description']}}</td>@endif
      <td width="35%">
        <table class="main-table" style="width:100%">
          <tr style="background-color: #3ab0bb;">
            <td width="15%">
              <div class="center"> @lang('layout.BuildNumber') </div>
            </td>
            <td width="25%">
              <div class="center"> @lang('layout.ItemName') </div>
            </td>
            <td width="30%">
              <div class="center"> @lang('layout.BaseUnit') </div>
            </td>
            <td width="30%">
              <div class="center"> @lang('layout.Quantity') </div>
            </td>
          </tr>
          <?php
          $totalOut = 0;
          $measureTotalOut=[];
          ?>
          @foreach($allBuildDetailOut AS $row)
          <?php
          $totalOut += $row['quantity'];
          $BuildOut += $row['quantity'];
          
          if(array_key_exists($row['Symbol_base'], $measureTotalOut))
          {
            $measureTotalOut[$row['Symbol_base']]=$measureTotalOut[$row['Symbol_base']]+$row['quantity'];
          }
          else
          {
            $measureTotalOut[$row['Symbol_base']]=$row['quantity'];
          }

          if(array_key_exists($row['item_name'], $measureBuildOut))
          {
            $measureBuildOut[$row['item_name']]=['amount'=>$measureBuildOut[$row['item_name']]['amount']+$row['quantity'], 'name'=>$row['Symbol_base']];
          }
          else
          {
            $measureBuildOut[$row['item_name']]=['amount'=>$row['quantity'], 'name'=>$row['Symbol_base']];
          }

          ?>
          <tr>
            <td class="center">{{$row['number']}}</td>
            <td class="center">{{$row['item_name']}}</td>
            <td class="center">{{myRound($row['quantity_base'])}} ({{$row['Symbol_base']}})</td>
            <td class="center">{{myRound($row['quantity'])}} ({{$row['Symbol']}})</td>
          </tr>
          @endforeach
          <?php
            if(isset($measureTotalOut))
            {
              foreach($measureTotalOut As $key=>$rowOut)
            {
              ?>
              <tr style="background-color: #cbc9e8;" >
                <td class="center" colspan="2">@lang('layout.Total')</td>
                <td class="center" colspan="2">{{$rowOut}} ({{$key}})</td>
              </tr>
              <?php
            }
            }
            ?>
            <tr class="bg">
              <td class="center" colspan="2">@lang('layout.Total')</td>
              <td class="center" colspan="2">{{$totalOut}}</td>
            </tr>
        </table>
      </td>

      <td width="35%">
        <table class="main-table" style="width:100%">
          <tr style="background-color: #3ab0bb;">
            <td width="15%">
              <div class="center"> @lang('layout.BuildNumber') </div>
            </td>
            <td width="20%">
              <div class="center"> @lang('layout.ItemName') </div>
            </td>
            <td width="25%">
              <div class="center"> @lang('layout.BaseUnit') </div>
            </td>
            <td width="25%">
              <div class="center"> @lang('layout.Quantity') </div>
            </td>
            <td width="15%">
              <div class="center"> @lang('layout.Percent') </div>
            </td>
          </tr>
          <?php
          $totalIn = 0;
          $totalInss = 0;
          $category = [];
          $measureTotalIn=[];
          foreach ($allBuildDetailIn as $valuuu) {
            $totalInss += $valuuu['quantity'];
          }
          ?>
          @foreach($allBuildDetailIn AS $row)
          <?php
          if (array_key_exists($row->category_name, $category)) {
              $category[$row->category_name] = $category[$row->category_name] + $row['quantity'];
          } else {
              $category[$row->category_name] = $row['quantity'];
          }
          $totalIn += $row['quantity'];
          $BuildIn += $row['quantity'];

          if(array_key_exists($row['Symbol_base'], $measureTotalIn))
          {
            $measureTotalIn[$row['Symbol_base']]=$measureTotalIn[$row['Symbol_base']]+$row['quantity'];
          }
          else
          {
            $measureTotalIn[$row['Symbol_base']]=$row['quantity'];
          }

          if(array_key_exists($row['item_name'], $measureBuildIn))
          {
            $measureBuildIn[$row['item_name']]=['amount'=>$measureBuildIn[$row['item_name']]['amount']+$row['quantity'], 'name'=>$row['Symbol_base']];
          }
          else
          {
            $measureBuildIn[$row['item_name']]=['amount'=>$row['quantity'], 'name'=>$row['Symbol_base']];
          }

          ?>
          <tr>
            <td class="center">{{$row['number']}}</td>
            <td class="center">{{$row['item_name']}}</td>
            <td class="center">{{myRound($row['quantity_base'])}} ({{$row['Symbol_base']}})</td>
            <td class="center">{{myRound($row['quantity'])}} ({{$row['Symbol']}})</td>
            <td class="center">{{myRound(($row['quantity'] * 100) / $totalInss)}} %</td>
          </tr>
          @endforeach
          <?php
            if(isset($measureTotalIn))
            {
              foreach($measureTotalIn As $key=>$rowIn)
            {
              ?>
              <tr style="background-color: #cbc9e8;" >
                <td class="center" colspan="2">@lang('layout.Total')</td>
                <td class="center" colspan="2">{{$rowIn}} ({{$key}})</td>
              </tr>
              <?php
            }
            }
          ?>
          <tr class="bg">
            <td class="center" colspan="2">@lang('layout.Total')</td>
            <td class="center" colspan="2">{{$totalIn}}</td>
          </tr>
        </table>
      </td>

      <td>
        <table class="main-table" style="width:100%">
          <tr class="bg">
            <td width="50%">
              <div class="center"> @lang('layout.CategoryName') </div>
            </td>
            <td width="50%">
              <div class="center"> @lang('layout.Percent') </div>
            </td>
          </tr>
          <?php
          foreach ($category as $keyy => $meas) {
          ?>
              <tr>
                  <td colspan="">
                      <div class="center">{{$keyy}}</div>
                  </td>
                  <td colspan="">
                      <div class="center">{{myRound(($meas * 100) / $totalInss)}} %</div>
                  </td>
              </tr>
          <?php
          }
          ?>
        </table>
      </td>
      
    </tr>
    @endforeach
    
    <tr style="background-color: #7ecdd6;">
      <td colspan="4">
        <!-- <div class="center">@lang('layout.Total'): {{round($totalCost,2)}}{{getHomeCurrency()[getCurrencyType()]}}</div> -->
      </td>
      <td width="35%"><center>@lang('layout.OutItems'): {{$BuildOut}} </center></td>
      <td width="35%"><center>@lang('layout.InItems'): {{$BuildIn}} </center></td>
      <td width=""></td>
    </tr>

    <tr>
      <td colspan="7"> <center> @lang('layout.TotalOut') </center> </td>
    </tr>

    <?php
      if(isset($measureBuildOut))
      {
        foreach($measureBuildOut As $key=>$rowOuts)
      {
        ?>
        <tr  style="background-color: #7eadd6;">
          <td colspan="4">
            @lang('layout.TotalOut')
          </td>
          <td width="35%">
            <center>{{$key}}</center>
          </td>
          <td width="35%">
            <center>{{$rowOuts['amount']}} ({{$rowOuts['name']}})</center>
          </td>
          <td width=""></td>
        </tr>
        <?php
      }
      }
    ?>
      <tr>
        <td colspan="7"> <center> @lang('layout.TotalIn') </center> </td>
      </tr>
    <?php
      if(isset($measureBuildIn))
      {
        foreach($measureBuildIn As $key=>$rowIns)
      {
        ?>
        <tr style="background-color: #9bd8e2;">
          <td colspan="4">
            @lang('layout.TotalIn')
          </td>
          <td width="35%"><center>{{$key}}</center></td>
          <td width="35%">
            <center>{{$rowIns['amount']}} ({{$rowIns['name']}})</center>
          </td>
          <td width=""></td>
        </tr>
        <?php
      }
      }
    ?>

  </tbody>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection