@extends('layouts.factor-master')

@section('content')
<h1></h1>

<?php
$report = customeReport('build_detail');

  $_build_number=in_array('build_number',$report);
  $_name=in_array('name',$report);
  $_measure=in_array('measure',$report);
  $_quantity=in_array('quantity',$report);
  $_purchase_rate=in_array('purchase_rate',$report);  
  $_total=in_array('total',$report);
  $_date=in_array('date',$report);

?>

  <h3 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h3>

            
<table class="main-table">
  <thead>
    <tr class="bg">
    <td class="center"><div> @lang('layout.Record')</div></td>
    @if($_build_number)<td class="center"><div> @lang('layout.BuildNumber') </div></td>@endif
    @if($_name)<td class="center"><div> @lang('layout.ItemName')</div></td>@endif
    @if($_measure)<td class="center"><div> @lang('layout.Measure')</div></td>@endif
    @if($_quantity)<td class="center"><div> @lang('layout.Quantity')</div></td>@endif
    @if($_purchase_rate)<td class="center"><div> @lang('layout.Cost')</div></td>@endif
    @if($_total)<td class="center"><div> @lang('layout.Total')</div></td>@endif
    @if($_total)<td class="center"><div> @lang('layout.Expense')</div></td>@endif
    @if($_total)<td class="center"><div> @lang('layout.CostWithExpenses')</div></td>@endif
    @if(systemConfig()[8] != 0 )
    @if($_quantity)<td class="center"><div> @lang('layout.Khada')</div></td>@endif
    @if($_quantity)<td class="center"><div> @lang('layout.EvaporatedWater')</div></td>@endif
    @endif
    @if($_quantity)<td class="center"><div> @lang('layout.MoiatemPercentage')</div></td>@endif
    @if($_date)<td class="center"><div> @lang('layout.Date')</div></td>@endif
  </tr>
  </thead>
 
  <tbody>
  <?php
  $count = 0;
  ?>
  @foreach($info AS $record)
  <tr>
    <td class="center">{{++$count}}</td>
    @if($_build_number)<td class="center">{{$record->number}}</td>@endif
    @if($_name)<td class="center">{{$record->item_name}}</td>@endif
    @if($_measure)<td  class="center">{{$record->measure}}</td>@endif
    @if($_quantity)<td  class="center">{{$record->quantity}}</td>@endif
    @if($_purchase_rate)<td  class="center">{{Currency()->format($record->price)}}</td>@endif
    @if($_total)<td  class="center">{{Currency()->format($record->cost)}}</td>@endif
    @if($_total)<td  class="center">{{myRound($record->expense_cost)}}</td>@endif
    @if($_total)<td  class="center">{{myRound($record->expense_cost+$record->price)}}</td>@endif
    @if(systemConfig()[8] != 0 )
    @if($_quantity)<td  class="center">{{$record->khada}}</td>@endif
    @if($_quantity)<td  class="center">{{$record->evaporated_water}}</td>@endif
    @endif
    @if($_quantity)<td  class="center">{{$record->moiatem_percentage}} % </td>@endif
    @if($_date)<td  class="center">{{convertDate($record->build_date)}}</td>@endif
  </tr>
  @endforeach
</tbody>
</table>  


@if($build_bundl)
 <h3 class="table-caption" style="text-align: center;">@lang('layout.Bundl')</h3>
<table class="main-table">
  <thead>
    <tr class="bg">
    <td><div class="center"> @lang('layout.Record')</div></td>
    @if($_name)<th>@lang('layout.ItemName')</th>@endif
    @if($_name)<th>@lang('layout.Code')</th>@endif
    @if($_date)<th>@lang('layout.Date')</th>@endif
    @if($_quantity)<th>@lang('layout.Quantity')</th>@endif
    @if($_measure)<th>@lang('layout.MeasureName')</th>@endif
    @if($_purchase_rate)<th>@lang('layout.Rate')</th>@endif
    @if($_name)<th>@lang('layout.Wing')</th>@endif
    @if(getOtherMeasure()=="true")
    <th> @lang('layout.OMeasureValue1')</th>
    @endif
    @if(getOtherMeasure2()=="true")
    <th> @lang('layout.OMeasureValue2')</th>
    @endif
  </tr>
  </thead>
 
  <tbody>
  <?php
  $count = 0;
  $total_cost=0;
  $currencies=[];
  ?>
  @foreach($build_bundl AS $record)
  <tr>
    <td class="center">{{++$count}}</td>
    @if($_name)<td class="center">{{$record->Name}}</td>@endif
    @if($_name)<td class="center">{{$record->code}}</td>@endif
    @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
    @if($_quantity)<td  class="center">{{$record->Quantity}}</td>@endif
    @if($_measure)<td  class="center">{{$record->Measure}}</td>@endif
    @if($_purchase_rate)<td  class="center">{{Currency()->format($record->Cost)}}</td>@endif
    @if($_name)<td class="center">{{$record->khada}}</td>@endif
    @if(getOtherMeasure()=="true")
    <td class="center">{{$record->other_measure}}</td>
    @endif
    @if(getOtherMeasure2()=="true")
    <td class="center">{{$record->other_measure2}}</td>
    @endif
  </tr>
  @endforeach
</tbody>
</table>
@endif

 <h3 class="table-caption" style="text-align: center;">@lang('layout.BuildOutItems')</h3>
<table class="main-table">
  <thead>
    <tr class="bg">
    <td class="center" ><div > @lang('layout.Record')</div></td>
    @if($_build_number)<td class="center" ><div > @lang('layout.BuildNumber') </div></td>@endif
    @if($_name)<td class="center" ><div > @lang('layout.Name')</div></td>@endif
    @if($_measure)<td class="center" ><div > @lang('layout.Measure')</div></td>@endif
    @if($_quantity)<td class="center" ><div > @lang('layout.Quantity')</div></td>@endif
    @if($_purchase_rate)<td class="center" ><div > @lang('layout.UnitCost')</div></td>@endif
    @if($_total)<td class="center" ><div > @lang('layout.Total')</div></td>@endif
    @if($_date)<td class="center" ><div > @lang('layout.Date')</div></td>@endif
  </tr>
  </thead>
 
  <tbody>
  <?php
  $count = 0;
  $total_cost=0;
  $currencies=[];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
      $total_cost+=$record->Cost*$record->Quantity;
    ?>
    <td class="center">{{++$count}}</td>
    @if($_build_number)<td class="center">{{$record->Build_Number}}</td>@endif
    @if($_name)<td class="center">{{$record->Name}}</td>@endif
    @if($_measure)<td  class="center">{{$record->Measure}}</td>@endif
    @if($_quantity)<td  class="center">{{$record->Quantity}}</td>@endif
    @if($_purchase_rate)<td  class="center">{{Currency()->format($record->Cost)}}</td>@endif
    @if($_total)<td  class="center">{{Currency()->format($record->Cost*$record->Quantity)}}</td>@endif
    @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
  </tr>
  @endforeach
</tbody>
</table>
<h4>@lang('layout.Total')</h4>
<table class="main-table">

<tr class="bg">
  <td><div class="center"> @lang('layout.Amount') </div></td>
  <td><div class="center"> {{round($total_cost,2)}}  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
</tr>

</table>
<h4 class="center">@lang('layout.Expense')</h4>
<table class="main-table">
  <thead>
    
    <tr class="bg">
      <th class="center">@lang('layout.No')</th>
      <th class="center">@lang('layout.Account')</th>
      <th class="center">@lang('layout.Description')</th>
      <th class="center">@lang('layout.Amount')</th>
    </tr>
  </thead>
  <tbody>
    <?php
    $count = 0;
    ?>
    @foreach($expenseDetails as $ex)
    <tr >
      <td class="center">{{++$count}}</td>
      <td class="center">{{$ex->account}}</td>
      <td class="center">{{$ex->description}}</td>
      <td class="center">{{$ex->amount}}</td>
    </tr>
    @endforeach
  </tbody>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection