@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('build');
$_date=in_array('date', $report);
$_build_number=in_array('build_number=', $report);
$_item_name=in_array('item_name', $report);
$_measure=in_array('measure', $report);
$_quantity=in_array('quantity', $report);
$_purchase_rate=in_array('purchase_rate', $report);
$_TotalExpense=in_array('_TotalExpense', $report);

?>
  
<h3 class="table-caption" style="text-align: center;">@lang('layout.AllBuildDetail')</h3>

<table class="main-table">
  <tr>
    @if($from_date)
    <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>



  <table class="main-table">
 
    <thead>
      <tr class="bg">

      <td class="center" ><div > @lang('layout.Record')</div></td>
      @if($_date)<td class="center" ><div > @lang('layout.Date')</div></td>@endif
      @if($_build_number)<td class="center" ><div > @lang('layout.BuildNumber') </div></td>@endif
      @if($_item_name)<td class="center" ><div > @lang('layout.ItemName')</div></td>@endif

      @if($_measure)<td class="center" ><div > @lang('layout.Measure')</div></td>@endif
      @if($_quantity)<td class="center" ><div > @lang('layout.Quantity')</div></td>@endif
      @if($_purchase_rate)<td class="center" ><div > @lang('layout.Cost')</div></td>@endif
      <td class="center"  ><div > @lang('layout.Total')</div></td>


    </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
      <td class="center">{{++$count}}</td>
    
       @if($_date)<td  class="center">{{convertDate($record->build_date)}}</td>@endif
      @if($_build_number)<td  class="center">{{$record->number}}</td>@endif
      @if($_item_name)<td class="center">{{$record->item_name}}</td>@endif
      @if($_measure)<td class="center">{{$record->measure}}</td>@endif
      @if($_quantity)<td class="center">{{$record->quantity}}</td>@endif
      @if($_purchase_rate)<td class="center">{{round($record->cost,2)}}{{getHomeCurrency()[getCurrencyType()]}}</td>@endif
   
      <td class="center">{{round($record->cost*$record->quantity,2)}}{{getHomeCurrency()[getCurrencyType()]}}</td>


  

    </tr>
    @endforeach
</table>

<br>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection