@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.AssemblyInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead >
                    <tr style="background-color:#9998ee"> 
                        <th class="hidden-xs">
                            <i class="fa fa-building"></i> @lang('layout.Type')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-bars"></i> @lang('layout.ProjectName')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.ProjectCode')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.ProjectId')
                        </th> 

                         <th>
                            <i class="fa fa-dashboard"></i> @lang('layout.Description')
                        </th>
                         <th>
                            <i class="fa fa-user"></i> @lang('layout.Date')
                        </th>
                    </tr>
                 
                    </thead>
                    <tbody>
                        <tr>  
                            <td class="hidden-xs"> {{$projectInfo->type }}  </td>
                            <td class="hidden-xs"> {{$projectInfo->name }}  </td>
                            <td class="hidden-xs"> {{$projectInfo->number}}  </td>
                            <td class="hidden-xs"> {{$projectInfo->id}}  </td>
                            <td class="hidden-xs"> {{$projectInfo->description }}  </td>
                            <td class="hidden-xs"> {{convertDate($projectInfo->date)}}  </td>
                        </tr> 
                    </tbody>
                </table>
            </div>
        </div>
    </div>
      <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Item')</span>
                    </div>
                    <div class="tools"></div>
                        <div class="actions">
                             {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                               <input type="hidden" name="type" value="buil-Item-Details"/>
                               <input type="hidden" name="id" value="{{$projectInfo->build_id}}"/> 
                               <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                            {{Form::close()}} 

                             {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                               <input type="hidden" name="type" value="buil-Item-Details"/>
                               <input type="hidden" name="id" value="{{$projectInfo->build_id}}"/> 
                               <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}  
                        </div>
                  
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="builditems">
                        <thead>
                        <tr>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Width')</th>
                            <th>@lang('layout.Height')</th>
                            <th>@lang('layout.BuildedQuantity')</th>
                            <th>@lang('layout.QuantityForBuild')</th>
                            <th>@lang('layout.Measure')</th> 
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')

<script>
     $(document).ready(function () {
        $('#builditems').DataTable({
            ajax: '{{route("buildItem.show",$projectInfo->build_id)}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,

            columns: [  
                {data: 'name',            name: 'name'},
                {data: 'width',           name: 'width'},
                {data: 'height',          name: 'height'},
                {data: 'qty',             name: 'qty'},
                {data: 'quantitytobuild', name: 'quantitytobuild'},
                {data: 'measure',         name: 'measure'}, 
            ]

        });
    });

</script>


@endpush
