@extends('layouts.app')
@section('content')
@include('layouts.modal')
<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="project_build_report"/>
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body"> 
        <div class="row">
            <div class="form-group"> 
                <div  class="col-md-12">
                    <label class="control-label ">@lang('layout.SelectProject') </label>
                      <v-select class="vue-select2" v-model="selectedproject" label="name" @search="onProjectSearch" :options="projectList">
                    </v-select>
                    <input type="hidden" name="project_id" v-model.number="(!selectedproject)?null:selectedproject.id">
                </div> 
            </div>
            <!-- <div class="form-group"> 
                <div  class="col-md-6">
                    <label class="control-label ">@lang('layout.Type') </label>
                       <select class="form-control" name="bType">
                         <option>@lang('layout.SelectType')</option>
                         <option value="item">@lang('layout.Item')</option>
                         <option value="glass">@lang('layout.Glass')</option>
                       </select>
                </div> 
            </div> -->
        </div>
          <div class="row">
            <div class="form-group">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label> 
                    <div slot="date">
                         <div class="input-group">
                            <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">  
                        </div>
                    </div> 
                    </div>
                </div>
            </div>
          </div>
    </div>
    <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
            @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
            @lang('layout.Cancel')
        </button>
    </div>
</modal>
{{Form::close()}}
</div>
<!-- app -->
<div id="app2" v-cloak>
    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="project_build_report"/>
    <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group"> 
                    <div  class="col-md-12">
                        <label class="control-label ">@lang('layout.SelectProject') </label>
                          <v-select class="vue-select2" v-model="selectedproject" label="name" @search="onProjectSearch" :options="projectList">
                        </v-select>
                        <input type="hidden" name="project_id" v-model.number="(!selectedproject)?null:selectedproject.id">
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example2" autocomplete="off" name="from_date">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example2" autocomplete="off" name="to_date">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>

        </div>
    </modal>
    {{Form::close()}}
</div>

<!-- BEGIN TAB PORTLET-->
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase"> @lang('layout.BuildList') </span>
            </div>
            <div class="tools"> </div> 
                <div class="btn-group pull-right">
                    @permission('assembly-export')
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="project_build_report"/>
                        <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}}
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="assemblylist"/>
                        <button type="submit" id="print_pdf_all" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}
                    @endpermission
                    @permission('assembly-create')
                        <a href="{{route('buildItem.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission
                </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="project_build_item">
                <thead>
                <tr>
                  <th>@lang('layout.ProjectName')</th>
                  <th>@lang('layout.Code')</th>
                  <th>@lang('layout.Description')</th>
                  <th>@lang('layout.Date')</th>
                  <th>@lang('layout.Type')</th>
                  <th>@lang('layout.Actions')</th>
                </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- END TAB PORTLET-->

<!-- END CONTENT BODY -->


@endsection
 
@push('scripts')
<script>
    Vue.component("v-select", VueSelect.VueSelect);

    $(document).ready(function () {
        $('#project_build_item').DataTable({
            ajax: '{{route("buildItem.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
            columns: [
                {data: 'name', name: 'project.name'},
                {data: 'number', name: 'project.number'},
                {data: 'description', name: 'description'},
                {data: 'date', name: 'date'},
                {data: 'type', name: 'type'},
                {data: 'actions', name: 'actions',orderable:false,searchable:false},
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


            ]

        });
    });

    // 
  
var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
        ok: function() {
            this.$emit('ok')
        }
    }
});

new Vue({
    el: '#app',
    data: {
        showModal: false,
        selectedproject:null,
        projectList:[],
    },
    methods:{
       onProjectSearch(search,loading)
         {  
             loading(true);
             this.searchProject(search,loading,this);
         },

       //ajax call to get items
       searchProject(search,loading,vm)
       {
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'anyTable',
              'search_column':'name',
              'table_name':'projects',
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.projectList=[];
             if(response.data.length>0)
             {
                vm.projectList=response.data;
                console.log('data',vm.projectList);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           })
       },
        ok:function(){
this.showModal = !this.showModal;
},
close:function(e)
{
    this.showModal = !this.showModal;
},
editExample : function(){
//Your other code that launches the modal
this.showModal= true;
this.$nextTick(function(){
    $(document).ready(function(){
        var to, from;
        to = $("#range-to-example").persianDatepicker(modelDate());
        from = $("#range-from-example").persianDatepicker(modelDate());
    });
})
}
},
})
$('#print_pdf_all').on('click',function(e){
    $('#show-modal').click();
    e.preventDefault();
})
new Vue({
    el: '#app2',
    data: {
        showModal: false,
        selectedproject:null,
        projectList:[],
    },
    methods:{
     onProjectSearch(search,loading)
       {  
           loading(true);
           this.searchProject(search,loading,this);
                   },

       //ajax call to get items
       searchProject(search,loading,vm)
       {
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'anyTable',
              'search_column':'name',
              'table_name':'projects',
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.projectList=[];
             if(response.data.length>0)
             {
                vm.projectList=response.data;
                console.log('data',vm.projectList);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           })
       },
        ok:function(){
//alert('you clicked me');
this.showModal = !this.showModal;
},

close:function(e)
{
    this.showModal = !this.showModal;
},
editExample2 : function(){
//Your other code that launches the modal
this.showModal= true;
this.$nextTick(function(){
    $(document).ready(function(){
        var to, from;
        to = $("#range-to-example2").persianDatepicker(modelDate());
        from = $("#range-from-example2").persianDatepicker(modelDate());
    });
})
}
},
})

 
$(document).ready(function(){
        var to, from;
        to = $("#range-to-example2").persianDatepicker(modelDate());
        from = $("#range-from-example2").persianDatepicker(modelDate());
    });
 
$('#excell_all').on('click',function(e){
    $('#show-modal2').click();
    e.preventDefault();
});
$("#excel_send").on('click',function(){
    $('#excel_sdate').val($("#range-from-example2").val());
    $('#excel_edate').val($("#range-to-example2").val());

});

$("#pdf_send").on('click',function(){
    $('#pdf_sdate').val($("#range-from-example2").val());
    $('#pdf_edate').val($("#range-to-example2").val());

});

</script>


@endpush
