@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">

@section('content')
    @include('itemAssemblies.modal')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">
      
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewAssembly')</span>
                    {{--<span class="caption-helper"></span>--}}
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <div class="portlet box blue"> 
                <div class="portlet-body" id="assembaly" v-cloak style="background-color:#f1f4f7">
                    {{Form::open(['route' => 'buildItem.store','method' => 'POST','class' => 'form-','id'=>'assembly-form'])}}
                    <div class="tabbable-line " >
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab_1_1_1" data-toggle="tab"><b> @lang('layout.ProjectDetails') </b></a>
                            </li>
                            <li>
                                <a href="#tab_1_1_2" data-toggle="tab"><b style="color: black,"> @lang('layout.Item') </b>  </a>
                            </li>
                            <li>
                                <a href="#tab_1_1_3" data-toggle="tab"><b style="color: red"> @lang('layout.Wastage')</b></a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1_1_1">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.Type')</label>
                                            <select class="form-control" name="type" v-model="type">
                                                <option value="glass">@lang('layout.Glass')</option>
                                                <option value="item">@lang('layout.Item')</option>
                                            </select>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.SelectProject')</label>
                                            <v-autocomplete :items="projectList" v-model="selectedProject" :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl' v-on:update-items='projectItemUpdate'
                                                            :input-attrs="{}" 
                                                            placeholder="@lang('layout.SelectItem')">
                                            </v-autocomplete>
                                            <input type="hidden" name="project" :value="(!selectedProject)?null:selectedProject.project_id">

                                            <v-select label="name" v-model="selectedProject" :options="project_items" @search="onItemsSearch"></v-select> 
                                            <input type="hidden" name="project" :value="(!selectedProject)?null:selectedProject.project_id">
                                        </div>
                                    </div> 
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                            <input class="form-control" id="date" name="date" autocomplete="off" value="{{$projectBuild->date}}">
                                        </div>
                                    </div>
                                     <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">@lang('layout.Description') </label>
                                            <textarea  name="gDescription" class="form-control" rows="3">
                                                {{$projectBuild->description}}
                                            </textarea>
                                        </div>
                                    </div> 
                                </div>
                                <div v-if="selectedProject && type=='item' "> 
                                    <table id="table_content" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.StuffDetails')</th>
                                            <th>@lang('layout.Width')</th>
                                            <th>@lang('layout.Height')</th>
                                            <th>@lang('layout.QuantityForBuild')</th>
                                            <th>@lang('layout.QuantityToBuild')</th>
                                            <th>@lang('layout.Measure')</th> 
                                        </tr>
                                        </thead>
                                        <tbody> 
                                            <tr v-for="(row ,index1) in (!selectedProject)?null && (type=='item'):selectedProject.projectItemDetails"> 
                                                <td>
                                                    @{{ row.Item }}
                                                </td>
                                                <td>
                                                    @{{ row.width }}
                                                </td>
                                                <td>
                                                    @{{ row.height }}
                                                </td>
                                                <td> 
                                                    <input type="number" name="quantity[]" v-model="row.qty"  class="form-control">
                                                    <input type="hidden" name="detail_id[]" :value="row.detail_id" class="form-control">
                                                    
                                                </td>
                                                <td class=" no-padding">
                                                    @{{ row.quantity-row.qty}}
                                                    <input name="rQty[]" type="hidden"  :value="row.quantity-row.qty">
                                                </td>
                                                <td class=" no-padding">
                                                     
                                                    @{{ row.um }}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div v-if="selectedProject && type=='glass' "> 
                                    <table id="table_content" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.GlassDetails')</th>
                                            <th>@lang('layout.Width')</th>
                                            <th>@lang('layout.Height')</th>
                                            <th>@lang('layout.QuantityForBuild')</th>
                                            <th>@lang('layout.QuantityToBuild')</th>
                                            <th>@lang('layout.Measure')</th> 
                                        </tr>
                                        </thead>
                                        <tbody> 
                                            <tr v-for="(row ,index1) in (!selectedProject)?null:selectedProject.glass"> 
                                                <td>
                                                    @{{ row.item }}
                                                </td>
                                                <td>
                                                    @{{ row.width }}
                                                </td>
                                                <td>
                                                    @{{ row.height }}
                                                </td>
                                                <td> 
                                                    <input type="number" name="quantity[]" v-model="row.gQty"  class="form-control">
                                                    <input type="hidden" name="detail_id[]" :value="row.detail_id" class="form-control"> 
                                                </td>
                                                <td class=" no-padding">
                                                    @{{ row.qty-row.gQty}} 
                                                </td>
                                                <td class=" no-padding"> 
                                                    @{{ row.um }}
                                                </td> 
                                                <td class=" no-padding">
                                                    @{{ row.description }}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_1_2">
                            <div v-if="selectedProject && type=='item' "> 
                                <table id="table_content" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Item')</th>
                                            <th>@lang('layout.Site')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.OnHand')</th>
                                            <th>@lang('layout.Description')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(row ,index1) in (!selectedProject)?null:selectedProject.projectItem"> 
                                            <td>
                                                @{{ row.name }}
                                            </td>
                                            
                                            <td>
                                                @{{ row.site_name }}
                                            </td> 
                                            <td class=" no-padding">
                                                @{{ row.measure }}
                                            </td>
                                            <td class=" no-padding">
                                                <input type="number" class="form-control" v-model="row.itemQty" name="itemQty[]">
                                                <input type="hidden" name="item_id[]" :value="row.inv_id" class="form-control">

                                            </td> 
                                                <input type="hidden" name="p_stock_id[]" :value="row.p_stock_id">
                                            <td>
                                                @{{ row.quantity-row.itemQty }}
                                            </td> 
                                            <td>
                                                @{{ row.description }}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div v-if="selectedProject && type=='glass' "> 
                                <table id="table_content" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Item')</th>
                                            <th>@lang('layout.Site')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.OnHand')</th>
                                            <th>@lang('layout.Description')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(row ,index1) in (!selectedProject)?null:selectedProject.projectGlassItem"> 
                                            <td>
                                                @{{ row.name }}
                                            </td>
                                            
                                            <td>
                                                @{{ row.site_name }}
                                            </td> 
                                            <td class=" no-padding">
                                                @{{ row.measure }}
                                            </td>
                                            <td class=" no-padding">
                                                <input type="number" class="form-control" v-model="row.itemQty" name="itemQty[]">
                                                <input type="hidden" name="item_id[]" :value="row.inv_id" class="form-control">

                                            </td> 
                                                <input type="hidden" name="p_stock_id[]" :value="row.p_stock_id">
                                            <td>
                                                @{{ row.quantity-row.itemQty }}
                                            </td> 
                                            <td>
                                                @{{ row.description }}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <!-- Itemmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm -->
                           <!--  <div v-if=" selectedProject && selectedProject.projectItem && inventories.length >0" class="">
                                <table id="table_content" class="table table-bordered table-striped">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width: 25px;"> # </th>
                                        <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                        <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName')  </th>
                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Description')</th>
                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                        <th class="text-center" style="min-width: 50px;"> @lang('layout.OnHand')</th>
                                        <th style="width: 20px;"></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(inventory,InventoryIndex) in inventories" class="even">
                                        <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                        </td>
                                        <td class="td_one">
                                            <v-autocomplete :items="inventory.items" v-model="inventory.item" :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl' v-on:update-items='update'
                                                            :input-attrs="{}"
                                                            @focus="setFocus(InventoryIndex)"
                                                            placeholder="@lang('layout.SelectItem')"
                                                            style="min-width: 220px  ;">
                                            </v-autocomplete>
                                            <input type="hidden" name="inventory_id[]" :value="(!inventory.item)?null:inventory.item.id">
                                        </td>
                                        <td>
                                            <select  class="form-control input_style"
                                                     placeholder="@lang('layout.Quantity')"
                                                     v-model="!inventory.item?null:inventory.item.site"
                                                    required="required">

                                                <option v-if="inventory.item"
                                                        v-for="sites in (!inventory.item?null:inventory.item.siteList)"
                                                        :value="sites">@{{sites.site_name}}
                                                </option>
                                            </select>
                                            <input type="hidden" name="site_id[]" :value="(!inventory.item)?null:(inventory.item.site)?inventory.item.site.site_id:null">
                                        </td>
                                        <td>
                                            <input name="description[]" class="form-control inpu-number-fild"  :class="" type="text" placeholder="@lang('layout.Description')" />
                                        </td>
                                        <td>
                                            <select  class="form-control input_style"
                                                     placeholder="Measure"
                                                     v-model="!inventory.item?null:inventory.item.measure"
                                                     required="required">

                                                <option v-if="inventory.item"
                                                        v-for="measures in (!inventory.item?null:inventory.item.measureList)"
                                                        :value="measures">@{{ measures.measure_name }}</option>
                                            </select>

                                            <input type="hidden" name="inventory_measure[]" :value="(!inventory.item)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                                        </td>
                                        <td>
                                            <input name="inventory_qty[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!inventory.item)?null:inventory.item.qty" placeholder="@lang('layout.Quantity')" />
                                        </td>
                                         <td>
                                            <input class="form-control spinner input_style" type="number" :value="(!inventory.item)?null:(!inventory.item.site)?null:((inventory.item.site.OnHand * inventory.item.measure_unit/inventory.item.measure.measure_unit).toFixed(2)) - inventory.item.qty " placeholder="@lang('layout.OnHand')" disabled/>
                                        </td>
                                        <td>
                                            <span  v-on:click="deleteItem(InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                        </td>
                                    </tr> 
                                    </tbody>
                                </table> 
                            </div> -->
                            <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addInventory">@lang('layout.AddItem')
                            </button>    
                               
                            </div>
                            <!-- Other buildddddddddddddddddddddddddddddddddddddd -->
                            <!-- <div class="tab-pane" id="tab_1_1_3"> 
                                <div v-if="otherBuild.length >0 && selectedProject" class="">
                                    <label class="control-label">@lang('layout.Usable')
                                        <span style="color:rgb(22, 177, 193)"  class="fa fa-check-square"></span>
                                        <span></span>
                                    </label>
                                    <table id="table_content" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th class="text-center" style="width: 25px;"> # </th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.SiteName')</th>
                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                            <th style="width: 20px;"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(inventory1,InventoryIndex) in otherBuild" class="even">
                                            <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                            </td>
                                            <td class="td_one">
                                                <v-autocomplete :items="inventory1.items" v-model="inventory1.item" :get-label='getLabel'
                                                                :min-len='0'
                                                                :component-item='tpl' v-on:update-items='otherBuildUpdate'
                                                                :input-attrs="{}"
                                                                @focus="setOtherBuild(InventoryIndex)"
                                                                placeholder="@lang('layout.SelectItem')"
                                                                style="min-width: 220px  ;">
                                                </v-autocomplete>
                                                <input type="hidden" name="other_build_id[]" :value="(!inventory1.item)?null:inventory1.item.id">
                                            </td>
                                            <td>
                                            <select  class="form-control input_style"
                                                     placeholder="@lang('layout.Quantity')"
                                                     v-model="!inventory1.item?null:inventory1.item.site"
                                                    required="required">

                                                <option v-if="inventory1.item"
                                                        v-for="sites in (!inventory1.item?null:inventory1.item.siteList)"
                                                        :value="sites">@{{sites.site_name}}
                                                </option>
                                            </select>
                                            <input type="hidden" name="Usite_id[]" :value="(!inventory1.item)?null:(inventory1.item.site)?inventory1.item.site.site_id:null">
                                        </td>
                                            <td>
                                                <select  class="form-control input_style"
                                                         placeholder="Measure"
                                                         v-model="!inventory1.item?null:inventory1.item.measure"
                                                         required="required">

                                                    <option v-if="inventory1.item"
                                                            v-for="measures in (!inventory1.item?null:inventory1.item.measureList)"
                                                            :value="measures">@{{ measures.measure_name }}</option>
                                                </select>
                                                <input type="hidden" name="other_build_measure[]" :value="(!inventory1.item)?null:(inventory1.item.measure)?inventory1.item.measure.measure_id:null">
                                            </td>
                                            <td >
                                                <input name="other_build_qty[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!inventory1.item)?null:inventory1.item.qty" placeholder="@lang('layout.Quantity')" />
                                            </td>
                                            <td>
                                                <span  v-on:click="deleteOtherBuild(InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                  <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addOtherBuild">@lang('layout.AddItem')
                                    </button>
<!-- 
                                <div v-if="otherBuild1.length >0 && selectedProject" class="">
                                    <label class="control-label">@lang('layout.UnUsable')
                                        <span style="color:red" class="fa fa-trash"></span>
                                    </label>
                                    <table id="table_content" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th class="text-center" style="width: 25px;"> # </th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.SiteName')</th>
                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                            <th style="width: 20px;"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(inventory,InventoryIndex1) in otherBuild1" class="even">
                                            <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex1+1}} </span>
                                            </td>
                                            <td class="td_one">
                                                <v-autocomplete :items="inventory.items" v-model="inventory.item" :get-label='getLabel'
                                                                :min-len='0'
                                                                :component-item='tpl' v-on:update-items='otherBuildUpdate1'
                                                                :input-attrs="{}"
                                                                @focus="setOtherBuild1(InventoryIndex1)"
                                                                placeholder="@lang('layout.SelectItem')"
                                                                style="min-width: 220px  ;">
                                                </v-autocomplete>
                                                <input type="hidden" name="other_build_idUn[]" :value="(!inventory.item)?null:inventory.item.id">
                                            </td>
                                            <td>
                                                <select  class="form-control input_style"
                                                     placeholder="@lang('layout.Quantity')"
                                                     v-model="!inventory.item?null:inventory.item.site"
                                                    required="required">

                                                <option v-if="inventory.item"
                                                        v-for="sites in (!inventory.item?null:inventory.item.siteList)"
                                                        :value="sites">@{{sites.site_name}}
                                                </option>
                                                </select>
                                                <input type="hidden" name="Unsite_id[]" :value="(!inventory.item)?null:(inventory.item.site)?inventory.item.site.site_id:null">
                                            </td>

                                            <td>
                                                <select  class="form-control input_style"
                                                         placeholder="Measure"
                                                         v-model="!inventory.item?null:inventory.item.measure"
                                                         required="required">
                                                    <option v-if="inventory.item"
                                                            v-for="measures in (!inventory.item?null:inventory.item.measureList)"
                                                            :value="measures">@{{ measures.measure_name }}</option>
                                                </select>

                                                <input type="hidden" name="other_build_measureUn[]" :value="(!inventory.item)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null"> 
                                            </td>
                                            <td >
                                                <input name="other_build_qtyUn[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!inventory.item)?null:inventory.item.qty" placeholder="@lang('layout.Quantity')" />
                                            </td>
                                            <td>
                                                <span  v-on:click="deleteOtherBuild1(InventoryIndex1)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                            </td>
                                        </tr>

                                        </tbody>
                                    </table>

                                </div> -->
                                 <button v-if="otherBuild1.length <= 0 " type="button" class="btn default" @click="addOtherBuild1">@lang('layout.AddItem')
                                </button>
                            </div> -->
                             

                        </div>
                    </div>
                    <div class="tabbable-custom tabs-below nav-justified" >
                        <div class="tab-content" >
                           <div class="row" >
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="button" class="btn green" onclick="regForm(this)" :disabled="!checkQty">@lang('layout.Submit')</button>
                                    <a href="{{route('assembly.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                {{Form::close()}}
            </div>
            
            <!-- END FORM-->
        </div>
    </div>
   
@endsection
@push('scripts')
 
<script>
     
    var ProjectAll         = {!! $project!!};
    var projectBuildItems  = {!! $projectGlasses !!};
    var projectWestages    = {!! $projectWestages !!};
    var projectItems       = {!! $projectItems !!};
    var sales = new Vue({
        el:'#assembaly',
        data:{
            checkedShowModel:false,
            inventories: [
                {
                    items: [],
                    item: null,
                },
                {
                    items: [],
                    item: null,
                },
                
            ],
            otherBuild: [],  
            otherBuild1: [],
            project_items: [],
            otherBuildIndex:0,
            type:"{{$projectBuild->type}}",
            otherBuildIndex1:0,
            inventoryIndex:0,
            inventoryList:InventoryAll, 
            inventoryList1:InventoryAll, 
            projectList:ProjectAll,
            inventoryItem   :null,
            selectedProject :null,
            tpl:temp,
            projectBuildItems :projectBuildItems,
            projectWestages   :projectWestages,
            projectItems      :projectItems,

        },
        created(){
           
        },
        computed:{  
            checkQty:function(){
                    var c = true;
                    for(var s =0; s<this.inventories.length;s++){
                        if(this.inventories[s].item){                            
                            var dq = ((this.inventories[s].item.site.OnHand * this.inventories[s].item.measure_unit)/this.inventories[s].item.measure.measure_unit).toFixed(2) - this.inventories[s].item.qty
                            if( dq < 0 ){
                                c = false;
                                break;
                            }
                        }
                    }
                    if(this.selectedProject)
                    {
                        for(var x =0; x<this.selectedProject.projectItemDetails.length; x++)
                        {
                            var qty =(this.selectedProject.projectItemDetails[x].qty);
                            var quantity =(this.selectedProject.projectItemDetails[x].quantity);
                            if(qty>quantity)
                            {
                                c=false;
                                break;
                            }
                        }
                        for(var i =0; i<this.selectedProject.projectItem.length; i++)
                        {
                            var qty =(this.selectedProject.projectItem[i].itemQty);
                            var quantity =(this.selectedProject.projectItem[i].quantity);
                            if(qty>quantity)
                            {
                                c=false;
                                break;
                            }
                        } 
                        for(var i =0; i<this.selectedProject.projectGlassItem.length; i++)
                        {
                            var qty =(this.selectedProject.projectGlassItem[i].itemQty);
                            var quantity =(this.selectedProject.projectGlassItem[i].quantity);
                            if(qty>quantity)
                            {
                                c=false;
                                break;
                            }
                        } 
                        for(var i =0; i<this.selectedProject.glass.length; i++)
                        {
                            var qty =(this.selectedProject.glass[i].gQty);
                            var quantity =(this.selectedProject.glass[i].qty);
                            if(qty>quantity)
                            {
                                c=false;
                                break;
                            }
                        }

                    }
                    return c;
                },
                
        },
        mounted:function(){ 
          // initialize the selected item
          for(var i=0;i<this.selected_item.length;i++)
          {
            this.inventories.push({item:this.selected_item[i]});
          }
          for(var m=4;m>this.selected_item.length;m--)
          {
            this.inventories.push({item:null});
          }  
        },
        methods:{
        // Search Project 
        onItemsSearch(search,loading)
        {   
          this.project_items=[];
           loading(true);
           this.itemsSearch(search,loading,this);
        },
        itemsSearch(search,loading,vm)
        {
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'serarchProject',  
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.project_items=[];
             if(response.data.length>0)
            {
                vm.project_items=response.data;
                console.log('data',vm.project_items);
            }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           })
       },
    }
});



</script>


@endpush