@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet">
    
@stop

@section('content') 
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">
       
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewBuild') </span>
                    
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <div class="portlet box blue"> 
                <div class="portlet-body" id="assembaly" v-cloak style="background-color:#f1f4f7">
                    {{Form::open(['route' => 'buildItem.store','method' => 'POST','class' => 'form-','id'=>'assembly-form'])}}
                    <div class="tabbable-line " >
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab_1_1_1" data-toggle="tab"><b> @lang('layout.ProjectDetails') </b></a>
                            </li>
                            <li>
                                <a href="#tab_1_1_2" data-toggle="tab"><b style="color: black,"> @lang('layout.Item') </b>  </a>
                            </li>
                            <li>
                                <a href="#tab_1_1_3" data-toggle="tab"><b style="color: red"> @lang('layout.Wastage')</b></a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1_1_1">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.Type')</label>
                                            <select class="form-control" name="type" v-model="type">
                                                <option value="glass">@lang('layout.Glass')</option>
                                                <option value="item">@lang('layout.Item')</option>
                                            </select> 
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.SelectProject')</label> 
                                            <v-select label="name" v-model="selectedProject" :options="project_items" @search="onItemsSearch"></v-select> 
                                            <input type="hidden" name="project" :value="(!selectedProject)?null:selectedProject.project_id">
                                        </div>
                                    </div> 
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                            <input class="form-control date" name="date" autocomplete="off" value="">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">@lang('layout.Description') </label>
                                            <textarea  name="gDescription" class="form-control" rows="3">
                                            </textarea>
                                        </div>
                                    </div> 
                                </div>
                                <div v-if="selectedProject && type=='item' "> 
                                    <table id="table_content" class="table table-bordered ">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.StuffDetails')</th>
                                            <th>@lang('layout.Width')</th>
                                            <th>@lang('layout.Height')</th>
                                            <th>@lang('layout.QuantityForBuild')</th>
                                            <th>@lang('layout.QuantityToBuild')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.Metrazh')</th>
                                        </tr>
                                        </thead>
                                        <tbody> 
                                            <tr v-for="(row ,index1) in (!selectedProject)?null && (type=='item'):selectedProject.projectItemDetails"> 
                                                <td>
                                                    @{{ row.Item }}
                                                </td>
                                                <td>
                                                    @{{ row.width }}
                                                </td>
                                                <td>
                                                    @{{ row.height }}
                                                </td>
                                                <td> 
                                                    <input type="number" name="quantity[]" v-model="row.qty"  class="form-control">
                                                    <input type="hidden" name="detail_id[]" :value="row.detail_id" class="form-control"> 
                                                </td>
                                                <td class=" no-padding">
                                                    @{{ row.quantity-row.qty}}
                                                    <input name="rQty[]" type="hidden"  :value="row.quantity-row.qty">
                                                </td>
                                                <td class=" no-padding"> 
                                                    @{{ row.um }}
                                                </td>
                                                <td class=" no-padding"> 
                                                    @{{ row.metrazh }}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div v-if="selectedProject && type=='glass' "> 
                                    <table id="table_content" class="table table-bordered ">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.GlassDetails')</th>
                                            <th>@lang('layout.Width')</th>
                                            <th>@lang('layout.Height')</th>
                                            <th>@lang('layout.QuantityForBuild')</th>
                                            <th>@lang('layout.QuantityToBuild')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.Description')</th>
                                        </tr>
                                        </thead>
                                        <tbody> 
                                            <tr v-for="(row ,index1) in (!selectedProject)?null:selectedProject.glass"> 
                                                <td>
                                                    @{{ row.item }}
                                                </td>
                                                <td>
                                                    @{{ row.width }}
                                                </td>
                                                <td>
                                                    @{{ row.height }}
                                                </td>
                                                <td> 
                                                    <input type="number" name="quantity[]" v-model="row.gQty"  class="form-control">
                                                    <input type="hidden" name="detail_id[]" :value="row.detail_id" class="form-control"> 
                                                </td>
                                                <td class=" no-padding">
                                                    @{{ row.qty-row.gQty}} 
                                                </td>
                                                <td class=" no-padding">
                                                     
                                                    @{{ row.um }}
                                                </td>
                                                
                                                <td class=" no-padding">
                                                    @{{ row.description }}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_1_2">
                            <div v-if="selectedProject && type=='item' "> 
                                <table id="table_content" class="table table-bordered ">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.Item')</th>
                                                <th>@lang('layout.Site')</th>
                                                <th>@lang('layout.Measure')</th>
                                                <th>@lang('layout.Quantity')</th>
                                                <th>@lang('layout.OnHand')</th>
                                                <th>@lang('layout.Description')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="(row ,index1) in (!selectedProject)?null:selectedProject.projectItem"> 
                                                <td>
                                                    @{{ row.name }}
                                                </td>
                                                
                                                <td>
                                                    @{{ row.site_name }}
                                                </td> 
                                                <td class=" no-padding">
                                                    @{{ row.measure }}
                                                </td>
                                                <td class=" no-padding">
                                                    <input type="number" class="form-control" v-model="row.itemQty" name="itemQty[]">
                                                    <input type="hidden" name="item_id[]" :value="row.inv_id" class="form-control">

                                                </td> 
                                                    <input type="hidden" name="inventory_id[]" :value="row.inventory_id">
                                                    <input type="hidden" name="site_id[]" :value="row.site_id">
                                                <td>
                                                    @{{ row.quantity-row.itemQty }}
                                                </td> 
                                                <td>
                                                    @{{ row.description }}
                                                </td>
                                            </tr>
                                        </tbody>
                                </table>
                            </div>
                            <div v-if="selectedProject && type=='glass' "> 
                                <table id="table_content" class="table table-bordered ">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.Item')</th>
                                                <th>@lang('layout.Site')</th>
                                                <th>@lang('layout.Measure')</th>
                                                <th>@lang('layout.Quantity')</th>
                                                <th>@lang('layout.OnHand')</th>
                                                <th>@lang('layout.Description')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="(row ,index1) in (!selectedProject)?null:selectedProject.projectGlassItem"> 
                                                <td>
                                                    @{{ row.name }}
                                                </td>
                                                
                                                <td>
                                                    @{{ row.site_name }}
                                                </td> 
                                                <td class=" no-padding">
                                                    @{{ row.measure }}
                                                </td>
                                                <td class=" no-padding">
                                                    <input type="number" class="form-control" v-model="row.itemQty" name="itemQty[]">
                                                    <input type="hidden" name="item_id[]" :value="row.inv_id" class="form-control">
                                                </td> 
                                                    <input type="hidden" name="inventory_id[]" :value="row.inventory_id">
                                                <td>
                                                    @{{ row.quantity-row.itemQty }}
                                                </td> 
                                                <td>
                                                    @{{ row.description }}
                                                </td>
                                            </tr>
                                        </tbody>
                                </table>
                            </div> 
                            </div>
                            <div class="tab-pane" id="tab_1_1_3"> 
                                <div v-if="otherBuild.length >0 && selectedProject" class="">
                                    <label class="control-label">@lang('layout.Usable')
                                        <span style="color:rgb(22, 177, 193)"  class="fa fa-check-square"></span>
                                        <span></span>
                                    </label>
                                    <div class="col-md-2">
                                       <div class="form-group">
                                            <select class="form-control" name="category" v-model="uCategory">
                                                <option>@lang('layout.SelectCategory')</option>
                                                <option value="withMetrazh">@lang('layout.WithMetrazh')</option>
                                                <option value="withoutMetrazh">@lang('layout.WithoutMetrazh')</option>
                                                 
                                            </select>
                                       </div>
                                    </div>
                                    <table id="table_content" class="table table-bordered ">
                                        <thead>
                                        <tr>
                                            <th class="text-center" style="width: 25px;"> # </th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.SiteName')</th>
                                            <th v-if="uCategory=='withMetrazh'" class="text-center" style="min-width: 160px;">@lang('layout.Height')</th>
                                                <th v-if="uCategory=='withMetrazh'" class="text-center" style="min-width: 160px;">@lang('layout.Width')</th> 
                                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                            <th style="width: 20px;"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(inventory1,otherBuildIndex) in otherBuild" class="even">
                                            <td class="highlight"> <span class="badge badge3 badge-success badge-roundless"> @{{otherBuildIndex+1}} </span>
                                            </td>
                                            <td class="highlight"> 
                                                <v-select label="name" v-model="inventory1.item" :options="otherBuild_temp" @click.native="addNew('otherBuilds',otherBuildIndex)" @search="westageItemsSearch"> 
                                                </v-select>
                                                <input type="hidden" name="other_build_id[]" :value="(inventory1.item==null)?null:inventory1.item.id">
                                            </td>
                                            <td> 
                                                <select v-model="(inventory1.item==null)?null:inventory1.item.site" class="form-control">
                                                   <option value="null">@lang('layout.Select')</option>
                                                   <span v-if="(inventory1.item != null)">
                                                    <option v-for="site in (inventory1.item==null)?null:inventory1.item.site_list" :value="site">
                                                      @{{site.site_name}}
                                                    </option> 
                                                  </span>
                                                </select>      
                                                <input type="hidden" name="Usite_id[]" :value="(inventory1.item==null)?null:((inventory1.item.site==null)?null:inventory1.item.site.site_id)">
                                            </td>
                                            <td v-if="uCategory=='withMetrazh'">
                                            <input name="uHeight[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!inventory1.item)?null:inventory1.item.height" placeholder="@lang('layout.Height')" />
                                            </td>
                                            <td v-if="uCategory=='withMetrazh'">
                                                <input name="uWidth[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!inventory1.item)?null:inventory1.item.width" placeholder="@lang('layout.Width')" />
                                            </td>
                                            <td>
                                            <input name="other_build_qty[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!inventory1.item)?null:inventory1.item.qty" placeholder="@lang('layout.Quantity')" />
                                            </td>
                                            <td> 
                                            <select v-if="(inventory1.item !=null)" v-model="(inventory1.item == null)?null:inventory1.item.measure"   class="form-control input_style"
                                             placeholder="Measure" 
                                             required="required"> 
                                               <span v-if="inventory1.item.measure_list !=null">
                                                    <option v-if="(inventory1.item !=null)"
                                                        v-for="measures in inventory1.item.measure_list"
                                                        :value="measures">@{{ measures.measure_name }}</option>
                                               </span>
                                            </select> 
                                            <input type="hidden" name="other_build_measure[]" :value="(inventory1.item==null)?null:(inventory1.item.measure)?inventory1.item.measure.measure_id:null">
                                        </td>
                                        
                                            <td>
                                                <span  v-on:click="deleteItem('otherBuild', otherBuildIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                  <button v-if="otherBuild.length <= 0 " type="button" class="btn default"@click="addItems('otherBuild')">@lang('layout.AddItem')
                                    </button>

                                <div v-if="otherBuild1.length >0 && selectedProject" class="">
                                    <div class="col-md-2">
                                        <select class="form-control" name="category" v-model="unCategory">
                                            <option>@lang('layout.SelectCategory')</option>
                                            <option value="withMetrazh">@lang('layout.WithMetrazh')</option>
                                            <option value="withoutMetrazh">@lang('layout.WithoutMetrazh')</option>
                                        </select>
                                    </div>
                                    <label class="control-label">@lang('layout.UnUsable')
                                        <span style="color:red" class="fa fa-trash"></span>
                                    </label> 
                                   
                                    <table id="table_content" class="table table-bordered ">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 25px;"> # </th>
                                                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                                <th class="text-center" style="min-width: 160px;">@lang('layout.SiteName')</th>
                                                <th v-if="unCategory=='withMetrazh'" class="text-center" style="min-width: 160px;">@lang('layout.Height')</th>
                                                <th v-if="unCategory=='withMetrazh'" class="text-center" style="min-width: 160px;">@lang('layout.Width')</th>

                                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                                <th style="width: 20px;"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="(otherBuild,otherBuildIndex1) in otherBuild1" class="even">
                                                <td class="highlight"> <span class="badge badge3 badge-success badge-roundless"> @{{otherBuildIndex1+1}} </span>
                                                </td>
                                                <td class="highlight"> 
                                                    <v-select label="name" v-model="otherBuild.item" :options="unOtherBuild_temp" @click.native="addNew('otherBuild1',otherBuildIndex1)" @search="unWestageItemsSearch"> 
                                                    </v-select>
                                                    <input type="hidden" name="other_build_idUn[]" :value="(otherBuild.item==null)?null:otherBuild.item.id">
                                                </td>
                                                <td> 
                                                    <select v-model="(otherBuild.item==null)?null:otherBuild.item.site" class="form-control">
                                                       <option value="null">@lang('layout.Select')</option>
                                                       <span v-if="(otherBuild.item != null)">
                                                        <option v-for="site in (otherBuild.item==null)?null:otherBuild.item.site_list" :value="site">
                                                          @{{site.site_name}}
                                                        </option> 
                                                      </span>
                                                    </select>      
                                                    <input type="hidden" name="Unsite_id[]" :value="(otherBuild.item==null)?null:((otherBuild.item.site==null)?null:otherBuild.item.site.site_id)"> 
                                                </td>
                                                <td v-if="unCategory=='withMetrazh'">
                                                    <input name="height[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!otherBuild.item)?null:otherBuild.item.height" placeholder="@lang('layout.Height')" />
                                                </td>
                                                <td v-if="unCategory=='withMetrazh'">
                                                    <input name="width[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!otherBuild.item)?null:otherBuild.item.width" placeholder="@lang('layout.Width')" />
                                                </td>
                                                <td>
                                                    <input name="unUsedQty[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!otherBuild.item)?null:otherBuild.item.qty" placeholder="@lang('layout.Quantity')" />
                                                </td>
                                                <td> 
                                                    <select v-if="(otherBuild.item !=null)" v-model="(otherBuild.item == null)?null:otherBuild.item.measure"   class="form-control input_style"
                                                     placeholder="Measure" 
                                                     required="required"> 
                                                       <span v-if="otherBuild.item.measure_list !=null">
                                                            <option v-if="(otherBuild.item !=null)"
                                                                v-for="measures in otherBuild.item.measure_list"
                                                                :value="measures">@{{ measures.measure_name }}</option>
                                                       </span>
                                                    </select> 
                                                    <input type="hidden" name="Unother_build_measure[]" :value="(otherBuild.item==null)?null:(otherBuild.item.measure)?otherBuild.item.measure.measure_id:null">
                                                </td>
                                                
                                                <td>
                                                    <span  v-on:click="deleteItem('otherBuild1',otherBuildIndex1)"><i class="paddint-both glyphicon glyphicon-trash"></i></span> 
                                                </td>
                                            </tr> 
                                        </tbody>
                                    </table>

                                </div>
                                 <button v-if="otherBuild1.length <= 0 " type="button" class="btn default" @click="addItems('otherBuild1',otherBuildIndex1)">@lang('layout.AddItem')
                                </button>
                            </div>
                             

                        </div>
                    </div>
                    <div class="tabbable-custom tabs-below nav-justified" >
                        <div class="tab-content" >
                           <div class="row" >
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="button" class="btn green" onclick="regForm(this)" :disabled="!checkQty">@lang('layout.Submit')</button>
                                    <a href="{{route('assembly.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                {{Form::close()}}
            </div>
            
            <!-- END FORM-->
        </div>
    </div>
  
@endsection
@push('scripts')
 


<script> 
     Vue.component('v-select', VueSelect.VueSelect); 
  
    var sales = new Vue({
        el:'#assembaly',
        data:{
            checkedShowModel:false,
            project_items:[],
            uCategory:'withoutMetrazh',
            unCategory:'withoutMetrazh',
            temp_items:[],
            otherBuild_temp:[],
            unOtherBuild_temp:[],

            inventories: [
                {
                    items: [],
                    item: null,
                },
                {
                    items: [],
                    item: null,
                },
                
            ],
            otherBuild: [
                {
                    items: [],
                    item: null,
                },
                {
                    items: [],
                    item: null,
                },
                 
            ],  
            otherBuild1: [
                {
                    items: [],
                    item: null,
                },
                {
                    items: [],
                    item: null,
                },
                 
            ],
            otherBuildIndex:0,
            type:null,
            otherBuildIndex1:0,
            inventoryIndex:0,
            inventoryItem   :null,
            selectedProject :null,
        },

        computed:{  
            checkQty:function(){
                    var c = true;
                   
                    if(this.selectedProject)
                    {
                        if(this.type=='item')
                        {
                            for(var x =0; x<this.selectedProject.projectItemDetails.length; x++)
                            {
                                var qty =(this.selectedProject.projectItemDetails[x].qty);
                                var quantity =(this.selectedProject.projectItemDetails[x].quantity);
                                if(qty>quantity)
                                {
                                    c=false;
                                    break;
                                }
                            }
                            for(var i =0; i<this.selectedProject.projectItem.length; i++)
                            {
                                var qty =(this.selectedProject.projectItem[i].itemQty);
                                var quantity =(this.selectedProject.projectItem[i].quantity);
                                if(qty>quantity)
                                {
                                    c=false;
                                    break;
                                }
                            } 
                        }
                        if(this.type=='glass')
                        { 
                            for(var i =0; i<this.selectedProject.projectGlassItem.length; i++)
                            {
                                var qty =(this.selectedProject.projectGlassItem[i].itemQty);
                                var quantity =(this.selectedProject.projectGlassItem[i].quantity);
                                if(qty>quantity)
                                {
                                    c=false;
                                    break;
                                }
                            } 
                            for(var i =0; i<this.selectedProject.glass.length; i++)
                            {
                                var qty =(this.selectedProject.glass[i].gQty);
                                var quantity =(this.selectedProject.glass[i].qty);
                                if(qty>quantity)
                                {
                                    c=false;
                                    break;
                                }
                            }
                        }
                    }
                    return c;
                },
                
        },
        methods:{
        // Search Project 
      
        onItemsSearch:_.debounce((search,loading)=>{
           sales.project_items=[];
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'serarchProject',  
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.project_items=[];
             if(response.data.length>0)
             {
                sales.project_items=response.data;
                console.log('test 22',sales.project_items);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
        },getDebounceTime()),
     
       // end item search
     
       //ajax call to get items
       onItemSearch:_.debounce((search,loading)=>{
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'otherBuildSearch',
              keyword:search,
            }
           })
           .then(function (response)
           {
             sales.temp_items=[];
             if(response.data.length>0)
             {
                sales.temp_items=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
       },getDebounceTime()),
     
       // Wastage Item serach 
   
       westageItemsSearch:_.debounce((search,loading)=>{
            sales.otherBuild_temp=[];
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'otherBuildSearch',
              'type':'assembaly',
              keyword:search,
            }
           })
           .then(function (response)
           {
             if(response.data.length>0)
             {
                sales.otherBuild_temp=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
       },getDebounceTime()),
  
  
       unWestageItemsSearch:_.debounce((search,loading)=>{
           sales.unOtherBuild_temp=[];
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'otherBuildSearch',
              'type':'assembaly',
              keyword:search,
            }
           })
           .then(function (response)
           {
             if(response.data.length>0)
             {
                sales.unOtherBuild_temp=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
       },getDebounceTime()),
    
// generic function for adding item to list
       addNew(type=null,index)
       {
          this.temp_items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null});
                }
             }  
             if(type=='otherBuilds')
             {
                if(this.otherBuild[index+1]==undefined)
                {
                  this.otherBuild_temp=[];
                  this.otherBuild.push({item:null});
                }
             } 
             if(type=='otherBuild1')
             {
                if(this.otherBuild1[index+1]==undefined)
                {
                  this.otherBuild_temp =[];
                  this.otherBuild1.push({item:null});
                }
             } 
          } 
       },
       addItems(type)
       { 
            if(type !=null)
            {
                if(type=="inventory")
                { 
                    this.temp_items=[];
                   this.inventories.push({item:null}); 
                }  
                if(type=="otherBuild")
                { 
                    this.otherBuild_temp=[];
                   this.otherBuild.push({item:null}); 
                }  
                if(type=="otherBuild1")
                { 
                    this.otherBuild_temp=[];
                   this.otherBuild1.push({item:null}); 
                }  
            }     
        },
        deleteItem(type=null,index)
       {
        if(type !=null)
            { 
                if(type=='inventory')
                {
                   this.inventories.splice(index, 1);
                } 
                if(type=='otherBuild')
                {
                   this.otherBuild.splice(index, 1);
                }
                if(type=='otherBuild1')
                {
                   this.otherBuild1.splice(index, 1);
                } 
           }
          
       },
 
             

 

        }
    });



</script>


@endpush