@extends('layouts.app')

@section('content')
@include('buildDetails.modal')
    <div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="build_details_with_recipe"/>
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group"> 
                  
            </div>
        </div>
        <div class="row">
            <div class="form-group">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                            
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example" name="to_date">
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
            @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
            @lang('layout.Cancel')
        </button>
    </div>
</modal>
{{Form::close()}}
</div>

<div id="app2" v-cloak>
    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="build_details_with_recipe"/>
    <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group">

                    

            </div>
        </div>
        <div class="row">
            <div class="form-group">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example2" name="from_date">
                            
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example2" name="to_date">
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
            @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
            @lang('layout.Cancel')
        </button>
    </div>
</modal>
{{Form::close()}}
</div>

    <!-- BEGIN TAB PORTLET-->
<div class="row">
  <!-- BEGIN EXAMPLE TABLE PORTLET-->
  <div class="portlet light bordered">
    <div class="portlet-title">
      <div class="caption font-dark">
        <i class="icon-settings font-dark"></i>
        <span class="caption-subject bold uppercase">  @lang('layout.BuildDetailList')  </span>
      </div>
      <div class="tools"> </div>
      <div class=" pull-right">
                <!-- @permission('bill-export') -->

                <!-- <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>

                <button type="submit" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button> -->
                <!-- @endpermission -->
                
        </div>

  
      </div>
      <div class="portlet-body">
        <table class="table table-striped table-bordered table-hover" id="buildDetails">
          <thead>
            <tr>
              <th>@lang('layout.Date')</th>
              <th>@lang('layout.Shift')</th>
              <th>@lang('layout.DeviceWash')</th>
              <th>@lang('layout.DeviceSpeed')</th>
              <th>@lang('layout.StartHour')</th>
              <th>@lang('layout.EndHour')</th>
              <th>@lang('layout.StartMeter')</th>
              <th>@lang('layout.EndMeter')</th>
              <th>@lang('layout.Actions')</th>
            </tr>
          </thead>
        </table>
      </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
  </div>


  <!-- END TAB PORTLET-->
  <iframe id="payframe" style="display: none;" ></iframe>
  <!-- END CONTENT BODY -->
  @stop

  @push('scripts')

  <script>


  @if(Session('id'))
    factorPrint("{{Session('id')}}")
    @endif
  

    function factorPrint(id) {

       
    var a=document.createElement('a');
    a.href="{{url('buildDetailsFactorPrint')}}/"+id;
    a.target="_blank";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
        


    }





   var Modal=Vue.component('modal', {
                    template: '#modal-template',
                    methods: {
                        ok: function() {
                            this.$emit('ok')
                        }
                    }
                });

   $(document).ready(function() {
    $('#buildDetails').DataTable( {
      ajax:'{{route("buildDetails.index")}}',
      pageLength:'{{getPageRows()}}',
      scrollCollapse: true,
      paging:         true,
      serverSide: true,
      columns: [
      { data: 'Date',                        name: 'Date', orderable:false, searchable:false },
      { data: 'shift',                       name: 'shift', orderable:false, searchable:false },
      { data: 'device_wash',                 name: 'device_wash' , orderable:false, searchable:false},
      { data: 'device_speed',                name: 'device_speed', orderable:false, searchable:false },
      { data: 'start_hour',                  name: 'start_hour', orderable:false, searchable:false },
      { data: 'end_hour',                    name: 'end_hour' , orderable:false, searchable:false},
      { data: 'start_meter',                 name: 'start_meter', orderable:false, searchable:false },
      { data: 'end_meter',                   name: 'end_meter', orderable:false, searchable:false },
      { data: 'actions',                     name: 'actions', orderable:false, searchable:false },

      ]
    });
  });

new Vue({
        el: '#app',
        data: {
            showModal: false,
           
        },
        methods:{
            ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){

                    //Your other code that launches the modal
                    this.showModal= true;
                    this.$nextTick(function(){
                        $(document).ready(function(){
                           $(".date").persianDatepicker(modelDate());
                       });
                    })
                }
            },
        });
    $('#print_pdf_all').on('click',function(e){
        $('#show-modal').click();
        e.preventDefault();
    })

    new Vue({
        el: '#app2',
        data: {
            showModal: false,
         
        },
        methods:{
            ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample2 : function(){

                    //Your other code that launches the modal
                    this.showModal= true;
                    this.$nextTick(function(){
                        $(document).ready(function(){
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
    $('#excell_all').on('click',function(e){
        $('#show-modal2').click();
        e.preventDefault();
    })
 </script>
 @endpush