@extends('layouts.app')
 <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewBuildDetail') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'buildDetails.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Shift')</label>
                                        <select name="shift" class="form-control">
                                          <option value="">@lang('layout.Select')</option>
                                          <option value="A">@lang('layout.A')</option>
                                          <option value="B">@lang('layout.B')</option>
                                        </select>
                                    </div>
                                  </div> 

                                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.DeviceWash')</label>
                                        <select name="device_wash" class="form-control">
                                          <option value="">@lang('layout.Select')</option>
                                          <option value="Yes">@lang('layout.yes')</option>
                                          <option value="Not">@lang('layout.Not')</option>
                                        </select>
                                    </div>
                                  </div>
                                

                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.DeviceSpeed')</label>
                                            {{Form::number('device_speed',null,['class' => 'form-control','placeholder' => __('layout.DeviceSpeed')])}}
                                            <input type="hidden" name="build_id" value="{{$id}}">
                                        </div>
                                </div> 

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.StartHour')</label>
                                            {{Form::time('start_hour',null,['class' => 'form-control','placeholder' => __('layout.Quantity')])}}
                                        </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.EndHour')</label>
                                            {{Form::time('end_hour',null,['class' => 'form-control','placeholder' => __('layout.EndHour')])}}
                                        </div>
                                </div>  
                           

                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      
                                      <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.StoppedHour')</label>
                                            {{Form::number('stoped_hours',null,['class' => 'form-control','placeholder' => __('layout.StoppedHour')])}}
                                        </div>
                               </div>

                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      
                                      <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.QuantityAndCause')</label>
                                            {{Form::text('qty_and_caus_of_stop',null,['class' => 'form-control','placeholder' => __('layout.QuantityAndCause')])}}
                                        </div>
                               </div>

                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      
                                      <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.StartMeter')</label>
                                            {{Form::number('start_meter',null,['class' => 'form-control','placeholder' => __('layout.StartMeter')])}}
                                        </div>
                               </div>

                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      
                                      <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.EndMeter')</label>
                                            {{Form::number('end_meter',null,['class' => 'form-control','placeholder' => __('layout.EndMeter')])}}
                                        </div>
                               </div>

                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      
                                      <div class="col-md-12">
                                            <label class="control-label ">@lang('menu.Recipe')</label>
                                            <v-select label="name" v-model="selected_recipe" :options="temp_recipe" @search="onRecipeSearch"></v-select>
                                            <input type="hidden" name="recipe_id" :value="(!selected_recipe)?null:selected_recipe.id">
                                        </div>
                               </div>

                           
                            </div>


                        </div>
                    </div>       
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        <a href="{{route('build.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}

            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 

@endsection 
@push('scripts')
 <script type="text/javascript">
     Vue.component('v-select', VueSelect.VueSelect);

     let v = new Vue({
       el: '#app',
       data: {
          temp_recipe:[],
          selected_recipe:null
       },
       methods: {
        onRecipeSearch:_.debounce((search,loading) =>{
              loading(true);
              axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:"anyTable",
                  keyword:search,
                  table_name:'recipes'
                }
              })
              .then(function(response){
                v.temp_recipe = [];
                if(response.data.length >0)
                {
                  v.temp_recipe = response.data;
                }
                loading(false);
              })
              .catch(function(error){
                console.log(error);
              })
           },getDebounceTime()),
       }
     })

 </script>

@endpush
 