@extends('layouts.app')
@section('content')
    @include('receives.modal')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'advancePricing'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                    </div>
                </div>
                  <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                            <select name="inventory_category_id"  class="form-control">
                                <option value="">@lang('layout.SelectInventoryCategory')</option>
                                {{-- @foreach($inventoryCategory as  $cat)
                                    <option value="{{$cat->id}}">{{$cat->name}}</option>
                                @endforeach --}}
                            </select>
                        </div> 
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SalePriceType') </label>
                            <select name="sale_price_type"  class="form-control">
                                <option value="inventory_sale_price">@lang('layout.InventorySalePrice')</option>
                                <option value="advance_price_sale_price">@lang('layout.AdvancePricingSalePrice')</option>
                                <option value="both" selected="selected">@lang('layout.BothPrice')</option>          
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">  @lang('layout.BudgetsList')  </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('FinancialPlanning-export')
                        {{-- <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span> --}}
                    @endpermission
                    @permission('FinancialPlanning-delete')
                    <button id="delete-all-button" class="btn btn-danger">@lang('layout.Delete') <i class="fa fa-trash"></i></button>

                    <a href="{{route('advancePricing.remove')}}">
                        <button  class="btn btn-danger"  onclick="DeleteAll(this)">
                            <i class="fa fa-times"></i> @lang('layout.DeleteAll')
                        </button>
                    </a>
                    @endpermission
                    @permission('FinancialPlanning-create')
                    <a href="{{route('budgets.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="budget_table">
                    <thead>
                    <tr>
                        <th><input type="checkbox" id="select_all_rows"></th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Type')</th>
                        {{-- <th>@lang('layout.BudgetPeriodType')</th> --}}
                        <th>@lang('layout.Year')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        @if (Session('receive_id'))
        printVoucher("{{Session('receive_id')}}")

        @endif

           //Delte All Records
            function DeleteAll(element){

                event.preventDefault();
          

                var e = $(element);
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    icon: "warning",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                                swal({
                                    title: "@lang('message.DeleteAllData')",
                                    icon: "warning",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                    dangerMode: true,
                                }).then((willDelete) => {
                                    if (willDelete) {
                                        
                                        window.location.href = "{{route('budgets.remove')}}"
                                    } else {
                                        return false
                                    }
                                });
                    } else {
                        return false
                    }
                });


            }     


        function printVoucher(id) {

            var a = document.createElement('a');
            a.href = "{{url('printReceive')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#budget_table').DataTable({
                ajax: '{{route("budgets.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'checkbox', name: 'checkbox', orderable: false, searchable: false},
                    {data: 'id', name: 'budgets.id'},
                    {data: 'name', name: 'budgets.name'},
                    {data: 'type', name: 'type'},
                    // {data: 'period_type', name: 'budgets.period_type'},
                    {data: 'period_year', name: 'budgets.period_year'},
                    {data: 'date', name: 'date', searchable: false},
                    {data: 'description', name: 'budgets.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

            
            // to check and uncheck
            $('#budget_table #select_all_rows').on('click', function(){
                

            //    $('#budget_table  #select_all_rows').prop('checked', function(index, checked) {
            //         return !checked;
            //     });
                // $('#budget_table input[type="checkbox"]').prop('checked', function(index, checked) {
                    //     return !checked;
                    // });

                var isChecked = $('#budget_table #select_all_rows').prop('checked');
                if(isChecked){
                    $('#budget_table input[type="checkbox"]').prop('checked', true);
                }else{
                    $('#budget_table input[type="checkbox"]').prop('checked', false);
                }

                
            });

            //When click on delete button
            $('#delete-all-button').on('click', function() {
                var checkedValues = [];
                $('#budget_table input[type="checkbox"]:checked').each(function() {
                    checkedValues.push($(this).val());
                });
                if (checkedValues.length > 0) {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: "warning",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            swal({
                                title: "@lang('message.DeleteAllData')",
                                icon: "warning",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                dangerMode: true,
                            }).then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                        url: "{{ route('budgets.removeMultiple') }}",
                                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                                        method: 'POST',
                                        data: {
                                            checked_rows: checkedValues
                                        },
                                        success: function(response) {
                                            toggleBlock(0);
                                            toastr.success('', response.message);
                                            checkedValues = [];
                                            // location.reload();
                                            $('#budget_table').DataTable().ajax.reload();
                                            console.log(response);
                                        },
                                        error: function(error) {
                                            console.error(error);
                                        }
                                    });
                                } else {
                                    return false
                                }
                            });
                        } else {
                            return false
                        }
                    });

                    
                }
                else {
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                }
            });
     


        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });


        //  function printVoucher(id){
        //   document.getElementById("payframe").src ="{{url('printReceive')}}/"+id+"";


        // }


        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

                var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

    </script>
@endpush
