@extends('layouts.app')
@section('style')

<style>
  .budget_total{
    transform: {{ (session()->get("system_direction") == "rtl")? 'rotate(180deg)':''}} ;
    color: white !important;
  }
  .part_header{
    background-color:rgb(228 228 233 / 50%);
  }
  .total_bud_row{
    background-color: bisque;
  }
</style>
@stop
@section('content')


<div class="row" id="app" v-cloak>

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    @if($duplicate)
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.BudgetsCreate')</span>
                    @else
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.BudgetsEdit') </span>
                    @endif
                </div>
                <div class="tools">
                    
                </div>
            </div>

            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                @if($duplicate)
                {{Form::open(['route' => 'budgets.store','method' => 'POST','class' => 'form-horizontal','id'=>'bill-submit'])}}
                @else
                {!! Form::model($budget, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['budgets.update',$budget->id]]) !!}
                @endif
                {{ csrf_field() }}

                    <div class="form-body">
                      <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                          <div class="form-group">
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Name')</label>
                                <input type="text" name="name" class="form-control" value="{{$budget->name}}" autocomplete="off">
                              </div>
                          </div> 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.BudgetType')</label>
                                     <select class="list-style form-control"  name="budget_type" v-model="budget_type">
                                            <option value="">@lang('layout.Select')</option>
                                            <option  value="profitAndLoss">@lang('layout.ProfitAndLost')</option>
                                            <option  value="balanceSheet">@lang('layout.BalanceSheet')</option>
                                     </select>
                                </div>
                            </div> 
                        </div> 
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.BudgetPeriodType')</label>
                                     <select class="list-style form-control" v-model="budget_period_type"  name="budget_period_type">
                                            <option value="">@lang('layout.Select')</option>
                                            <option  value="ShamsiDate">@lang('layout.ShamsiDate')</option>
                                            <option  value="MeladiDate">@lang('layout.MeladiDate')</option>
                                     </select>
                                </div>
                            </div> 
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="budget_period_type=='MeladiDate'">
                          <div class="form-group">
                              
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Year')</label>
                                   <select  class="list-style form-control"  name="budget_period_year" v-model="budget_period_year">
                                          <option value="">@lang('layout.Select')</option>
                                          <option  value="2024">2024</option>
                                          <option  value="2025">2025</option>
                                          <option  value="2026">2026</option>
                                          <option  value="2027">2027</option>
                                          <option  value="2028">2028</option>
                                          <option  value="2029">2029</option>
                                          <option  value="2030">2030</option>
                                          <option  value="2031">2031</option>
                                          <option  value="2032">2032</option>
                                          <option  value="2033">2033</option>
                                          <option  value="2034">2034</option>
                                          <option  value="2035">2035</option>
                                          <option  value="2036">2036</option>
                                   </select>
                              </div>
                          </div> 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="budget_period_type=='MeladiDate'">
                            <div class="form-group">
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Month')</label>
                                     <select  class="list-style form-control"  name="budget_period_begin" v-model="budget_period_begin">
                                            <option value="">@lang('layout.Select')</option>
                                            <option  value="1">1</option>
                                            <option  value="2">2</option>
                                            <option  value="3">3</option>
                                            <option  value="4">4</option>
                                            <option  value="5">5</option>
                                            <option  value="6">6</option>
                                            <option  value="7">7</option>
                                            <option  value="8">8</option>
                                            <option  value="9">9</option>
                                            <option  value="10">10</option>
                                            <option  value="11">11</option>
                                            <option  value="12">12</option>
                                     </select>
                                </div>
                            </div> 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="budget_period_type=='ShamsiDate'">
                          <div class="form-group">
                              
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Year')</label>
                                   <select  class="list-style form-control"  name="budget_period_year" v-model="budget_period_year">
                                          <option value="">@lang('layout.Select')</option>
                                          <option value="1403">1403</option>
                                          <option  value="1404">1404</option>
                                          <option  value="1405">1405</option>
                                          <option  value="1406">1406</option>
                                          <option  value="1407">1407</option>
                                          <option  value="1408">1408</option>
                                          <option  value="1409">1409</option>
                                          <option  value="1410">1410</option>
                                          <option  value="1411">1411</option>
                                          <option  value="1412">1412</option>
                                          <option  value="1413">1413</option>
                                          <option  value="1414">1414</option>
                                          <option  value="1415">1415</option>
                                   </select>
                              </div>
                          </div> 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="budget_period_type=='ShamsiDate'">
                            <div class="form-group">
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Month')</label>
                                     <select  class="list-style form-control"  name="budget_period_begin" v-model="budget_period_begin">
                                            <option value="">@lang('layout.Select')</option>
                                            <option  value="1">1</option>
                                            <option  value="2">2</option>
                                            <option  value="3">3</option>
                                            <option  value="4">4</option>
                                            <option  value="5">5</option>
                                            <option  value="6">6</option>
                                            <option  value="7">7</option>
                                            <option  value="8">8</option>
                                            <option  value="9">9</option>
                                            <option  value="10">10</option>
                                            <option  value="11">11</option>
                                            <option  value="12">12</option>
                                     </select>
                                </div>
                            </div> 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                          <div class="form-group">
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input type="text" name="date" class="form-control date" value="{{ convertDate($budget->date) }}" autocomplete="off">
                              </div>
                          </div> 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                          <div class="form-group">
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Description')</label>
                                <textarea name="description" class="form-control" rows="1">{{$budget->description}}</textarea>
                              </div>
                          </div> 
                        </div>
                        <div class="col-md-1">
                          <label class="control-label">&nbsp;</label>
                          <button type="button" @click="searchData" class="btn btn-info form-control" style="background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141);">
                            <i class="fa fa-search"></i>@lang('layout.Search')</button> 
                        </div> 
                      </div>
                      <br>
                  
                  <!-- begin profitAndLoss -->
                  <div class="row"  style="overflow-x: scroll;" v-if="budget_type=='profitAndLoss'">
                    <table id="table_content" class="table table-bordered table-advance">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.Account')</th>
                            <th style="min-width: 100px">@lang('layout.BudgetTotals')</th>
                            <th style="min-width: 100px"  v-for="m in month">
                                @{{ m.all }}
                            </th>
                            <th style="min-width: 100px">@lang('layout.TotalBudget')</th>
                        </tr>
                        </thead>
                        <tbody>
                          <tr v-if="income.length>0">
                              <td colspan="16"  class="part_header" >@lang('layout.Income')</td>
                          </tr>
                          <tr v-for="(item,index) in income">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                <div class="input-group">
                                  {{-- <input type="number" class="form-control" v-model="(!item)?null:item.budget_total"> --}}
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'income')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                      <i class="fa fa-random budget_total" ></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">

                                  <td v-for="(m , mindex) in item.month">
                                    <input type="number" class="form-control"  v-model="(!item && !m)?null:m.budget_row" 
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  > 
                                    
                                    {{-- <input type="number" class="form-control ddd"  :ref="`cell-${item.account_id}-${index}-${m.m}`"  value="100"
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  > --}}

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr>
                          <tr v-if="costOfGoodSold.length>0">
                            <td colspan="16" class="part_header">@lang('layout.CostOfGoodSold')</td>
                          </tr>
                          <tr v-for="(item,index) in costOfGoodSold">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                
                                <div class="input-group">
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'cogs')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                      <i class="fa fa-random budget_total" ></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">

                                  <td v-for="m in item.month">
                                    <input type="number" class="form-control" v-model="(!item && !m)?null:m.budget_row" 
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  >

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr>
                          <tr v-if="expense.length>0">
                            <td colspan="16" class="part_header">@lang('layout.Expense')</td>
                          </tr>
                          <tr v-for="(item,index) in expense">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                
                                <div class="input-group">
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'expense')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                      <i class="fa fa-random budget_total"></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">
                                  <td v-for="m in item.month">
                                    <input type="number" class="form-control"  v-model="(!item && !m)?null:m.budget_row" 
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  >

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr>
                          <tr v-if="otherExpense.length>0">
                            <td colspan="16" class="part_header">@lang('layout.OtherExpense')</td>
                          </tr>
                          <tr v-for="(item,index) in otherExpense">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                
                                <div class="input-group">
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'otherExpense')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                    <i class="fa fa-random budget_total" ></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">
                                  <td v-for="m in item.month">
                                    <input type="number" class="form-control"  v-model="(!item && !m)?null:m.budget_row"
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  >

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr>
                          <tr v-if="otherIncome.length>0">
                            <td colspan="16" class="part_header">@lang('layout.OtherIncome')</td>
                          </tr>
                          <tr v-for="(item,index) in otherIncome">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                <div class="input-group">
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'otherIncome')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                    <i class="fa fa-random budget_total" ></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">
                                  <td v-for="m in item.month">
                                    <input type="number" class="form-control"  v-model="(!item && !m)?null:m.budget_row"
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  >

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr> 
                          
                        </tbody>
                    </table>

                  </div>
                 <!-- end profitAndLoss -->                  
                
                
                <!-- begin balanceSheet -->
                  <div class="row"  style="overflow-x: scroll;" v-if="budget_type=='balanceSheet'">
                    <table id="table_content" class="table table-bordered table-advance">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.Account')</th>
                            <th style="min-width: 100px !important;">@lang('layout.BudgetTotals')</th>
                            <th style="min-width: 100px"  v-for="m in month">
                                @{{ m.all }}
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                          <tr v-if="currentAsset.length>0">
                            <td colspan="16" class="part_header">@lang('layout.CurrentAssets')</td>
                          </tr>
                          <tr v-for="(item,index) in currentAsset">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                
                                <div class="input-group">
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'currentAsset')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                    <i class="fa fa-random budget_total" ></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">
                                  <td v-for="m in item.month">
                                    <input type="number" class="form-control"  v-model="(!item && !m)?null:m.budget_row" 
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  >

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr>
                          <tr v-if="noneCurrentAsset.length>0">
                            <td colspan="16" class="part_header">@lang('layout.NoneCurrentAssets') / @lang('layout.FixedAsset')</td>
                          </tr>
                          <tr v-for="(item,index) in noneCurrentAsset">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                
                                <div class="input-group">
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'noneCurrentAsset')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                    <i class="fa fa-random budget_total" ></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">
                                  <td v-for="m in item.month">
                                    <input type="number" class="form-control" v-model="(!item && !m)?null:m.budget_row"
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  >

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr> 
                          <tr v-if="liability.length>0">
                            <td colspan="16" class="part_header">@lang('layout.Liabilities')</td>
                          </tr>
                          <tr v-for="(item,index) in liability">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                
                                <div class="input-group">
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'liability')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                    <i class="fa fa-random budget_total" ></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">

                                  <td v-for="m in item.month">
                                    <input type="number" class="form-control"  v-model="(!item && !m)?null:m.budget_row"
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  >

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr> 
                          <tr v-if="equity.length>0">
                            <td colspan="16" class="part_header">@lang('layout.Equity')</td>
                          </tr>
                          <tr v-for="(item,index) in equity">
                              <td>@{{index+1}}</td>
                              <td>@{{(!item)?null:item.name}}</td>
                              <td>
                                
                                <div class="input-group">
                                  <input type="number" class="form-control" v-model="(!item)?null:item.budget_total">
                                  <span class="btn btn-success input-group-addon" @click="budget_total(index,'equity')" title="@lang('button.ClickToSplitTheTotalAcrossTheRow')" style="background-color:  rgb(84, 199, 211)">
                                    <i class="fa fa-random budget_total" ></i>
                                  </span> 
                              </div>

                              </td>
                              <template v-if="item.month">

                                  <td v-for="m in item.month">
                                    <input type="number" class="form-control"  v-model="(!item && !m)?null:m.budget_row"
                                    :name="'account_id['+item.account_id+']['+m.y+']['+m.m+']'"  >

                                  </td>
                              </template>
                              <td class="total_bud_row">@{{myRound(totalBugetRow((!item && !m)?null:item.month))}}</td>
                          </tr> 
                          
                        </tbody>
                    </table>

                  </div>
                <!-- end balanceSheet -->

                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('advancePricing.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">
  var budget = {!! $budget !!}
  var income = {!! $income !!}
  var costOfGoodSold = {!! $costOfGoodSold !!}
  var expense = {!! $expense !!}
  var otherExpense = {!! $otherExpense !!}
  var otherIncome = {!! $otherIncome !!}
  var noneCurrentAsset = {!! $noneCurrentAsset !!}
  var currentAsset = {!! $currentAsset !!}
  var liability = {!! $liability !!}
  var equity = {!! $equity !!}
  var month = {!! $month !!}
  var vm = new Vue({
    el: '#app',
    data: {
      budget_type:budget.type,
      budget_period_type:budget.period_type,
      budget_period_year:budget.period_year,
      budget_period_begin:budget.period_begin,

      income:income,
      costOfGoodSold:costOfGoodSold,
      expense:expense,
      otherExpense:otherExpense,
      otherIncome:otherIncome,
      noneCurrentAsset:noneCurrentAsset,
      currentAsset:currentAsset,
      liability:liability,
      equity:equity,
      month:month

    },
    // computed: {
    // devideBudget() {
    //   return baba;
    // }
    // },
    mounted() {
      console.log('day',this.budget_period_begin)
    },
    methods:
    {
      budget_total(index,type){

        // for (var i = 0; i < month.length; i++) {
        //   var cell = this.$refs[`cell-${item_id}-${index}-${month[i].m}`];
        //   if (cell) {
        //     // cell.value = 400; // Assign a new value
        //     console.log('cell',cell,cell.value)
        //   }
          
        // }
        if(type == "income" && vm.income[index]['budget_total'] != null && vm.income[index]['month'] != null){
          // console.log(vm.income[index]['month']);

          //Change Object to array
          var month = vm.income[index].month;
          month = Object.values(month);

          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.income[index]['budget_total']/12;
            // console.log('cell', month[i])
          }
        }        
        if(type == "cogs" && vm.costOfGoodSold[index]['budget_total'] != null && vm.costOfGoodSold[index]['month'] != null){
          var month = vm.costOfGoodSold[index].month;
          month = Object.values(month);
          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.costOfGoodSold[index]['budget_total']/12;
          }
        }
        if(type == "expense" && vm.expense[index]['budget_total'] != null && vm.expense[index]['month'] != null){
          var month = vm.expense[index].month;
          month = Object.values(month);
          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.expense[index]['budget_total']/12;
          }
        }        
        if(type == "otherExpense" && vm.otherExpense[index]['budget_total'] != null && vm.otherExpense[index]['month'] != null){
          var month = vm.otherExpense[index].month;
          month = Object.values(month);
          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.otherExpense[index]['budget_total']/12;
          }
        }        
        if(type == "otherIncome" && vm.otherIncome[index]['budget_total'] != null && vm.otherIncome[index]['month'] != null){
          var month = vm.otherIncome[index].month;
          month = Object.values(month);
          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.otherIncome[index]['budget_total']/12;
          }
        }        
        if(type == "currentAsset" && vm.currentAsset[index]['budget_total'] != null && vm.currentAsset[index]['month'] != null){
          var month = vm.currentAsset[index].month;
          month = Object.values(month);
          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.currentAsset[index]['budget_total']/12;
          }
        }        
        if(type == "noneCurrentAsset" && vm.noneCurrentAsset[index]['budget_total'] != null && vm.noneCurrentAsset[index]['month'] != null){
          var month = vm.noneCurrentAsset[index].month;
          month = Object.values(month);
          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.noneCurrentAsset[index]['budget_total']/12;
          }
        }        
        if(type == "liability" && vm.liability[index]['budget_total'] != null && vm.liability[index]['month'] != null){
          var month = vm.liability[index].month;
          month = Object.values(month);
          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.liability[index]['budget_total']/12;
          }
        }        
        if(type == "equity" && vm.equity[index]['budget_total'] != null && vm.equity[index]['month'] != null){
          var month = vm.equity[index].month;
          month = Object.values(month);
          for (var i = 0; i < month.length; i++) {
            month[i]['budget_row']  = vm.equity[index]['budget_total']/12;
          }
        }

        





        



      },
      searchData(){
        if(this.budget_type && this.budget_period_type && this.budget_period_year && this.budget_period_begin){
          axios.get("{{route('callBudget.search')}}", {
              params: {
                  method_name: 'getBudgetPeriod',
                  budget_type: this.budget_type,
                  budget_period_type: this.budget_period_type,
                  budget_period_year: this.budget_period_year,
                  budget_period_begin: this.budget_period_begin
              }
          })
          .then(function (response) {
              if (response.data) {
                var myDataArray=response.data.income;
                
  
                for(var i=0;i<myDataArray.length;i++){
                    vm.income.push(myDataArray[i]);
                    // vm.month=myDataArray[i].month;
                }
                vm.month = response.data.month;
  
                vm.costOfGoodSold  = response.data.costOfGoodSold;
                vm.expense = response.data.expense;
                vm.otherExpense = response.data.otherExpense;
                vm.otherIncome = response.data.otherIncome;
  
                vm.noneCurrentAsset = response.data.noneCurrentAsset;
                vm.currentAsset = response.data.currentAsset;
                vm.liability = response.data.liability;
                vm.equity = response.data.equity;
  
                console.log('ddddd',response.data)
  
                // vm.inventories  = response.data;
                      // v.temp_items = response.data;
              }
  
          })
          .catch(function (error) {
              console.log(error);
          });
        }
      }
    }

  });

</script>


@endpush