@extends('layouts.factor-master')


@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.BranchTransferVocher')</h3>
    <table class="main-table">

        <tr>
            <th><i class="fa fa-bars"></i> @lang('layout.ReferenceNumber')</th> 
            <th><i class="fa fa-bars"></i> @lang('layout.Type')</th> 
            <th><i class="fa fa-home"></i> @lang('layout.FromBranch')</th> 
            <th><i class="fa fa-home"></i> @lang('layout.ToBranch')</th>
            <th>
                <i class="fa fa-clock-o"></i> @lang('layout.Date')
            </th>
            <th><i class="fa fa-signal"></i> @lang('layout.Description')</th>
            <th>@lang('layout.Accountant')</th>
        </tr>
        <tr>
             <td class="hidden-xs"> {{ $transfer->ref_no}}  </td>
            <td class="hidden-xs"> {{ $transfer->type}}  </td>
            <td class="hidden-xs"> {!! $transfer->from_company !!}  </td>
            <td class="hidden-xs"> {!! $transfer->to_company !!}  </td>
            <td align="center">{{convertDate($transfer->date)}}</td>
            <td class="hidden-xs"> {{ $transfer->description}}  </td>
            <td align="center">{{$user}}</td>


        </tr>

    </table>

    <br>





    <table class="main-table">
        <thead>
        <tr>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Unit')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Cost')</th>
            <th>@lang('layout.Site')</th>

        </tr>
        </thead>
        <tbody>
        @foreach($transferDetail as $key )
            <tr>
                <td>
                    {{$key->ItemName}}
                </td>
                <td>
                    {{$key->Measure}}
                </td>
                <td>
                    {{$key->quantity}}
                </td>
                <td>
                    {{$key->cost}}
                </td>
                <td>
                    {{$key->site_name}}
                </td>
            </tr>
        @endforeach

        </tbody>
    </table>
    <br>

    <table class="main-table">
        <thead>
        <tr>
            <th width="70%"> @lang('layout.Description') </th>
            <th>@lang('layout.MohrAndSignature')</th>


        </tr>
        </thead>
        <tbody>
        <tr>
            <td width="70%">{{$transfer->description}}</td>
            <td style="width: 30%;height: 50px"></td>
        </tr>


        </tbody>
    </table>




    @if(company()['inventory_transfer_message'])
        <table width="100%">
            <tr>
                <td style="font-size: 14px;">@lang('layout.Note'): {{company()['inventory_transfer_message']}}</td>
            </tr>

            <tr>
                <td></td>
                <td></td>
            </tr>


        </table>
    @endif
@endsection
