@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('inventory_transfer');
    $_item_name = in_array('item_name', $report);
    $_measure = in_array('measure=', $report);
    $_quantity = in_array('quantity', $report);
    $_from_site = in_array('from_site', $report);
    $_to_site = in_array('to_site', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryTransferReport')</h3>
    <table class="main-table">
            @if($transferInfo)
				
			<tr>
                     <th><i class="fa fa-bars"></i> @lang('layout.WayBillNumber')</th> 
                    <th><i class="fa fa-bars"></i> @lang('layout.PlateNumber')</th> 
                    <th><i class="fa fa-bars"></i> @lang('layout.TotalQty')</th> 
                    <th><i class="icon-user"></i> @lang('layout.Driver')</th>
                    <th>
                        <i class="fa fa-clock-o"></i> @lang('layout.Date')
                    </th>
                    <th><i class="fa fa-signal"></i> @lang('layout.Description')</th>

            </tr>
			<tr>
					<td class="hidden-xs"> {{ $transferInfo->way_bill_number}}  </td>
					<td class="hidden-xs"> {{ $transferInfo->plate_number}}  </td>
					<td class="hidden-xs"> {{ $transferInfo->total_bori}}  </td>
					<td class="hidden-xs"> {{ $transferInfo->name}}  </td>
					<td class="hidden-xs"> <BDO DIR="LTR"> {{convertDate(date('Y-m-d'))}} </BDO> </td>
					<td class="hidden-xs"> {{ $transferInfo->description}}  </td>
			</tr>
            @endif
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            @if($_item_name)
                <td>
                    <div class="center"> @lang('layout.ItemName') </div>
                </td>@endif
                <td>
                    <div class="center"> @lang('layout.Code')</div>
                </td>
            @if($_measure)
                <td>
                    <div class="center"> @lang('layout.Measure')</div>
                </td>@endif
            @if($_quantity)
                <td>
                    <div class="center"> @lang('layout.Quantity')</div>
                </td>@endif
            @if($_from_site)
                <td>
                    <div class="center"> @lang('layout.FromSite')</div>
                </td>@endif
            @if($_to_site)
                <td>
                    <div class="center"> @lang('layout.ToSite')</div>
                </td>@endif
                <td>
                    <div class="center"> @lang('layout.Date')</div>
                </td>
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)

            <tr>

                <td class="center">{{++$count}}</td>
                @if($_item_name)
                    <td class="center">{{$record->ItemName}}</td>@endif
                    <td class="center">{{$record->code}}</td>
                @if($_measure)
                    <td class="center">{{$record->Measure}}</td>@endif
                @if($_quantity)
                    <td class="center">{{$record->quantity}}</td>@endif
                @if($_from_site)
                    <td class="center">{{$record->from_site}}</td>@endif
                @if($_to_site)
                    <td class="center">{{$record->to_site}}</td>@endif
                    <td class="center">{{convertDate($record->Date)}}</td>
            </tr>

        @endforeach
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection