@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('branch_transfer');
    $_date = in_array('date', $report);
    $_description = in_array('description', $report);
    $_reference_number = in_array('reference_number', $report);
    $_member = in_array('member', $report);
    $_type = in_array('type', $report);
    $_total_amount = in_array('total', $report);
    ?>



<table   class="main-table">
    <tr>
      @if($member_name)
     <td>
      <span>@lang('layout.Name')</span>:
      {{$member_name}}
    </td>
    @endif
  
  
  </tr>
  </table>




    <h3 class="table-caption" style="text-align: center;">@lang('layout.BranchTransferReport')</h3>
  

    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            @if($_date)
                <td class="center">@lang('layout.Date')</td>@endif
            @if($_description)
                <td class="center">@lang('layout.Description')</td>@endif
            @if($_reference_number)
                <td class="center">@lang('layout.ReferenceNumber')</td>@endif
                <td  class="center">@lang('layout.FromBranch')</td>
                <td  class="center">@lang('layout.ToBranch')</td>
            @if(!$member_name)
            @if($_member)
             <td class="center">@lang('layout.MemberName')</td>@endif
             @endif
            @if($_type)
             <td class="center">@lang('layout.Type')</td>@endif
             @if(getDriverInfo()=="true")
             <th class="center">@lang('layout.Driver')</th>
            <th class="center">@lang('layout.WayBillNumber')</th>
            <th class="center">@lang('layout.PlateNumber')</th>
            <th class="center">@lang('layout.TotalQty')</th>
            <th class="center">@lang('layout.User')</th>
            @endif
        </tr>
        </thead>
        <?php
        $count = 0;
        $member='';
        ?>
        @foreach($data AS $record)
        <?php
        if ($record->type == 'transfer') {
            $member = $record->from_member_name;
        } else {
            $member = $record->to_member_name;
        }
        ?>
            <tr>
                <td class="center">{{++$count}}</td>
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>@endif
                    <td  class="center">{!!$record->from_company!!}</td>
                    <td  class="center">{!!$record->to_company!!}</td>
                    @if(!$member_name)
                @if($_member)
                    <td class="center">{{$member}}</td>@endif
                    @endif
                    @if($_type)
                    <td class="center">{{__('layout.'.ucfirst($record->type))}}</td>@endif
                    @if(getDriverInfo()=="true")
                    <td class="center">{{$record->driver_name}}</td>
                    <td class="center">{{$record->way_bill_number}}</td>
                    <td class="center">{{$record->plate_number}}</td>
                    <td class="center">{{$record->total_bori}}</td>
                    <td class="center">{{$record->user}}</td>
                    @endif
            </tr>
        @endforeach
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection