@extends('layouts.app')

@section('content')


    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'branch_transfer_roll'" @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.SelectType')</label>
                                <select name="report_type" class="form-control">
                                    <option value="">@lang('layout.SelectType')</option>
                                    <option value="general">@lang('layout.General')</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Member')</label>
                                <v-select label="name" :options="member" v-model="selected_member" @search="onMemberSearch"></v-select>
                                <input type="hidden" name="member_id" :value="(!selected_member)?null:selected_member.id">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('menu.BranchTransferRoll')</span>
                </div>
                <div class="pull-right">
                    @permission('branchTransfer-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('branchTransfer-create')
                    <a href="{{route('branchTransferRoll.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="InventoryTransfer">
                    <thead>
                    <tr>
                        <th>@lang('layout.ID')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.WayBillNumber')</th>
                        <th>@lang('layout.PlateNumber')</th>
                        <th>@lang('layout.TotalQty')</th>
                        <th>@lang('layout.Driver')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

    <iframe id="transferFrames" style="display: none;"></iframe>
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        @if (Session('transfer_id'))
        //printTransferBill("{{Session('transfer_id')}}")

        @endif

        function printTransferBill(id) {

            var a = document.createElement('a');
            a.href = "{{url('branchTransferBillRoll')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#InventoryTransfer').DataTable({
                ajax: '{{route("branchTransferRoll.index")}}',
                pageLength: '{{getPageRows()}}',
                // scrollY:        450,
                order: [["{{orderByColumn()=='number'?0:8}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'id', name: 'branch_transfers.id'},
                    {data: 'ref_no', name: 'branch_transfers.ref_no'},
                    {data: 'name', name: 'members.name'},
                    {data: 'type', name: 'type', orderable: false, searchable: false},
                    {data: 'way_bill_number', name: 'branch_transfers.way_bill_number'},
                    {data: 'plate_number', name: 'branch_transfers.plate_number'},
                    {data: 'total_bori', name: 'branch_transfers.total_bori'},
                    {data: 'dirver', name: 'members.name'},
                    {data: 'Date', name: 'branch_transfers.date'},
                    {data: 'description', name: 'branch_transfers.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                member:[],
                selected_member:null

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'members',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.member = [];
                            if (response.data.length > 0) {
                                vm.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        Vue.component('v-select', VueSelect.VueSelect)
    </script>


@endpush

