@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('inventory_transfer');
    $_item_name = in_array('item_name', $report);
    $_measure = in_array('measure=', $report);
    $_quantity = in_array('quantity', $report);
    $_from_site = in_array('from_site', $report);
    $_to_site = in_array('to_site', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.BranchTransferReport')</h3>
        <table class="main-table">
            @if($branchTransfer)
            <tr>
                       <th><i class="fa fa-bars"></i> @lang('layout.ReferenceNumber')</th> 
                        <th><i class="fa fa-bars"></i> @lang('layout.Type')</th> 
                        <th><i class="fa fa-home"></i> @lang('layout.FromBranch')</th> 
                        <th><i class="fa fa-home"></i> @lang('layout.ToBranch')</th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th><i class="fa fa-signal"></i> @lang('layout.Description')</th>

            </tr>
                <tr>

                        <td class="hidden-xs"> {{ $branchTransfer->ref_no}}  </td>
                        <td class="hidden-xs"> {{ $branchTransfer->type}}  </td>
                        <td class="hidden-xs"> {!! $branchTransfer->from_company!!}  </td>
                        <td class="hidden-xs"> {!! $branchTransfer->to_company!!}  </td>
                        <td class="hidden-xs"> <BDO DIR="LTR"> {{convertDate($branchTransfer->date)}} </BDO> </td>
                        <td class="hidden-xs"> {{ $branchTransfer->description}}  </td>


                </tr>
        @endif
        </table>




    <table class="main-table">
 
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td class="center">
                <div>  @lang('layout.Record') </div>
            </td>
            @if($_item_name)
                <td class="center">
                    <div> @lang('layout.ItemName') </div>
                </td>@endif
            @if($_item_name)
                <td class="center">
                    <div> @lang('layout.Code') </div>
                </td>@endif
                @if(getOtherMeasure()=="true")
                <th>@lang('layout.OMeasureValue1')</th>
                @endif
                @if(getOtherMeasure2()=="true")
                <th>@lang('layout.OMeasureValue2')</th>
                @endif
            @if($_measure)
                <td class="center">
                    <div> @lang('layout.Measure')</div>
                </td>@endif
            @if($_quantity)
                <td class="center">
                    <div> @lang('layout.Quantity')</div>
                </td>@endif  

                <td class="center">
                    <div> @lang('layout.Cost')</div>
                </td>

            @if($_from_site)
                <td class="center">
                    <div> @lang('layout.Site')</div>
                </td>@endif
          
                <td class="center">
                    <div> @lang('layout.Total')</div>
                </td>
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)

            <tr>

                <td class="center">{{++$count}}</td>
                @if($_item_name)
                <td class="center">{{$record->ItemName}}</td>@endif
                @if($_item_name)
                <td class="center">{{$record->code}}</td>@endif
                @if(getOtherMeasure()=="true")
                <td class="center">{{$record->other_measure_name}}</td>
                @endif
                @if(getOtherMeasure2()=="true")
                <td class="center">{{$record->other_measure_name2}}</td>
                @endif
                @if($_measure)
                    <td class="center">{{$record->Measure}}</td>@endif
                @if($_quantity)
                    <td class="center">{{myRound($record->quantity)}}</td>@endif

                    <td class="center">{{myRound($record->cost)}}</td>
                @if($_from_site)
                    <td class="center">{{$record->site_name}}</td>@endif
              
                    <td class="center">{{myRound($record->cost*$record->quantity)}}</td>
            </tr>

        @endforeach

    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection