@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>
    .required {
        padding-left: 0px !important;
        color: red;
    }
</style>
@stop
@section('content')
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.NewBranchTransfer')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="app" class="portlet-body">

                <div class="tabbable tabbable-tabdrop">


                    <div>
                        {{Form::open(['route' => 'branchTransferRoll.store','method' => 'POST','class' => 'form-horizontal','id'=>'transfer-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->


                                    <div class="form-body">
                                        <div class="row">
                                            <!-- begin inputs -->
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                        <input type="number" name="ref_no" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Date')</label>

                                                            <input type="text" name="date" class="form-control date now" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Description')</label>

                                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                                        </div>
                                                    </div>
                                                </div>

                                            <!-- end inputs -->


                                        </div>
                                        <!-- begin Driver And Other Info -->
                                        <div class="row">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Driver')</label>
                                                            <v-select label="name" v-model="selected_driver" :options="driver">
                                                            </v-select>
                                                            <input type="hidden" name="driver_id" :value="(!selected_driver)?null:selected_driver.id">

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.TotalQty')</label>
                                                            <input type="text" name="total_bori" :value="subtotal" class="form-control" placeholder="@lang('layout.TotalQty')">

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.WayBillNumber')</label>
                                                            <input type="text" name="way_bill_number" class="form-control" placeholder="@lang('layout.WayBillNumber')">

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.PlateNumber')</label>
                                                            <input type="text" name="plate_number" class="form-control" placeholder="@lang('layout.PlateNumber')">

                                                        </div>
                                                    </div>
                                                </div>
                                            <!-- End Driver And Other Info -->

                                        </div>

                                        <div class="row">

                                            <div v-if="type=='transfer'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Company')</label>
                                                        <v-select label="name" :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>

                                                        <input type="hidden" name="to_company_id" :value="(!selected_company)?null:selected_company.id" v-validate="'required'" data-vv-as="@lang('layout.Company')">


                                                        <span class="required">@{{ errors.first('to_company_id') }}</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div v-if="type !='transfer'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.From')</label>
                                                        <v-select label="name" :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>

                                                        <input type="hidden" name="from_company_id" :value="(!selected_company)?null:selected_company.id" v-validate="'required'" data-vv-as="@lang('layout.Company')">


                                                        <span class="required">@{{ errors.first('from_company_id') }}</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                                        <v-select label="name" :options="member" v-model="selected_member" placeholder="@lang('layout.SelectMember')"></v-select>
                                                        <input type="hidden" name="member_id" :value="(!selected_member)?null:selected_member.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">

                                                        <span class="required">@{{ errors.first('member_id') }}</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label" for="type">@lang('layout.Type')</label>
                                                        <select name="type" v-model="type" class="form-control" id="type" style="border: 1px solid rgba(60,60,60,.26) !important;">
                                                            <option value="transfer">@lang('layout.Transfer')</option>
                                                            <option value="receiveTransfer">@lang('layout.ReceiveTransfer')</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            @if(getShowWing()!="false")
                                            <div class="col-lg-1 col-md-1 col-sm-6 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.Wing')
                                                                    <input type="checkbox" name="wing" v-model="wing">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            @endif
                                        </div>

                                        <div class="row">
                                            <table id="table_content" class="table table-bordered table-advance">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th style="min-width: 100px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.Site') </th>
                                                        <th style="min-width: 100px">@lang('layout.Code') </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px"  v-if="type=='transfer'"> @lang('layout.OnHand') @lang('layout.Code') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')</th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')</th>
                                                        @if(getShowWing()!="false")
                                                        <th style="min-width: 100px">@lang('layout.Wing') </th>
                                                        @endif
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Cost')</th>
                                                        @if(systemConfig()[9] == 0 )
                                                        <th v-if="type=='receiveTransfer'" style="min-width: 100px;">@lang('layout.Width')</th>
                                                        @endif
                                                        <th v-show="showWhat('expire_date')=='yes'" v-if="type=='receiveTransfer'" style="min-width: 100px;">@lang('layout.ExpireDate')</th>
                                                        <th class="text-center" style="min-width: 100px;">@lang('layout.Total')</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="item.inventory" @keyup.native="onItemLoadCode(index)" :options="temp_items" @search="onItemSearch" @click.native="onItemLoadCode(index), addNew('inventory',index)"></v-select>
                                                            <input type="hidden" id="item_id" :name="'inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">
                                                        </td>
                                                        <td v-if="type=='transfer'" class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" @input="onItemSearchCodeSelect(index)" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                    <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            <input type="hidden" id="inventory_site" :name="'site['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td v-if="type=='receiveTransfer'">
                                                          <span v-if="(item.item !=null)">
                                                            <select class="form-control input_style"
                                                                    placeholder="@lang('layout.Site')"
                                                                    required="required"
                                                                    v-model="item.site" >
                                                            <option v-for="si in site"
                                                                    :value="si.id">@{{si.name}}
                                                            </option>
                                                        </select>
                                                        </span>
                                                            <input type="hidden" :name="'site['+index+']'"
                                                                   :value="item.site">
                                                        </td>
                                                        <td class="highlight" v-if="type=='transfer'">
                                                            <v-select label="name" @click.native="addIndex(index)" @input="addIndex(index)" v-model="(item.item==null)?null:item.item.code" :options="subItemes" @search="onItemSearchCode" placeholder="@lang('layout.Code')" style=""></v-select>
                                                            <input type="hidden" :name="'m_stocks_in_id['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.id)">
                                                            <input type="hidden" :name="'main_stock_id['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.main_stock_id)">
                                                        </td>
                                                        <td v-if="type=='transfer'">
                                                            <input type="number" :name="'inventory_quantity['+index+']'" ref="qut_temp" @input="setNewRate(index)" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.qut_temp)" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td v-if="type=='receiveTransfer'">
                                                            <input type="text" :name="'code['+index+']'" ref="code" @input="setNewRate(index)" :value="item.code" class="form-control input-style input-number" placeholder="@lang('layout.Code')">
                                                        </td>
                                                        <td v-if="type=='receiveTransfer'">
                                                            <input type="number" :name="'inventory_quantity['+index+']'" ref="qty" @input="setNewRate(index)" :value="item.quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">

                                                        </td>
                                                        <td v-if="type=='transfer'">
                                                            @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.OnHand))}}
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,((item.item.code==null)?null:item.item.code.qut_temp),item.quantity))}}
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" :disabled="type=='transfer'" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            <input type="hidden" :name="'inventory_measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" :name="'other_measure['+index+']'"
                                                                class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(item.item==null)?null:item.item.other_measure">
                                                                <span class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.other_measure))}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" :name="'other_measure2['+index+']'"
                                                                class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.other_measure2">
                                                                <span class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.other_measure2))}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        @if(getShowWing()!="false")
                                                        <td>
                                                            <div class="input-group">
                                                                <input :name="'khada['+index+']'" type="number" v-model.numbe="(item.item==null)?null:item.item.khada" @input="change_khada(index)"
                                                                oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Wing')">
                                                                <span class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.khada))}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        @endif
                                                        <td >
                                                            <div class="input-group">
                                                                <input type="number" :name="'cost['+index+']'" placeholder="@lang('layout.Cost')" ref="cost"  @input="setNewRate(index)"
                                                                :value="(item.item==null)?null:((item.item.code==null)?item.cost:item.item.code.cost)"
                                                                        class="form-control" :readonly="type=='transfer'">
                                                            </div>

                                                        </td>
                                                        @if(systemConfig()[9] == 0 )
                                                        <td v-if="type=='receiveTransfer'" >
                                                            <div class="input-group">
                                                                <input type="number" :name="'widths['+index+']'" placeholder="@lang('layout.Width')" class="form-control" />
                                                            </div>
                                                        </td>
                                                        @endif
                                                        <td v-if="type=='receiveTransfer'" v-show="showWhat('expire_date')=='yes'">
                                                            <date_picker :name="'expire_date['+index+']'" placeholder="@lang('layout.ExpireDate')" ></date_picker>
                                                        </td>
                                                        <td v-if="type=='transfer'">
                                                            @{{myRound((item.item==null)?null:((item.item.code==null)?null:(item.item.code.cost * item.item.code.qut_temp)))}}
                                                        </td>
                                                        <td v-if="type=='receiveTransfer'">
                                                            @{{myRound(item.cost * item.quantity)}}
                                                        </td>
                                                        <td>
                                                            <span v-if="inventories.length>1" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>

                                        </div>


                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="!isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                                        <!-- button type="button" class="btn blue"
                                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button -->

                                        <a href="{{route('inventoryTransfer.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    </div>

                                    <cmodal :show='showModal' @close="showModal=false">

                                    </cmodal>
                                </div>

                            </div>


                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>
@endsection
@push('scripts')


<script type="text/javascript">
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif



    Vue.component('v-select', VueSelect.VueSelect);

    var inventory_category = {!! $inventory_category !!};
    var driver = {!! $driver !!};
    var site = {!! $site !!};
    var member = {!! $member !!};
    var company = {!! $company !!};

    var v = new Vue({
        el: '#app',
        data: {
            driver: driver,
            selected_driver: null,
            showModal: false,
            temp_items: [],
            inventory_category: inventory_category,
            selected_iventory_category: null,
            selected_index: 0,
            selectedIndex: 0,
            site: site,
            subItems: [],
            subItemes: [],
            inventories: [{
                inventory: null,
                item: null,
                item_category: null,
                quantity: null,
                site: null,
                code: null,
                cost: null
            }, ],
            type_number: null,
            wing: false,
            member: member,
            selected_member: null,
            company:company,
            selected_company:null,
            type:'transfer'

        },
        computed: {
            // calculate subtotal
            subtotal: function() {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].item.code && this.inventories[i].item.code != null && this.type=='transfer') {
                            var quantity = this.inventories[i]['item']['code']['qut_temp'];
                            // var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            // var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (quantity > 0) {
                                sum += Number.parseFloat(quantity);
                            }
                        }
                        if (this.type=='receiveTransfer') {
                            var quantity = this.inventories[i]['quantity'];
                            if (quantity > 0) {
                                sum += Number.parseFloat(quantity);
                            }
                        }
                    }
                }

                return sum;
            },

            // check data validation
            isError: function() {
                var isError = false;
                var flag = false;
                /**for (var i = 0; i < this.inventories.length; i++)
                     {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 } **/

                return isError;
            },

        },
        methods: {
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        v.submitForm(e.target);
                    }
                });
            },


            // begin item search

            onItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    var inventory_id = v.inventories[index].inventory.id;
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchTransfer',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,

                            }
                        })
                        .then(function(response) {
                            v.inventories[index].item = null;
                            if (response.data.length > 0) {
                                v.inventories[index].item = response.data[0];
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            //ajax call to get items
            onItemSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {

                        params: {
                            member_id: v.member_id,
                            method_name: 'itemSearchNameRoll',
                            keyword: search,
                        },
                    })
                    .then(function(response) {
                        v.temp_items = [];

                        if (response.data.length > 0) {
                            v.temp_items = response.data;
                            // console.log('pp',response.data);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    });

            }, getDebounceTime()),

            //ajax call to get items code
            onItemLoadCode(selectedIndex) {
                v.selectedIndex = selectedIndex;

                if (v.inventories[selectedIndex].inventory != null) {
                    // console.log('klk',v.inventories[selectedIndex].inventory,v.main_inventories);
                    var inventory_id = v.inventories[selectedIndex].inventory.id;
                    let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSaleRoll',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                        .then(function(response) {
                            v.inventories[selectedIndex].item = null;
                            if (response.data.length > 0) {
                                v.inventories[selectedIndex].item = response.data[0];
                                // console.log('gg');

                                v.onItemSearchCodeSelect(selectedIndex);

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }



            },


            //ajax call to get items code
            onItemSearchCode: _.debounce((search, loading) => {

                // console.log('selectedIndex',v.selectedIndex);
                item_id = v.inventories[v.selectedIndex].item.id;
                if (v.inventories[v.selectedIndex].item.site != null) {
                    inventory_site = v.inventories[v.selectedIndex].item.site.site_id;
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                keyword: search,
                                item_id: item_id,
                                inventory_site: inventory_site,
                            }
                        })
                        .then(function(response) {
                            // v.subItems[v.selectedIndex] = [];
                            // v.subItemes = [];
                            if (response.data.length > 0) {
                                v.subItems[v.selectedIndex] = response.data;
                                v.subItemes = response.data;
                                // console.log('subItems', v.subItems);
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            }, getDebounceTime()),

            //ajax call to get items code
            onItemSearchCodeSelect(selectedIndex) {
                setTimeout(function() {

                    item_id = v.inventories[selectedIndex].item.id;
                    // console.log('plplpl', v.inventories[selectedIndex].item);
                    if (v.inventories[selectedIndex].item.site != null) {
                        inventory_site = v.inventories[selectedIndex].item.site.site_id;
                        console.log('selectedIndex', selectedIndex, item_id, inventory_site);
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'getAssebmliesSubSite',
                                    item_id: item_id,
                                    inventory_site: inventory_site,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // v.subItems[selectedIndex] = [];
                                    // v.subItemes = [];
                                    v.inventories[selectedIndex].item.code = null;
                                    v.subItems[selectedIndex] = response.data;
                                    v.subItemes = response.data;

                                    console.log('subItemss', v.subItems);
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                    }
                }, 200);
            },

            // delete item from list
            addIndex(index) {
                v.subItemes = [];
                v.selectedIndex = index;
                v.subItemes = this.subItems[index];

            },

            //ajax call to get items
            setIndex(e) {
                //v.temp_items=[];
                this.selected_index = e;
            },

            setNewRate(index) {
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].item.code && this.inventories[i].item.code != null) {
                            if (this.type=='transfer') {
                                this.inventories[i].item.code.qut_temp = this.$refs.qut_temp[i].value;
                            }
                            this.inventories[i].item.code.cost = this.$refs.cost[i].value;
                        }
                        if (this.type=='receiveTransfer') {
                            this.inventories[i].code = this.$refs.code[i].value;
                            this.inventories[i].quantity = this.$refs.qty[i].value;
                            this.inventories[i].cost = this.$refs.cost[i].value;
                        }
                    }
                }

                @if(getShowWing()!="false")
                // if (this.inventories[index].item && this.inventories[index].item != null) {
                //     if (this.inventories[index].item.code && this.inventories[index].item.code != null) {
                //         this.inventories[index].item.code.khada = this.$refs.khada[index].value;
                //     }
                // }
                @endif
            },

            change_khada(index) {
                @if(getShowWing()!="false")
                if (this.wing) {
                    if (this.inventories[index].item.code && this.inventories[index].item.code != null) {
                        if (this.inventories[index].item.code.OnHand && this.inventories[index].item.code.khada && this.inventories[index].item.khada) {
                            if (this.type=='transfer') {
                                var per = Number.parseFloat(this.inventories[index].item.code.OnHand / this.inventories[index].item.code.khada);
                                this.inventories[index].item.code.qut_temp = Number.parseFloat(this.inventories[index].item.khada * per).toFixed(7);
                            }
                        }
                    }
                }
                @endif
            },

            itemCategoryChange(index) {
                v.setIndex(index);
                v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                if (this.inventories[this.selected_index]['item_category'] != null) {
                    let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id
                            }
                        })
                        .then(function(response) {
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            // end item search

            // contract search


            // generic function for adding item to list
            addNew(type = null, index) {
                this.selected_index = index;
                this.selectedIndex = index;
                this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null,
                                item_category: this.selected_iventory_category,
                                quantity: null,
                                site: null,
                                code: null,
                                cost: null
                            });
                        }
                    }


                }

            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    console.log(type);
                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }

                }

            },
            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("transfer-form").submit()

                    } else {

                    }
                });

            },
            defaultValue() {
                this.selected_index = 0;

                this.inventories = [{
                    item: null,
                    item_category: this.selected_iventory_category,
                    quantity: null,
                    site: null,
                    code: null,
                    cost: null
                }, ];

                this.temp_items = [];

            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {

                            var url = "{{route('inventoryTransfer.store')}}";
                            form_id = 'transfer-form';
                            var data = $('#' + form_id).serialize();

                            axios.post(url, data)
                                .then(function(response) {
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        toastr.success('', response.data.message);

                                        v.defaultValue();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        },
        created: function() {

        }

    });
</script>


@endpush