@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('branch_transfer');
    $_date = in_array('date', $report);
    $_description = in_array('description', $report);
    $_reference_number = in_array('reference_number', $report);
    $_member = in_array('member', $report);
    $_type = in_array('type', $report);
    $_total_amount = in_array('total', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.BranchTransferReport')</h3>
  
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td class="center" >
                <div >  @lang('layout.Record') </div>
            </td>
            @if($_date)
                <td class="center">@lang('layout.Date')</td>@endif
            @if($_description)
                <td class="center">@lang('layout.Description')</td>@endif
            @if($_reference_number)
                <td class="center">@lang('layout.ReferenceNumber')</td>@endif
            @if($_member)
             <td class="center">@lang('layout.MemberName')</td>@endif
            @if($_type)
             <td class="center">@lang('layout.Type')</td>@endif
            @if($_total_amount)
                <td class="center">@lang('layout.TotalAmount')</td>@endif
                <td class="center">@lang('layout.User')</td>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total=0;
        ?>
        @foreach($data AS $record)
        <?php
        $total+=$record->total;
        ?>
            <tr>
                <td class="center">{{++$count}}</td>
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>@endif
                @if($_member)
                    <td class="center">{{$record->member_name}}</td>@endif
                @if($_type)
                    <td class="center">{{__('layout.'.ucfirst($record->type))}}</td>@endif
              
                @if($_total_amount)
                    <td class="center">{{$record->total}}</td>@endif
                    <td class="center">{{$record->user}}</td>
            </tr>
        @endforeach
    </table>
    <p>@lang('layout.Total'): {{$total}} {{getReportCurrency()}}</p>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection