@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'branch_transfer'"
                      @closed="closeModal">
            <div slot="body">
                  <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.SelectType')</label>
                                
                                    <select name="report_type" class="form-control">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="general">@lang('layout.General')</option>
                                    </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Member')</label>

                                <v-select label="name" :options="member" v-model="selected_member" @search="onMemberSearch"></v-select>
                                <input type="hidden" name="member_id" :value="(!selected_member)?null:selected_member.id">
                            </div>
                        </div>
                    </div>
                </div>


            
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.BranchTransferslist')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('branchTransfer-export')

                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                    </span>
                    @endpermission
                    @permission('branchTransfer-create')
                    <a href="{{route('branch.transfer.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="adjustment">
                    <thead>
                    <tr>
                        <th>@lang('layout.ID')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- <div id="factor-obj" >
        @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif
            </div> -->



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->
<iframe id="transferFrames" style="display: none;"></iframe>

@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

      @if (Session('transfer_id'))
        printBranchTransferBill("{{Session('transfer_id')}}")

        @endif

        function printBranchTransferBill(id) {

            var a = document.createElement('a');
            a.href = "{{url('branchTransfer/printBranchTransferBill')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }


        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#adjustment').DataTable({
                ajax: '{{route("branch.transfer.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [[0, "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'ref_no', name: 'ref_no'},
                    {data: 'type', name: 'type',orderable:false,searchable:false},
                    {data: 'date', name: 'date'},
                    {data: 'description', name: 'description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable:false, searchable:false}

                ]
            });

        });
        var vm = new Vue({

            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                member:[],
                selected_member:null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'members',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.member = [];
                            if (response.data.length > 0) {
                                vm.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });


        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>


@endpush
