@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewBranchTransfer') </span>
                </div>
                <div class="tools"></div>
            </div>

            <div id="branchTransfer" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- begin sale order modal -->

                <!-- end sale order modal -->

                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'branch.transfer.store','method' => 'POST','class' => 'form-horizontal','id'=>'branch-transfer-form'])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                            <input type="text" name="ref_no" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" name="date" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-8 col-md-9 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="3"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal.toFixed(precision())))}}</span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row">

                        <div v-if="type=='transfer'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Company')</label>
                                    <v-select label="name"  :options="company" v-model="selected_company"
                                              placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>

                                    <input type="hidden" name="to_company_id"
                                           :value="(!selected_company)?null:selected_company.id" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Company')">


                                        <span class="required">@{{ errors.first('to_company_id') }}</span>
                                </div>
                            </div>
                        </div>

                        <div v-if="type !='transfer'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.From')</label>
                                    <v-select label="name"  :options="company" v-model="selected_company"
                                              placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>

                                    <input type="hidden" name="from_company_id"
                                           :value="(!selected_company)?null:selected_company.id" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Company')">


                                        <span class="required">@{{ errors.first('from_company_id') }}</span>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <v-select label="name" :options="member" v-model="selected_member"
                                              placeholder="@lang('layout.SelectMember')"></v-select>
                                    <input type="hidden" name="member_id"
                                           :value="(!selected_member)?null:selected_member.id" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Member')">

                                        <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label" for="type">@lang('layout.Type')</label>
                                    <select name="type" v-model="type"  class="form-control" id ="type">
                                        <option value="transfer">@lang('layout.Transfer')</option>
                                        <option  value="receiveTransfer">@lang('layout.ReceiveTransfer')</option>
                                    </select>
                                </div>
                            </div>
                        </div>




                    </div>


                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 130px">@lang('layout.Category') </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName') </th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 80px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 80px">@lang('layout.OMeasureValue2')
                                </th>
                                <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 40px;"> @lang('layout.Cost')</th>
                                <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>

                                <th style="min-width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td >@{{index+1}}</td>
                                <td  v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" @keyup.native="onItemload(index)"
                                              @Click.native="onItemload
                                              (index)"
                                              v-model="item.inventory" :options="temp_items"
                                              @search="onItemSearch"></v-select>
                                    <input type="hidden" name="item[]" :value="(!item.item)?null:item.item.id">

                                </td>
                                <td  class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>

                                    <input type="hidden" name="from_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td>
                                    <input type="number" name="quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"

                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                <td  v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                <td  v-show="showWhat('other_measure2')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                </td>

                                <td >
                                    <template v-if="type =='transfer'">
                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                    </template>

                                    <template v-if="type !='transfer'">
                                        
                                        @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                    </template>
                                </td>
                                <td  class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                    </select>
                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td >
                                    <div class="input-group">
                                        <input type="number" name="cost[]" placeholder="@lang('layout.Cost')"
                                               v-model="(item.item==null)?null:item.item.cost"
                                                
                                                class="form-control" :readonly="type=='transfer'">
                                    </div>

                                </td>
                                <td >
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(item.item==null)?null:(item.item.cost)*((item.item==null)?null:item.item.quantity)"
                                               placeholder="@lang('layout.Total')" disabled>

                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>

                                </td>
                            </tr>
                            <tr>
                                <td colspan="12">
                                    <button class="btn btn-success" style="background-color: rgb(80, 129, 141) !important; border: 1px solid rgb(80, 129, 141); " @click.prevent="addNew()">
                                        <i class="fa fa-plus"></i>
                                    </button>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>
                        <!-- begin service -->

                    </div>
                    <button v-if="inventories.length <= 0 " type="button" class="btn default"
                            @click="addNew('inventory',0)">@lang('layout.AddItem')
                    </button>

                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" @click="handleSubmit($event)"
                                    class="btn green">@lang('layout.Submit')</button>
                        <!--     <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> -->

                            <a href="{{route('branch.transfer.index')}}" class="btn default">
                                <i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                            </a>

                        </div>
                    </div>


                </div>

                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif


        // end new member

        var inventory_category = {!! $inventory_category !!};
        var member = {!! $member !!};
        var company = {!! $company !!};
        var v = new Vue({
            el: '#branchTransfer',
            data: {
                temp_items: [],
                inventory_category: inventory_category,
                selected_index: 0,
                selected_iventory_category: null,

                inventories: [
                    {item: null, inventory: null,item_category:null},
                ],
                type_number: null,
                type: 'refund',
                member: member,
                selected_member: null,
                company:company,
                selected_company:null,
                type:'transfer'
            },
            computed: {
                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['cost'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit));
                            }

                        }

                    }

                    return sum;
                },

                // check payed amount

                // check data validation
                isError: function () {
                    var isError = false;
                   


                },
            },
            mounted:function()
            {
                
            },
            methods:
                {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("branch-transfer-form").submit()

                            }
                            else {

                            }
                        });

                    },

                    // search items based on type,type_number
                    searchType() {
                        if (this.type && this.type_number) {

                            axios.get("{{route('adjustment.item')}}", {
                                params: {
                                    type: this.type,
                                    type_number: this.type_number,
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];
                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                        v.inventories = [];
                                        for (var i = 0; i < response.data.length; i++) {

                                            v.inventories.push({item: response.data[i], inventory: response.data[i]});
                                        }
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.new_rate = this.$refs.in[index].value;
                            }
                        }

                    },
                    // calculate item price based on measure change
                    measureChange(index) {
                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // calculate item price based on measure change

                    onItemSearch: _.debounce((search, loading) => {

                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let url='itemSearchSale';
                            if(this.type=='transfer')
                            {
                                url='itemSearchSale';
                            }
                            else
                            {  // url='itemSearchPurchase';

                            }
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: url,
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },


                    // end item search

                    //ajax call to get items
                    setIndex(e) {
                        //v.temp_items=[];
                        this.selected_index = e;
                    },

                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];
                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },


                    // contract search


                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.inventories.push({item: null, inventory: null,item_category:null});
                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }

                        }

                    },

                    defaultValue() {
                        this.inventories = [
                            {item: null, inventory: null},
                        ];

                        this.temp_items = [];
                    },
                
                },


        });

    </script>



@endpush