@extends('layouts.app')
@section('style')
<link href="{{url('/assets/global/plugins/jstree/dist/themes/default/style.min.css')}}" rel="stylesheet" type="text/css" />

<style type="text/css">
    @media print{
        a[href]:after{
            content: none !important;
        }
    }
    #main {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #main th, #main td {
        padding: 5px 0px 5px 0px;
    }


    .doubleLine {
        text-decoration-line: underline;
        text-decoration-style: double;
        text-underline-position: under;
    }

    .modal-mask {
        position: fixed;
        z-index: 9998;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, .5);
        display: table;
        transition: opacity .3s ease;
    }

    .modal-wrapper {
        display: table-cell;
        vertical-align: middle;
    }

    .modal-container {
        width: 80%;
        max-width: 90%;
        margin: 0px auto;
        padding: 20px 30px;
        background-color: #fff;
        border-radius: 2px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
        transition: all .3s ease;
        font-family: Helvetica, Arial, sans-serif;
    }

    .modal-header h3 {
        margin-top: 0;
        color: #42b983;
    }

    .modal-body {
        margin: 20px 0;
    }

    .modal-default-button {
        float: right;
    }

    .modal-enter {
        opacity: 0;
    }

    .modal-leave-active {
        opacity: 0;
    }

    .modal-enter .modal-container,
    .modal-leave-active .modal-container {
        -webkit-transform: scale(1.1);
        transform: scale(1.1);
    }



    ul, #treeUL {
      list-style-type: none;
    }
    
    #treeUL {
        margin: 0;
        padding: 0;
    }
  
    .rt1 {
        font-size: 20px;
        font-weight: bold;
        /* color: green; */
    }     
    
    .rt1a {
        font-size: 20px;
        font-weight: bold;
        {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 30px !important;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: green; */
    }    
    .rt2 {
        font-size: 18px;
        font-weight: bold;
        /* color: purple; */
    }    
    .rt2a {
        font-size: 18px;
        font-weight: bold;
        {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 30px !important;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: purple; */
    }    
    .rt3 {
        font-size: 16px;
        font-weight: bold;
        /* color: red; */
    }    
    
    .rt3a {
        font-size: 16px;
        font-weight: bold;
        {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 30px !important;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: red; */
    }
    .rt4n{
        font-size: 14px;
        font-weight: bold;
        {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 30px !important;
        text-align: {{(session()->get("system_direction") == "rtl")?"right":"left"}}; 
        /* color: white; */
    }


    .mparent{
    /* padding: 4px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 30px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }          
    
    .fchild{
    /* padding: 8px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 60px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }          
    
    .schild{
    /* padding: 12px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 85px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }  

    .tchild{
    /* padding: 12px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 100px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }

    .rt4{
    padding: 0px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'left':'right'}};
    }
    a{
        color: black;
    }  
    a:hover{
        /* color: white; */
        text-decoration: none;
    }
    .asset{
        
    }     
    .currentasset{
        
    } 

    .assetOther{
        
    }     
    .assetBank{
        
    }    
    .assetReceiv{
        
    }     
    
    .fixasset{
        
    }     
    .otherasset{
        
    }    
    .lib{
        
    }    
    
    .libPay{
        
    }    
    
    .equity{
        
    }

    hr {
        margin: 0px 0;
        border-top: 2px solid #eee;
    }

    /*
    li {
        font-size: 16px;
        color: crimson;
        font-weight: 500;
    }
    .rootTree::before {
        content: "\25B6";
        color: black;
        display: inline-block;
        margin-right: 6px;
    }
    .rootTree-down::before {
        transform: rotate(90deg);
    }
    .children {
        display: none;
    }
    .active {
        display: block;
    }   */


</style>
@stop
@section('content')

<div id="print-modal" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'blanceSheet1'" @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                <span class="input-group-addon"> @lang('layout.To')</span>
                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

<!-- BEGIN EXAMPLE TABLE PORTLET-->
<div class="portlet light bordered">
    <div class="portlet-title hidden-print">
        <div class="caption font-dark">
            @lang('menu.BalanceSheet')
        </div>
        <div class="tools"> </div>
        <div class="btn-group pull-right hidden-print" style="display: flex;gap: 3px;">
            @permission(['balancesheet-list'])
            <a href="{{route('blanceSheet.index')}}">
                <button class="btn btn-success">
                    <i class="fa fa-file"></i> @lang('layout.Default')
                </button>
            </a>
            @endpermission

            @permission('balancesheet-export')
            <a onclick="window.print()" class="hidden-print btn btn-success">
                <i class="fa fa-print"></i>
            </a>
            <!-- <span id="anchore-modal">
                <button type="submit" @click.prevent="showModal" class="btn btn-success">
                    <i class="fa fa-print"></i>
                </button>
            </span> -->
            @endpermission
        </div>
    </div>
    <div class="portlet-body">
        <div class="hidden-print">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12" style="border: 1px solid rgba(198, 198, 198, 0.907);padding: 25px 25px 0px 25px;border-radius: 5px;margin-bottom: 10px;">
                <table class="table table-striped  table-advance" style="width: 100%;">
                    <tr>
                        <td colspan="5" style="text-align: center; font-size:16px;font-weight:bold;color:black">
                            {!!company()['name']!!}
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5" style="text-align: center;">
                            @lang('menu.BalanceSheetByPrevYearComparison')
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5" style="text-align: center;">
                        {{$date}}
                        </td>
                    </tr>
                </table>
            </div>
            
            <div class="col-md-12 col-sm-12" style="border: 1px solid rgba(198, 198, 198, 0.907); padding: 25px;border-radius: 5px;">
                <ul id="treeUL">
                    <div class="asset">
                        <li>
                            <table class="" id="main">
                                <tr style="background-color: rgb(207, 207, 207);">
                                    <td style="width: 30%;" class="rt1 text-center" >@lang('layout.Account')</td>
                                    <td class="rt1a doubleLine" style="width: 20%;">@lang('layout.Total')</b></td>
                                    <td class="rt1a doubleLine" style="width: 20%;">@lang('layout.TotalLastYear')</b></td>
                                    <td class="rt1a doubleLine" style="width: 20%;">@lang('layout.Change') {{getHomeCurrency()['symbol']}}</b></td>
                                    <td class="rt1a doubleLine" style="width: 10%;">@lang('layout.Change')%</b></td>
                                </tr>

                            </table>
                        </li>
                        <li>
                            <table id="main">
                                <tr>
                                    <td style="width: 100%;" class="rt1">@lang('layout.Assets') </td>
                                </tr>
                            </table>
                            <ul class="children">
                                <div class="currentasset">
                                    <li>
                                        <table id="main" class="rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.CurrentAssets') </td>
                                            </tr>
                                        </table>

                                        <ul class="children">
                                            <div class="assetOther">
                                                <li>
                                                    <table id="main" class="rt3">
                                                        <tr>
                                                            <td colspan="2">@lang('layout.OtherCurrentAssets') </td>
                                                        </tr>
                                                    </table>
                                                    <ul class="children">
                                                        <table id="main" class=" main-table">
                                                            @foreach($otherCurrentAsset as $accountRow)
                                                            @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] !=
                                                            0 || !empty($accountRow['children']))
                                                            <tr>
                                                                <td class="mparent" style="width: 30%;">
                                                                    <a
                                                                        href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['Amount'])}}</td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['LAmount'])}}</td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['Amount']-
                                                                    $accountRow['LAmount'])}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                                <td class="rt4" style="width: 10%;">
                                                                    @if($accountRow['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <!-- begin first chiled -->
                                                            @if(!empty($accountRow['children']) && getShowSubAccount()
                                                            !="false")
                                                            @foreach($accountRow['children'] as $key=>$fc)
                                                            @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 ||
                                                            !empty($fc['children']))
                                                            <tr>
                                                                <td class="fchild" style="width: 30%; ">
                                                                    <b>{{$key+1}}</b> <a
                                                                        href="{{url('/account/'.$fc['id'])}}"
                                                                        class="report_a">{{$fc['AccountName']}}</a>
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['Amount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['Amount']-$fc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 10%;">
                                                                    @if(!empty($fc['children']))
                                                                    @if($fc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                                                    @endif
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <!-- begin second chiled -->
                                                            @if(!empty($fc['children']))
                                                            @foreach($fc['children'] as $key1=>$sc)
                                                            @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                            <tr>
                                                                <td class="schild">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$sc['id'])}}"
                                                                        class="report_a">{{$sc['AccountName']}}</a>
                                                                    <br>
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['Amount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['Amount']-$sc['LAmount'])
                                                                    }}
                                                                </td>
                                                                <td class="rt4">
                                                                    @if($sc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- begin therd chiled -->
                                                            @if(!empty($sc['children']))
                                                            @foreach($sc['children'] as $key2=>$tc)
                                                            @if($tc['Amount'] != 0 || $tc['LAmount'] != 0 ||
                                                            !empty($tc['children']))
                                                            <tr>
                                                                <td class="tchild">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$tc['id'])}}"
                                                                        class="report_a">{{$tc['AccountName']}}</a>
                                                                    <br>
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['Amount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['Amount']-$tc['LAmount'])
                                                                    }}
                                                                </td>
                                                                <td class="rt4">
                                                                    @if($tc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($sc['children']))
                                                            <tr class="borders">
                                                                <td class="schild" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$sc['AccountName']}} </td>
                                                                <td class="rt4" style="width:20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['total'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    @if($sc['Ltotal'] == 0)
                                                                    [100]
                                                                    @else
                                                                    [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                                                    @endif
                                                                    @endif

                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end therd child -->
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($fc['children']))
                                                            <tr class="borders">
                                                                <td class="fchild" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$fc['AccountName']}} </td>
                                                                <td class="rt4" style="width:20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['total'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    @if($fc['Ltotal'] == 0)
                                                                    [100]
                                                                    @else
                                                                    [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                                                    @endif
                                                                    @endif

                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end second child -->
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($accountRow['children']))
                                                            <tr class="borders">
                                                                <td class="mparent" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$accountRow['AccountName']}} </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['total'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['Ltotal'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    @if($accountRow['Ltotal'] == 0)
                                                                    (100)
                                                                    @else
                                                                    ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                                                    @endif

                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end first chiled -->
                                                            @endif
                                                            @endforeach
                                                        </table>
                                                    </ul>
                                                </li>
                                                <hr>
                                                <li>
                                                    <table id="main">
                                                        <tr>
                                                            <td class="rt3" style="width: 30%;">
                                                                @lang('layout.TotalOtherCurrentAssets') </td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalOtherCurrentAsset)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalOtherCurrentAssetLast)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalOtherCurrentAsset -
                                                                $TotalOtherCurrentAssetLast)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                            <td class="rt3a doubleLine" style="width: 10%;">
                                                                @if($TotalOtherCurrentAssetLast == 0)
                                                                100 %
                                                                @else
                                                                {{myRound((($TotalOtherCurrentAsset -
                                                                $TotalOtherCurrentAssetLast)*100)/$TotalOtherCurrentAssetLast)}}
                                                                %
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </li>
                                            </div>
                                            <div class="assetBank">
                                                <li>
                                                    <table id="main" class="rt3">
                                                        <tr>
                                                            <td colspan="2">@lang('layout.Checking/Savings') </td>
                                                        </tr>
                                                    </table>

                                                    <ul class="children">
                                                        <table id="main" class=" main-table">
                                                            @foreach($banks as $accountRow)
                                                            @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] !=
                                                            0 || !empty($accountRow['children']))
                                                            <tr>
                                                                <td class="mparent" style="width: 30%;">
                                                                    <a
                                                                        href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['Amount'])}}</td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['LAmount'])}}</td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['Amount']-
                                                                    $accountRow['LAmount'])}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                                <td class="rt4" style="width: 10%;">
                                                                    @if($accountRow['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <!-- begin first chiled -->
                                                            @if(!empty($accountRow['children']) && getShowSubAccount()
                                                            !="false")
                                                            @foreach($accountRow['children'] as $key=>$fc)
                                                            @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 ||
                                                            !empty($fc['children']))
                                                            <tr>
                                                                <td class="fchild" style="width: 30%; ">
                                                                    <b>{{$key+1}}</b> <a
                                                                        href="{{url('/account/'.$fc['id'])}}"
                                                                        class="report_a">{{$fc['AccountName']}}</a>
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['Amount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['Amount']-$fc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 10%;">
                                                                    @if(!empty($fc['children']))
                                                                    @if($fc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                                                    @endif
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <!-- begin second chiled -->
                                                            @if(!empty($fc['children']))
                                                            @foreach($fc['children'] as $key1=>$sc)
                                                            @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                            <tr>
                                                                <td class="schild">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$sc['id'])}}"
                                                                        class="report_a">{{$sc['AccountName']}}</a>
                                                                    <br>
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['Amount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['Amount']-$sc['LAmount'])
                                                                    }}
                                                                </td>
                                                                <td class="rt4">
                                                                    @if($sc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- begin therd chiled -->
                                                            @if(!empty($sc['children']))
                                                            @foreach($sc['children'] as $key2=>$tc)
                                                            @if($tc['Amount'] != 0 || $tc['LAmount'] != 0 ||
                                                            !empty($tc['children']))
                                                            <tr>
                                                                <td class="tchild">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$tc['id'])}}"
                                                                        class="report_a">{{$tc['AccountName']}}</a>
                                                                    <br>
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['Amount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['Amount']-$tc['LAmount'])
                                                                    }}
                                                                </td>
                                                                <td class="rt4">
                                                                    @if($tc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($sc['children']))
                                                            <tr class="borders">
                                                                <td class="schild" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$sc['AccountName']}} </td>
                                                                <td class="rt4" style="width:20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['total'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    @if($sc['Ltotal'] == 0)
                                                                    [100]
                                                                    @else
                                                                    [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                                                    @endif
                                                                    @endif

                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end therd child -->
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($fc['children']))
                                                            <tr class="borders">
                                                                <td class="fchild" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$fc['AccountName']}} </td>
                                                                <td class="rt4" style="width:20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['total'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    @if($fc['Ltotal'] == 0)
                                                                    [100]
                                                                    @else
                                                                    [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                                                    @endif
                                                                    @endif

                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end second child -->
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($accountRow['children']))
                                                            <tr class="borders">
                                                                <td class="mparent" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$accountRow['AccountName']}} </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['total'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['Ltotal'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    @if($accountRow['Ltotal'] == 0)
                                                                    (100)
                                                                    @else
                                                                    ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                                                    @endif

                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end first chiled -->
                                                            @endif
                                                            @endforeach
                                                        </table>
                                                    </ul>
                                                </li>
                                                <hr>
                                                <li>
                                                    <table id="main">
                                                        <tr>
                                                            <td class="rt3" style="width: 30%;">
                                                                @lang('layout.TotalChecking/Savings') </td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalBanks)}} {{getHomeCurrency()['symbol']}}
                                                            </td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalBanksLast)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalBanks - $TotalBanksLast)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                            <td class="rt3a doubleLine" style="width: 10%;">
                                                                @if($TotalBanksLast == 0)
                                                                100 %
                                                                @else
                                                                {{myRound((($TotalBanks -
                                                                $TotalBanksLast)*100)/$TotalBanksLast)}} %
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </li>
                                            </div>
                                            <div class="assetReceiv">

                                                <li>
                                                    <table id="main" class="rt3">
                                                        <tr>
                                                            <td colspan="2">@lang('layout.AccountsReceivable') </td>
                                                        </tr>
                                                    </table>
                                                    <ul class="children">
                                                        <table id="main" class=" main-table">
                                                            @foreach($accountReceivable as $accountRow)
                                                            @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] !=
                                                            0 || !empty($accountRow['children']))
                                                            <tr>
                                                                <td class="mparent" style="width: 30%;">
                                                                    <a
                                                                        href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['Amount'])}}</td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['LAmount'])}}</td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($accountRow['Amount']-
                                                                    $accountRow['LAmount'])}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                                <td class="rt4" style="width: 10%;">
                                                                    @if($accountRow['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <!-- begin first chiled -->
                                                            @if(!empty($accountRow['children']) && getShowSubAccount()
                                                            !="false")
                                                            @foreach($accountRow['children'] as $key=>$fc)
                                                            @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 ||
                                                            !empty($fc['children']))
                                                            <tr>
                                                                <td class="fchild" style="width: 30%; ">
                                                                    <b>{{$key+1}}</b> <a
                                                                        href="{{url('/account/'.$fc['id'])}}"
                                                                        class="report_a">{{$fc['AccountName']}}</a>
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['Amount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($fc['Amount']-$fc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4" style="width: 10%;">
                                                                    @if(!empty($fc['children']))
                                                                    @if($fc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                                                    @endif
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <!-- begin second chiled -->
                                                            @if(!empty($fc['children']))
                                                            @foreach($fc['children'] as $key1=>$sc)
                                                            @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                            <tr>
                                                                <td class="schild">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$sc['id'])}}"
                                                                        class="report_a">{{$sc['AccountName']}}</a>
                                                                    <br>
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['Amount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($sc['Amount']-$sc['LAmount'])
                                                                    }}
                                                                </td>
                                                                <td class="rt4">
                                                                    @if($sc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- begin therd chiled -->
                                                            @if(!empty($sc['children']))
                                                            @foreach($sc['children'] as $key2=>$tc)
                                                            @if($tc['Amount'] != 0 || $tc['LAmount'] != 0 ||
                                                            !empty($tc['children']))
                                                            <tr>
                                                                <td class="tchild">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$tc['id'])}}"
                                                                        class="report_a">{{$tc['AccountName']}}</a>
                                                                    <br>
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['Amount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['LAmount']) }}
                                                                </td>
                                                                <td class="rt4">{{myRound($tc['Amount']-$tc['LAmount'])
                                                                    }}
                                                                </td>
                                                                <td class="rt4">
                                                                    @if($tc['LAmount'] == 0)
                                                                    100
                                                                    @else
                                                                    {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($sc['children']))
                                                            <tr class="borders">
                                                                <td class="schild" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$sc['AccountName']}} </td>
                                                                <td class="rt4" style="width:20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['total'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($sc['children']))
                                                                    @if($sc['Ltotal'] == 0)
                                                                    [100]
                                                                    @else
                                                                    [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                                                    @endif
                                                                    @endif

                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end therd child -->
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($fc['children']))
                                                            <tr class="borders">
                                                                <td class="fchild" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$fc['AccountName']}} </td>
                                                                <td class="rt4" style="width:20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['total'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                                                    @endif

                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($fc['children']))
                                                                    @if($fc['Ltotal'] == 0)
                                                                    [100]
                                                                    @else
                                                                    [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                                                    @endif
                                                                    @endif

                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end second child -->
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            @if(!empty($accountRow['children']))
                                                            <tr class="borders">
                                                                <td class="mparent" style="width: 30%;">
                                                                    @lang('layout.Total')
                                                                    {{$accountRow['AccountName']}} </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['total'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['Ltotal'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                                                    @endif
                                                                </td>
                                                                <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                                    @if(!empty($accountRow['children']))
                                                                    @if($accountRow['Ltotal'] == 0)
                                                                    (100)
                                                                    @else
                                                                    ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                                                    @endif

                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <!-- end first chiled -->
                                                            @endif
                                                            @endforeach
                                                        </table>
                                                    </ul>
                                                </li>
                                                <hr>
                                                <li>
                                                    <table id="main">
                                                        <tr>
                                                            <td class="rt3" style="width: 30%;">
                                                                @lang('layout.TotalAccountsReceivable') </td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalaccountReceivable)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalaccountReceivableLast)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                            <td class="rt3a doubleLine" style="width: 20%;">
                                                                {{myRound($TotalaccountReceivable -
                                                                $TotalaccountReceivableLast)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                            <td class="rt3a doubleLine" style="width: 10%;">
                                                                @if($TotalaccountReceivableLast == 0)
                                                                100 %
                                                                @else
                                                                {{myRound((($TotalaccountReceivable -
                                                                $TotalaccountReceivableLast)*100)/$TotalaccountReceivableLast)}}
                                                                %
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </li>
                                            </div>
                                        </ul>
                                    </li>
                                    <hr>
                                    <li>
                                        <table id="main">
                                            <tr>
                                                <td class="rt2" style="width: 30%;">@lang('layout.TotalCurrentAssets')
                                                </td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalCurrentAsset)}} {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalCurrentAssetLast)}} {{getHomeCurrency()['symbol']}}
                                                </td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalCurrentAsset - $TotalCurrentAssetLast)}}
                                                    {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 10%;">
                                                    @if($TotalCurrentAssetLast == 0)
                                                    100 %
                                                    @else
                                                    {{myRound((($TotalCurrentAsset -
                                                    $TotalCurrentAssetLast)*100)/$TotalCurrentAssetLast)}} %
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </li>
                                </div>
                                <div class="fixasset">
                                    <li class="">
                                        <table id="main" class="rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.FixAsset') </td>
                                            </tr>
                                        </table>
                                        <ul class="children">
                                            <table id="main" class=" main-table">
                                                @foreach($fixedAssets as $accountRow)
                                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 ||
                                                !empty($accountRow['children']))
                                                <tr>
                                                    <td class="mparent" style="width: 30%;">
                                                        <a
                                                            href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($accountRow['Amount'])}}</td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($accountRow['LAmount'])}}</td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($accountRow['Amount']-
                                                        $accountRow['LAmount'])}} {{getHomeCurrency()['symbol']}}</td>
                                                    <td class="rt4" style="width: 10%;">
                                                        @if($accountRow['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                <!-- begin first chiled -->
                                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                                @foreach($accountRow['children'] as $key=>$fc)
                                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 ||
                                                !empty($fc['children']))
                                                <tr>
                                                    <td class="fchild" style="width: 30%; ">
                                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                                            class="report_a">{{$fc['AccountName']}}</a>
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($fc['Amount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($fc['Amount']-$fc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 10%;">
                                                        @if(!empty($fc['children']))
                                                        @if($fc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                                        @endif
                                                        @endif
                                                    </td>
                                                </tr>
                                                <!-- begin second chiled -->
                                                @if(!empty($fc['children']))
                                                @foreach($fc['children'] as $key1=>$sc)
                                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                <tr>
                                                    <td class="schild">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$sc['id'])}}"
                                                            class="report_a">{{$sc['AccountName']}}</a>
                                                        <br>
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">
                                                        @if($sc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- begin therd chiled -->
                                                @if(!empty($sc['children']))
                                                @foreach($sc['children'] as $key2=>$tc)
                                                @if($tc['Amount'] != 0 || $tc['LAmount'] != 0 ||
                                                !empty($tc['children']))
                                                <tr>
                                                    <td class="tchild">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$tc['id'])}}"
                                                            class="report_a">{{$tc['AccountName']}}</a>
                                                        <br>
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">
                                                        @if($tc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                @endforeach
                                                @endif
                                                @if(!empty($sc['children']))
                                                <tr class="borders">
                                                    <td class="schild" style="width: 30%;"> @lang('layout.Total')
                                                        {{$sc['AccountName']}} </td>
                                                    <td class="rt4" style="width:20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['total'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        @if($sc['Ltotal'] == 0)
                                                        [100]
                                                        @else
                                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                                        @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end therd child -->
                                                @endforeach
                                                @endif
                                                @if(!empty($fc['children']))
                                                <tr class="borders">
                                                    <td class="fchild" style="width: 30%;"> @lang('layout.Total')
                                                        {{$fc['AccountName']}} </td>
                                                    <td class="rt4" style="width:20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['total'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        @if($fc['Ltotal'] == 0)
                                                        [100]
                                                        @else
                                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                                        @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end second child -->
                                                @endif
                                                @endforeach
                                                @endif
                                                @if(!empty($accountRow['children']))
                                                <tr class="borders">
                                                    <td class="mparent" style="width: 30%;"> @lang('layout.Total')
                                                        {{$accountRow['AccountName']}} </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['total'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['Ltotal'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        @if($accountRow['Ltotal'] == 0)
                                                        (100)
                                                        @else
                                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                                        @endif

                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end first chiled -->
                                                @endif
                                                @endforeach
                                            </table>
                                        </ul>
                                    </li>
                                    <hr>
                                    <li>
                                        <table id="main">
                                            <tr>
                                                <td class="rt2" style="width: 30%;">@lang('layout.TotalFixedAssets')
                                                </td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalfixedAssets)}} {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalfixedAssetsLast)}} {{getHomeCurrency()['symbol']}}
                                                </td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalfixedAssets - $TotalfixedAssetsLast)}}
                                                    {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 10%;">
                                                    @if($TotalfixedAssetsLast == 0)
                                                    100 %
                                                    @else
                                                    {{myRound((($TotalfixedAssets -
                                                    $TotalfixedAssetsLast)*100)/$TotalfixedAssetsLast)}} %
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </li>
                                </div>
                                <div class="otherasset">
                                    <li class="">
                                        <table id="main" class="rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.OtherAssets') </td>
                                            </tr>
                                        </table>
                                        <ul class="children">
                                            <table id="main" class=" main-table">
                                                @foreach($otherAssets as $accountRow)
                                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 ||
                                                !empty($accountRow['children']))
                                                <tr>
                                                    <td class="mparent" style="width: 30%;">
                                                        <a
                                                            href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($accountRow['Amount'])}}</td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($accountRow['LAmount'])}}</td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($accountRow['Amount']-
                                                        $accountRow['LAmount'])}} {{getHomeCurrency()['symbol']}}</td>
                                                    <td class="rt4" style="width: 10%;">
                                                        @if($accountRow['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                <!-- begin first chiled -->
                                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                                @foreach($accountRow['children'] as $key=>$fc)
                                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 ||
                                                !empty($fc['children']))
                                                <tr>
                                                    <td class="fchild" style="width: 30%; ">
                                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                                            class="report_a">{{$fc['AccountName']}}</a>
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($fc['Amount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($fc['Amount']-$fc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 10%;">
                                                        @if(!empty($fc['children']))
                                                        @if($fc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                                        @endif
                                                        @endif
                                                    </td>
                                                </tr>
                                                <!-- begin second chiled -->
                                                @if(!empty($fc['children']))
                                                @foreach($fc['children'] as $key1=>$sc)
                                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                <tr>
                                                    <td class="schild">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$sc['id'])}}"
                                                            class="report_a">{{$sc['AccountName']}}</a>
                                                        <br>
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">
                                                        @if($sc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- begin therd chiled -->
                                                @if(!empty($sc['children']))
                                                @foreach($sc['children'] as $key2=>$tc)
                                                @if($tc['Amount'] != 0 || $tc['LAmount'] != 0 ||
                                                !empty($tc['children']))
                                                <tr>
                                                    <td class="tchild">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$tc['id'])}}"
                                                            class="report_a">{{$tc['AccountName']}}</a>
                                                        <br>
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">
                                                        @if($tc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                @endforeach
                                                @endif
                                                @if(!empty($sc['children']))
                                                <tr class="borders">
                                                    <td class="schild" style="width: 30%;"> @lang('layout.Total')
                                                        {{$sc['AccountName']}} </td>
                                                    <td class="rt4" style="width:20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['total'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        @if($sc['Ltotal'] == 0)
                                                        [100]
                                                        @else
                                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                                        @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end therd child -->
                                                @endforeach
                                                @endif
                                                @if(!empty($fc['children']))
                                                <tr class="borders">
                                                    <td class="fchild" style="width: 30%;"> @lang('layout.Total')
                                                        {{$fc['AccountName']}} </td>
                                                    <td class="rt4" style="width:20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['total'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        @if($fc['Ltotal'] == 0)
                                                        [100]
                                                        @else
                                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                                        @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end second child -->
                                                @endif
                                                @endforeach
                                                @endif
                                                @if(!empty($accountRow['children']))
                                                <tr class="borders">
                                                    <td class="mparent" style="width: 30%;"> @lang('layout.Total')
                                                        {{$accountRow['AccountName']}} </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['total'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['Ltotal'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        @if($accountRow['Ltotal'] == 0)
                                                        (100)
                                                        @else
                                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                                        @endif

                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end first chiled -->
                                                @endif
                                                @endforeach
                                            </table>
                                        </ul>
                                    </li>
                                    <hr>
                                    <li>
                                        <table id="main">
                                            <tr>
                                                <td class="rt2" style="width: 30%;">@lang('layout.TotalOtherAssets')
                                                </td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalotherAssets)}} {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalotherAssetsLast)}} {{getHomeCurrency()['symbol']}}
                                                </td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalotherAssets - $TotalotherAssetsLast)}}
                                                    {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 10%;">
                                                    @if($TotalotherAssetsLast == 0)
                                                    100 %
                                                    @else
                                                    {{myRound((($TotalotherAssets -
                                                    $TotalotherAssetsLast)*100)/$TotalotherAssetsLast)}} %
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </li>
                                </div>
                            </ul>
                        </li>
                        <hr>
                        <li>
                            <table id="main">
                                <tr>
                                    <td style="width: 30%;" class="rt1"> @lang('layout.TotalAssets')</td>
                                    <td class="rt1a doubleLine" style="width: 20%;">{{myRound($totalAsset)}}
                                        {{getHomeCurrency()['symbol']}}</td>
                                    <td class="rt1a doubleLine" style="width: 20%;">{{myRound($totalAssetLast)}}
                                        {{getHomeCurrency()['symbol']}}</td>
                                    <td class="rt1a doubleLine" style="width: 20%;">{{myRound($totalAsset -
                                        $totalAssetLast)}} {{getHomeCurrency()['symbol']}}</td>
                                    <td class="rt1a doubleLine" style="width: 10%;">
                                        @if($totalAssetLast == 0)
                                        100 %
                                        @else
                                        {{myRound((($totalAsset - $totalAssetLast)*100)/$totalAssetLast)}} %
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </li>
                    </div>

                    <div class="lib">
                        <li>
                            <table id="main" class="rt1">
                                <tr>
                                    <td colspan="2">@lang('layout.LiabilitiesAndEquity') </td>
                                </tr>
                            </table>

                            <ul class="children">
                                <div class="libPay">
                                    <li>
                                        <table id="main" class=" rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.Liabilities') </td>
                                            </tr>
                                        </table>

                                        <ul class="children">
                                            <table id="main" class=" main-table">
                                                @foreach($liability as $accountRow)
                                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 ||
                                                !empty($accountRow['children']))
                                                <tr>
                                                    <td class="mparent" style="width: 30%;">
                                                        <a
                                                            href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($accountRow['Amount'])}}</td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($accountRow['LAmount'])}}</td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($accountRow['Amount']-
                                                        $accountRow['LAmount'])}} {{getHomeCurrency()['symbol']}}</td>
                                                    <td class="rt4" style="width: 10%;">
                                                        @if($accountRow['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                <!-- begin first chiled -->
                                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                                @foreach($accountRow['children'] as $key=>$fc)
                                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 ||
                                                !empty($fc['children']))
                                                <tr>
                                                    <td class="fchild" style="width: 30%; ">
                                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                                            class="report_a">{{$fc['AccountName']}}</a>
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($fc['Amount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($fc['Amount']-$fc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 10%;">
                                                        @if(!empty($fc['children']))
                                                        @if($fc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                                        @endif
                                                        @endif
                                                    </td>
                                                </tr>
                                                <!-- begin second chiled -->
                                                @if(!empty($fc['children']))
                                                @foreach($fc['children'] as $key1=>$sc)
                                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                <tr>
                                                    <td class="schild">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$sc['id'])}}"
                                                            class="report_a">{{$sc['AccountName']}}</a>
                                                        <br>
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">
                                                        @if($sc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- begin therd chiled -->
                                                @if(!empty($sc['children']))
                                                @foreach($sc['children'] as $key2=>$tc)
                                                @if($tc['Amount'] != 0 || $tc['LAmount'] != 0 ||
                                                !empty($tc['children']))
                                                <tr>
                                                    <td class="tchild">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$tc['id'])}}"
                                                            class="report_a">{{$tc['AccountName']}}</a>
                                                        <br>
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">
                                                        @if($tc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                @endforeach
                                                @endif
                                                @if(!empty($sc['children']))
                                                <tr class="borders">
                                                    <td class="schild" style="width: 30%;"> @lang('layout.Total')
                                                        {{$sc['AccountName']}} </td>
                                                    <td class="rt4" style="width:20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['total'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        @if($sc['Ltotal'] == 0)
                                                        [100]
                                                        @else
                                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                                        @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end therd child -->
                                                @endforeach
                                                @endif
                                                @if(!empty($fc['children']))
                                                <tr class="borders">
                                                    <td class="fchild" style="width: 30%;"> @lang('layout.Total')
                                                        {{$fc['AccountName']}} </td>
                                                    <td class="rt4" style="width:20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['total'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        @if($fc['Ltotal'] == 0)
                                                        [100]
                                                        @else
                                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                                        @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end second child -->
                                                @endif
                                                @endforeach
                                                @endif
                                                @if(!empty($accountRow['children']))
                                                <tr class="borders">
                                                    <td class="mparent" style="width: 30%;"> @lang('layout.Total')
                                                        {{$accountRow['AccountName']}} </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['total'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['Ltotal'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        @if($accountRow['Ltotal'] == 0)
                                                        (100)
                                                        @else
                                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                                        @endif

                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end first chiled -->
                                                @endif
                                                @endforeach
                                            </table>
                                        </ul>
                                    </li>
                                    <hr>
                                    <li>
                                        <table id="main">
                                            <tr>
                                                <td class="rt2" style="width: 30%;">@lang('layout.TotalLiabilities')
                                                </td>
                                                <td class="rt1a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalLiability)}} {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt1a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalLiabilityLast)}} {{getHomeCurrency()['symbol']}}
                                                </td>
                                                <td class="rt1a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalLiability - $TotalLiabilityLast)}}
                                                    {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt1a doubleLine" style="width: 10%;">
                                                    @if($TotalLiabilityLast == 0)
                                                    100 %
                                                    @else
                                                    {{myRound((($TotalLiability -
                                                    $TotalLiabilityLast)*100)/$TotalLiabilityLast)}} %
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </li>
                                </div>
                            </ul>

                            <ul class="children">
                                <div class="equity">
                                    <li>
                                        <table id="main" class="rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.Equity') </td>
                                            </tr>
                                        </table>
                                        <ul class="children">
                                            <table id="main" class=" main-table">
                                                @foreach($equity as $accountRow)
                                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 ||
                                                !empty($accountRow['children']))
                                                <tr>
                                                    <td class="mparent" style="width: 30%;">
                                                        <a
                                                            href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($accountRow['Amount'])}}</td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($accountRow['LAmount'])}}</td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($accountRow['Amount']-
                                                        $accountRow['LAmount'])}} {{getHomeCurrency()['symbol']}}</td>
                                                    <td class="rt4" style="width: 10%;">
                                                        @if($accountRow['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                <!-- begin first chiled -->
                                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                                @foreach($accountRow['children'] as $key=>$fc)
                                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 ||
                                                !empty($fc['children']))
                                                <tr>
                                                    <td class="fchild" style="width: 30%; ">
                                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                                            class="report_a">{{$fc['AccountName']}}</a>
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($fc['Amount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($fc['Amount']-$fc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4" style="width: 10%;">
                                                        @if(!empty($fc['children']))
                                                        @if($fc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                                        @endif
                                                        @endif
                                                    </td>
                                                </tr>
                                                <!-- begin second chiled -->
                                                @if(!empty($fc['children']))
                                                @foreach($fc['children'] as $key1=>$sc)
                                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                <tr>
                                                    <td class="schild">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$sc['id'])}}"
                                                            class="report_a">{{$sc['AccountName']}}</a>
                                                        <br>
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">
                                                        @if($sc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- begin therd chiled -->
                                                @if(!empty($sc['children']))
                                                @foreach($sc['children'] as $key2=>$tc)
                                                @if($tc['Amount'] != 0 || $tc['LAmount'] != 0 ||
                                                !empty($tc['children']))
                                                <tr>
                                                    <td class="tchild">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$tc['id'])}}"
                                                            class="report_a">{{$tc['AccountName']}}</a>
                                                        <br>
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                                    </td>
                                                    <td class="rt4">
                                                        @if($tc['LAmount'] == 0)
                                                        100
                                                        @else
                                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                @endforeach
                                                @endif
                                                @if(!empty($sc['children']))
                                                <tr class="borders">
                                                    <td class="schild" style="width: 30%;"> @lang('layout.Total')
                                                        {{$sc['AccountName']}} </td>
                                                    <td class="rt4" style="width:20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['total'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($sc['children']))
                                                        @if($sc['Ltotal'] == 0)
                                                        [100]
                                                        @else
                                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                                        @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end therd child -->
                                                @endforeach
                                                @endif
                                                @if(!empty($fc['children']))
                                                <tr class="borders">
                                                    <td class="fchild" style="width: 30%;"> @lang('layout.Total')
                                                        {{$fc['AccountName']}} </td>
                                                    <td class="rt4" style="width:20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['total'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                                        @endif

                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($fc['children']))
                                                        @if($fc['Ltotal'] == 0)
                                                        [100]
                                                        @else
                                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                                        @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end second child -->
                                                @endif
                                                @endforeach
                                                @endif
                                                @if(!empty($accountRow['children']))
                                                <tr class="borders">
                                                    <td class="mparent" style="width: 30%;"> @lang('layout.Total')
                                                        {{$accountRow['AccountName']}} </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['total'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['Ltotal'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 20%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                                        @endif
                                                    </td>
                                                    <td class="rt4" style="width: 10%; font-weight:bolder;">
                                                        @if(!empty($accountRow['children']))
                                                        @if($accountRow['Ltotal'] == 0)
                                                        (100)
                                                        @else
                                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                                        @endif

                                                        @endif
                                                    </td>
                                                </tr>
                                                @endif
                                                <!-- end first chiled -->
                                                @endif
                                                @endforeach
                                                <tr>
                                                    <td class="rt4n" style="width: 30%;">
                                                        @lang('layout.NetProfit/NetIncome')</td>
                                                    <td class="rt4 doubleLine" style="width: 20%;">
                                                        {{myRound($netProfit)}} {{getHomeCurrency()['symbol']}}</td>
                                                    <td class="rt4 doubleLine" style="width: 20%;">
                                                        {{myRound($netProfitLast)}} {{getHomeCurrency()['symbol']}}</td>
                                                    <td class="rt4 doubleLine" style="width: 20%;">{{myRound($netProfit
                                                        - $netProfitLast)}} {{getHomeCurrency()['symbol']}}</td>
                                                    <td class="rt4 doubleLine" style="width: 10%;">
                                                        @if($netProfitLast == 0)
                                                        100 %
                                                        @else
                                                        {{myRound((($netProfit - $netProfitLast)*100)/$netProfitLast)}}
                                                        %
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        </ul>
                                    </li>
                                    <hr>
                                    <li>
                                        <table id="main">
                                            <tr>
                                                <td class="rt2" style="width: 30%;">@lang('layout.TotalEquity') </td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalEquities)}} {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalEquitiesLast)}} {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 20%;">{{myRound($TotalEquities
                                                    - $TotalEquitiesLast)}} {{getHomeCurrency()['symbol']}}</td>
                                                <td class="rt2a doubleLine" style="width: 10%;">
                                                    @if($TotalEquitiesLast == 0)
                                                    100 %
                                                    @else
                                                    {{myRound((($TotalEquities -
                                                    $TotalEquitiesLast)*100)/$TotalEquitiesLast)}} %
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </li>
                                </div>

                            </ul>

                        </li>
                        <li>
                            <table id="main">
                                <tr>
                                    <td class="rt1" style="width: 30%;">@lang('layout.TotalLibilities&Equity') </td>
                                    <td class="rt2a doubleLine" style="width: 20%;">
                                        {{myRound($totalLiabilityAndEquity)}} {{getHomeCurrency()['symbol']}}</td>
                                    <td class="rt2a doubleLine" style="width: 20%;">
                                        {{myRound($totalLiabilityAndEquityLast)}} {{getHomeCurrency()['symbol']}}</td>
                                    <td class="rt2a doubleLine" style="width: 20%;">{{myRound($totalLiabilityAndEquity -
                                        $totalLiabilityAndEquityLast)}} {{getHomeCurrency()['symbol']}}</td>
                                    <td class="rt2a doubleLine" style="width: 10%;">
                                        @if($totalLiabilityAndEquityLast == 0)
                                        100 %
                                        @else
                                        {{myRound((($totalLiabilityAndEquity -
                                        $totalLiabilityAndEquityLast)*100)/$totalLiabilityAndEquityLast)}} %
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </li>
                    </div>

                </ul>
            </div>
    </div>
</div>
<!-- END EXAMPLE TABLE PORTLET-->



@endsection
@include('groupCompanyFilter.select')
@include('print.modal')

@push('scripts')
<script src="{{url('/assets/pages/scripts/ui-tree.min.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/global/plugins/jstree/dist/jstree.min.js')}}" type="text/javascript"></script>




<script type="text/javascript">
    var toggler = document.querySelectorAll(".rootTree");
    Array.from(toggler).forEach(item => {
        item.addEventListener("click", () => {
            item.parentElement.querySelector(".children").classList.toggle("active");
            item.classList.toggle("rootTree-down");
        });
    });


    var vm = new Vue({
        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            items: null,


        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },

        }
    });


    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.is_show = true
            }
        }
    });

    // start app
    Vue.component('v-select', VueSelect.VueSelect)

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload();
            }
        }
    });
</script>
@endpush