@extends('layouts.factor-master')


@section('style')

    <style type="text/css">
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
        #main tr:hover {
            background-color: #ddd;
        }

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }

    </style>
@stop
@section('content')

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table id="main" class="main-table">
                    <tr>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.AccountName')</th>
                        <th>@lang('layout.AccountType')</th>
                        <th>@lang('layout.Amount')</th>
                    </tr>

                    <tr>
                        <td colspan="3"
                            style="background-color: #689696; color: #ffffff;"> @lang('layout.OpeningBalance'):
                        </td>
                        <td style="background-color: blue; color:white;" >{{myRound($openingBalance)}}</td>
                    </tr>

                    <tr>
                        <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.CurrentAssets'):</th>
                    </tr>

                    <tr>
                        <td> + </td>
                        <td>{{__('layout.Bank')}}</td>
                        <td>{{__('layout.Bank')}}</td>
                        <td>{{myRound($totalBankReport)}}</td>
                    </tr>
                    <tr>
                        <td> + </td>
                        <td>{{__('layout.InventoryAssetAccount')}}</td>
                        <td>{{__('layout.OtherCurrentAsset')}}</td>
                        <td>{{myRound($totalOtherCurrentAssetReport)}}</td>
                    </tr>
                    <tr>
                        <td> + </td>
                        <td>{{__('layout.TotalAR')}}</td>
                        <td>{{__('layout.AccountsReceivable')}}</td>
                        <td>{{myRound($totalReceivableReport)}}</td>
                    </tr>
                    <tr>
                        <td> + </td>
                        <td>{{__('layout.TotalNoneCurrentAssets')}}</td>
                        <td>{{__('layout.FixedAsset')}}</td>
                        <td>{{myRound($TotalNoneCurrentAsset)}}</td>
                    </tr>
                    
                    <tr>
                        <td style="background-color: #ffb1bc; color: black;" > - </td>
                        <td style="background-color: #ffb1bc; color: black;" >{{__('layout.TotalLiabilities')}}</td>
                        <td style="background-color: #ffb1bc; color: black;" >{{__('layout.AccountsPayable')}}</td>
                        <td style="background-color: #ffb1bc; color: black;" >{{myRound($TotalLiability)}}</td>
                    </tr>
                    
                    <tr>
                        <th colspan="3" style="background-color: green; color:white;">@lang('layout.TotalAssets'): </th>                       
                       <td style="background-color: green; color:white;" class="doubleLine">{{myRound($totalAsset)}}</td>
                    </tr>
                    <tr>
                        <th></th>
                        <th>@lang('layout.OpeningBalance')</th>
                        <th>@lang('layout.CurrentAssets')</th>
                        <th>@lang('layout.Differ')</th>
                    </tr>
                    <tr>
                        <td></td>
                        <td>{{myRound($openingBalance)}}</td>
                        <td>{{myRound($totalAsset)}}</td>
                        <td>{{myRound($totalAsset - $openingBalance)}}</td>
                    </tr>
                    <tr>
                        <!-- <th>@lang('layout.TotalInvestment')</th>
                        <th>@lang('layout.TotalDrawing')</th> -->
                        <th></th>
                        <th>@lang('layout.TotalInvestmentAndDrawing')</th>
                        <th>@lang('layout.NetProfit/NetIncome')</th>
                        <th></th>
                    </tr>
                    <tr>
                        <!-- <td>{{myRound($investmentAmountReport)}}</td>
                        <td>{{myRound($drawingAmountReport)}}</td> -->
                        <td></td>
                        <td>{{myRound($drawingAndInvestmentAmount)}}</td>
                        <td>{{myRound($netProfit)}}</td>
                        <td>{{myRound($netProfit + $drawingAndInvestmentAmount)}}</td>
                    </tr>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    
@endsection

