@extends('layouts.app')
@section('style')

    <style type="text/css">
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
        #main tr:hover {
            background-color: #ddd;
        }

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }

    </style>
@stop
@section('content')

    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'totalFinancialStatement'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-12" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off" v-model="from_date"
                                           name="from_date">
                                    <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                    <span class="input-group-addon"> @lang('layout.To')</span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" v-model="to_date" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            {{Form::open(['route' => 'totalFinancial.statement','method' => 'GET','class' => 'form-horizontal'])}}
            {{ csrf_field() }}
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        {{-- <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" value="{{$from_date}}" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span> --}}
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" value="{{$to_date}}" autocomplete="off" />
                        <span class="input-group-addon btn" style="padding: 0px;background-color: rgb(80, 129, 141) !important;" > <input type="submit" style="padding: 0px 8px;background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141);" value="@lang('layout.Search')" > </span>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
            <div class="portlet-title">
                <div class="caption font-dark">
                </div>
                <div class="tools"> </div>
                <div class=" pull-right">
                <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
                </div>
                {{-- <div class="btn-group pull-right">
                    @permission('financialReport-list')
                        <span id="anchore-modal">
                            <button type="submit" @click.prevent="showModal" class="btn btn-success">
                                <i class="fa fa-print"></i>
                            </button>
                        </span>
                    @endpermission
                </div> --}}
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table id="main" class="main-table">
                    <tr>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.AccountName')</th>
                        <th>@lang('layout.AccountType')</th>
                        <th>@lang('layout.Amount')</th>
                    </tr>

                    <tr>
                        <td colspan="3"
                            style="background-color: #689696; color: #ffffff;"> @lang('layout.OpeningBalance'):
                        </td>
                        <td style="background-color: blue; color:white;" >{{myRound($openingBalance)}}</td>
                    </tr>

                    <tr>
                        <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.CurrentAssets'):</th>
                    </tr>

                    <tr>
                        <td> + </td>
                        <td>{{__('layout.Bank')}}</td>
                        <td>{{__('layout.Bank')}}</td>
                        <td>{{myRound($totalBankReport)}}</td>
                    </tr>
                    <tr>
                        <td> + </td>
                        <td>{{__('layout.TotalAR')}}</td>
                        <td>{{__('layout.AccountsReceivable')}}</td>
                        <td>{{myRound($totalReceivableReport)}}</td>
                    </tr>

                    <tr>
                        <td style="background-color: #ffb1bc; color: black;" > - </td>
                        <td style="background-color: #ffb1bc; color: black;" >{{__('layout.TotalLiabilities')}}</td>
                        <td style="background-color: #ffb1bc; color: black;" >{{__('layout.AccountsPayable')}}</td>
                        <td style="background-color: #ffb1bc; color: black;" >{{myRound($totalPayableReport)}}</td>
                    </tr>
                    
                    <tr>
                        <th colspan="3" style="background-color: green; color:white;">@lang('layout.TotalAssets'): </th>                       
                       <td style="background-color: green; color:white;" class="doubleLine">{{myRound($totalAsset)}}</td>
                    </tr>
                    <tr>
                        <th></th>
                        <th>@lang('layout.OpeningBalance')</th>
                        <th>@lang('layout.CurrentAssets')</th>
                        <th>@lang('layout.Differ')</th>
                    </tr>
                    <tr>
                        <td></td>
                        <td>{{myRound($openingBalance)}}</td>
                        <td>{{myRound($totalAsset)}}</td>

                        @if(($totalAsset - $openingBalance) > 0)
                        <td style="background-color: green; color:white;" >{{myRound($totalAsset - $openingBalance)}}</td>
                        @else
                        <td style="background-color: #ffb1bc; color: black;" > {{myRound($totalAsset - $openingBalance)}} </td>
                        @endif
                    </tr>
                    <tr>
                        <th></th>
                        <th colspan="1">@lang('layout.Total') @lang('layout.NetProfit/NetIncome')</th>
                        <th colspan="1">@lang('layout.NetProfit/NetIncome')</th>
                        <th></th>
                    </tr>
                    <tr>
                        <td></td>
                        <td colspan="1">{{myRound($netProfit)}}</td>
                        <td colspan="1">{{myRound($TodayNetProfit)}}</td>
                        <td></td>
                    </tr>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- BEGIN TAB PORTLET-->
    <!-- BEGIN TAB PORTLET-->
    <div class=" pull-right">


    </div>
    <br>
    <br>





@endsection
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script type="text/javascript">

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.PDFAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>
@endpush