@extends('layouts.factor-master')


@section('style')

    <style type="text/css">
 
         .doubleLine{
            text-decoration-line: underline;
            text-decoration-style: double;
        }

    </style>
@stop
@section('content')

<?php

$totalPayableAmount=0;
if ($totalPayableReport<0) {
    $totalReceivableReport+=ABS($totalPayableReport);
    $totalPayableAmount = ABS($totalPayableReport);
    $totalPayableReport = 0;
    
}

$totalReceivableAmount=0;
if ($totalReceivableReport<0) {

    $totalPayableReport+=ABS($totalReceivableReport);
    $totalReceivableAmount = ABS($totalReceivableReport);
    $totalReceivableReport = 0;
    // dd($totalReceivableAmount);


}


?>


        <h3 class="table-caption" style="text-align: center;">@lang('layout.BalanceSheet')</h3>
        <table   class="main-table">
          <tr>
            @if($from_date)
           <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
          </td>
          @endif
          @if($to_date)
          <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
          </td>
          @endif
        </tr>
        </table>
        <br>
       <table id="main" class="main-table">
        <tr>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.AccountName')</th>
            <th>@lang('layout.AccountType')</th>
            <th>@lang('layout.Amount')</th>
        </tr>
        <tr>
            <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Assets'):</th>
        </tr>
        @foreach($currentAsset as $currentAsset)
        <tr>
            <td></td>
            <td>{{$currentAsset->name}}</td>
            <td>{{__('layout.'.ucfirst($currentAsset->type))}}</td>
            <td>{{myRound($currentAsset->amount)}}</td>
        </tr>
            @endforeach

         <tr>
            <td colspan="3"
                style="background-color: #e8edff; color:#669; font-size: 12px"> @lang('layout.TotalAR'):
            </td>
            <td style="background-color: #e8edff; color:#669;">{{myRound($totalReceivableReport)}}</td>
        </tr>

        <tr>
            <td colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px"> @lang('layout.TotalCurrentAssets'):</td>
            <td  style="background-color: #e8edff; color:#669;">{{myRound($TotalCurrentAsset)}}</td>
        </tr>
         @foreach($noneCurrentAsset as $noneCurrentAsset)
        <tr>
            <td></td>
            <td>{{$noneCurrentAsset->name}}</td>
            <td>{{__('layout.'.ucfirst($noneCurrentAsset->type))}}</td>
            <td>{{myRound($noneCurrentAsset->amount)}}</td>
        </tr>
            @endforeach
        <tr>
            <td colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px"> @lang('layout.TotalNoneCurrentAssets'):</td>
            <td  style="background-color: #e8edff; color:#669">{{myRound($TotalNoneCurrentAsset)}}</td>
        </tr>
        <tr>
            <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalAssets'):
                {{-- <span style="margin-left: 78.5%;font-size: 15px">{{$totalAsset}}</span> --}}
            </th>
            {{--<td style="background-color: #e8edff; color:#669;" class="doubleLine">{{myRound($totalAsset)}}</td>--}}

            @if($totalReceivableReport==0)
                        
            <td style="background-color: #e8edff; color:#669;" class="doubleLine">{{myRound($totalAsset+$totalReceivableAmount)}}</td>
           @elseif($totalPayableReport==0)
           <td style="background-color: #e8edff; color:#669;" class="doubleLine">{{myRound($totalAsset+$totalPayableAmount)}}</td>
           @else
           <td style="background-color: #e8edff; color:#669;" class="doubleLine">{{myRound($totalAsset)}}</td>
           @endif


        </tr>
         <tr>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.AccountName')</th>
            <th>@lang('layout.AccountType')</th>
            <th>@lang('layout.Amount')</th>
        </tr>
        <tr>
        <tr>
            <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Liabilities'):</th>
        </tr>
        @foreach($liability as $liability)
        <tr>
            <td></td>
            <td>{{$liability->name}}</td>
            <td>{{__('layout.'.ucfirst($liability->type))}}</td>
            <td>{{myRound($liability->amount)}}</td>
        </tr>
            @endforeach

            <tr>
                <th colspan="3"
                    style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalAP'):
                </th>
                <td style="background-color: #e8edff; color:#669;">{{myRound($totalPayableReport)}}</td>

            </tr>
        <tr>
            <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalLiabilities'):
                {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
            </th>
            <td style="background-color: #e8edff; color:#669;">{{myRound($TotalLiability)}}</td>

        </tr>
        <tr>
            <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Equity'):</th>
        </tr>
         @foreach($equity as $equities)
        <tr>
            <td></td>
            <td>{{$equities->name}}</td>
            <td>{{__('layout.'.ucfirst($equities->type))}}</td>
            <td>{{myRound($equities->amount)}}</td>
        </tr>
            @endforeach
        <tr>
            <td>@lang('layout.NetProfit/NetIncome')</td>
            <td></td>
            <td></td>
            <td>{{myRound($netProfit)}}</td>
        </tr>
         <tr>
            <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalEquity'):
                {{-- <span style="margin-left: 90%;">{{$TotalEquities}}</span> --}}
            </th>
            <td style="background-color: #e8edff; color:#669;">{{myRound($TotalEquities)}}</td>

        </tr>
        <tr>
            <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalLibilities&Equity'):
                {{-- <span style="margin-left: 90%;">{{$totalLiabilityAndEquity}}</span> --}}
            </th>
            {{--<td style="background-color: #e8edff; color:#669;" class="doubleLine">{{myRound($totalLiabilityAndEquity)}}</td>--}}

            @if($totalReceivableReport==0)
            <td style="background-color: #e8edff; color:#669;"
                class="doubleLine">{{myRound($totalLiabilityAndEquity+$totalReceivableAmount)}}</td>
           @elseif($totalPayableReport==0)
           <td style="background-color: #e8edff; color:#669;"
                class="doubleLine">{{myRound($totalLiabilityAndEquity+$totalPayableAmount)}}</td>
            @else
            <td style="background-color: #e8edff; color:#669;"
                class="doubleLine">{{myRound($totalLiabilityAndEquity)}}</td>
           @endif

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
    
@endsection

