@extends('layouts.factor-master')
@section('style')

<style type="text/css">
    @media print{
        a[href]:after{
            content: none !important;
        }
    }
    #main {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #main th, #main td {
        /* border: 1px solid #ddd; */
        padding: 8px;
        
        {{(session()->get("system_direction") == "rtl")?"padding-left: 20px":"padding-right:20px"}}
    }

    /* #main tr:hover {
        background-color: #ddd;
    } */

    #main th {
        padding-top: 12px;
        padding-bottom: 12px;

        background-color: #768585;
        color: white;
    }

    .doubleLine {
        text-decoration-line: underline;
        text-decoration-style: double;
    }

    .modal-mask {
        position: fixed;
        z-index: 9998;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, .5);
        display: table;
        transition: opacity .3s ease;
    }

    .modal-wrapper {
        display: table-cell;
        vertical-align: middle;
    }

    .modal-container {
        width: 80%;
        max-width: 90%;
        margin: 0px auto;
        padding: 20px 30px;
        background-color: #fff;
        border-radius: 2px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
        transition: all .3s ease;
        font-family: Helvetica, Arial, sans-serif;
    }

    .modal-header h3 {
        margin-top: 0;
        color: #42b983;
    }

    .modal-body {
        margin: 20px 0;
    }

    .modal-default-button {
        float: right;
    }

    .modal-enter {
        opacity: 0;
    }

    .modal-leave-active {
        opacity: 0;
    }

    .modal-enter .modal-container,
    .modal-leave-active .modal-container {
        -webkit-transform: scale(1.1);
        transform: scale(1.1);
    }

    ul, #treeUL {
        list-style-type: none;
    }

    #treeUL {
        margin: 0;
        padding: 0;
    }

    .rt1 {
        font-size: 20px;
        font-weight: bold;
        /* color: green; */
    }     

    .rt1a {
        font-size: 20px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        color: green;
    }    
    .rt2 {
        font-size: 18px;
        font-weight: bold;
        /* color: purple; */
    }    
    .rt2a {
        font-size: 18px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: purple; */
    }    
    .rt3 {
        font-size: 16px;
        font-weight: bold;
        /* color: red; */
    }    

    .rt3a {
        font-size: 16px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: red; */
    }
    .rt4{
        font-size: 14px;
        font-weight: bold;
        text-align:{{(session()->get("system_direction") == "rtl")?"left":"right"}} ; 
        /* color: white; */
    }    
    .rt4n{
        font-size: 14px;
        font-weight: bold;
        
        text-align: {{(session()->get("system_direction") == "rtl")?"right":"left"}}; 
        /* color: white; */
    }
    a{
        color: black;
        text-decoration: none;
    }  
    a:hover{
        /* color: white; */
        text-decoration: none;
    }
    .asset{
        background-color: #eaefec;
        /* color: white; */
    }     
    .currentasset{
        background-color: #eaefec;
        /* color: white; */
    } 

    .assetOther{
        background-color: #eaefec;
        /* color: white; */
    }     
    .assetBank{
        background-color: #eaefec;
        /* color: white; */
    }    
    .assetReceiv{
        background-color: #eaefec;
        /* color: white; */
    }     

    .fixasset{
        background-color: #eaefec;
        /* color: white; */
    }     
    .otherasset{
        background-color: #eaefec;
        /* color: white; */
    }    
    .lib{
        background-color: #eaefec;
        /* color: white; */
    }    

    .libPay{
        background-color: #eaefec;
        /* color: white; */
    }    

    .equity{
        background-color: #eaefec;
        /* color: white; */
    }

    hr {
        margin: 0px 0;
        border-top: 2px solid #eee;
    }
</style>
@stop
@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.BalanceSheet')
    <span class="text-primary">(
        <b> {{getHomeCurrency()['name']}}) </b>
    </span>
</h3>
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
<ul id="treeUL">

    <li class="asset">
        <table id="main" class="rt1">
            <tr>
                <td colspan="2" style="text-align: center;">@lang('layout.Assets') </td>
            </tr>
        </table>

        <ul class="children" style="padding: 0px !important;">
            <li class="currentasset">
                <table id="main" class="rt2">
                    <tr>
                        <td colspan="2">@lang('layout.CurrentAssets') </td>
                    </tr>
                </table>

                <ul class="children" style="padding: 0px !important;">
                    <li class="assetOther">
                        <table id="main" class="rt3">
                            <tr>
                                <td colspan="2">@lang('layout.OtherCurrentAssets') </td>
                            </tr>
                        </table>
                        <ul class="children" style="padding: 0px !important;">
                            <table id="main" class=" main-table">
                                @foreach($otherCurrentAsset as $accountRow)
                                @if($accountRow['Amount'] != 0 ||
                                !empty($accountRow['children']))
                                <tr>
                                    <td class="rt4n" style="width: 50% !important;">
                                        <a
                                            href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    
                                    <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total')
                                        {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) &&
                                getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}}
                                        :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="rt4n">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}}
                                        :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="rt4n">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}}
                                        :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                <!-- end second child -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    
                    <li class="assetOther">
                        <table id="main">
                            <tr>
                                <td class="rt3">@lang('layout.TotalOtherCurrentAssets')
                                </td>
                                <td class="rt3a doubleLine">
                                    {{myRound($TotalOtherCurrentAsset)}}
                                    {{getHomeCurrency()['symbol']}}</td>


                            </tr>
                        </table>
                    </li>
                    <li class="assetBank">
                        <table id="main" class="rt3">
                            <tr>
                                <td colspan="2">@lang('layout.Checking/Savings') </td>
                            </tr>
                        </table>

                        <ul class="children" style="padding: 0px !important;">
                            <table id="main" class=" main-table">
                                @foreach($banks as $accountRow)
                                @if($accountRow['Amount'] != 0 ||
                                !empty($accountRow['children']))
                                <tr>
                                    <td class="rt4n" style="width: 50% !important;">
                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    
                                    <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total')
                                        {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) &&
                                getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}}
                                        :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="rt4n">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}}
                                        :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="rt4n">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}}
                                        :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                <!-- end second child -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    
                    <li class="assetBank">
                        <table id="main">
                            <tr>
                                <td class="rt3">@lang('layout.TotalChecking/Savings')
                                </td>
                                <td class="rt3a doubleLine">{{myRound($TotalBanks)}}
                                    {{getHomeCurrency()['symbol']}}</td>
                            </tr>
                        </table>
                    </li>
                    <li class="assetReceiv">
                        <table id="main" class="rt3">
                            <tr>
                                <td colspan="2">@lang('layout.AccountsReceivable') </td>
                            </tr>
                        </table>
                        <ul class="children" style="padding: 0px !important;">
                            <table id="main" class=" main-table">
                                @foreach($accountReceivable as $accountRow)
                                @if($accountRow['Amount'] != 0 ||
                                !empty($accountRow['children']))
                                <tr>
                                    <td class="rt4n" style="width: 50% !important;">
                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    
                                    <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total')
                                        {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) &&
                                getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}}
                                        :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="rt4n">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}}
                                        :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="rt4n">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    
                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}}
                                        :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                <!-- end second child -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    
                    <li class="assetReceiv">
                        <table id="main">
                            <tr>
                                <td class="rt3">@lang('layout.TotalAccountsReceivable')
                                </td>
                                <td class="rt3a doubleLine">
                                    {{myRound($TotalaccountReceivable)}}
                                    {{getHomeCurrency()['symbol']}}</td>


                            </tr>
                        </table>
                    </li>
                </ul>
            </li>
            
            <li class="currentasset">
                <table id="main">
                    <tr>
                        <td class="rt2">@lang('layout.TotalCurrentAssets') </td>
                        <td class="rt2a doubleLine">{{myRound($TotalCurrentAsset)}}</td>


                    </tr>
                </table>
            </li>
            <li class="fixasset">
                <table id="main" class="rt2">
                    <tr>
                        <td colspan="2">@lang('layout.FixAsset') </td>
                    </tr>
                </table>
                <ul class="children" style="padding: 0px !important;">
                    <table id="main" class=" main-table">
                        @foreach($fixedAssets as $accountRow)
                        @if($accountRow['Amount'] != 0 ||
                        !empty($accountRow['children']))
                        <tr>
                            <td class="rt4n" style="width: 50% !important;">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            
                            <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total')
                                {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) &&
                        getShowSubAccount() !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                            </td>
                            
                            <td class="rt4">{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            <td class="rt4n">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            
                            <td class="rt4">{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            <td class="rt4n">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            
                            <td class="rt4">{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach
                    </table>
                </ul>
            </li>
            
            <li class="fixasset">
                <table id="main">
                    <tr>
                        <td class="rt2" style="width: 50% !important;">@lang('layout.TotalFixedAssets') </td>
                        <td class="rt2a doubleLine" style="width: 50% !important;">{{myRound($TotalfixedAssets)}}
                            {{getHomeCurrency()['symbol']}}</td>


                    </tr>
                </table>
            </li>
            <li class="otherasset">
                <table id="main" class="rt2">
                    <tr>
                        <td colspan="2">@lang('layout.OtherAssets') </td>
                    </tr>
                </table>
                <ul class="children" style="padding: 0px !important;">
                    <table id="main" class=" main-table">
                        @foreach($otherAssets as $accountRow)
                        @if($accountRow['Amount'] != 0 ||
                        !empty($accountRow['children']))
                        <tr>
                            <td class="rt4n" style="width: 50% !important;">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            
                            <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total')
                                {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) &&
                        getShowSubAccount() !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                            </td>
                            
                            <td class="rt4">{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            <td class="rt4n">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            
                            <td class="rt4">{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            <td class="rt4n">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            
                            <td class="rt4">{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach
                    </table>
                </ul>
            </li>
            
            <li class="otherasset">
                <table id="main">
                    <tr>
                        <td class="rt2" style="width: 50% !important;">@lang('layout.TotalOtherAssets') </td>
                        <td class="rt2a doubleLine" style="width: 50% !important;">{{myRound($TotalotherAssets)}}
                            {{getHomeCurrency()['symbol']}}</td>


                    </tr>
                </table>
            </li>
        </ul>
    </li>
    
    <li class="asset">
        <table id="main" class="main-table">
            <tr>
                <td class="rt1" style="width: 50% !important;">@lang('layout.TotalAssets') </td>
                <td class="rt1a doubleLine" style="width: 50% !important;">{{myRound($totalAsset)}}
                    {{getHomeCurrency()['symbol']}}</td>
            </tr>
        </table>
    </li>
    <li class="lib">
        <table id="main" class="rt1">
            <tr>
                <td colspan="2">@lang('layout.LiabilitiesAndEquity') </td>
            </tr>
        </table>

        <ul class="children" style="padding: 0px !important;">
            <li class="libPay">
                <table id="main" class=" rt2">
                    <tr>
                        <td colspan="2">@lang('layout.Liabilities') </td>
                    </tr>
                </table>

                <ul class="children">
                    <table id="main" class=" main-table">
                        @foreach($liability as $accountRow)
                        @if($accountRow['Amount'] != 0 ||
                        !empty($accountRow['children']))
                        <tr>
                            <td class="rt4n" style="width: 50% !important;">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            
                            <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total')
                                {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) &&
                        getShowSubAccount() !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                            </td>
                            
                            <td class="rt4">{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            <td class="rt4n">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            
                            <td class="rt4">{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            <td class="rt4n">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            
                            <td class="rt4">{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach
                    </table>
                </ul>
            </li>
            
            <li class="libPay">
                <table id="main">
                    <tr>
                        <td class="rt2">@lang('layout.TotalLiabilities') </td>
                        <td class="rt2a doubleLine">{{myRound($TotalLiability)}}
                            {{getHomeCurrency()['symbol']}}</td>


                    </tr>
                </table>
            </li>
        </ul>

        <ul class="children" style="padding: 0px !important;">
            <li class="equity">
                <table id="main" class="rt2">
                    <tr>
                        <td colspan="2">@lang('layout.Equity') </td>
                    </tr>
                </table>
                <ul class="children" style="padding: 0px !important;">
                    <table id="main" class=" main-table">
                        @foreach($equity as $accountRow)
                        @if($accountRow['Amount'] != 0 ||
                        !empty($accountRow['children']))
                        <tr>
                            <td class="rt4n" style="width: 50% !important;">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            
                            <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total')
                                {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) &&
                        getShowSubAccount() !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                            </td>
                            
                            <td class="rt4">{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            <td class="rt4n">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            
                            <td class="rt4">{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            <td class="rt4n">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            
                            <td class="rt4">{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach
                        <tr>
                            <td class="rt4n" style="width: 50% !important;">@lang('layout.NetProfit/NetIncome')</td>
                            <td class="rt4" style="width: 50% !important;">{{myRound($netProfit)}}
                                {{getHomeCurrency()['symbol']}}</td>
                        </tr>
                    </table>
                </ul>
            </li>
            
            <li class="equity">
                <table id="main">
                    <tr>
                        <td class="rt2">@lang('layout.TotalEquity') </td>
                        <td class="rt2a doubleLine">{{myRound($TotalEquities)}}
                            {{getHomeCurrency()['symbol']}}</td>
                    </tr>
                </table>
            </li>

        </ul>

    </li>
    <li class="lib">
        <table id="main" class="main-table">
            <tr>
                <td class="rt1" style="width: 50% !important;">@lang('layout.TotalLibilities&Equity') </td>
                <td class="rt1a doubleLine" style="width: 50% !important;">{{myRound($totalLiabilityAndEquity)}}
                    {{getHomeCurrency()['symbol']}}</td>
            </tr>
        </table>
    </li>
</ul>

@endsection