@extends('layouts.factor-master')
@section('style')
    <style type="text/css">
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        /* #main tr:hover {
            background-color: #ddd;
        } */

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            /* background-color: #768585; */
            color: black;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }



        ul, #treeUL {
        list-style-type: none;
        }
        
        #treeUL {
            margin: 0;
            padding: 0;
        }
    
        .rt1 {
            font-size: 22px;
            font-weight: bold;
            color: black;
        }    
        .rt2 {
            font-size: 20px;
            font-weight: bold;
            color: black;
        }    
        .rt3 {
            font-size: 18px;
            font-weight: bold;
            color: black;
        }
        .rt4{
            font-size: 16px;
            font-weight: bold;
            /* text-align: center;  */
            color: black;
        }
        a{
            color: black;
            text-decoration: none;
        }  
        a:hover{
            color: black;
            text-decoration: none;
        }
        .asset{
            background-color: rgb(189, 189, 189 / 30%);
            color: black;
        }     
        .currentasset{
            background-color: rgba(253, 253, 253, 0.861);
            color: black;
        } 

        .assetOther{
            background-color: rgba(213, 213, 213, 0.432);
            color: black;
        }     
        .assetBank{
            background-color: rgba(213, 213, 213, 0.432);
            color: black;
        }    
        .assetReceiv{
            background-color: rgba(213, 213, 213, 0.432);
            color: black;
        }     
        
        .fixasset{
            background-color: rgba(213, 213, 213, 0.432);
            color: black;
        }     
        .otherasset{
            background-color: rgba(213, 213, 213, 0.432);
            color: black;
        }    
        .lib{
            background-color: rgb(183, 183, 183);
            color: black;
        }    
        
        .libPay{
            background-color: rgb(183, 183, 183);
            color: black;
        }    
        
        .equity{
            background-color: rgb(183, 183, 183);
            color: black;
        }
    </style>
@stop
@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.BalanceSheet')
    <span class="text-primary">(
        <b> {{getHomeCurrency()['name']}}) </b>
    </span>
</h3>
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>

<ul id="treeUL">

    <li class="asset">
        <table class="main main-table rt1">
            <tr style="background-color: rgb(207, 207, 207);">
                <td colspan="2" style="text-align: center;font-size: 25px;background-color: rgb(207, 207, 207);color: black;">@lang('layout.Assets') </td>
            </tr>
        </table>

        <ul class="children" style="padding: 0px !important;">
            <li class="currentasset">
                <table class="main main-table rt2">
                    <tr>
                        <td colspan="2" style="text-align: center; font-size: 20px;">@lang('layout.CurrentAssets') </td>
                    </tr>
                </table>

                <ul class="children" style="padding: 0px !important;">
                    <li class="assetOther">
                        <table class="main main-table rt3">
                            <tr>
                                <td colspan="2">@lang('layout.OtherCurrentAssets') </td>
                            </tr>
                        </table>
                        <ul class="children" style="padding: 0px !important;">
                            <table class=" main-table">
                                @foreach($otherCurrentAsset as $accountRow)
                                @if($accountRow['Amount'] != 0 ||
                                !empty($accountRow['children']))
                                <tr>
                                    <td class="rt4" style="width: 50% !important;">
                                        <a
                                            href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    {{-- <td>
                                        {{__('layout.'.ucfirst($accountRow['Type']))}}
                                    </td> --}}
                                    <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total')
                                        {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) &&
                                getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="rt4">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}}
                                        :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="rt4">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}}
                                        :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="rt4">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}}
                                        :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                <!-- end second child -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    <li>
                        <table class="main main-table rt3">
                            <tr>
                                <td style="width: 50% !important;">@lang('layout.TotalOtherCurrentAssets') </td>
                                <td style="width: 50% !important;">{{myRound($TotalOtherCurrentAsset)}}</td>
                            </tr>
                        </table>
                    </li>
                    <li class="assetBank">
                        <table class="main main-table rt3">
                            <tr>
                                <td colspan="2" style="font-size: 25px; font-weight: bolder;">@lang('layout.Checking/Savings') </td>
                            </tr>
                        </table>

                        <ul class="children" style="padding: 0px !important;">
                            <table class=" main-table">
                                @foreach($banks as $accountRow)
                                @if($accountRow['Amount'] != 0 ||
                                !empty($accountRow['children']))
                                <tr>
                                    <td class="rt4" style="width: 50% !important;">
                                        <a
                                            href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    {{-- <td>
                                        {{__('layout.'.ucfirst($accountRow['Type']))}}
                                    </td> --}}
                                    <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total')
                                        {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) &&
                                getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="rt4">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}}
                                        :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="rt4">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}}
                                        :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="rt4">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}}
                                        :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                <!-- end second child -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    <li>
                        <table class="main main-table rt3">
                            <tr>
                                <td style="width: 50% !important;fontfont-size: 25px; font-weight: bolder;">@lang('layout.TotalChecking/Savings') </td>
                                <td style="width: 50% !important;">{{myRound($TotalBanks)}}</td>


                            </tr>
                        </table>
                    </li>
                    <li class="assetReceiv">
                        <table class="main main-table rt3">
                            <tr>
                                <td colspan="2" style="font-size: 25px; font-weight: bolder;">@lang('layout.AccountsReceivable') </td>
                            </tr>
                        </table>
                        <ul class="children" style="padding: 0px !important;">
                            <table class=" main-table">
                                @foreach($accountReceivable as $accountRow)
                                @if($accountRow['Amount'] != 0 ||
                                !empty($accountRow['children']))
                                <tr>
                                    <td class="rt4" style="width: 50% !important;">
                                        <a href="{{url('/account/'.$accountRow['id'])}}" style="font-size: 25px;font-weight: bolder;">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    {{-- <td>
                                        {{__('layout.'.ucfirst($accountRow['Type']))}}
                                    </td> --}}
                                    <td class="rt4" style="width: 50%;">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total')
                                        {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) &&
                                getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="rt4">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}}
                                        :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="rt4">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}}
                                        :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="rt4">
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                    --}}
                                    <td class="rt4">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}}
                                        :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                <!-- end second child -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>

                    <li>
                        <table class="main main-table rt3">
                            <tr>
                                <td style="width: 50% !important; font-size: 25px; font-weight: bolder;">@lang('layout.TotalAccountsReceivable') </td>
                                <td style="width: 50% !important;">{{myRound($TotalaccountReceivable)}}</td>


                            </tr>
                        </table>
                    </li>
                </ul>
            </li>
            <li>
                <table class="main main-table rt2">
                    <tr style="background-color: rgb(183, 183, 183);">
                        <td style="width: 50% !important; font-size: 25px; font-weight: bolder;background-color: rgb(183, 183, 183);">@lang('layout.TotalCurrentAssets') </td>
                        <td style="width: 50% !important;background-color: rgb(183, 183, 183);">{{myRound($TotalCurrentAsset)}}</td>


                    </tr>
                </table>
            </li>
            <li class="fixasset">
                <table class="main main-table rt2">
                    <tr style="background-color: rgb(183, 183, 183);">
                        <td colspan="2" style="font-size: 25px; font-weight: bolder;background-color: rgb(183, 183, 183);">@lang('layout.FixAsset') </td>
                    </tr>
                </table>
                <ul class="children" style="padding: 0px !important;">
                    <table class=" main-table">
                        @foreach($fixedAssets as $accountRow)
                        @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                        <tr style="background-color: rgb(183, 183, 183);">
                            <td class="rt4" style="width: 50% !important;background-color: rgb(183, 183, 183);">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
                            --}}
                            <td class="rt4" style="width: 50% !important;background-color: rgb(183, 183, 183);">{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) && getShowSubAccount()
                        !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            <td class="rt4">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            <td class="rt4">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            <td class="rt4">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach

                    </table>
                </ul>
            </li>
            <li>
                <table class="main main-table rt2">
                    <tr style="background-color: rgb(183, 183, 183);">
                        <td style="width: 50% !important; font-size: 25px; font-weight: bolder;background-color: rgb(183, 183, 183);">@lang('layout.TotalFixedAssets') </td>
                        <td style="width: 50% !important;background-color: rgb(183, 183, 183);">{{myRound($TotalfixedAssets)}}</td>


                    </tr>
                </table>
            </li>
            <li class="otherasset">
                <table class="main main-table rt2">
                    <tr style="background-color: rgb(183, 183, 183);">
                        <td colspan="2" style="font-size: 25px; font-weight: bolder;background-color: rgb(183, 183, 183);">@lang('layout.OtherAssets') </td>
                    </tr>
                </table>
                <ul class="children" style="padding: 0px !important;">
                    <table class=" main-table">
                        @foreach($otherAssets as $accountRow)
                        @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                        <tr>
                            <td class="rt4">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
                            --}}
                            <td class="rt4">{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) && getShowSubAccount()
                        !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            <td class="rt4">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            <td class="rt4">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            <td class="rt4">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach
                    </table>
                </ul>
            </li>
            <li>
                <table class="main main-table rt2">
                    <tr>
                        <td style="width: 50% !important;font-size: 25px; font-weight: bolder;background-color: rgb(183, 183, 183);">@lang('layout.TotalOtherAssets') </td>
                        <td style="width: 50% !important;background-color: rgb(183, 183, 183);">{{myRound($TotalotherAssets)}}</td>


                    </tr>
                </table>
            </li>
        </ul>
    </li>
    <li class="asset">
        <table class="main main-table rt1">
            <tr style="background-color: rgb(183, 183, 183);">
                <td style="width: 50% !important;font-size: 25px; font-weight: bolder;background-color: rgb(183, 183, 183);">@lang('layout.TotalAssets') </td>
                <td style="width: 50% !important;background-color: rgb(183, 183, 183);" class="doubleLine">{{myRound($totalAsset)}}</td>


            </tr>
        </table>
    </li>
    <!--Lib-->
    <li class="lib">
        <table class="main main-table rt1">
            <tr>
                <td colspan="2" style="font-size: 25px; font-weight: bolder;">@lang('layout.LiabilitiesAndEquity') </td>
            </tr>
        </table>

        <ul class="children" style="padding: 0px !important;">
            <li class="libPay">
                <table class="main main-table rt2">
                    <tr>
                        <td colspan="2" style="font-size: 25px; font-weight: bolder;">@lang('layout.Liabilities') </td>
                    </tr>
                </table>

                <ul class="children" style="padding: 0px !important;">
                    <table class="main main-table">
                        @foreach($liability as $accountRow)
                        @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                        <tr>
                            <td class="rt4" style="width: 50% !important;">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
                            --}}
                            <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) && getShowSubAccount()
                        !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            <td class="rt4">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            <td class="rt4">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            <td class="rt4">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach
                    </table>
                </ul>
            </li>
            <li>
                <table class="main main-table rt2">
                    <tr>
                        <td style="width: 50% !important;font-size: 25px; font-weight: bolder;">@lang('layout.TotalLiabilities') </td>
                        <td style="width: 50% !important;">{{myRound($TotalLiability)}}</td>


                    </tr>
                </table>
            </li>
        </ul>

        <ul class="children" style="padding: 0px !important;">
            <li class="equity">
                <table class="main main-table rt1">
                    <tr>
                        <td colspan="2" style="font-size: 25px; font-weight: bolder;">@lang('layout.Equity') </td>
                    </tr>
                </table>
                <ul class="children" style="padding: 0px !important;">
                    <table class="main main-table">
                        @foreach($equity as $accountRow)
                        @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                        <tr>
                            <td class="rt4" style="width: 50% !important;">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
                            --}}
                            <td class="rt4" style="width: 50% !important;">{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) && getShowSubAccount()
                        !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            <td class="rt4">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            <td class="rt4">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            <td class="rt4">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td> --}}
                            <td class="rt4">{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach
                        <tr>
                            <td class="rt4" style="width: 50% !important;font-size: 25px; font-weight: bolder;">@lang('layout.NetProfit/NetIncome')</td>
                            <td class="rt4" style="width: 50% !important;">{{myRound($netProfit)}}</td>
                        </tr>
                    </table>
                </ul>
            </li>
            <li>
                <table class="main main-table rt2">
                    <tr>
                        <td style="width: 50% !important;font-size: 25px; font-weight: bolder;">@lang('layout.TotalEquity') </td>
                        <td style="width: 50% !important;">{{myRound($TotalEquities)}}</td>
                    </tr>
                </table>
            </li>
        </ul>
        <!--  -->
    </li>
    <li class="lib">
        <table class="main  main-table rt1">
            <tr>
                <td style="width: 50% !important; font-size: 25px; font-weight: bolder;">@lang('layout.TotalLibilities&Equity') </td>
                <td style="width: 50% !important;" class="doubleLine">{{myRound($totalLiabilityAndEquity)}}</td>
            </tr>
        </table>
    </li>
</ul>
@endsection