@extends('layouts.factor-master')
@section('style')
<style type="text/css">
    .doubleLine {
        text-decoration-line: underline;
        text-decoration-style: double;
        text-underline-position: under;
    }
</style>
@stop
@section('content')

<?php
    $setting_jalali = isset(uSetting()->jalali_and_gerogarian_date);
    $setting_date_type = isset(uSetting()->date_type);
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.BalanceSheet')
    <span class="text-primary">(
        <b> {{getHomeCurrency()['name']}}) </b>
    </span>
</h3>
<table class="main-table">
    <tr>
      @if($from_date)
     <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">    @if($setting_jalali == 'true')  {{convertDate($from_date, null, null, (($setting_date_type == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">    @if($setting_jalali == 'true')  {{convertDate($to_date, null, null, (($setting_date_type == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
  </table>
<br>
<table id="main" class="main-table">
    <tr>
        {{-- <th>@lang('layout.Category')</th> --}}
        <th>@lang('layout.AccountName')</th>
        <th>@lang('layout.AccountType')</th>
        <th>@lang('layout.Amount')</th>
    </tr>
    <tr>
        <th colspan="3" style="background-color: rgb(207, 207, 207); color:#000;font-size: 20px;">@lang('layout.Assets')</th>
    </tr>

    @foreach($currentAsset as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="font-size: 20px">
            <a href="{{url('/account/'.$accountRow['id'])}}" style="color: #000000;text-decoration: none;">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}}
            :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="color: #29B4B6; font-size: 17px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                style="color: #29B4B6">{{$fc['AccountName']}}</a>
        </td>
        <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a style="color: #8e29b6;"
                href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key2=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        {{-- <td></td> --}}
        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd child -->
    @endforeach
    @endif
    <!-- end second child -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach

    @if($totalReceivableReport > 0)
    <tr>
        <td colspan="2" style="background-color: #bce7bc66; font-size: 20px"> 
            @lang('layout.TotalAR')
        </td>
        <td style="background-color: #bce7bc66;">{{myRound($totalReceivableReport)}}</td>
    </tr>
    @endif
    <tr>
        <td colspan="2" style="background-color: rgb(207, 207, 207);; color:#000; font-size: 25px">
            @lang('layout.TotalCurrentAssets')</td>
        <td style="background-color: rgb(207, 207, 207); color:#000;">{{myRound($TotalCurrentAsset)}}</td>
    </tr>
    
    @foreach($noneCurrentAsset as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="font-size: 20px">
            <a href="{{url('/account/'.$accountRow['id'])}}" style="color: #000000;text-decoration: none;">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}}
            :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="color: #29B4B6; font-size: 17px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                style="color: #29B4B6">{{$fc['AccountName']}}</a>
        </td>
        <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a style="color: #8e29b6;"
                href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key2=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        {{-- <td></td> --}}
        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd child -->
    @endforeach
    @endif
    <!-- end second child -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach

    <tr>
        <td colspan="2" style="background-color: rgb(207, 207, 207); color:#000; font-size: 25px">
            @lang('layout.TotalNoneCurrentAssets')</td>
        <td style="background-color: rgb(207, 207, 207); color:#000">{{myRound($TotalNoneCurrentAsset)}}</td>
    </tr>
    <tr>
        <td colspan="2" style="background-color: rgb(207, 207, 207); color:#000; font-size: 25px">@lang('layout.TotalAssets')
            {{-- <span style="margin-left: 78.5%;font-size: 15px">{{$totalAsset}}</span> --}}
        </td>
        <td style="background-color: rgb(207, 207, 207); color:#000;" class="doubleLine">{{myRound($totalAsset)}}</td>
    </tr>
    <tr>
        {{-- <th>@lang('layout.Category')</th> --}}
        <th>@lang('layout.AccountName')</th>
        <th>@lang('layout.AccountType')</th>
        <th>@lang('layout.Amount')</th>
    </tr>
    <tr>
    <tr>
        <th colspan="3" style="background-color: rgb(207, 207, 207); color:#000;font-size: 25px;">@lang('layout.Liabilities')</th>
    </tr>
    
    @foreach($liability as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="font-size: 20px">
            <a href="{{url('/account/'.$accountRow['id'])}}" style="color: #000000;">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}}
            :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="color: #29B4B6; font-size: 17px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                style="color: #29B4B6">{{$fc['AccountName']}}</a>
        </td>
        <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a style="color: #8e29b6;"
                href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key2=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        {{-- <td></td> --}}
        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd child -->
    @endforeach
    @endif
    <!-- end second child -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach
    @if($totalPayableReport > 0)
    <tr>
        <th colspan="2" style="background-color: #bce7bc66; font-size: 25px">
            @lang('layout.TotalAP')
        </th>
        <td style="background-color: #bce7bc66;">{{myRound($totalPayableReport)}}</td>

    </tr>
    @endif
    <tr>
        <th colspan="2" style="background-color: rgb(207, 207, 207);; color:#000; font-size: 25px">@lang('layout.TotalLiabilities')
            {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
        </th>
        <td style="background-color: rgb(207, 207, 207);; color:#000;">{{myRound($TotalLiability)}}</td>

    </tr>
    <tr>
        <th colspan="3" style="background-color: rgb(207, 207, 207); color:#000;font-size: 25px;">@lang('layout.Equity')</th>
    </tr>
    
    @foreach($equity as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="font-size: 20px">
            <a href="{{url('/account/'.$accountRow['id'])}}" style="color: #000000;text-decoration: none;">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}}
            :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="font-size: 17px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" style="color: #29B4B6">{{$fc['AccountName']}}</a>
        </td>
        <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        {{-- <td></td> --}}
        <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a style="color: #8e29b6;"
                href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key2=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        {{-- <td></td> --}}
        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd child -->
    @endforeach
    @endif
    <!-- end second child -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach

    <tr>
        <td>@lang('layout.NetProfit/NetIncome')</td>
        <td></td>
        <td>{{myRound($netProfit)}}</td>
    </tr>
    <tr>
        <th colspan="2" style="background-color: rgb(207, 207, 207); color:#000; font-size: 25px">@lang('layout.TotalEquity')
            {{-- <span style="margin-left: 90%;">{{$TotalEquities}}</span> --}}
        </th>
        <td style="background-color: rgb(207, 207, 207); color:#000;">{{myRound($TotalEquities)}}</td>

    </tr>
    <tr>
        <th colspan="2" style="background-color: rgb(207, 207, 207); color:#000; font-size: 25px">
            @lang('layout.TotalLibilities&Equity')
            {{-- <span style="margin-left: 90%;">{{$totalLiabilityAndEquity}}</span> --}}
        </th>
        <td style="background-color: rgb(207, 207, 207); color:#000;" class="doubleLine">{{myRound($totalLiabilityAndEquity)}}</td>

    </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->

@endsection