@extends('layouts.app')
@section('style')
{{-- <link href="{{ asset('assets/global/css/plugins.min.css')}}" rel="stylesheet" type="text/css" />
<link href="{{ asset('assets/global/css/plugins-md.css')}}" rel="stylesheet" type="text/css" />
<link href="{{ asset('assets/global/plugins/morris/morris.css')}}" rel="stylesheet" type="text/css" /> --}}
<link rel="stylesheet" href="{{url('/')}}/ltr/assets/global/plugins/amcharts/amcharts/plugins/export/export.css" type="text/css" media="all" />
<style type="text/css">
    .setting_menu li.active a,
    .ver-inline-menu li.active i {
        background-color: #d4d7dc !important;
        color: #393a3d !important;
    }

    .ver-inline-menu li a {
        background: #eceef1 !important;
        border-left: solid 2px #eceef1;
        color: #393a3d !important;
    }

    .ver-inline-menu li i {
        background: #eceef1 !important;

    }

    .t_head {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }

    .t_body {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }

    .report_a_title {
        color: #393a3d;
    }

    a.report_a_title:hover {
        color: #393a3d;
        text-decoration: none;
    }

    .table-advance {
        text-align: center !important;
    }
    .amcharts-chart-div>a{
        display: none !important;

    }

        .income .amcharts-pie-slice {
            fill: #00ff00;
            }
        .expense .amcharts-pie-slice {
        fill: #ff0000
        }
        .cost .amcharts-pie-slice {
            fill: #ffff00
            }


        .exp {
            float: left;
        }

        .exp:hover .amcharts-export-menu {
            opacity: 1;
        }
        #chartdiv {
            width: 100%;
            height: 300px;
            }

            .amcharts-legend-div {
            overflow-y: auto!important;
            max-height: 300px;
            }


</style>
@stop

@section('content')
@include('invoices.modal')

<div id="date_model" v-cloak>
    {{Form::open(['route' => 'blanceSheet.DateComparison','method' => 'Get','class' => 'inline'])}}
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.FirstDate')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off" >
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off" >
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.SecondDate')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date1" autocomplete="off" >
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date1" autocomplete="off" >
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>

<div class="portlet light ">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class="icon-equalizer font-green-haze"></i>&nbsp;
            <span class="caption-subject font-green-haze bold uppercase">@lang('menu.BalanceSheet')</span>
        </div>

    </div>
    <div class="portlet-body form">

        <div class="row">

            <div id="tab_6" class="tab-pane active">
                <div id="accordion1" class="panel-group">
                    <div class="panel panel-default">
                        @permission(['balancesheet-list'])
                            <div class="panel-body">
                                <a href="{{route('blanceSheet.index')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.BalanceSheet')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                <a href="{{route('blanceSheet1.index')}}" class="report_a_title">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BalanceSheet1')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                <a href="{{route('blanceSheet2.index')}}" class="report_a_title">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BalanceSheet2')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>


                                <a href="{{route('blanceSheet3.index')}}" class="report_a_title">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BalanceSheet3')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>

                                <a id="select_date_report" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.BalanceSheetYTDComparison')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                @if(systemConfig()[24] == 1)
                                <a href="{{route('blanceSheet.ClassComparison')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.BalanceSheetByClass')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                @endif
                                <a href="{{route('blanceSheet.YearComparison')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.BalanceSheetByPrevYearComparison')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                            </div>
                        @endpermission
                    </div>

                </div>
            </div>
        </div>

           




    </div>
</div>



@endsection

@push('scripts')
<script>

    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function () {
                this.$emit('ok')
            }
        }
    });
    // start date_model
    new Vue({
        el: '#date_model',
        data: {
            showModal: false
        },
        methods: {
            ok: function () {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function (e) {
                this.showModal = !this.showModal;
            },
            editExample: function () {
                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function () {
                    $(document).ready(function () {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#select_date_report').on('click', function (e) {
        $('#show-modal').click();
        e.preventDefault();
    })
    
    </script>

@endpush