@extends('layouts.factor-master')
@section('style')

    <style type="text/css">
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #6f6e6e;
            padding: 8px;
        }

        /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
        #main tr:hover {
            background-color: #ddd;
        }

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }

    </style>
@stop
@section('content')

    <div class="row">
        <table id="main" class="main-table">
            <tr> 
                <th colspan="4" style="background-color: #e8edff; color:#669;"><center><b>@lang('layout.GeneralBranchDailyReport') @if(getCompanyID() == 'all') ( @lang('layout.All') ) @else {!! company()['name'] !!} @endif @lang('layout.FromDate') ( {{$from_date}} ) @lang('layout.ToDate') ( {{$to_date}} ) </b></center></th>
            </tr>
            <tr>
                <th style="width: 15px;">#</th>
                <th>@lang('layout.Details')</th>
                <th>@lang('layout.Weight')</th>
                <th>@lang('layout.Amount')</th>
            </tr>
            <tr>
                <td>1</td>
                <td><b>{{__('layout.PreviousOnHand')}}</b></td>
                <td style="background-color: #dff0ff; color: black;"> @if($measure) {{myRound($inventory_last_quantity / $measure->unit)}} {{$measure->symbol}} @else {{myRound($inventory_last_quantity / 1000)}} KG @endif</td>
                <td style="background-color: #dff0ff; color: black;">{{myRound($inventory_last_cost)}} {{$homeCurrency['code']}} </td>
            </tr>
            <tr>
                <td>1</td>
                <td><b>{{__('layout.OnHand')}}</b></td>
                <td style="background-color: #dff0ff; color: black;"> @if($measure) {{myRound($inventory_quantity / $measure->unit)}} {{$measure->symbol}} @else {{myRound($inventory_quantity / 1000)}} KG @endif</td>
                <td style="background-color: #dff0ff; color: black;">{{myRound($inventory_cost)}} {{$homeCurrency['code']}} </td>
            </tr>
            <tr>
                <td>2</td>
                <td><b>{{__('layout.Purchase')}}</b></td> 
                <td style="background-color: #dffeff; color: black;"> @if($measure) {{myRound($purchase_quantity / $measure->unit)}} {{$measure->symbol}} @else {{myRound($purchase_quantity / 1000)}} KG @endif</td>
                <td colspan="1"  style="background-color: #dffeff; color: black;">
                    <table id="main" class="main-table">
                        @foreach($totalPurchaseData as  $key => $pur)
                        <tr>
                            <td>{{myRound($pur['amount'])}} {{$key}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            <tr>
                <td>3</td>
                <td><b>{{__('layout.TotalSale')}}</b></td> 
                <td style="background-color: #dfffef; color: black;"> @if($measure) {{myRound($sale_quantity / $measure->unit)}} {{$measure->symbol}} @else {{myRound($sale_quantity / 1000)}} KG @endif</td>
                <td colspan="1" style="background-color: #dfffef; color: black;" >
                    <table id="main" class="main-table">
                        @foreach($totalsaleData as  $key1 => $sal)
                        <tr>
                            <td>{{myRound($sal['amount'])}} {{$key1}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            <tr>
                <td>4</td>
                <td><b>{{__('layout.TotalSaleReceived')}}</b></td> 
                <td style="background-color: #dfffec; color: black;"></td> 
                <td colspan="1" style="background-color: #dfffec; color: black;" >
                    <table id="main" class="main-table">
                        @foreach($totalsalePayment as $key3 => $rec1)
                        <tr>
                            <td>{{myRound($rec1['receivable'])}} {{$key3}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            <tr>
                <td>5</td>
                <td><b>{{__('layout.SaleRemainAmount')}}</b></td> 
                <td style="background-color: #dfffec; color: black;"></td> 
                <td colspan="1" style="background-color: #dfffec; color: black;" >
                    <table id="main" class="main-table">
                        @foreach($totalsalePayment as $key4 => $rec2)
                        <tr>
                            <td>{{myRound($rec2['remain_amount'])}} {{$key4}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            <tr>
                <td>6</td>
                <td><b>{{__('layout.Total')}} {{__('layout.ReceivedAmount')}}</b></td> 
                <td style="background-color: #dfffec; color: black;"></td> 
                <td colspan="1" style="background-color: #dfffec; color: black;" >
                    <table id="main" class="main-table">
                        @foreach($receivable as $rec)
                        <tr>
                            <td>{{myRound($rec['amount'])}} {{$rec['currency']}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            <tr>
                <td>7</td>
                <td><b>{{__('layout.TotalAR')}}</b></td>
                <td style="background-color: #e6e2fd; color: black;">{{__('layout.AccountsReceivable')}}</td>
                <td style="background-color: #e6e2fd; color: black;">{{myRound($totalReceivableReport)}} {{$homeCurrency['code']}} </td>
            </tr>
            <tr>
                <td>8</td>
                <td><b> {{__('layout.Total')}}  {{__('layout.PaidAmount')}}</b></td> 
                <td style="background-color: #fdf6e2; color: black;"></td> 
                <td colspan="1" style="background-color: #fdf6e2; color: black;" >
                    <table id="main" class="main-table">
                        @foreach($payment as $pay)
                        <tr>
                            <td>{{myRound($pay['amount'])}} {{$pay['currency']}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            <tr>
                <td>9</td>
                <td><b>{{__('layout.PurchaseRemainAmounts')}}</b></td> 
                <td style="background-color: #fbcccc; color: black;"></td> 
                <td colspan="1" style="background-color: #fbcccc; color: black;" >
                    <table id="main" class="main-table">
                        @foreach($totalpurchaseReceive as $key5 => $rec3)
                        <tr>
                            <td>{{myRound($rec3['remain_amount'])}} {{$key5}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            <tr>
                <td>10</td>
                <td style=" color: black;" ><b>{{__('layout.TotalLiabilities')}}</b></td>
                <td style="background-color: #ffb1bc; color: black;" >{{__('layout.AccountsPayable')}}</td>
                <td style="background-color: #ffb1bc; color: black;" >{{myRound($TotalLiability)}} {{$homeCurrency['code']}} </td>
            </tr>
            <tr>
                <td>11</td>
                <td style=" color: black;" ><b>{{__('layout.TotalExpenses')}}</b></td>
                <td style="background-color: #ffb1bc; color: black;" >{{__('layout.ExpenseAccount')}}</td>
                <td style="background-color: #ffb1bc; color: black;" >{{myRound($expenses)}} {{$homeCurrency['code']}} </td>
            </tr>
            <tr>
                <td>12</td>
                <td style=" color: black;" ><b>@lang('layout.ProfitAndLost')</b></td>
                @if($netProfit > 0)
                <td style="background-color: #81bf72; color: black;" >@lang('layout.Profit')</td>
                <td style="background-color: #81bf72; color: black;" >{{myRound($netProfit)}} {{$homeCurrency['code']}} </td>
                @else
                <td style="background-color: #ffb1bc; color: black;" >@lang('layout.Loss')</td>
                <td style="background-color: #ffb1bc; color: black;" >{{myRound($netProfit)}} {{$homeCurrency['code']}} </td>
                @endif
            </tr>
            <tr>
                <td>13</td>
                <td><b>{{__('layout.CashOnHand')}}</b></td>
                <td style="background-color: #a3e6b4; color: black;"></td>
                <td colspan="1" style="background-color: #a3e6b4; color: black;" >
                    <table id="main" class="main-table">
                        @foreach($totalBankCurrency as $bank)
                        <tr>
                            <td>{{myRound($bank->amount)}} {{$bank->currency}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            <tr>
                <td>14</td>
                <td><b>{{__('layout.CashOnHand')}}</b></td>
                <td style="background-color: #a3e6b4; color: black;">{{__('layout.Total')}}</td>
                <td style="background-color: #a3e6b4; color: black;">{{myRound($totalBankReport)}} {{$homeCurrency['code']}} </td>
            </tr>
        </table>
    </div>

@endsection
