@extends('layouts.app')
@section('style')

    <style type="text/css">
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #6f6e6e;
            padding: 8px;
        }

        /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
        #main tr:hover {
            background-color: #ddd;
        }

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }

    </style>
@stop
@section('content')

    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'dailyFinancialStatement'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date" >
                                    <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                    <span class="input-group-addon"> @lang('layout.To')</span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date" >
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            {{Form::open(['route' => 'dailyFinancial1.statement','method' => 'GET','class' => 'form-horizontal'])}}
            {{ csrf_field() }}
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group  hidden-print">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" value="{{$from_date}}" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" value="{{$to_date}}" autocomplete="off" />
                        <span class="input-group-addon btn" style="padding: 0px;" > <input type="submit" style="padding: 0px 8px;background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141);" value="@lang('layout.Search')" > </span>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
            <div class="portlet-title">
                <div class="caption font-dark">
                </div>
                <div class="tools"> </div>
                <div class="btn-group pull-right">
                    @permission('build-export')

                        <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
            

                        <!-- <span id="anchore-modal">
                            <button type="submit" @click.prevent="showModal" class="btn btn-success">
                                <i class="fa fa-print"></i>
                            </button>
                        </span> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table id="main" class="main-table">
                    <tr> 
                        <th colspan="4" style="background-color: #e8edff; color:#669;"><center><b>@lang('layout.GeneralDailyReport') @if(getCompanyID() == 'all') ( @lang('layout.All') ) @else {!! company()['name'] !!} @endif @lang('layout.FromDate') ( {{$from_date}} ) @lang('layout.ToDate') ( {{$to_date}} ) </b></center></th>
                    </tr>
                    <tr>
                        <th style="width: 15px;">#</th>
                        <th>@lang('layout.Details')</th>
                        <th>@lang('layout.Amount')</th>
                    </tr>
                    <tr>
                        <td>1</td>
                        <td><b>
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="chartofaccountlist"/>
                           <input type="hidden" name="type_id" value="bank"/>
                           @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                           @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif

                           <button type="submit" class="btn "> {{__('layout.BankBalances')}} </button>
                        {{Form::close()}}  
                        </b></td>
                        <td colspan="2" style="background-color: #a3e6b4; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($totalBankCurrency as $bank)
                                <tr>
                                    <td>{{myRound($bank->amount)}} {{$bank->currency}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td><b>
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="chartofaccountlist"/>
                           <input type="hidden" name="type_id" value="bank"/>
                           @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                            @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif

                           <button type="submit" class="btn "> {{__('layout.BankBalances')}} {{__('layout.Total')}} </button>
                        {{Form::close()}}
                        </b></td>
                        <td style="background-color: #a3e6b4; color: black;">{{myRound($totalBankReport)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <td>
                            <b>
                            {{Form::open(['route' => 'memberStatement.type','method' => 'Get','class' => 'inline'])}}
                            <input type="hidden" name="report_type" value="Payable"/>
                            @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                            @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
                        
                            <button type="submit" class="btn "> {{__('layout.TotalAR')}} </button>
                            {{Form::close()}}
                            </b>
                        </td>
                        <td style="background-color: #e6e2fd; color: black;">{{myRound($totalReceivableReport)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>4</td>
                        <td>
                            <b>
                            {{Form::open(['route' => 'memberStatement.type','method' => 'Get','class' => 'inline'])}}
                            <input type="hidden" name="report_type" value="Receivable"/>
                            @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                            @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif

                            <button type="submit" class="btn "> {{__('layout.TotalLiabilities')}} </button>
                            {{Form::close()}}
                            </b>
                        </td>
                        <td style="background-color: #ffb1bc; color: black;" >{{myRound($TotalLiability)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>5</td>
                        <td><b>
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="allInventoryReport"/>
                        @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                        @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif

                           <button type="submit" class="btn "> {{__('layout.OnHand')}} {{__('layout.Inventory')}} </button>
                        {{Form::close()}}
                        </b></td>
                        <td style="background-color: #dff0ff; color: black;">{{myRound($inventory_cost)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>6</td>
                        <td><b>
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="GeneralSaleReportCustomerReceive"/>
                        @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                            @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif

                           <button type="submit" class="btn "> {{__('layout.TotalSale')}} </button>
                        {{Form::close()}}
                        </b></td>    
                        <td colspan="1" style="background-color: #dfffef; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($totalsaleData as  $key1 => $sal)
                                <tr>
                                    <td>{{myRound($sal['amount'])}} {{$key1}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>7</td>
                        <td><b>
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="GeneralPurchaseReportCustomer"/>
                        @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                            @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif

                           <button type="submit" class="btn "> {{__('layout.TotalPurchase')}} </button>
                        {{Form::close()}}
                        </b></td> 
                        <td colspan="1"  style="background-color: #dffeff; color: black;">
                            <table id="main" class="main-table">
                                @foreach($totalPurchaseData as  $key => $pur)
                                <tr>
                                    <td>{{myRound($pur['amount'])}} {{$key}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>8</td>
                        <td><b>
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="chartofaccountlist"/>
                           <input type="hidden" name="type_id" value="expense"/>
                           @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                            @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
                            
                           <button type="submit" class="btn "> {{__('layout.TotalExpenses')}} </button>
                        {{Form::close()}}
                        </b></td>
                        <td style="background-color: #ffb1bc; color: black;" >{{myRound($expenses)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>9</td>
                        <td><b>{{__('layout.TotalAssets')}}</b></td>
                        <td style="background-color: #a3e6b4; color: black;">{{myRound($totalAsset)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>10</td>
                        <td><b>
                            <a href="{{route('financialReport.income')}}">
                                <span class="btn " >{{__('layout.ProfitAndLost')}}</span>
                            </a>
                        </b></td>
                        @if($netProfit > 0)
                        <td style="background-color: #81bf72; color: black;" >{{myRound($netProfit)}} {{$homeCurrency['code']}}  @lang('layout.Profit')</td>
                        @else
                        <td style="background-color: #ffb1bc; color: black;" >{{myRound($netProfit)}} {{$homeCurrency['code']}}  @lang('layout.Loss')</td>
                        @endif
                    </tr>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- BEGIN TAB PORTLET-->
    <!-- BEGIN TAB PORTLET-->
    <div class=" pull-right">


    </div>
    <br>
    <br>





@endsection
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script type="text/javascript">

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.PDFAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>
@endpush