@extends('layouts.app')
@section('style')

    <style type="text/css">
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #6f6e6e;
            padding: 8px;
        }

        /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
        #main tr:hover {
            background-color: #ddd;
        }

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }

    </style>
@stop
@section('content')

    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'dailyFinancialStatement'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-12" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off" v-model="from_date" name="from_date" >
                                    <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                    <span class="input-group-addon"> @lang('layout.To')</span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" v-model="to_date" name="to_date" >
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            {{Form::open(['route' => 'dailyFinancial.statement','method' => 'GET','class' => 'form-horizontal'])}}
            {{ csrf_field() }}
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" value="{{$from_date}}" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" value="{{$to_date}}" autocomplete="off" />
                        <span class="input-group-addon btn" style="padding: 0px;background-color: rgb(80, 129, 141) !important;" > <input type="submit" style="padding: 0px 8px;background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141);" value="@lang('layout.Search')" > </span>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
            <div class="portlet-title">
                <div class="caption font-dark">
                </div>
                <div class="tools"> </div>
                <div class="btn-group pull-right">
                    @permission('build-export')
                        <span id="anchore-modal">
                            <button type="submit" @click.prevent="showModal" class="btn btn-success">
                                <i class="fa fa-print"></i>
                            </button>
                        </span>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table id="main" class="main-table">
                    <tr> 
                        <th colspan="4" style="background-color: #e8edff; color:#669;"><center><b>@lang('layout.GeneralBranchDailyReport') @if(getCompanyID() == 'all') ( @lang('layout.All') ) @else {!! company()['name'] !!} @endif @lang('layout.FromDate') ( {{$from_date}} ) @lang('layout.ToDate') ( {{$to_date}} ) </b></center></th>
                    </tr>
                    <tr>
                        <th style="width: 15px;">#</th>
                        <th>@lang('layout.Details')</th>
                        <th>@lang('layout.Weight')</th>
                        <th>@lang('layout.Amount')</th>
                    </tr>
                    <tr>
                        <td>1</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="allInventoryReport"/>
                                <input type="hidden" name="exportType" value="all"/>
                                <input type="hidden" name="all_onhund" value="yes"/>
                                @if(isset($FDate)) <input type="hidden" name="to_date" value="{{$FDate}}" /> @endif
        
                                   <button type="submit" class="btn "> {{__('layout.PreviousOnHand')}} </button>
                                {{Form::close()}}
                            </b>
                        </td>
                        <td style="background-color: #dff0ff; color: black;"> @if($measure) {{myRound($inventory_last_quantity / $measure->unit)}} {{$measure->symbol}} @else {{myRound($inventory_last_quantity / 1000)}} KG @endif</td>
                        <td style="background-color: #dff0ff; color: black;">{{myRound($inventory_last_cost)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>1</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="allInventoryReport"/>
                                <input type="hidden" name="exportType" value="all"/>
                                <input type="hidden" name="all_onhund" value="yes"/>
                                @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
        
                                   <button type="submit" class="btn "> {{__('layout.OnHand')}}</button>
                                {{Form::close()}}
                            </b>
                        </td>
                        <td style="background-color: #dff0ff; color: black;"> @if($measure) {{myRound($inventory_quantity / $measure->unit)}} {{$measure->symbol}} @else {{myRound($inventory_quantity / 1000)}} KG @endif</td>
                        <td style="background-color: #dff0ff; color: black;">{{myRound($inventory_cost)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="GeneralPurchaseReportCustomer"/>
                                @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                    @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
        
                                   <button type="submit" class="btn "> {{__('layout.TotalPurchase')}} </button>
                                {{Form::close()}}
                            </b>
                        </td> 
                        <td style="background-color: #dffeff; color: black;"> @if($measure) {{myRound($purchase_quantity / $measure->unit)}} {{$measure->symbol}} @else {{myRound($purchase_quantity / 1000)}} KG @endif</td>
                        <td colspan="1"  style="background-color: #dffeff; color: black;">
                            <table id="main" class="main-table">
                                @foreach($totalPurchaseData as  $key => $pur)
                                <tr>
                                    <td>{{myRound($pur['amount'])}} {{$key}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>3</td>    
                        <td>
                            <b>
                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="GeneralSaleReportCustomerReceive"/>
                            @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
    
                                <button type="submit" class="btn "> {{__('layout.TotalSale')}} </button>
                            {{Form::close()}}
                            </b>
                        </td> 
                        <td style="background-color: #dfffef; color: black;"> @if($measure) {{myRound($sale_quantity / $measure->unit)}} {{$measure->symbol}} @else {{myRound($sale_quantity / 1000)}} KG @endif</td>
                        <td colspan="1" style="background-color: #dfffef; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($totalsaleData as  $key1 => $sal)
                                <tr>
                                    <td>{{myRound($sal['amount'])}} {{$key1}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>4</td>
                        <td><b>{{__('layout.TotalSaleReceived')}}</b></td> 
                        <td style="background-color: #dfffec; color: black;"></td> 
                        <td colspan="1" style="background-color: #dfffec; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($totalsalePayment as $key3 => $rec1)
                                <tr>
                                    <td>{{myRound($rec1['receivable'])}} {{$key3}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>5</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="GeneralSaleReportCustomerReceive"/>
                                <input type="hidden" name="remian" value="true">
                                @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
        
                                <button type="submit" class="btn "> {{__('layout.SaleRemainAmount')}} </button>
                                {{Form::close()}}
                            </b>
                        </td> 
                        <td style="background-color: #dfffec; color: black;"></td> 
                        <td colspan="1" style="background-color: #dfffec; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($totalsalePayment as $key4 => $rec2)
                                <tr>
                                    <td>{{myRound($rec2['remain_amount'])}} {{$key4}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>6</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="receive"/>
                                @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
        
                                <button type="submit" class="btn ">{{__('layout.Total')}} {{__('layout.ReceivedAmount')}} </button>
                                {{Form::close()}}
                            </b>
                        </td> 
                        <td style="background-color: #dfffec; color: black;"></td> 
                        <td colspan="1" style="background-color: #dfffec; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($receivable as $rec)
                                <tr>
                                    <td>{{myRound($rec['amount'])}} {{$rec['currency']}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>7</td>
                        <td><b>
                            {{Form::open(['route' => 'memberStatement.type','method' => 'Get','class' => 'inline'])}}
                            <input type="hidden" name="report_type" value="Payable"/>
                            @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                            @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
                        
                            <button type="submit" class="btn "> {{__('layout.TotalAR')}} </button>
                            {{Form::close()}}
                        </b></td>
                        <td style="background-color: #e6e2fd; color: black;">{{__('layout.AccountsReceivable')}}</td>
                        <td style="background-color: #e6e2fd; color: black;">{{myRound($totalReceivableReport)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>8</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="all_pay"/>
                                @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
        
                                <button type="submit" class="btn ">{{__('layout.Total')}} {{__('layout.PaidAmount')}} </button>
                                {{Form::close()}}
                            </b>
                        </td> 
                        <td style="background-color: #fdf6e2; color: black;"></td> 
                        <td colspan="1" style="background-color: #fdf6e2; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($payment as $pay)
                                <tr>
                                    <td>{{myRound($pay['amount'])}} {{$pay['currency']}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>9</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="GeneralPurchaseVendorPaymentReport"/>
                                <input type="hidden" name="remian" value="true">
                                @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
        
                                <button type="submit" class="btn "> {{__('layout.PurchaseRemainAmounts')}} </button>
                                {{Form::close()}}
                            </b>
                        </td> 
                        <td style="background-color: #fbcccc; color: black;"></td> 
                        <td colspan="1" style="background-color: #fbcccc; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($totalpurchaseReceive as $key5 => $rec3)
                                <tr>
                                    <td>{{myRound($rec3['remain_amount'])}} {{$key5}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>10</td>
                        <td style=" color: black;" >
                            <b>
                            {{Form::open(['route' => 'memberStatement.type','method' => 'Get','class' => 'inline'])}}
                            <input type="hidden" name="report_type" value="Receivable"/>
                            @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                            @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif

                            <button type="submit" class="btn "> {{__('layout.TotalLiabilities')}} </button>
                            {{Form::close()}}
                            </b>
                        <td style="background-color: #ffb1bc; color: black;" >{{__('layout.AccountsPayable')}}</td>
                        <td style="background-color: #ffb1bc; color: black;" >{{myRound($TotalLiability)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>11</td>
                        <td style=" color: black;" >
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="chartofaccountlist"/>
                                   <input type="hidden" name="type_id" value="expense"/>
                                   @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                    @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
                                    
                                   <button type="submit" class="btn "> {{__('layout.TotalExpenses')}} </button>
                                {{Form::close()}}
                            </b>
                        </td>
                        <td style="background-color: #ffb1bc; color: black;" >{{__('layout.ExpenseAccount')}}</td>
                        <td style="background-color: #ffb1bc; color: black;" >{{myRound($expenses)}} {{$homeCurrency['code']}} </td>
                    </tr>
                    <tr>
                        <td>12</td>
                        <td style=" color: black;" ><b>
                            <a href="{{route('financialReport.income')}}">
                                <span class="btn " >{{__('layout.ProfitAndLost')}}</span>
                            </a>
                            </b></td>
                        @if($netProfit > 0)
                        <td style="background-color: #81bf72; color: black;" >@lang('layout.Profit')</td>
                        <td style="background-color: #81bf72; color: black;" >{{myRound($netProfit)}} {{$homeCurrency['code']}} </td>
                        @else
                        <td style="background-color: #ffb1bc; color: black;" >@lang('layout.Loss')</td>
                        <td style="background-color: #ffb1bc; color: black;" >{{myRound($netProfit)}} {{$homeCurrency['code']}} </td>
                        @endif
                    </tr>
                    <tr>
                        <td>13</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                   <input type="hidden" name="type" value="chartofaccountlist"/>
                                   <input type="hidden" name="type_id" value="bank"/>
                                   @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                   @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
        
                                   <button type="submit" class="btn "> {{__('layout.CashOnHand')}} </button>
                                {{Form::close()}}  
                            </b>
                        </td>
                        <td style="background-color: #a3e6b4; color: black;"></td>
                        <td colspan="2" style="background-color: #a3e6b4; color: black;" >
                            <table id="main" class="main-table">
                                @foreach($totalBankCurrency as $bank)
                                <tr>
                                    <td>{{myRound($bank->amount)}} {{$bank->currency}}</td>
                                </tr>
                                @endforeach
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>14</td>
                        <td>
                            <b>
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                   <input type="hidden" name="type" value="chartofaccountlist"/>
                                   <input type="hidden" name="type_id" value="bank"/>
                                   @if($from_date) <input type="hidden" name="from_date" value="{{$from_date}}" /> @endif
                                   @if($to_date) <input type="hidden" name="to_date" value="{{$to_date}}" /> @endif
        
                                   <button type="submit" class="btn "> {{__('layout.CashOnHand')}} </button>
                                {{Form::close()}}  
                            </b>
                        </td>
                        <td style="background-color: #a3e6b4; color: black;">{{__('layout.Total')}}</td>
                        <td style="background-color: #a3e6b4; color: black;">{{myRound($totalBankReport)}} {{$homeCurrency['code']}} </td>
                    </tr>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- BEGIN TAB PORTLET-->
    <!-- BEGIN TAB PORTLET-->
    <div class=" pull-right">


    </div>
    <br>
    <br>





@endsection
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script type="text/javascript">

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.PDFAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>
@endpush